/*!******************************************************************************

  @file         hak34.h

  ------------------------------------------------------------------------------

  @author       ThomasA

  @brief        AK_PERSISTENT_OBJECTS

\if EMIT_LICENCE  

    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

\endif

********************************************************************************/

#ifndef HAK34_H
#define HAK34_H


/*===========================================================================*
 *     RefType: C++                                                          *
 *===========================================================================*/

/*===========================================================================*
 *     MD5: '\x3e\x2c\xf1\xa6\x4c\x6d\xdd\x65\xfd\x8d\xed\x46\x4b\x4c\xcd\xa5'
 *===========================================================================*/


/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gsp00.h"
#include "vsp001.h"
#include "ggg00.h"
#include "vak001.h"
#include "ggg01.h"


/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/

externPascal void a34AbapRead (
    tak_all_command_glob  &  acv,
    void                  *  handle,
    tsp00_Int4            &  row_count,
    tsp00_Int4            &  buf_size,
    tsp00_MoveObjPtr      &  pBuf,
    tsp00_Int2            &  e);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a34AbapWrite (
    tak_all_command_glob  &  acv,
    void                  *  handle,
    tsp00_Int4               row_size,
    tsp00_Int4               row_count,
    void                  *  buf,
    tsp00_Int2            &  e);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a34AllocPacket (
    tak_all_command_glob  &  acv,
    tsp1_packet_ptr       &  packet_ptr,
    tsp00_Int4            &  size);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a34BasisError (
    tak_all_command_glob  &  acv,
    tgg00_BasisError         e);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a34ClassMapSyskey (
    tsp00_Int4               ContainerId,
    tgg00_SysInfoKey      &  SysKey);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a34ContainerSyskey (
    tsp00_Int4               SchemaId,
    tsp00_C16             &  Guid,
    tsp00_Int4               ContainerNo,
    tgg00_SysInfoKey      &  Syskey);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a34call_semantic (
    tak_all_command_glob  &  acv);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a34CreateSchema (
    tak_all_command_glob  &  acv,
    tak_WydeArray         &  SchemaNameWyde,
    tsp00_Int4            &  SchemaId,
    tgg00_BasisError      &  e);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a34DropContainer (
    tak_all_command_glob  &  acv,
    tsp00_Int4               SchemaId,
    tsp00_C16             &  Guid,
    tsp00_Int4               ContainerNo,
    tgg00_BasisError      &  b_err);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a34DropSchema (
    tak_all_command_glob  &  acv,
    tsp00_Int4               SchemaId,
    tgg00_BasisError      &  e);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a34ExistsContainer (
    tak_all_command_glob  &  acv,
    tsp00_Int4            &  SchemaId,
    tsp00_C16             &  guid,
    tsp00_Int4               container_no,
    tgg00_BasisError      &  e);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a34ExistsSchema (
    tak_all_command_glob  &  acv,
    tak_WydeArray         &  SchemaNameWyde,
    tsp00_Int4            &  SchemaId,
    tgg00_BasisError      &  e);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a34GetContainerInfo (
    tak_all_command_glob  &  acv,
    tsp00_Int4               ContainerHandle,
    tsp00_C16             &  Guid,
    tsp00_Int4            &  SchemaId,
    tsp00_Int4            &  ContainerNo,
    tgg00_BasisError      &  e);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a34InitOms (
    tak_all_command_glob  &  acv);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool a34IsUnicodeLivecacheUser (
    tak_all_command_glob  &  acv);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a34Lock (
    tak_all_command_glob  &  acv,
    tsp00_MoveObjPtr         pKey,
    integer                  KeyLen,
    pasbool                  lockExclusive,
    tgg00_BasisError      &  e);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a34RegisterClass (
    tak_all_command_glob  &  acv,
    tsp00_Int4               SchemaId,
    tsp00_C16             &  guid,
    tsp00_KnlIdentifier   &  className,
    tsp00_Int4               size,
    tsp00_Int4               container_no,
    tgg00_ObjColDesc      &  coldesc,
    tgg01_ContainerId     &  containerId,
    tsp00_Int2            &  e);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a34SchemaRefSyskey (
    tsp00_KnlIdentifier   &  SchemaName,
    tgg00_SysInfoKey      &  Syskey);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a34SchemaSyskey (
    tsp00_Int4               SchemaId,
    tgg00_SysInfoKey      &  Syskey);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a34GetErrormsg (
    tak_all_command_glob  &  acv,
    tsp00_Int2               error,
    void                  *  errtext,
    integer               &  errtextlen);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a34GetSchemaName (
    tak_all_command_glob  &  acv,
    tsp00_Int4               SchemaId,
    tak_WydeArray         &  SchemaNameWyde,
    tgg00_BasisError      &  e);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a34HResultError (
    tak_all_command_glob  &  acv,
    tsp00_Int4               hresult);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a34InquireKey (
    tgg00_TransContext    &  Trans,
    tgg00_FileId          &  ObjFile,
    tgg00_ObjColDesc      &  ColDesc);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a34OpMsg (
    pasbool                  isError,
    void                  *  Buf,
    tsp00_Int4               BufLen);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a34Receive (
    tak_all_command_glob  &  acv,
    tsp1_packet_ptr       &  out_packet_ptr);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a34Request (
    tak_all_command_glob  &  acv,
    tsp1_packet_ptr          sql_packet_ptr);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a34outstanding_packet (
    tak_all_command_glob  &  acv,
    tsp00_Int2            &  e);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a34Restart (
    tak_all_command_glob  &  acv);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tsp00_Int2 a34ReturnCode (
    tgg00_BasisError         b_err);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a34Rollback (
    tak_all_command_glob  &  acv,
    void                  *  keeplock,
    tsp00_Int4               keep_len,
    tsp00_Int2            &  e);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tak_sysbufferaddress a34SchemaIdExists (
    tak_all_command_glob  &  acv,
    tsp00_Int4               SchemaId);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a34Sequence (
    tak_all_command_glob  &  acv,
    const tsp00_KnlIdentifier VAR_ARRAY_REF     seqname,
    tgg00_Surrogate       &  seqid,
    tgg00_SeqInfo         &  seqInfo,
    tsp00_Int2            &  e);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a34SetError (
    tak_all_command_glob  &  acv,
    tsp00_Int2               error,
    void                  *  errtext,
    integer                  errtextlen,
    tsp00_CodeType           codetype);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a34SubtransCommit (
    tak_all_command_glob  &  acv,
    tsp00_Int2            &  e);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a34SubtransRollback (
    tak_all_command_glob  &  acv,
    tsp00_Int2            &  e);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a34SubtransStart (
    tak_all_command_glob  &  acv,
    tsp00_Int2            &  e);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a34UnLock (
    tak_all_command_glob  &  acv,
    tsp00_MoveObjPtr         pKey,
    integer                  KeyLen,
    pasbool                  lockExclusive,
    tgg00_BasisError      &  e);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a34VTrace (
    tak_all_command_glob  &  acv,
    void                  *  trace_obj,
    tsp00_Int4               trace_len);

/* Don't edit this file by hand, it is generated by ptocProto.py */


#endif

