#    coding: utf-8
#
#    module:       test_loader.py
#
#    responsible : d033893 
#
#    special area: sdb.loader
#
#
#
#    ========== licence begin  GPL
#    Copyright (c) 2000-2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end

# 

#system
import sys
import time
import os
import imp
import socket
#shell
import shutil
#string
import string
import re
#sapdb
import optlib
from   sdb    import dbm,loader,sql

LOADERAPPLPATH  =  os.getcwd()
LOADERDATAPATH  =  os.getcwd()

#raw_input('')

loadersyntax = [
'|-------------------------------------------------------------------------------------------------------------------------------------|',
'|                                                                                                                                     |',
'|                                        Loader Session Parameter                                                                     |',
'|                                                                                                                                     |',
'|-------------------------------------------------------------------------------------------------------------------------------------|',
'|                                                                                                                                     |',
'|  Session Parameter      Parameter Value                                 Default Value                                               |',
'|                                                                                                                                     |',
'|-------------------------------------------------------------------------------------------------------------------------------------|',
'|                                                                                                                                     |', 
'|  SET COMPRESSED          \'/<s>/<d>/\'                                   \  ,/"/\'                                                  |',
'|  SET BLOBMASK            \'###\'                                                                                                    |',
'|  SQLMODE                 [INTERNAL|ANSI|DB2|ORACLE]                      INTERNAL                                                   |', 
'|  SET LANGUAGE            [ENG|DEU]                                       \'ENG\'                                                    |', 
'|  SET CODETYPE            [ASCII|UCS2|UTF8]                               ASCII                                                      |',
'|  SET CODEPAGE            [http://www.unicode.org/Public/MAPPINGS/]       ISO-8859-1                                                 |',
'|  SET DATE                [INTERNAL|ISO|USA|EUR|JIS]                      ISO                                                        |',
'|  SET TIME                [INTERNAL|ISO|USA|EUR|JIS]                      ISO                                                        |',
'|  SET TIMESTAMP           [INTERNAL|ISO|USA|EUR|JIS]                      ISO                                                        |',
'|  SET DECIMAL             \'/[<t>]/<d>/\'                                 \'//./\'                                                   |',
'|  SET BOOLEAN                                                             \'TRUE/FALSE\'                                             |',
'|  SET NULL                                                                \'?\'                                                      |',
'|  SET TRANSACTION SIZE                                                    1000                                                       |',
'|  SET MAXERRORCOUNT                                                       100                                                        |',
'|  SET BACKUPTOOL          [TSM|NETWORKER|BACKINT]                         NETWORKER                                                  |', 
'|  SET ODBCTRACE           [ON|OFF]                                        OFF                                                        |',
'|                                                                                                                                     |',
'|-------------------------------------------------------------------------------------------------------------------------------------|',
'|                                                                                                                                     |',
'|                                        Loader Transformation Parameter                                                              |',
'|                                                                                                                                     |',
'|-------------------------------------------------------------------------------------------------------------------------------------|',
'|                    |                    |                 |                |               |                       |                |',
'| What should be     | Transformation of  |  Logging of     | Package of     | Medium of     | Format of             | Mapping of     |',
'| imported/exported ?| Models und Data    |  Transformation | Transformation | Staging Area  | Models and Data       | Char Codetypes |',
'|                    |                    |                 |                |               |                       |                |',
'|-------------------------------------------------------------------------------------------------------------------------------------|',
'|Catalog, Data and   |EXTRACT|LOAD        |[RESTORE]        | DB             |               |                       |                |',
'|Package of a        |CONFIGURATION       |                 |                | FILE          | DTL, XMI              | UCS2           |',
'|Database            |CATALOG             |                 |                | PIPE          | DDL, XMI              | UTF8           |',
'|                    |DATA                |                 |                | TAPE          | PAGES, RECORDS        | ASCII          |',
'|                    |PACKAGE             |[RESTART]        |                |               | DTL, XMI              |                |',
'|-------------------------------------------------------------------------------------------------------------------------------------|',
'|Catalog, Data and   |EXTRACT|LOAD        |[RESTORE]        | USER           |               |                       |                |',
'|Package of a        |CONFIGURATION       |                 |                | FILE          | DTL, XMI              | UCS2           |',
'|Database User       |CATALOG             |                 |                | PIPE          | DDL, XMI              | UTF8           |',
'|                    |DATA                |                 |                | TAPE          | PAGES, RECORDS        | ASCII          |',
'|                    |PACKAGE             |[RESTART]        |                |               | DTL, XMI              |                |',
'|-------------------------------------------------------------------------------------------------------------------------------------|',
'|Catalog, Data and   |EXTRACT|LOAD[FAST]| |[RESTORE]        | TABLE          |               |                       |                |',
'|Package of a        |CONFIGURATION       |                 |                | FILE          | DTL, XMI              | UCS2           |',
'|Database Table      |CATALOG             |                 |                | PIPE          | DDL, XMI              | UTF8           |',
'|                    |DATA                |                 |                | TAPE          | PAGES, RECORDS,       | ASCII          |',
'|                    |                    |                 |                |               | FORMATTED, COMPRESSED |                |',
'|                    |                    |                 |                |               | COMPRESSED            |                |',
'|                    |PACKAGE             |[RESTART]        |                |               | DTL, XMI              |                |',
'|-------------------------------------------------------------------------------------------------------------------------------------|',
'|Data and Package    |EXTRACT|LOAD[FAST]  |                 | COLUMNS FIELDS |               |                       |                |',
'|of a qualified      |                    |                 |                | FILE          |                       | UCS2           |',
'|Database Columnset  |                    |                 |                | PIPE          |                       | UTF8           |',
'|                    |DATA                |                 |                | TAPE          | FORMATTED, COMPRESSED | ASCII          |',
'|                    |PACKAGE             |[RESTART]        |                |               | DTL, XMI              |                |',
'|                    |                    |                 |                |               |                       |                |',
'|-------------------------------------------------------------------------------------------------------------------------------------|',
'|                                                                                                                                     |',
'|                                        Loader Migration Parameter                                                                   |',
'|                                                                                                                                     |',
'|-------------------------------------------------------------------------------------------------------------------------------------|',
'|                                                                                                                                     |',
'| Option     Transformation Parameter                 Parameter Value                 Default Value             Varname               |',
'|                                                                                                                                     |',
'|-------------------------------------------------------------------------------------------------------------------------------------|',
'|                                                                                                                                     |',
'| t          Type      of Transformation              TRANSPORT, EXPORT, IMPORT       TRANSPORT                 transformationtype    |',
'| p          Package   of Transformation              DB  , USER, TABLE               DB                        transformationpackage |',
'| P          Part      of Package                     DB  , USER, TABLE               DB                        transformationpart    |',
'| m          Medium    of Staging Area                PIPE, FILE, TAPE                FILE                      streammedium          |',
'| f          Format    of Models and Data             DDL, XML                        DDL,RECORDS               streamformat          |',
'|                                                     RECORDS, PAGES,                                                                 |',
'|                                                     COMPRESSED, FORMATTED                                                           |',
'| F                                                   DATA , FAST                     DATA                      streamformat_target   |',
'| e          Mapping of Char Codetypes                ASCII, UCS2, UTF8, DYNAMIC      DYNAMIC                   streamcharencoding    |',
'| b          Mask    of BLOB Datatypes                COLUMN, COLUMNVALUE             COLUMN                    streamblob            |',
'| l          Logging of Transformation                START, RESTART                  START                     startposition               |',
'|                                                                                                                                     |',
'|-------------------------------------------------------------------------------------------------------------------------------------|',
'|                                                                                                                                     |',
'| x          Connector to Medium                      PIPE2TAPE,PIPE2FILE,PIPE2HTTP   none                      streamconnector       |',
'| X          Connector to Database System             SAPDB, ADABAS                   SAPDB                     migration             |',
'|                                                                                                                                     |',
'|-------------------------------------------------------------------------------------------------------------------------------------|',
'|                                                                                                                                     |',
'| z          specifies debug  mode                    TRUE , FALSE                    false                     debug                 |',
'| t          specifies test   case                                                    80                        testcase              |',
'|                                                                                                                                     |',
'| n          specifies source servernode                                              localhost                 sourcenode            |',
'| r          specifies sapdb  source  instroot                                        os.environ[INSTROOT]      sourceinstroot        |',
'| i          init      sapdb  source                  SYSTEM,USER,CATALOG,DELETE      data                      sourceinit            |',
'| d          specifies source serverdb to create                                      sourcedb                  sourcedbname          |',
'| a          specifies source SYSDBA user                                             DBA                       sourcedbauser         |',
'| c          specifies source catalog coding          ASCII, UNICODE                  ascii                     sourcecatalog         |',
'|                                                                                                                                     |',
'| N          specifies target servernode                                              localhost                 targetnode            |',
'| R          specifies sapdb  target  instroot                                        os.environ[INSTROOT]      targetinstroot        |',
'| I          init      sapdb  target                  SYSTEM,USER,CATALOG,DELETE      system                    targetinit            |',
'| D          specifies target serverdb to create                                      targetdb                  targetdbname          |',
'| A          specifies target SYSDBA user                                             DBA                       targetdbauser         |',
'| C          specifies target catalog coding          ASCII, UNICODE                  ascii                     targetcatalog         |',
'|                                                                                                                                     |',
'|-------------------------------------------------------------------------------------------------------------------------------------|',
'|                                                                                                                                     |',
'|                                        Loader Migration Parameters                                                                  |',
'|                                                                                                                                     |',
'|-------------------------------------------------------------------------------------------------------------------------------------|',
]

#package webdav : 1,2,3,4,5,
#medium  file   : 6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,
#medium  pipe   : 58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,
#medium  tape   : 83,84,85 

parameters = [
#|Testcase          |Transformation     |Datastream                                                      |Database                                                                                           |Testenvironment                 
                                                                                                                                                                                                                                                                             
#|Test  |Type       |Package  |Part     |Startpos |Medium |Format              |Encoding   |Lobmask      |Sourcedb                            |Targetdb                                |Encoding             |Validation            | Initialization       |Version
#|1     |2          |3        |4        |5        |6      |7           |8      |9          |10           |11          |12         |13         |14         |15         |16              |17        |18        |19       |20          |21         |22        |23              |24 
																																												  
#data                                    usecases:																																
'-T  1 -t TRANSPORT -p WEBDAV -P TABLE  -s START -m FILE -f PAGES      -F PAGE -c DYNAMIC -l COLUMN      -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E ascii   -v data    -V complete -i data    -I system  -r sourceinstroot -R targetinstroot',
'-T  2 -t TRANSPORT -p WEBDAV -P TABLE  -s START -m FILE -f RECORDS    -F ROW  -c ASCII   -l TABLE       -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E unicode -v data    -V complete -i delete  -I system  -r sourceinstroot -R targetinstroot',
'-T  3 -t TRANSPORT -p WEBDAV -P TABLE  -s START -m FILE -f RECORDS    -F ROW  -c UCS2    -l TABLE       -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E unicode -v data    -V complete -i delete  -I system  -r sourceinstroot -R targetinstroot',
'-T  4 -t TRANSPORT -p WEBDAV -P TABLE  -s START -m FILE -f COMPRESSED -F ROW  -c ASCII   -l COLUMN      -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E unicode -v data    -V complete -i delete  -I system  -r sourceinstroot -R targetinstroot',
'-T  5 -t TRANSPORT -p WEBDAV -P TABLE  -s START -m FILE -f COMPRESSED -F PAGE -c ASCII   -l COLUMN      -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E unicode -v data    -V complete -i delete  -I system  -r sourceinstroot -R targetinstroot',
#metadata                                usecases : ascii2ascii																													 	 																								
'-T  6 -t TRANSPORT -p DB     -P DB     -s START -m FILE -f DDL        -F DDL  -c ASCII   -l COLUMN      -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E ascii   -v catalog -V sorted   -i catalog -I system  -r sourceinstroot -R targetinstroot',
'-T  7 -t EXPORT    -p DB     -P DB     -s START -m FILE -f XML        -F XML  -c ASCII   -l COLUMN      -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E ascii   -v catalog -V none     -i delete  -I delete  -r sourceinstroot -R targetinstroot',
'-T  8 -t TRANSPORT -p DB     -P USER   -s START -m FILE -f DDL        -F DDL  -c ASCII   -l COLUMN      -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E ascii   -v catalog -V none     -i delete  -I delete  -r sourceinstroot -R targetinstroot',
'-T  9 -t EXPORT    -p DB     -P USER   -s START -m FILE -f XML        -F XML  -c ASCII   -l COLUMN      -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E ascii   -v catalog -V none     -i delete  -I delete  -r sourceinstroot -R targetinstroot',
'-T 10 -t TRANSPORT -p DB     -P TABLE  -s START -m FILE -f DDL        -F DDL  -c ASCII   -l COLUMN      -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E ascii   -v catalog -V none     -i delete  -I delete  -r sourceinstroot -R targetinstroot',
'-T 11 -t EXPORT    -p DB     -P TABLE  -s START -m FILE -f XML        -F XML  -c ASCII   -l COLUMN      -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E ascii   -v catalog -V none     -i delete  -I delete  -r sourceinstroot -R targetinstroot',
'-T 12 -t TRANSPORT -p DB     -P TABLE  -s START -m FILE -f PAGES      -F DTL  -c ASCII   -l TABLE       -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E ascii   -v catalog -V none     -i delete  -I catalog -r sourceinstroot -R targetinstroot',
'-T 13 -t TRANSPORT -p DB     -P TABLE  -s START -m FILE -f RECORDS    -F DTL  -c ASCII   -l TABLE       -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E ascii   -v catalog -V none     -i delete  -I delete  -r sourceinstroot -R targetinstroot',
'-T 14 -t TRANSPORT -p DB     -P TABLE  -s START -m FILE -f FORMATTED  -F DTL  -c ASCII   -l COLUMN      -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E ascii   -v catalog -V none     -i delete  -I delete  -r sourceinstroot -R targetinstroot',
'-T 15 -t TRANSPORT -p DB     -P TABLE  -s START -m FILE -f COMPRESSED -F DTL  -c ASCII   -l COLUMN      -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E ascii   -v catalog -V none     -i delete  -I delete  -r sourceinstroot -R targetinstroot',
#data																																											 	 																								
'-T 16 -t TRANSPORT -p DB     -P DB     -s START -m FILE -f PAGES      -F PAGE -c DYNAMIC -l TABLE       -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E ascii   -v all     -V sorted   -i data    -I system  -r sourceinstroot -R targetinstroot',
'-T 17 -t TRANSPORT -p DB     -P DB     -s START -m FILE -f RECORDS    -F ROW  -c ASCII   -l TABLE       -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E ascii   -v all     -V sorted   -i delete  -I system  -r sourceinstroot -R targetinstroot',
'-T 18 -t TRANSPORT -p DB     -P USER   -s START -m FILE -f PAGES      -F PAGE -c DYNAMIC -l TABLE       -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E ascii   -v data    -V sorted   -i delete  -I catalog -r sourceinstroot -R targetinstroot',
'-T 19 -t TRANSPORT -p DB     -P USER   -s START -m FILE -f RECORDS    -F ROW  -c ASCII   -l TABLE       -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E ascii   -v data    -V sorted   -i delete  -I catalog -r sourceinstroot -R targetinstroot',
'-T 20 -t TRANSPORT -p DB     -P TABLE  -s START -m FILE -f PAGES      -F PAGE -c DYNAMIC -l TABLE       -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E ascii   -v all     -V sorted   -i delete  -I catalog -r sourceinstroot -R targetinstroot',
'-T 21 -t TRANSPORT -p DB     -P TABLE  -s START -m FILE -f RECORDS    -F ROW  -c ASCII   -l TABLE       -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E ascii   -v all     -V sorted   -i delete  -I catalog -r sourceinstroot -R targetinstroot',
'-T 22 -t TRANSPORT -p DB     -P TABLE  -s START -m FILE -f FORMATTED  -F ROW  -c ASCII   -l COLUMNVALUE -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E ascii   -v all     -V sorted   -i delete  -I catalog -r sourceinstroot -R targetinstroot',
'-T 23 -t TRANSPORT -p DB     -P TABLE  -s START -m FILE -f FORMATTED  -F PAGE -c ASCII   -l COLUMN      -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E ascii   -v all     -V sorted   -i delete  -I catalog -r sourceinstroot -R targetinstroot',
'-T 24 -t TRANSPORT -p DB     -P TABLE  -s START -m FILE -f COMPRESSED -F ROW  -c ASCII   -l COLUMNVALUE -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E ascii   -v all     -V sorted   -i delete  -I catalog -r sourceinstroot -R targetinstroot',
'-T 25 -t TRANSPORT -p DB     -P TABLE  -s START -m FILE -f COMPRESSED -F PAGE -c ASCII   -l COLUMNVALUE -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E ascii   -v all     -V sorted   -i delete  -I catalog -r sourceinstroot -R targetinstroot',
#metadata                                usecases : ascii2unicode																												 	 																								
'-T 26 -t TRANSPORT -p DB     -P DB     -s START -m FILE -f DDL        -F DDL  -c ASCII   -l COLUMN      -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E unicode -v catalog -V sorted   -i catalog -I system  -r sourceinstroot -R targetinstroot',
'-T 27 -t TRANSPORT -p DB     -P TABLE  -s START -m FILE -f FORMATTED  -F PAGE -c ASCII   -l COLUMN      -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E unicode -v catalog -V none     -i delete  -I delete  -r sourceinstroot -R targetinstroot',
'-T 28 -t TRANSPORT -p DB     -P TABLE  -s START -m FILE -f COMPRESSED -F PAGE -c ASCII   -l COLUMN      -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E unicode -v catalog -V none     -i delete  -I delete  -r sourceinstroot -R targetinstroot',
#data																																											 	 																									
'-T 29 -t TRANSPORT -p DB     -P DB     -s START -m FILE -f RECORDS    -F ROW  -c DYNAMIC -l TABLE       -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E unicode -v all     -V sorted   -i data    -I catalog -r sourceinstroot -R targetinstroot',
'-T 30 -t TRANSPORT -p DB     -P USER   -s START -m FILE -f RECORDS    -F ROW  -c DYNAMIC -l TABLE       -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E unicode -v all     -V sorted   -i delete  -I catalog -r sourceinstroot -R targetinstroot',
'-T 31 -t TRANSPORT -p DB     -P TABLE  -s START -m FILE -f RECORDS    -F ROW  -c DYNAMIC -l TABLE       -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E unicode -v all     -V sorted   -i delete  -I catalog -r sourceinstroot -R targetinstroot',
'-T 32 -t TRANSPORT -p DB     -P TABLE  -s START -m FILE -f FORMATTED  -F ROW  -c ASCII   -l COLUMNVALUE -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E unicode -v all     -V sorted   -i delete  -I catalog -r sourceinstroot -R targetinstroot',
'-T 33 -t TRANSPORT -p DB     -P TABLE  -s START -m FILE -f FORMATTED  -F PAGE -c ASCII   -l COLUMN      -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E unicode -v all     -V sorted   -i delete  -I catalog -r sourceinstroot -R targetinstroot',
'-T 34 -t TRANSPORT -p DB     -P TABLE  -s START -m FILE -f COMPRESSED -F ROW  -c ASCII   -l COLUMNVALUE -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E unicode -v all     -V sorted   -i delete  -I catalog -r sourceinstroot -R targetinstroot',
'-T 35 -t TRANSPORT -p DB     -P TABLE  -s START -m FILE -f COMPRESSED -F PAGE -c ASCII   -l COLUMN      -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E unicode -v all     -V sorted   -i delete  -I catalog -r sourceinstroot -R targetinstroot',
'-T 36 -t TRANSPORT -p DB     -P TABLE  -s START -m FILE -f FORMATTED  -F ROW  -c UTF8    -l COLUMNVALUE -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E unicode -v all     -V sorted   -i delete  -I catalog -r sourceinstroot -R targetinstroot',
'-T 37 -t TRANSPORT -p DB     -P TABLE  -s START -m FILE -f FORMATTED  -F PAGE -c UTF8    -l COLUMN      -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E unicode -v all     -V sorted   -i delete  -I catalog -r sourceinstroot -R targetinstroot',
'-T 38 -t TRANSPORT -p DB     -P TABLE  -s START -m FILE -f COMPRESSED -F ROW  -c UTF8    -l COLUMNVALUE -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E unicode -v all     -V sorted   -i delete  -I catalog -r sourceinstroot -R targetinstroot',
'-T 39 -t TRANSPORT -p DB     -P TABLE  -s START -m FILE -f COMPRESSED -F PAGE -c UTF8    -l COLUMN      -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E unicode -v all     -V sorted   -i delete  -I catalog -r sourceinstroot -R targetinstroot',
#metadata                                usecases : unicode2unicode																												 	 																								
'-T 40 -t TRANSPORT -p DB     -P DB     -s START -m FILE -f DDL        -F DDL  -c UCS2    -l COLUMN      -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e unicode -E unicode -v catalog -V sorted   -i catalog -I system  -r sourceinstroot -R targetinstroot',
'-T 41 -t TRANSPORT -p DB     -P TABLE  -s START -m FILE -f PAGES      -F PAGE -c DYNAMIC -l COLUMN      -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e unicode -E unicode -v catalog -V sorted   -i delete  -I catalog -r sourceinstroot -R targetinstroot',
'-T 42 -t TRANSPORT -p DB     -P TABLE  -s START -m FILE -f RECORDS    -F ROW  -c UCS2    -l COLUMN      -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e unicode -E unicode -v catalog -V sorted   -i delete  -I delete  -r sourceinstroot -R targetinstroot',
'-T 43 -t TRANSPORT -p DB     -P TABLE  -s START -m FILE -f FORMATTED  -F PAGE -c UCS2    -l COLUMN      -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e unicode -E unicode -v catalog -V none     -i delete  -I delete  -r sourceinstroot -R targetinstroot',
'-T 44 -t TRANSPORT -p DB     -P TABLE  -s START -m FILE -f COMPRESSED -F PAGE -c UCS2    -l COLUMN      -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e unicode -E unicode -v catalog -V sorted   -i delete  -I delete  -r sourceinstroot -R targetinstroot',
#data																																											 	 																								
'-T 45 -t TRANSPORT -p DB     -P DB     -s START -m FILE -f PAGES      -F PAGE -c DYNAMIC -l TABLE       -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e unicode -E unicode -v all     -V sorted   -i data    -I system  -r sourceinstroot -R targetinstroot',
'-T 46 -t TRANSPORT -p DB     -P DB     -s START -m FILE -f RECORDS    -F ROW  -c UCS2    -l TABLE       -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e unicode -E unicode -v all     -V sorted   -i delete  -I system  -r sourceinstroot -R targetinstroot',
'-T 47 -t TRANSPORT -p DB     -P USER   -s START -m FILE -f RECORDS    -F ROW  -c UCS2    -l TABLE       -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e unicode -E unicode -v all     -V sorted   -i delete  -I catalog -r sourceinstroot -R targetinstroot',
'-T 48 -t TRANSPORT -p DB     -P TABLE  -s START -m FILE -f PAGES      -F PAGE -c DYNAMIC -l TABLE       -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e unicode -E unicode -v all     -V sorted   -i delete  -I catalog -r sourceinstroot -R targetinstroot',
'-T 49 -t TRANSPORT -p DB     -P TABLE  -s START -m FILE -f RECORDS    -F ROW  -c UCS2    -l TABLE       -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e unicode -E unicode -v all     -V sorted   -i delete  -I catalog -r sourceinstroot -R targetinstroot',
'-T 50 -t TRANSPORT -p DB     -P TABLE  -s START -m FILE -f FORMATTED  -F ROW  -c UCS2    -l COLUMNVALUE -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e unicode -E unicode -v all     -V sorted   -i delete  -I catalog -r sourceinstroot -R targetinstroot',
'-T 51 -t TRANSPORT -p DB     -P TABLE  -s START -m FILE -f FORMATTED  -F PAGE -c UCS2    -l COLUMN      -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e unicode -E unicode -v all     -V sorted   -i delete  -I catalog -r sourceinstroot -R targetinstroot',
'-T 52 -t TRANSPORT -p DB     -P TABLE  -s START -m FILE -f COMPRESSED -F ROW  -c UCS2    -l COLUMNVALUE -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e unicode -E unicode -v all     -V sorted   -i delete  -I catalog -r sourceinstroot -R targetinstroot',
'-T 53 -t TRANSPORT -p DB     -P TABLE  -s START -m FILE -f COMPRESSED -F PAGE -c UCS2    -l COLUMN      -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e unicode -E unicode -v all     -V sorted   -i delete  -I catalog -r sourceinstroot -R targetinstroot',
'-T 54 -t TRANSPORT -p DB     -P TABLE  -s START -m FILE -f FORMATTED  -F ROW  -c UTF8    -l COLUMNVALUE -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e unicode -E unicode -v all     -V sorted   -i delete  -I catalog -r sourceinstroot -R targetinstroot',
'-T 55 -t TRANSPORT -p DB     -P TABLE  -s START -m FILE -f FORMATTED  -F PAGE -c UTF8    -l COLUMN      -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e unicode -E unicode -v all     -V sorted   -i delete  -I catalog -r sourceinstroot -R targetinstroot',
'-T 56 -t TRANSPORT -p DB     -P TABLE  -s START -m FILE -f COMPRESSED -F ROW  -c UTF8    -l COLUMNVALUE -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e unicode -E unicode -v all     -V sorted   -i delete  -I catalog -r sourceinstroot -R targetinstroot',
'-T 57 -t TRANSPORT -p DB     -P TABLE  -s START -m FILE -f COMPRESSED -F PAGE -c UTF8    -l COLUMN      -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e unicode -E unicode -v all     -V sorted   -i delete  -I catalog -r sourceinstroot -R targetinstroot',
#metadata                                usecases : ascii2ascii																													 	 																									
'-T 58 -t TRANSPORT -p DB     -P DB     -s START -m PIPE -f DDL        -F DDL  -c ASCII   -l COLUMN      -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E ascii   -v catalog -V sorted   -i catalog -I system  -r sourceinstroot -R targetinstroot',
#data                                      																																		 	 																								
'-T 59 -t TRANSPORT -p DB     -P DB     -s START -m PIPE -f PAGES      -F PAGE -c DYNAMIC -l TABLE       -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E ascii   -v all     -V sorted   -i data    -I system  -r sourceinstroot -R targetinstroot',
'-T 60 -t TRANSPORT -p DB     -P DB     -s START -m PIPE -f RECORDS    -F ROW  -c ASCII   -l TABLE       -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E ascii   -v all     -V sorted   -i delete  -I system  -r sourceinstroot -R targetinstroot',
'-T 61 -t TRANSPORT -p DB     -P TABLE  -s START -m PIPE -f RECORDS    -F ROW  -c ASCII   -l TABLE       -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E ascii   -v all     -V sorted   -i delete  -I catalog -r sourceinstroot -R targetinstroot',
'-T 62 -t TRANSPORT -p DB     -P TABLE  -s START -m PIPE -f FORMATTED  -F ROW  -c ASCII   -l COLUMN      -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E ascii   -v all     -V sorted   -i delete  -I catalog -r sourceinstroot -R targetinstroot',
'-T 63 -t TRANSPORT -p DB     -P TABLE  -s START -m PIPE -f FORMATTED  -F PAGE -c ASCII   -l COLUMN      -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E ascii   -v all     -V sorted   -i delete  -I catalog -r sourceinstroot -R targetinstroot',
'-T 64 -t TRANSPORT -p DB     -P TABLE  -s START -m PIPE -f COMPRESSED -F ROW  -c ASCII   -l COLUMN      -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E ascii   -v all     -V sorted   -i delete  -I catalog -r sourceinstroot -R targetinstroot',
'-T 65 -t TRANSPORT -p DB     -P TABLE  -s START -m PIPE -f COMPRESSED -F PAGE -c ASCII   -l COLUMN      -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E ascii   -v all     -V sorted   -i delete  -I catalog -r sourceinstroot -R targetinstroot',
#metadata                                usecases : ascii2unicode																												 	 																									
'-T 66 -t TRANSPORT -p DB     -P DB     -s START -m PIPE -f DDL        -F DDL  -c ASCII   -l COLUMN      -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E unicode -v catalog -V sorted   -i catalog -I system  -r sourceinstroot -R targetinstroot',
#data                                      																																		 	 																									
'-T 67 -t TRANSPORT -p DB     -P DB     -s START -m PIPE -f RECORDS    -F ROW  -c DYNAMIC -l TABLE       -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E unicode -v all     -V sorted   -i data    -I catalog -r sourceinstroot -R targetinstroot',
'-T 68 -t TRANSPORT -p DB     -P USER   -s START -m PIPE -f RECORDS    -F ROW  -c DYNAMIC -l TABLE       -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E unicode -v all     -V sorted   -i delete  -I catalog -r sourceinstroot -R targetinstroot',
'-T 69 -t TRANSPORT -p DB     -P TABLE  -s START -m PIPE -f RECORDS    -F ROW  -c DYNAMIC -l TABLE       -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E unicode -v all     -V sorted   -i delete  -I catalog -r sourceinstroot -R targetinstroot',
'-T 70 -t TRANSPORT -p DB     -P TABLE  -s START -m PIPE -f FORMATTED  -F ROW  -c ASCII   -l COLUMN      -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E unicode -v all     -V sorted   -i delete  -I catalog -r sourceinstroot -R targetinstroot',
'-T 71 -t TRANSPORT -p DB     -P TABLE  -s START -m PIPE -f FORMATTED  -F PAGE -c ASCII   -l COLUMN      -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E unicode -v all     -V none     -i delete  -I catalog -r sourceinstroot -R targetinstroot',
'-T 72 -t TRANSPORT -p DB     -P TABLE  -s START -m PIPE -f COMPRESSED -F ROW  -c ASCII   -l COLUMN      -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E unicode -v all     -V sorted   -i delete  -I catalog -r sourceinstroot -R targetinstroot',
'-T 73 -t TRANSPORT -p DB     -P TABLE  -s START -m PIPE -f COMPRESSED -F PAGE -c ASCII   -l COLUMN      -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E unicode -v all     -V none     -i delete  -I catalog -r sourceinstroot -R targetinstroot',
#metadata                                usecases : unicode2unicode																												 	 																									
'-T 74 -t TRANSPORT -p DB     -P DB     -s START -m PIPE -f DDL        -F DDL  -c UCS2    -l COLUMN      -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e unicode -E unicode -v catalog -V sorted   -i catalog -I system  -r sourceinstroot -R targetinstroot',
#data                                      																																		 	 																									
'-T 75 -t TRANSPORT -p DB     -P DB     -s START -m PIPE -f PAGES      -F PAGE -c DYNAMIC -l TABLE       -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e unicode -E unicode -v all     -V sorted   -i data    -I system  -r sourceinstroot -R targetinstroot',
'-T 76 -t TRANSPORT -p DB     -P DB     -s START -m PIPE -f RECORDS    -F ROW  -c UCS2    -l TABLE       -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e unicode -E unicode -v all     -V sorted   -i delete  -I system  -r sourceinstroot -R targetinstroot',
'-T 77 -t TRANSPORT -p DB     -P TABLE  -s START -m PIPE -f RECORDS    -F ROW  -c UCS2    -l TABLE       -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e unicode -E unicode -v all     -V sorted   -i delete  -I catalog -r sourceinstroot -R targetinstroot',
'-T 78 -t TRANSPORT -p DB     -P TABLE  -s START -m PIPE -f FORMATTED  -F ROW  -c UCS2    -l COLUMN      -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e unicode -E unicode -v all     -V sorted   -i delete  -I catalog -r sourceinstroot -R targetinstroot',
'-T 79 -t TRANSPORT -p DB     -P TABLE  -s START -m PIPE -f FORMATTED  -F PAGE -c UCS2    -l COLUMN      -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e unicode -E unicode -v all     -V none     -i delete  -I catalog -r sourceinstroot -R targetinstroot',
'-T 80 -t TRANSPORT -p DB     -P TABLE  -s START -m PIPE -f COMPRESSED -F ROW  -c UCS2    -l COLUMN      -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e unicode -E unicode -v all     -V sorted   -i delete  -I catalog -r sourceinstroot -R targetinstroot',
'-T 81 -t TRANSPORT -p DB     -P TABLE  -s START -m PIPE -f COMPRESSED -F PAGE -c UCS2    -l COLUMN      -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e unicode -E unicode -v all     -V none     -i delete  -I catalog -r sourceinstroot -R targetinstroot',
'-T 82 -t TRANSPORT -p DB     -P TABLE  -s START -m PIPE -f COMPRESSED -F ROW  -c UTF8    -l COLUMN      -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e unicode -E unicode -v all     -V sorted   -i delete  -I catalog -r sourceinstroot -R targetinstroot',
#metadata                                usecases: ascii2ascii																													 	 																									
'-T 83 -t TRANSPORT -p DB     -P DB     -s START -m TAPE -f DDL        -F DDL  -c ASCII   -l COLUMN      -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E ascii   -v catalog -V sorted   -i catalog -I system  -r sourceinstroot -R targetinstroot',
#data                                      																																		 	 																								
'-T 84 -t TRANSPORT -p DB     -P DB     -s START -m TAPE -f PAGES      -F PAGE -c DYNAMIC -l TABLE       -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E ascii   -v all     -V sorted   -i data    -I system  -r sourceinstroot -R targetinstroot',
'-T 85 -t TRANSPORT -p DB     -P DB     -s START -m TAPE -f RECORDS    -F ROW  -c ASCII   -l TABLE       -n LOCALHOST -d SOURCEDB -u DBA,DBA -N LOCALHOST -D TARGETDB -U DBA,DBA       -e ascii   -E ascii   -v all     -V sorted   -i delete  -I system  -r sourceinstroot -R targetinstroot' 
]																																												 													

def _options ():																																									
    return [
    #testcase
    ('T', 'testcase'               , ':', '16'                  , 'specifies use   case'  ),   
    ('mode', 'mode'                , ':', 'PARAM'               , 'specifies use   mode'  ),                    # PARAM,INTER,DEBUG
    ('v', 'validation'             , ':', ''                    , 'specifies validation scope'),                # 
    ('V', 'validationmode'         , ':', ''                    , 'specifies validation type' ),                # 
    #transport sourcedb to targetdb
    ('t', 'transformationtype'     , ':', ''                    , 'type      of transformation '),              # TRANSPORT, EXPORT, IMPORT
    ('p', 'transformationpackage'  , ':', ''                    , 'package   of transformation '),              # DB   , USER, TABLE, WEBDAV
    ('P', 'transformationpart'     , ':', ''                    , 'part      of transformation '),              # DB   , USER, TABLE, WEBDAV
    ('m', 'streammedium'           , ':', ''                    , 'streammedium of transformation '),           # PIPE , FILE, TAPE
    ('f', 'streamformat'           , ':', ''                    , 'streamformat of transformation '),           # RECORDS, PAGES, COMPRESSED, FORMATTED, FORMATTED BINARY, DDL, XML
    ('F', 'streamformat_target'    , ':', ''                    , 'streamformat of transformation '),           # DATA  , FAST
    ('c', 'streamcharencoding'     , ':', ''                    , 'streamcoding of transformation '),           # ASCII , UCS2, UTF8
    ('l', 'streamlob'              , ':', ''                    , 'lobmask      of transformation '),           # COLUMN, COLUMNVALUE
    ('s', 'startposition'          , ':', ''                    , 'startposition transformation '),             # START , RESTART
    ('L', 'loaderinstroot'         , ':', ''                    , 'specifies sdb  loader  independent path'),   # 
    #sourcedb
    ('i', 'sourceinit'             , ':', ''                    , 'init      sdb  source'),                     # DELETE, SYSTEM, USER, CATALOG, DATA 
    ('e', 'sourcecharencoding'     , ':', ''                    , 'specifies sdb  source char encoding '),      # ASCII , UNICODE
    ('n', 'sourcenode'             , ':', socket.gethostname()  , 'specifies source servernode'),
    ('r', 'sourceinstroot'         , ':', '_sourceinstroot_'    , 'specifies sdb  source  instroot'), 
    ('j', 'sourceindepdatapath'    , ':', ''                    , 'specifies sdb  source  independent data path'), 
    ('k', 'sourceindepprogpath'    , ':', ''                    , 'specifies sdb  source  independent prog path'), 
    ('d', 'sourcedbname'           , ':', ''                    , 'specifies source serverdb to create'),
    ('u', 'sourcedbuser'           , ':', ''                    , 'specifies source SYSDBA user'),
    #targetdb
    ('I', 'targetinit'             , ':', ''                    , 'init      sdb  target'),                     # DELETE, SYSTEM, USER, CATALOG, DATA
    ('E', 'targetcharencoding'     , ':', ''                    , 'specifies sdb  target char encoding '),      # ASCII , UNICODE
    ('N', 'targetnode'             , ':', socket.gethostname()  , 'specifies target servernode '),
    ('R', 'targetinstroot'         , ':', '_targetinstroot_'    , 'specifies sdb  target  instroot'), 
    ('J', 'targetindepdatapath'    , ':', ''                    , 'specifies sdb  target  independent data path'), 
    ('K', 'targetindepprogpath'    , ':', ''                    , 'specifies sdb  target  independent prog path'), 
    ('D', 'targetdbname'           , ':', ''                    , 'specifies target serverdb to create'),
    ('U', 'targetdbuser'           , ':', ''                    , 'specifies target SYSDBA user'),
] 

INSTROOT = ['C:\\SAPDevelop\\V73\\c_00\\develop\\usr','C:\\SAPDevelop\\V743\\usr','C:\\SAPDevelop\\V75\\c_00\\develop\\usr','C:\\sapdevelop\\V75\\usr','C:\\sapdevelop\\V76\\usr']
INDEPPROGRAMS = ''
TESTPATH      = ''

#environment
def getEnvironment(options,environment):
    global INDEPPROGRAMS
    global TESTPATH
    if sys.platform[:3] == 'win': 
       import _winreg
       try:
           indepprog     = _winreg.QueryValueEx(_winreg.OpenKey(_winreg.HKEY_LOCAL_MACHINE,"SOFTWARE\\SAP\\SAP DBTech"),"IndepPrograms") 
           INDEPPROGRAMS = os.path.join(indepprog[0] )
           TESTPATH      = os.path.join(indepprog[0],'lib','test')
           if options.sourceinstroot == 'sourceinstroot':
              options.sourceinstroot  =  INSTROOT[2]
           else:
              options.sourceinstroot  =  INSTROOT[2]
           if options.targetinstroot == 'targetinstroot':
              options.targetinstroot  =  INSTROOT[2]
           else:
              options.targetinstroot  =  INSTROOT[2]
       except EnvironmentError,err:
           print err
    if sys.platform[:3] != 'win': 
       INDEPPROGRAMS = os.environ['INSTROOT']
       TESTPATH      = os.path.split(os.environ['JTEST_ROOT'])[0]
       options.loaderinstroot      =  INDEPPROGRAMS 
       if options.sourceinstroot  == 'sourceinstroot':
          options.sourceinstroot   =  INDEPPROGRAMS
       else:
          options.sourceinstroot   =  INSTROOT[2]
       if options.targetinstroot  == 'targetinstroot':
          options.targetinstroot   =  INDEPPROGRAMS
       else:
          options.targetinstroot   =  INSTROOT[2]
    environment.append(TESTPATH)

def main (options, args):
    rc = 0
    print "\nLoader test module:\n'%s'" % os.path.abspath(sys.argv[0])
    environment = []
    os.putenv('TESTLOADER','TRUE')
    getEnvironment (options,environment)
    testcase = options.testcase
    for case in re.split(',',testcase):
        options.testcase = string.atoi(case,10)
        #source db
        
        if  check_options(options) == 0 :
            #execute use case
            print '\n# %i: EXECUTE TESTCASE \n ' % (options.testcase)
            #transformation attributes
            print '-t %s  '  % options.transformationtype
            print '-p %s  '  % options.transformationpackage
            print '-P %s  '  % options.transformationpart
            print '-m %s  '  % options.streammedium
            print '-f %s  '  % options.streamformat
            print '-F %s  '  % options.streamformat_target
            print '-c %s  '  % options.streamcharencoding 
            print '-l %s  '  % options.streamlob
            print '-s %s\n'  % options.startposition
            
            #transformation resources
            init_transformation_resources(options,environment)
            
            #transport sourcedb to targetdb
            #     |Transformation                                        |Source           |Target Database                         
            cmd = '"%s" -T %s -t %s -p %s -P %s -m %s -f %s -F %s -c %s -l %s -s %s -n %s -d %s -u %s -N %s -D %s -U %s ' % ( 
            os.path.join( INDEPPROGRAMS ,'bin','loadercli.exe'),
            'EXECUTE', options.transformationtype,options.transformationpackage,options.transformationpart, 
            options.streammedium, options.streamformat, options.streamformat_target, options.streamcharencoding, options.streamlob, options.startposition,
            options.sourcenode, options.sourcedbname, options.sourcedbuser ,  
            options.targetnode, options.targetdbname, options.targetdbuser  )
            try:
               rc = os.system (cmd)
            except OSError, err:
               print 'command failed:', err
               
            #transformation resources   
            deinit_transformation_resources(options) 
            
def init_transformation_resources (options,environment):

    init_transformation_databases (options,environment)
    init_transformation_files     (options)
    
def deinit_transformation_resources(options):
    
    deinit_transformation_files    (options)  
    
    #transformation attributes
    options.transformationtype    = ''
    options.transformationpackage = ''
    options.transformationpart    = ''
    options.streammedium          = ''   
    options.streamformat          = ''    
    options.streamformat_target   = ''    
    options.streamcharencoding    = ''    
    options.streamcoding_target   = ''    
    options.streamblob            = ''    
    options.startposition         = ''    

    #sourcedb
    options.sourceinit            = ''
    options.transformationpackage = ''
    options.transformationpart    = ''
    options.sourcecharencoding    = ''   
    options.sourcenode            = ''  
    options.sourcedbname          = ''
    
    #targetdb   
    options.targetinit            = '' 
    options.targetcharencoding    = ''
    options.targetnode            = ''
    options.targetdbname          = ''          
    
def init_transformation_databases (options,environment):
    input = None
    rc    = 0
    TESTPATH = environment[0]
    while input not in ["y","n"]:   
          if options.mode == 'INTER':
             input = raw_input('Init      Transformation Databases ? [y]/[n] : ')
          if options.mode == 'PARAM':
             print             'Init      Transformation Databases '
             input  = "y"
          if input == "n":
             try:
                 session = dbm.DBM ('',options.sourcedbname, options.sourceinstroot, 'DBM,DBM' )
                 sourceindepdatapath = session.cmd('dbm_getpath INDEPDATAPATH ')
                 sourceindepprogpath = session.cmd('dbm_getpath INDEPPROGPATH ')
                 options.sourceindepdatapath = re.split('\n',sourceindepdatapath)[0]
                 options.sourceindepprogpath = re.split('\n',sourceindepprogpath)[0]
             except dbm.CommunicationError, err :
                 raise dbm.CommunicationError, err, sys.exc_traceback
             except dbm.DBMServError, err:
                 raise dbm.DBMServError, err , sys.exc_traceback 
             except:
                  kind, val, traceback = sys.exc_info()
                  raise kind, val, traceback
             try:
                 session = dbm.DBM ('',options.targetdbname, options.targetinstroot, 'DBM,DBM' )
                 targetindepdatapath = session.cmd('dbm_getpath INDEPDATAPATH ')
                 targetindepprogpath = session.cmd('dbm_getpath INDEPPROGPATH ')
                 options.targetindepdatapath = re.split('\n',targetindepdatapath)[0]
                 options.targetindepprogpath = re.split('\n',targetindepprogpath)[0]
             except dbm.CommunicationError, err :
                 raise dbm.CommunicationError, err, sys.exc_traceback
             except dbm.DBMServError, err:
                 raise dbm.DBMServError, err , sys.exc_traceback 
             except:
                  kind, val, traceback = sys.exc_info()
                  raise kind, val, traceback
          if input == "y":
             #sourcedb
             if options.sourceinit <> 'DELETE' and options.sourcedbname == 'SOURCEDB' :
                print '\nInstall   Databasesystem %s ' % options.sourcedbname
                cmd = 'x_python23 "%s" -mode %s -r "%s" -d %s -e %s '         % (os.path.join (TESTPATH,'sdb','dbm','demo','installdb.py' ) , options.mode ,options.sourceinstroot,options.sourcedbname,options.sourcecharencoding)
                try:
                    rc = os.system (cmd)
                except OSError, err:
                    print 'command failed:', err
             try:
                 session = dbm.DBM ('',options.sourcedbname, options.sourceinstroot, 'DBM,DBM' )
                 sourceindepdatapath = session.cmd('dbm_getpath INDEPDATAPATH ')
                 sourceindepprogpath = session.cmd('dbm_getpath INDEPPROGPATH ')
                 options.sourceindepdatapath = re.split('\n',sourceindepdatapath)[0]
                 options.sourceindepprogpath = re.split('\n',sourceindepprogpath)[0]
             except dbm.CommunicationError, err :
                 raise dbm.CommunicationError, err, sys.exc_traceback
             except dbm.DBMServError, err:
                 raise dbm.DBMServError, err , sys.exc_traceback 
             except:
                  kind, val, traceback = sys.exc_info()
                  raise kind, val, traceback
             #db
             if options.transformationpackage <> 'WEBDAV'  :          
                print '\nImport    Database       %s ' % options.sourcedbname
                cmd = 'x_python23 "%s" -mode %s -r "%s" -d %s -i %s'           % (os.path.join (TESTPATH,'sdb','loader','demo','import.py' ), options.mode,INDEPPROGRAMS ,options.sourcedbname,options.sourceinit)
                try:
                    rc = os.system (cmd)
                except OSError, err:
                    print 'command failed:', err    
             #dav
             if options.transformationpackage == 'WEBDAV'  :    
                print '\nImport    DAV Database   %s ' % options.sourcedbname
                cmd = 'x_python23 "%s" -mode %s -r "%s" -d %s -i %s -h %s:85'  % (os.path.join (TESTPATH,'sdb','dav'   ,'demo','import.py' ), options.mode,options.targetinstroot,options.sourcedbname,options.sourceinit,socket.gethostname())
                try:
                    rc = os.system (cmd)
                except OSError, err:
                    print 'command failed:', err        
                
             #targetdb
             if options.targetinit <> 'DELETE' and options.targetdbname == 'TARGETDB' :
                print '\nInstall   Databasesystem %s \n'  % options.targetdbname 
                cmd = 'x_python23 "%s" -mode %s -r "%s" -d %s -e %s '          % (os.path.join (TESTPATH,'sdb','dbm','demo','installdb.py' ), options.mode,options.targetinstroot,options.targetdbname,options.targetcharencoding)
                try:
                    rc = os.system (cmd)
                except OSError, err:
                    print 'command failed:', err
                   
             try:
                 session = dbm.DBM ('',options.targetdbname, options.targetinstroot, 'DBM,DBM' )
                 targetindepdatapath = session.cmd('dbm_getpath INDEPDATAPATH ')
                 targetindepprogpath = session.cmd('dbm_getpath INDEPPROGPATH ')
                 options.targetindepdatapath = re.split('\n',targetindepdatapath)[0]
                 options.targetindepprogpath = re.split('\n',targetindepprogpath)[0]
             except dbm.CommunicationError, err :
                 raise dbm.CommunicationError, err, sys.exc_traceback
             except dbm.DBMServError, err:
                 raise dbm.DBMServError, err , sys.exc_traceback 
             except:
                  kind, val, traceback = sys.exc_info()
                  raise kind, val, traceback
                           
             #db
             if options.transformationpackage <> 'WEBDAV'  :      
                print '\nImport    Database       %s '  % options.targetdbname 
                cmd = 'x_python23 "%s" -mode %s -r "%s" -d %s -i %s'           % (os.path.join (TESTPATH,'sdb','loader','demo','import.py' ), options.mode,INDEPPROGRAMS, options.targetdbname,options.targetinit)
                try:
                    rc = os.system (cmd)
                except OSError, err:
                    print 'command failed:', err  
             #dav
             if options.transformationpackage == 'WEBDAV'  :        
                print '\nImport    DAV Database   %s'   % options.targetdbname
                cmd = 'x_python23 "%s" -mode %s -r "%s" -d %s -i %s -h %s:85'  % (os.path.join (TESTPATH,'sdb','dav'   ,'demo','import.py' ), options.mode,options.targetinstroot,options.targetdbname,options.targetinit,socket.gethostname())
                try:
                    rc = os.system (cmd)
                except OSError, err:
                    print 'command failed:', err   

    return rc
           
def init_transformation_files     (options): 
    input = None
    global LOADERDATAPATH
    global LOADERAPPLPATH
    sourceloaderdatapath  = None
    targetloaderdatapath  = None
    sourcetapedatapath    = None
    targettapedatapath    = None
    if sys.platform[:3] == 'win': 
       import _winreg
       LOADERDATAPATH = os.path.join (_winreg.QueryValueEx(_winreg.OpenKey(_winreg.HKEY_CURRENT_USER ,"Volatile Environment"),"HOMEDRIVE")[0], _winreg.QueryValueEx(_winreg.OpenKey(_winreg.HKEY_CURRENT_USER ,"Volatile Environment"),"HOMEPATH")[0])
       LOADERAPPLPATH = _winreg.QueryValueEx(_winreg.OpenKey(_winreg.HKEY_CURRENT_USER ,"Volatile Environment"),"APPDATA")[0] 
    if sys.platform[:3] != 'win': 
       LOADERDATAPATH = os.environ['HOME']
       LOADERAPPLPATH = os.environ['HOME']
    
    sourceloaderdatapath = os.path.join(LOADERDATAPATH, 'sdb','loader','data', 'export', options.sourcenode, options.sourcedbname)
    targetloaderdatapath = os.path.join(LOADERDATAPATH, 'sdb','loader','data', 'import', options.targetnode, options.targetdbname)
    sourcetapedatapath   = os.path.join(LOADERDATAPATH, 'sdb','tape'  , options.sourcenode, options.sourcedbname)
    targettapedatapath   = os.path.join(LOADERDATAPATH, 'sdb','tape'  , options.targetnode, options.targetdbname)

    while input not in ["y","n"]:   
          if options.mode == 'INTER':
             input = raw_input('Init      Transformation Files ?     [y]/[n] : ')
          if options.mode == 'PARAM':
             print             'Init      Transformation Files '
             input  = "y"
          if input == "n": 
              pass          
        
          if input == "y": 
              #source and target loader protocol file             
              try :
                  print 'Loader Application Data: %s' % os.path.join (LOADERAPPLPATH, 'sdb', 'loader') 
                  os.chdir (os.path.join (LOADERAPPLPATH, 'sdb', 'loader', 'log' ))
                  curdir = os.getcwd()
                  for file in os.listdir(curdir) :
                      if os.path.isfile(file) and  ( string.find(file,'loader') == 0 or string.find(file,'%s_loader' % options.testcase ) == 0 or string.find(file,'%s_install' % options.testcase ) == 0) :
                         try:
                            os.unlink(file)
                         except OSError, err:
                            print 'os.unlink (%s) failed: %s ' %( file ,err )
              except OSError, (errno, err ):
                  if errno <> 17 :
                     print 'command failed %s ' % ( err )
              
              #backup file     
              try:
                  os.makedirs (sourcetapedatapath)
                  os.makedirs (targettapedatapath) 
              except OSError, (errno, err ):
                  if errno <> 17 :
                     print 'os.makedirs (%s) failed: %s ' % (sourcetapedatapath, err )
                     
              if options.streammedium == 'TAPE' and socket.gethostname() == 'p66796':            
                 try :
                     os.chdir ("C:\\WINNT\\Temp\\")
                 except OSError, err:
                     print 'command failed:', err 
                  
                 curdir = os.getcwd() 
                 print 'Empty     Directory %s' % curdir     
                 for file in os.listdir(curdir) :
                     if ( os.path.isfile(file) and ( 
                          string.find(file,'temp')  == 0 )):
                          try:
                              os.unlink(file)
                          except OSError, err:
                              print 'command failed:', err 
                    
def deinit_transformation_files (options):
    # install protocol                  
    try :
        os.chdir (os.path.join (LOADERAPPLPATH, 'sdb','loader','log'))
    except OSError, (errno, err ):
        print 'os.chdir %s : %s ' % (os.path.join (LOADERAPPLPATH, 'sdb','loader','log') , err  )
    
    for file in os.listdir(os.curdir) :        
        if os.path.isfile(file) and  string.find(file,'install') == 0 :
           time.sleep(1) 
           file_install = string.replace(file, 'install', '%s_install' % options.testcase ) 
           try:
              os.rename(file,file_install)
           except OSError, err:
              print 'os.rename(%s) failed: %s ' % ( file , err )

    #loader protocol
    try :
        os.chdir (os.path.join (LOADERAPPLPATH, 'sdb','loader','log'))
    except OSError, (errno, err ):
        print 'os.chdir %s : %s ' % (os.path.join (LOADERAPPLPATH, 'sdb','loader','log'), err  )
   
    for file in os.listdir(os.curdir) :
        if os.path.isfile(file) and  string.find(file,'loader') == 0 :
           time.sleep(1) 
           file_target = string.replace(file, 'loader', '%s_loader' % options.testcase ) 
           try:
              os.rename(file,file_target)
           except OSError, err:
              print 'os.rename(%s) failed: %s ' % ( file , err )
              
def check_options(options):
    rc = 0
    
    #testcase
    if options.testcase              == '':    
       options.testcase               = string.upper(string.strip(re.split('-',parameters[options.testcase-1]) [1] [1:]))
    #transformation 
    if options.transformationtype    == '':
       options.transformationtype     = string.upper(string.strip(re.split('-',parameters[options.testcase-1]) [2] [1:]))  
    else:
       options.transformationtype     = string.upper(options.transformationtype)
    if options.transformationpackage == '':
       options.transformationpackage  = string.upper(string.strip(re.split('-',parameters[options.testcase-1]) [3] [1:]))
    if options.transformationpart    == '':
       options.transformationpart     = string.upper(string.strip(re.split('-',parameters[options.testcase-1]) [4] [1:]))       
    if options.startposition         == '':    
       options.startposition          = string.upper(string.strip(re.split('-',parameters[options.testcase-1]) [5] [1:]))       
    #stream   
    if options.streammedium          == '':   
       options.streammedium           = string.upper(string.strip(re.split('-',parameters[options.testcase-1]) [6] [1:]))
    if options.streamformat          == '':    
       options.streamformat           = string.upper(string.strip(re.split('-',parameters[options.testcase-1]) [7] [1:]))
    if options.streamformat_target   == '':    
       options.streamformat_target    = string.upper(string.strip(re.split('-',parameters[options.testcase-1]) [8] [1:]))
    if options.streamcharencoding   == '':    
       options.streamcharencoding     = string.upper(string.strip(re.split('-',parameters[options.testcase-1]) [9] [1:]))
    if options.streamlob             == '':    
       options.streamlob              = string.upper(string.strip(re.split('-',parameters[options.testcase-1])[10] [1:]))
    #database
    if options.sourcenode            == 'localhost' or options.sourcenode == '':  
       options.sourcenode             = socket.gethostname()
    if options.sourcedbname          == '':
       options.sourcedbname           = string.upper(string.strip(re.split('-',parameters[options.testcase-1])[12] [1:]))
    if options.sourcedbuser          == '':
       options.sourcedbuser           = string.upper(string.strip(re.split('-',parameters[options.testcase-1])[13] [1:]))
    if options.targetnode            == 'localhost' or options.targetnode == '':
       options.targetnode             = socket.gethostname()
    if options.targetdbname          == '':
       options.targetdbname           = string.upper(string.strip(re.split('-',parameters[options.testcase-1])[15] [1:]))
    if options.targetdbuser          == '':
       options.targetdbuser           = string.upper(string.strip(re.split('-',parameters[options.testcase-1])[16] [1:]))
    #testenvironment
    if options.sourcecharencoding    == '': 
       options.sourcecharencoding     = string.upper(string.strip(re.split('-',parameters[options.testcase-1])[17] [1:])) 
    if options.targetcharencoding    == '':
       options.targetcharencoding     = string.upper(string.strip(re.split('-',parameters[options.testcase-1])[18] [1:]))                     
    if options.validation            == '':    
       options.validation             = string.upper(string.strip(re.split('-',parameters[options.testcase-1])[19] [1:]))
    if options.validationmode        == '':    
       options.validationmode         = string.upper(string.strip(re.split('-',parameters[options.testcase-1])[20] [1:]))                    
    if options.sourceinit            == '':
       options.sourceinit             = string.upper(string.strip(re.split('-',parameters[options.testcase-1])[21] [1:]))
    else:
       options.sourceinit             = string.upper(options.sourceinit)
    if options.targetinit            == '': 
       options.targetinit             = string.upper(string.strip(re.split('-',parameters[options.testcase-1])[22] [1:]))
    else:
       options.targetinit             = string.upper(options.targetinit)

    return rc   
              
def check_parameter(options):
    rc    = 0 
    if( check_range        (options) <> 0 or
        check_parameter    (options) <> 0 or
        check_configuration(options) <> 0   ):
        rc = 1
    return rc            
           
def check_range    (options):
    rc = 0
    if options.testcase > 85:
       print 'Index out of range.' 
       rc = 1
    return rc  

def check_configuration (options):
    rc = 0
    if options.transformationpackage == 'WEBDAV':
       if(socket.gethostname() == 'P48126' or   #markus
          socket.gethostname() == 'P48142' or 
          socket.gethostname() == 'p66796' or 
          socket.gethostname() == 'P76209' or
          socket.gethostname() == 'P59953'   ) :
          rc = 0
       else:        
          print 'transformationpackage DAV: test restricted on server' 
          rc = 1
    if options.streammedium == 'TAPE' :
       if(socket.gethostname() == 'P47579' or   #tilo
          socket.gethostname() == 'p66796' or
          socket.gethostname() == 'P76209'   ) :
          rc = 0
       else:
           print 'medium TAPE: test restricted on server' 
           rc = 1
    if options.streammedium == 'PIPE':
       if sys.platform == 'win32':
          rc = 0
       else: 
          print 'medium PIPE: test restricted on platform' 
          rc = 1
    return rc
       
if __name__ == '__main__':
   optlib.optMain2 (main, _options () )
