/*!
   @file           Log_IImage.hpp
   @author         UweH
   @ingroup        Logging
   @brief          defines the class Log_IImage

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



\endif
 */



#ifndef Log_IImage_H
#define Log_IImage_H

/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "SAPDBCommon/SAPDB_Types.hpp"
#include "DataAccess/Data_ISplitSpace.hpp"
#include "Logging/Log_Types.hpp"

/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/
/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/
/*===========================================================================*
 *  EXTERNAL VARIABLES                                                       *
 *===========================================================================*/
/*===========================================================================*
 *  CLASSES, STRUCTURES, TYPES, UNIONS ...                                   *
 *===========================================================================*/

/*!
   @interface      Log_IImage
   @brief          common image interface
 */

class Log_IImage
{

public:
    /// returns the action type
    virtual Log_ActionType GetActionType() const = 0;
    
    /// returns the local entry sequence
    virtual Log_EntrySequence GetSequence() const = 0;

    /// the image is written as persistent layout
    virtual void WritePersistentFormat (Data_SplitSpaceWriter &Writer,
                                        bool                  &isOK) const = 0;

    /// the image is read from persistent layout
    virtual void ReadPersistentFormat (Data_SplitSpaceReader &Reader,
                                       bool                  &isOK,
                                       bool                   checkAlignment = false) = 0;
    /// the action is written to the trace file
    virtual void WriteToTrace (const char * title) const = 0;

    /// returns true, if image is an after image.
    virtual bool IsAfterImage () const = 0;
};


#endif  /* Log_IImage_H */
