/*!
    @file    DBMSrvFrmCmd_Arguments.hpp
    @author  BerndV
    @ingroup DBMServer commands
    @brief   object to analyze the command arguments 

    ========== licence begin  GPL
    Copyright (c) 2002-2006 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end
*/

#if !defined(DBMSrvFrmCmd_Arguments_hpp)
#define DBMSrvFrmCmd_Arguments_hpp

#include "ToolsCommon/Tools_CommandlineToArgumentsConverter.hpp"
#include "ToolsCommon/Parsers/ToolsParsers_ProgramParameterParser.hpp"
#include "DBM/Srv/Message/DBMSrvMsg_Error.hpp"

/*! @brief a class for parsing the arguments of a DBMServer comamnd
 */
class DBMSrvFrmCmd_Arguments
{
public:
    /*! @brief constructor
        
        This constructor creates the object with the given arguments. See file
        ToolsParsers_ProgramParameterParser.hpp for more information about 
        syntax description.

        @param Arguments [IN] a zero terminated character string with the arguments
        @param Syntax    [IN] a zero terminated string with the syntax to parse
        @param Command   [IN] the current command to add this value in the error message
     */
    DBMSrvFrmCmd_Arguments
        ( const char * Arguments,
          const char * Syntax,
          const char * Command);

    /*! @brief destructor
     */
    ~DBMSrvFrmCmd_Arguments
        ( );

    /*! @brief function to retrieve the parse result
        
        The function reports any errors via DBMSrvMsg_Error object to the caller. Therefore
        the caller should use an emtpy message list. This function does _not_ clear the
        DBMSrvMsg_Error object Please check the DBMSrvMsg_Error object _before_ accessing 
        the result. The reference to the parse results becomes invalid on destruction of 
        the DBMSrvFrmCmd_Arguments object.

        @param  Error [OUT] This object returns a error. 
        @return the parse result (see ToolsParsers_ParseResult.hpp for more information)
                This reference becomes invalid after the destructions of this object.
     */
    const ToolsParsers_ParseResult & parse 
        ( DBMSrvMsg_Error & Error );

private:
    const char * m_Arguments;
    const char * m_Syntax;
    const char * m_Command;

    ToolsParsers_ProgramParameterParser   * m_pParser;
    Tools_CommandlineToArgumentsConverter   m_oConverter;
    ToolsParsers_ParseResult                m_oDummyParseResult;

}; // end class DBMSrvFrmCmd_Arguments

#endif // DBMSrvFrmCmd_Arguments
