/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc;

import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.InternalStatementSapDB;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.util.MessageTranslator;
import java.sql.SQLException;
import java.sql.Savepoint;

public class SavepointSapDB
implements Savepoint {
    private int SavepointId = 0;
    private String SavepointName = null;
    private boolean released = false;
    private static int savepointIndex = 0;
    private static final String savepointPrefix_C = "JDBC_SP_";
    private InternalStatementSapDB internalStmt = null;

    public SavepointSapDB(ConnectionSapDB connectionSapDB) throws SQLException {
        this.SavepointId = SavepointSapDB.nextSavepointID();
        this.internalStmt = new InternalStatementSapDB(connectionSapDB, 5);
    }

    public SavepointSapDB(String string, ConnectionSapDB connectionSapDB) throws SQLException {
        this.SavepointName = string;
        this.internalStmt = new InternalStatementSapDB(connectionSapDB, 5);
    }

    public int getSavepointId() throws SQLException {
        if (this.SavepointId == 0) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.named.savepoint"));
        }
        return this.SavepointId;
    }

    public String getSavepointName() throws SQLException {
        if (this.SavepointName == null) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.unnamed.savepoint"));
        }
        return this.SavepointName;
    }

    static final synchronized int nextSavepointID() {
        return ++savepointIndex;
    }

    final String getInternalSavepointName() {
        if (this.SavepointName == null) {
            return savepointPrefix_C + String.valueOf(this.SavepointId);
        }
        return this.SavepointName;
    }

    private void rollbackSavepoint() throws SQLException {
        this.internalStmt.execute("ROLLBACK TO SAVEPOINT " + this.getInternalSavepointName());
    }

    private void releaseSavepoint() throws SQLException {
        this.released = true;
        if (this.internalStmt.getConnectionSapDB().isReleaseSavePointSupported()) {
            try {
                this.internalStmt.execute("RELEASE SAVEPOINT " + this.getInternalSavepointName());
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() == -3005) {
                    this.internalStmt.getConnectionSapDB().setReleaseSavePointSupported(false);
                }
                throw sQLException;
            }
        }
    }

    private boolean isrelease() {
        return this.released;
    }

    public static Savepoint setSavepoint(ConnectionSapDB connectionSapDB) throws SQLException {
        SavepointSapDB savepointSapDB = new SavepointSapDB(connectionSapDB);
        savepointSapDB.internalStmt.execute("SAVEPOINT " + savepointSapDB.getInternalSavepointName());
        return savepointSapDB;
    }

    public static Savepoint setSavepoint(String string, ConnectionSapDB connectionSapDB) throws SQLException {
        SavepointSapDB savepointSapDB = new SavepointSapDB(string, connectionSapDB);
        savepointSapDB.internalStmt.execute("SAVEPOINT " + savepointSapDB.getInternalSavepointName());
        return savepointSapDB;
    }

    public static void rollback(Savepoint savepoint) throws SQLException {
        SavepointSapDB savepointSapDB;
        try {
            savepointSapDB = (SavepointSapDB)savepoint;
        }
        catch (ClassCastException classCastException) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.nosavepointsapdb", savepoint.getClass()));
        }
        if (savepointSapDB.isrelease()) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.savepoint.released"));
        }
        savepointSapDB.rollbackSavepoint();
    }

    public static void releaseSavepoint(Savepoint savepoint) throws SQLException {
        SavepointSapDB savepointSapDB;
        try {
            savepointSapDB = (SavepointSapDB)savepoint;
        }
        catch (ClassCastException classCastException) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.nosavepointsapdb", savepoint.getClass()));
        }
        if (savepointSapDB.isrelease()) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.savepoint.released"));
        }
        savepointSapDB.releaseSavepoint();
    }
}

