
#    ========== licence begin  GPL
#    Copyright (c) 2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end
"""
Various extensions to the core SAX 2.0 API.

$Id: sax2exts.py,v 1.5 2001/12/30 22:17:03 loewis Exp $
"""

import saxexts,saxlib

# In SAX2, validation is turned-on through a property. Make sure
# that all parsers returned from this factory are validating
class ValidatingReaderFactory(saxexts.ParserFactory):
    def make_parser(self, parser_list = []):
        p = saxexts.ParserFactory.make_parser(self,parser_list)
        p.setFeature(saxlib.feature_validation, 1)
        return p


# --- XMLReader factory

XMLReaderFactory = saxexts.ParserFactory

# --- Creating parser factories

XMLParserFactory = XMLReaderFactory(["xml.sax.drivers2.drv_pyexpat",
                                     "xml.sax.drivers2.drv_xmlproc"])

XMLValParserFactory = ValidatingReaderFactory(["xml.sax.drivers2.drv_xmlproc"])

HTMLParserFactory=XMLReaderFactory(["xml.sax.drivers2.drv_htmllib",
                                    "xml.sax.drivers2.drv_sgmlop",
                                    "xml.sax.drivers2.drv_sgmllib"])

SGMLParserFactory=XMLReaderFactory(["xml.sax.drivers2.drv_sgmlop",
                                    "xml.sax.drivers2.drv_sgmllib"])

def make_parser(parser_list = []):
    return XMLParserFactory.make_parser(parser_list)
