
#    ========== licence begin  GPL
#    Copyright (c) 2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end
"""
SAX driver for htmllib.py

$Id: drv_htmllib.py,v 1.5 2001/12/30 12:13:44 loewis Exp $
"""

version="0.10"

from xml.sax import saxutils,saxlib
from xml.sax.drivers import pylibs

import htmllib,sys,string

# --- SAX_HLParser

class SAX_HLParser(pylibs.SGMLParsers,htmllib.HTMLParser):
    "SAX driver for htmllib.py."

    def __init__(self):
        htmllib.HTMLParser.__init__(self,None)
        pylibs.LibParser.__init__(self)
        self.standalone=0

    # --- EXPERIMENTAL PYTHON SAX EXTENSIONS

    def get_parser_name(self):
        return "htmllib"

    def get_parser_version(self):
        return sys.version[:string.find(sys.version," ")]

    def get_driver_version(self):
        return version

    def is_validating(self):
        return 0

    def is_dtd_reading(self):
        return 0

    # reset and feed are taken care of by the subclassing :-)

    def close(self):
        htmllib.HTMLParser.close(self)
        self.doc_handler.endDocument()

# --- Global functions

def create_parser():
    return SAX_HLParser()
