########################################################################
#
# File Name:            implementation.py
#
# Documentation:        http://docs.4suite.com/4DOM/implementation.py.html
#
#    ========== licence begin  GPL
#    Copyright (c) 2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end

"""
WWW: http://4suite.com/4DOM         e-mail: support@4suite.com

Copyright (c) 2000 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.com/COPYRIGHT  for license and copyright information
"""

from xml.dom import DOMImplementation

# Add the HTML feature
DOMImplementation.FEATURES_MAP['HTML'] = 2.0

class HTMLDOMImplementation(DOMImplementation.DOMImplementation):

    def __init__(self):
        DOMImplementation.DOMImplementation.__init__(self)

    def createHTMLDocument(self, title):
        from xml.dom.html import HTMLDocument
        doc = HTMLDocument.HTMLDocument()
        h = doc.createElement('HTML')
        doc.appendChild(h)
        doc._set_title(title)
        return doc

    def _4dom_createHTMLCollection(self,list=None):
        if list is None:
            list = []
        from xml.dom.html import HTMLCollection
        hc = HTMLCollection.HTMLCollection(list)
        return hc
