# DOMException
#    ========== licence begin  GPL
#    Copyright (c) 2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end

from xml.dom import INDEX_SIZE_ERR, DOMSTRING_SIZE_ERR , HIERARCHY_REQUEST_ERR
from xml.dom import WRONG_DOCUMENT_ERR, INVALID_CHARACTER_ERR, NO_DATA_ALLOWED_ERR
from xml.dom import NO_MODIFICATION_ALLOWED_ERR, NOT_FOUND_ERR, NOT_SUPPORTED_ERR
from xml.dom import INUSE_ATTRIBUTE_ERR, INVALID_STATE_ERR, SYNTAX_ERR
from xml.dom import INVALID_MODIFICATION_ERR, NAMESPACE_ERR, INVALID_ACCESS_ERR

# EventException
from xml.dom import UNSPECIFIED_EVENT_TYPE_ERR

#Range Exceptions
from xml.dom import BAD_BOUNDARYPOINTS_ERR
from xml.dom import INVALID_NODE_TYPE_ERR

# Fourthought Exceptions
from xml.dom import XML_PARSE_ERR

try:
    import os, gettext
    locale_dir = os.path.split(__file__)[0]
    gettext.install('4Suite', locale_dir)
except (ImportError, AttributeError, IOError):
    def _(msg):
        return msg

DOMExceptionStrings = {
    INDEX_SIZE_ERR: _("Index error accessing NodeList or NamedNodeMap"),
    DOMSTRING_SIZE_ERR: _("DOMString exceeds maximum size"),
    HIERARCHY_REQUEST_ERR: _("Node manipulation results in invalid parent/child relationship."),
    WRONG_DOCUMENT_ERR: _("Node is from a different document"),
    INVALID_CHARACTER_ERR: _("Invalid or illegal character"),
    NO_DATA_ALLOWED_ERR: _("Node does not support data"),
    NO_MODIFICATION_ALLOWED_ERR: _("Attempt to modify a read-only object"),
    NOT_FOUND_ERR: _("Node does not exist in this context"),
    NOT_SUPPORTED_ERR: _("Object or operation not supported"),
    INUSE_ATTRIBUTE_ERR: _("Attribute already in use by an element"),
    INVALID_STATE_ERR: _("Object is not, or is no longer, usable"),
    SYNTAX_ERR: _("Specified string is invalid or illegal"),
    INVALID_MODIFICATION_ERR: _("Attempt to modify the type of a node"),
    NAMESPACE_ERR: _("Invalid or illegal namespace operation"),
    INVALID_ACCESS_ERR: _("Object does not support this operation or parameter"),
    }

EventExceptionStrings = {
    UNSPECIFIED_EVENT_TYPE_ERR : _("Uninitialized type in Event object"),
    }

FtExceptionStrings = {
    XML_PARSE_ERR : _("XML parse error at line %d, column %d: %s"),
    }

RangeExceptionStrings = {
    BAD_BOUNDARYPOINTS_ERR : _("Invalid Boundary Points specified for Range"),
    INVALID_NODE_TYPE_ERR : _("Invalid Container Node")
    }
