########################################################################
#
# File Name:            DocumentFragment.py
#
# Documentation:        http://docs.4suite.com/4DOM/DocumentFragment.py.html
#
#    ========== licence begin  GPL
#    Copyright (c) 2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end

"""
WWW: http://4suite.com/4DOM         e-mail: support@4suite.com

Copyright (c) 2000 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.com/COPYRIGHT  for license and copyright information
"""

from xml.dom import Node
from FtNode import FtNode

class DocumentFragment(FtNode):
    nodeType = Node.DOCUMENT_FRAGMENT_NODE
    _allowedChildren = [Node.ELEMENT_NODE,
                        Node.PROCESSING_INSTRUCTION_NODE,
                        Node.COMMENT_NODE,
                        Node.TEXT_NODE,
                        Node.CDATA_SECTION_NODE,
                        Node.ENTITY_REFERENCE_NODE]

    def __init__(self, ownerDocument):
        FtNode.__init__(self, ownerDocument)
        self.__dict__['__nodeName'] = '#document-fragment'

    ### Overridden Methods ###

    def __repr__(self):
        return '<DocumentFragment Node at %x: with %d children>' % (
                id(self),
                len(self.childNodes),
                )

    ### Helper Functions For Cloning ###

    def _4dom_clone(self, owner):
        return self.__class__(owner)

    def __getinitargs__(self):
        return (self.ownerDocument,
                )
