/*!******************************************************************************

  @file         hkb391.h

  ------------------------------------------------------------------------------

  @author       <unknown>

  @brief        <unknown topic>

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2001-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end
\endif

********************************************************************************/

#ifndef HKB391_H
#define HKB391_H


/*===========================================================================*
 *     RefType: Both                                                         *
 *===========================================================================*/

/*===========================================================================*
 *     MD5: '\x89\xd8\xc3\x9d\x49\x57\x6a\xfe\x02\x91\x5a\x80\x2d\x95\x7c\xec'
 *===========================================================================*/


/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gsp00.h"
#include "ggg00.h"
#include "gkb00.h"
#include "gkb03.h"


/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/

externPascal void kb391InitLogSaveIterator (
    tgg00_TransContext    VAR_VALUE_REF  trans,
    tsp00_Int2                           maxToBeRead,
    pasbool                              dbIsCold,
    pasbool                              forAutosave,
    pasbool                              completeLog,
    pasbool                              repeatable);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb391FreeLog (
    tsp00_TaskId                         taskId,
    tgg00_BasisError      VAR_VALUE_REF  trError);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb391FreeLogForPipe (
    tsp00_TaskId                         taskId,
    const Log_IOSequenceNo&                 firstSavedIOsequence,
    const Log_IOSequenceNo&                 lastSavedIOsequence,
    tgg00_BasisError      VAR_VALUE_REF  trError);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb391InvalidateSaveIterator ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb391ReadNextLogpages (
    tgg00_TransContext    VAR_VALUE_REF  trans,
    tkb3_block_ptr                       queue_buffer,
    tsp00_Int2            VAR_VALUE_REF  num_read);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb391GetSaveIterInfo (
    Kernel_Time&                         startTime,
    Kernel_Date&                         startDate,
    Kernel_Time&                         endTime,
    Kernel_Date&                         endDate,
    Log_IOSequenceNo&                    startIOSeq,
    Log_IOSequenceNo&                    endIOSeq,
    Log_RawDeviceOffset&                 pageCount,
    tsp00_Int4            VAR_VALUE_REF  backupCount);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb391GetNumOfPagesLeftForSegment (
    tsp00_Uint4           VAR_VALUE_REF  numOfUnsavedPages);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb391GetNumOfPagesLeftForLogDev (
    tsp00_Uint4           VAR_VALUE_REF  numOfUnsavedPages);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool kb391IOSeqIsInPage (
    const Log_IOSequenceNo&                 ioSequence,
    tkb00_Page            VAR_VALUE_REF  page);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool kb391IOSeqIsYoungerThanPage (
    const Log_IOSequenceNo&                 ioSequence,
    const Log_IOSequenceNo&                 oldestKnownIOSeq,
    tkb00_Page            VAR_VALUE_REF  page);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb391InitializeWaitLists ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb391ResumeAllWaitingTask (
    pasbool                              forAutosave);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb391ResumeFirstWaitingTask (
    pasbool                              forRead,
    pasbool                              forAutosave);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb391InsertWaitingTaskAtLast (
    tsp00_TaskId                         taskid,
    tgg00_WaitContext     VAR_VALUE_REF  waitcontext,
    pasbool                              forRead,
    pasbool                              forAutosave);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb391Create_RTEConf_ParameterAccess (
    tgg00_TransContext    VAR_VALUE_REF  trans,
    tsp00_Addr            VAR_VALUE_REF  params);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb391AppendTo_RTEConf_ParameterAccess (
    RTEConf_Parameter&                   params,
    tkb3_xparam_page      VAR_VALUE_REF  xpPage);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tgg00_BasisError kb391CheckParameterForRestore (
    RTEConf_Parameter&                   params);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb391Destroy_RTEConf_ParameterAccess (
    tgg00_TransContext    VAR_VALUE_REF  trans,
    tsp00_Addr            VAR_VALUE_REF  params);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool kb391SupressDBIdentCheckForMigration (
    tsp00_Version         VAR_ARRAY_REF  backupVersion);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb391CheckLogTapeAndDataCompatibility (
    tgg00_TransContext    VAR_VALUE_REF  trans,
    const tkb00_Page&                    restartRecord,
    tsp00_Version         VAR_ARRAY_REF  backupVersion,
    tsp00_Line            VAR_ARRAY_REF  dbident,
    const Log_IOSequenceNo&                 firstIOSeq,
    const Log_IOSequenceNo&                 lastIOSeq);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool kb391ValidLogSaveIterator ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb391CheckLogBackup (
    tsp00_TaskId                         taskId,
    pasbool               VAR_VALUE_REF  rteCancelFlag,
    const Log_IOSequenceNo&                 firstIOSequence,
    const Log_IOSequenceNo&                 lastIOSequence,
    tgg00_BasisError      VAR_VALUE_REF  trError);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb391AppendTapeErrorToMessageList (
    tsp00_TaskId                         taskid,
    pasbool                              isInfo,
    pasbool                              writeImmediately,
    tsp00_Int4                           mediano,
    tsp00_VFilename       VAR_ARRAY_REF  medianame,
    tsp00_ErrText         VAR_ARRAY_REF  errortext);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb391TestAndPrintErrorList (
    tgg00_TransContext    VAR_VALUE_REF  trans);

/* Don't edit this file by hand, it is generated by ptocProto.py */


#endif

