/*!***************************************************************************

  module      : SQLMan_SQLStatementContext.cpp

  -------------------------------------------------------------------------

  responsible : ThomasA

  special area: SQL Manager
  description : internal call of SQL statements.

  last changed: 2000-12-06  19:04
  see also    : example.html ...
  first created:2000-03-09  18:21

  -------------------------------------------------------------------------

  copyright:    (c) 2000-2004 SAP AG




    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end




*****************************************************************************/

#include "hak93.h"

#include "SQLManager/SQLMan_SQLStatementContext.hpp"
#include "SQLManager/SQLMan_Context.hpp"
#include "SAPDBCommon/MemoryManagement/SAPDBMem_NewDestroy.hpp"
#include "SQLManager/SQLMan_Tracing.hpp"

SQLMan_SQLStatementContext::SQLMan_SQLStatementContext(SQLMan_Context& context)
: m_statementId(-1)
, m_context(context)
, m_pMessBlock(0)
, m_pStatementContext(0)
{
    SAPDBTRACE_ROUTINE_DEBUG ("SQLMan_SQLStatementContext::SQLMan_SQLStatementContext", SQLMan_Trace, 1);
    m_statementId = context.RegisterCurrentStatement();
    if (m_statementId < 0)
    {
        context.SetNoMoreMemoryError();
        return;
    }
    m_pStatementContext = context.GetAllocator().Allocate(context.GetStatementPartSize());
    if (!m_pStatementContext)
    {
        context.SetNoMoreMemoryError();
        return;
    }
    // save statement status of running sql statement
    memcpy (m_pStatementContext, context.GetStatementPartPtr(), context.GetStatementPartSize());
    // save current mess block
    m_pMessBlock = context.SaveMessBlock();
    if (context.IsOk())
    {
        memset (context.GetStatementPartPtr(), 0, context.GetStatementPartSize());
        m_context.SetSharedSQL();
        ++m_context.a_dbproc_level;
        context.NewSyntaxTree(256);
    }
}

/*-------------------------------------------------------------------*/

SQLMan_SQLStatementContext::~SQLMan_SQLStatementContext()
{
    SAPDBTRACE_ROUTINE_DEBUG ("SQLMan_SQLStatementContext::~SQLMan_SQLStatementContext", SQLMan_Trace, 1);
    m_context.UnregisterStatement(m_statementId);
    if (m_pStatementContext)
    {
        // restore statement status of running sql statement
        memcpy (m_context.GetStatementPartPtr(), m_pStatementContext, m_context.GetStatementPartSize());
        m_context.GetAllocator().Deallocate(m_pStatementContext);
    }
    if (m_pMessBlock)
    {
        // restore context mess block
        m_context.RestoreMessBlock(m_pMessBlock);
    }
}


