/*!**************************************************************************

  module      : Log_HistoryDirectory.hpp
  special area: Logging
  responsible : UweH
  created     : 2000-09-25  12:00
  last changed: 2000-10-27  12:00
  copyright:    (c) 2000-2004 SAP AG
  description : defines the classes Log_HistoryDirectory



    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*****************************************************************************/


#ifndef Log_HistoryDirectory_H
#define Log_HistoryDirectory_H

/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "SAPDBCommon/SAPDB_Types.hpp"
#include "DataAccess/Data_ChainFixSizeSpace.hpp"
#include "DataAccess/Data_BaseFile.hpp"

/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/

class Log_HistoryFile;

/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/
/*===========================================================================*
 *  EXTERNAL VARIABLES                                                       *
 *===========================================================================*/
/*===========================================================================*
 *  CLASSES, STRUCTURES, TYPES, UNIONS ...                                   *
 *===========================================================================*/

/*---------------------------------------------------------------------------*/
/*! class:       Log_HistoryDirectory
    description: This stores anchors to undo file.
*/
class Log_HistoryDirectory : public Data_BaseFile
{

public:
    
    /*! --------------------------------------------------------------------------------
    declaration: Container, Iterator, BeforeImageId
    description: These types are used with this class.
    */
    typedef Data_PageFixSizeSpace             PageType;
    typedef Data_ChainFixSizeSpace<PageType>  Container;
    typedef Container::Iterator               Iterator;
    typedef Data_ChainIterator<PageType>      PageIterator;
    /*! enddeclaration: */

    /*! --------------------------------------------------------------------------------
    declaration: HistoryFileInfo
    description: This describes a history file and is used to write into directory.
    ----------------------------------------------------------------------------------*/
    struct HistoryFileInfo
    {
        Data_PageNo   root;            // 4
        Data_PageNo   last;            // 4
        tgg91_TransNo oldestTransNo;   // 6
        tgg91_TransNo youngestTransNo; // 6
                                       // 20
        HistoryFileInfo()
        {
            Invalidate();
        }
        bool IsValid() const
        {
            return root.IsValid();
        }
        void Invalidate()
        {
            root.Invalidate();
            last.Invalidate();
            oldestTransNo.gg90SetNil();
            youngestTransNo.gg90SetNil();
        }
    };

public:

    /*! --------------------------------------------------------------------------
    function:    Log_HistoryDirectory
    arguments:   Trans               [in/out]
                 RootPageNo          [in]
    description: If the RootPageNo is valid, an existing file is assumed.
    -----------------------------------------------------------------------------*/
    Log_HistoryDirectory (tgg00_TransContext &Trans,
                          const Data_PageNo   Root );
              
    /*! ---------------------------------------------------------------------------
    function:    Create
    returns:     true, if successfull
    -----------------------------------------------------------------------------*/
    virtual bool Create ();

    /*! ---------------------------------------------------------------------------
    function:    Drop
    -----------------------------------------------------------------------------*/
    virtual void Drop ();

    /*! ---------------------------------------------------------------------------
    function:    Verify
    returns:     true, if the file is consistent
    -----------------------------------------------------------------------------*/
    virtual bool Verify (bool isCold);
    /*! --------------------------------------------------------------------------------
    function:    AppendHistoryFile
    arguments:   info [in]
    description: A new entry is created and appended to the file.
    -----------------------------------------------------------------------------*/
    void AppendHistoryFile (const HistoryFileInfo &info);

    /*! --------------------------------------------------------------------------------
    function:    GetFirstHistoryFileInfo
    arguments:   fileinfo [out]
    returns:     (bool) true, if there is more to read
    description: The first entry of the file is read.
    -----------------------------------------------------------------------------*/
    bool GetFirstHistoryFileInfo (HistoryFileInfo& fileinfo);
                          
    /*! --------------------------------------------------------------------------------
    function:    ReadNextHistoryEntry
    arguments:   fileinfo [out]
    returns:     (bool) true, if there is more to read
    description: The first entry of the file is read.
    -----------------------------------------------------------------------------*/
    bool GetNextHistoryFileInfo (HistoryFileInfo& fileinfo);

    /*! --------------------------------------------------------------------------------
    function:    MigratePageType
    arguments:   trans [in/out]
    description: For migration of wrong page type.
    -----------------------------------------------------------------------------*/
    void MigratePageType (tgg00_TransContext &trans);

private:

    /*! --------------------------------------------------------------------------------
    variable:    m_Container
    description: The container for this file.
    */
    Container m_Container;

    /*! --------------------------------------------------------------------------------
    variable:    m_Iterator
    description: The iterator for the container.
    */
    Iterator  m_Iterator;

    /*! --------------------------------------------------------------------------------
    variable:    m_Allocator
    */
    SAPDBMem_IRawAllocator &m_Allocator;
};
/*! endclass: Log_HistoryDirectory */


/*===========================================================================*
 *  DEFINITION OF INLINE METHODS                                              *
 *===========================================================================*/

/*===========================================================================*
 *  DEFINITION OF INLINE METHODS                                              *
 *===========================================================================*/
                                         
#endif  /* Log_HistoryDirectory_H */
