/*
        ========== licence begin  GPL
        Copyright (C) 2005 SAP AG

        This program is free software; you can redistribute it and/or
        modify it under the terms of the GNU General Public License
        as published by the Free Software Foundation; either version 2
        of the License, or (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
        ========== licence end
 */
#ifndef DATA_MESSAGES_HPP
#define DATA_MESSAGES_HPP

// Generated Header file Data_Messages.hpp.
// Generated by genmsg V2.2 DO NOT EDIT

#include "SAPDBCommon/ErrorsAndMessages/SAPDBErr_MessageList.hpp"

#define DATA_NOT_IMPLEMENTED                 SAPDBErr_MessageList::Error,20000,"%s not yet implemented",1
#define DATA_NOT_IMPLEMENTED_ID 20000
#define DATA_PAM_ERROR                       SAPDBErr_MessageList::Error,20001,"%s: PageId=%s/%s",3
#define DATA_PAM_ERROR_ID 20001
#define DATA_CHAIN_IS_INCONSISTENT           SAPDBErr_MessageList::Error,20002,"Chain is inconsistent: '%s'->'%s'",2
#define DATA_CHAIN_IS_INCONSISTENT_ID 20002
#define DATA_CHAIN_SPLITTED_RECORD_TRUNCATED SAPDBErr_MessageList::Error,20003,"Truncated record: %s,%s",2
#define DATA_CHAIN_SPLITTED_RECORD_TRUNCATED_ID 20003
#define DATA_ERR_BAD_CHECKSUM                SAPDBErr_MessageList::Error,20004,"Bad page - checksums not matching",0
#define DATA_ERR_BAD_CHECKSUM_ID 20004
#define DATA_ERR_CHECKSUM_MISMATCH           SAPDBErr_MessageList::Error,20005,"Bad page - calculated checksum [ %s ] checksum found in page [ %s ]",2
#define DATA_ERR_CHECKSUM_MISMATCH_ID 20005
#define DATA_ERR_BAD_WRITE_CNT               SAPDBErr_MessageList::Error,20006,"Bad page - header and trailer write count not matching",0
#define DATA_ERR_BAD_WRITE_CNT_ID 20006
#define DATA_ERR_WRITE_CNT_MISMATCH          SAPDBErr_MessageList::Error,20007,"Bad page - header write count [ %s ] trailer write count [ %s ]",2
#define DATA_ERR_WRITE_CNT_MISMATCH_ID 20007
#define DATA_ERR_BAD_PAGE_TYPE               SAPDBErr_MessageList::Error,20008,"Bad page - page type '%s' is invalid",1
#define DATA_ERR_BAD_PAGE_TYPE_ID 20008
#define DATA_ERR_BAD_ALGO                    SAPDBErr_MessageList::Error,20009,"Bad page - page check algorithm is invalid",0
#define DATA_ERR_BAD_ALGO_ID 20009
#define DATA_ERR_CORRUPTED_PAGE              SAPDBErr_MessageList::Error,20010,"Corrupted data page %s belongs to root %s which is of filetype '%s'",3
#define DATA_ERR_CORRUPTED_PAGE_ID 20010
#define DATA_NOT_ENOUGH_SPACE                SAPDBErr_MessageList::Error,20011,"PageAccessManager: cannot allocate new pages",0
#define DATA_NOT_ENOUGH_SPACE_ID 20011
#define DATA_ERROR_VERIFY_PAGE               SAPDBErr_MessageList::Error,20012,"Verify page %s next: %s, root: %s, chainroot: %s, prev: %s",5
#define DATA_ERROR_VERIFY_PAGE_ID 20012
#define DATA_ERROR_MARK_USED                 SAPDBErr_MessageList::Error,20013,"Verify page %s: error during 'mark as used'",1
#define DATA_ERROR_MARK_USED_ID 20013
#define DATA_ERROR_VERIFY_CHAIN              SAPDBErr_MessageList::Error,20014,"Verify chain: root %s, error: %s, first page failed: %s",3
#define DATA_ERROR_VERIFY_CHAIN_ID 20014
#define DATA_ERR_PRIM_STATISTIC              SAPDBErr_MessageList::Error,20015,"Base error '%s' during update statistic on record index %s on page %s of root %s",4
#define DATA_ERR_PRIM_STATISTIC_ID 20015
#define DATA_ERR_SCAN_TREE                   SAPDBErr_MessageList::Error,20016,"Base error '%s' during tree scan operation on record index %s on page %s of root %s",4
#define DATA_ERR_SCAN_TREE_ID 20016
#define DATA_COMPONENT_TEST_FAILED           SAPDBErr_MessageList::Error,20017,"Component test failed: %s",1
#define DATA_COMPONENT_TEST_FAILED_ID 20017
#define DATA_ERROR_CHAIN_FIX_SIZE_MISMATCH   SAPDBErr_MessageList::Error,20018,"fix size is %s but requested is %s",2
#define DATA_ERROR_CHAIN_FIX_SIZE_MISMATCH_ID 20018
#define DATA_PAGE_SPLIT_SPACE_VERIFY         SAPDBErr_MessageList::Error,20019,"split space page verify failed: pno: %s",1
#define DATA_PAGE_SPLIT_SPACE_VERIFY_ID 20019
#define DATA_ERR_BAD_PAGE                    SAPDBErr_MessageList::Error,20020,"Bad data page %s belongs to root %s which is of filetype '%s'",3
#define DATA_ERR_BAD_PAGE_ID 20020
#define DATA_ERR_PAGENO_OUT_OF_RANGE         SAPDBErr_MessageList::Error,20021,"Requested %s data page %s of root %s is greater than the upper limit of %s.",4
#define DATA_ERR_PAGENO_OUT_OF_RANGE_ID 20021
#define DATA_ERR_REFRENCE_COUNT              SAPDBErr_MessageList::Error,20022,"Reference Count mismatch %s, base error '%s' on root %s",3
#define DATA_ERR_REFRENCE_COUNT_ID 20022
#define DATA_WRN_BAD_FILE                    SAPDBErr_MessageList::Warning,20023,"Bad file for root %s",1
#define DATA_WRN_BAD_FILE_ID 20023
#define DATA_PAGE_INFO                       SAPDBErr_MessageList::Info,20024,"%s: pno=%s(%s/%s) acc=%s rel=%s err=%s",7
#define DATA_PAGE_INFO_ID 20024
#define DATA_PRIM_STATISTIC_CANCELED         SAPDBErr_MessageList::Info,20025,"Update statistic on root %s canceled by task %s",2
#define DATA_PRIM_STATISTIC_CANCELED_ID 20025
#define DATA_SPLIT_SPACE_RESIZE              SAPDBErr_MessageList::Info,20026,"A split space is resized to %s",1
#define DATA_SPLIT_SPACE_RESIZE_ID 20026
#define DATA_CHAIN_INFO                      SAPDBErr_MessageList::Info,20027,"%s: root %s last %s addressing: %s recovery: %s",5
#define DATA_CHAIN_INFO_ID 20027

#endif /* DATA_MESSAGES_HPP */
