# *******************************************************************************
#
#  module:       cn.com
#
#  ------------------------------------------------------------------------------
#
#  responsible:  BerndV
#
#  special area: Database Manager
#
#  description:  COM Description for all c(++) sources of the cn layer
#
#  see also:
#
#  ------------------------------------------------------------------------------
#
#                         Copyright (c) 1998-2005 SAP AG
#
# *******************************************************************************
#
#
#    ========== licence begin  GPL
#    Copyright (c) 1998-2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end

*       -DSAPDB$RELVER noshrglob
&if $OS in [ WIN32 ]
*       -FR                                        # MSDEV source browser
# *       -DBVMEMDEBUG -D_DEBUG -D_CRTDBG_MAP_ALLOC  # MSDEV memory debug
&endif

dbmapi.idl binary

gcn00.h     inc=gsp00,geo572.h,gcn00_1.h,DBM/Srv/DBMSrv_Common.hpp,ToolsCommon/Tools_Arguments.hpp,SAPDB_string.h
gcn00_1.h   inc=geo200.h,hin100.h
gcn002.h    inc=geo002.h,RTEConf_ParameterAccess.hpp
gcn003.h

hcn10.h     inc=gcn00.h
vcn10*.cpp  inc=hcn10.h,hcn20.h,hcn30.h,hcn31.h,hcn32.h,hcn40.h,hcn41.h,hcn42.h,\
hcn43.h,hcn45.h,hcn46.h,hcn50.h,hcn51.h,hcn80.h,hcn81.h,hcn82.h,hcn83.h,hcn84.h,\
DBMSrvCmd_DbmVersion.hpp,DBMSrvCmd_InstInfo.hpp,DBMSrvCmd_HssCopyFile.hpp,\
hcn85.h,hcn90.h,vsp001,vsp009c,heo02.h,heo06.h,hsp100.h,\
:SAPDB/DBM/Srv/Commands/BackupHistory/DBMSrvCmdBHist_BackupHistoryAppend.hpp,\
DBMSrvHSS_Nodes.hpp,\
DBMSrvBHist_RestorePlanner.hpp,DBMSrvCmd_BackupHistory.hpp,DBMSrvCmd_Explain.hpp,\
DBMSrvCmd_Help.hpp,:SAPDB/DBM/Srv/Commands/Medium/DBMSrvCmdMedium_MediumDeleteNoDistribute.hpp,\
:SAPDB/DBM/Srv/Commands/Db/DBMSrvCmdDb_DbReg.hpp,:SAPDB/DBM/Srv/Commands/Db/DBMSrvCmdDb_DbUnreg.hpp,\
:SAPDB/DBM/Srv/Commands/DBMSrvCmd_DbmExecuteServerprocess.hpp,\
:SAPDB/DBM/Srv/Commands/Medium/DBMSrvCmdMedium_MediumDelete.hpp,\
:SAPDB/DBM/Srv/Commands/Medium/DBMSrvCmdMedium_MediumLabelOffline.hpp,\
:SAPDB/DBM/Srv/Commands/Medium/DBMSrvCmdMedium_MediumPutNoDistribute.hpp,\
:SAPDB/DBM/Srv/Commands/Medium/DBMSrvCmdMedium_MediumPut.hpp,\
:SAPDB/DBM/Srv/Commands/SQL/DBMSrvCmdSQL_SqlUpdatestatPerSystemtable.hpp dep=RTE_UNIXAuthenticate.hpp 

vcn10-st.cpp    -DSTARTSTOP 
vcn10-cli.cpp   -DDBMCLI

vcn11.cpp   inc=hcn14.h

vcn12.cpp   inc=gsp09.h,heo01.h,heo02.h,heo13.h,hcn10.h,hcn13.h,hcn14.h,hcn90.h,hsp100.h,heo06.h,RTE_GetDBRootOfDB.h,RTE_UNIXAuthenticate.hpp,geo43.h,Tools_PipeCall.hpp

vcn12dbm*.cpp      setbuildinfo inc=heo01.h,hsp02.h,hsp77.h,geo002.h,RTEConf_ParameterAccess.hpp,Tools_PipeCall.hpp,RTE_DBRegister.hpp
&if $OS not in [ WIN32 ]
vcn12dbm*.cpp      dep=RTE_UNIXAuthenticate.hpp,RTE_saveUNIXcalls.h
&endif
vcn12dbm-start.cpp -DDBMSTART
vcn12dbm-stop.cpp  -DDBMSTOP
vcn12dbm-reg.cpp   -DDBMREG
vcn12dbm-unreg.cpp -DDBMUNREG

hcn13.h     inc=
vcn13.cpp   inc=hcn13.h,SAPDB_UTF8Basis.hpp,SAPDB_string.h

hcn14.h     inc=gsp00,geo47.h
vcn14*.c    inc=hcn14.h,gsp09.h,vsp004,heo03.h,heo13.h,hsp77.h,heo01.h,SAPDB_string.h,gip00.h
vcn14-u.c   -DDBMUNICODE
vcn14-ut.c  -DDBMUNICODE -DDBMUNICODETRACE
vcn14-p.c   -DNOWINAPI

vcn15.cpp   inc=:SAPDB/DBM/Cli/DBMCli_EventListener.hpp

# dbm scripting
&if $OS in [ WIN32 ]
vcn16-a.c   inc=hsp100.h,hcn14.h -I$ACTIVEPERL_INCLUDE -DWIN32 -DMSWIN32 -DACTIVE_PERL -TP
vcn16-c.c   inc=hsp100.h,hcn14.h -I$COREPERL_INCLUDE -DWIN32 -DMSWIN32 -DWIN32IO_IS_STDIO
&else
vcn16-c.c   inc=hsp100.h,hcn14.h -I$COREPERL_INCLUDE
&endif

vcn17.c   inc=hsp100.h,hcn14.h -I$PYTHON_INCLUDE
dbm.pm ascii ->$INSTMISC/SAP/DBTech/
# end dbm scripting

vcn18.cpp inc=RTE_FileUser.hpp,RTE_DBRegister.hpp,RTE_MessageList.hpp,SAPDBErr_Assertions.hpp,RTE_UNIXAuthenticate.hpp,SAPDB_string.h

hcn20.h   inc=gcn00.h,gcn002.h
vcn20.cpp inc=hcn90.h,hcn20.h,hcn23.h,hcn29.h,hcn42.h,hcn52.h,heo02.h,hcn50.h,hcn51.h,hcn80.h,heo06.h,heo11.h,hsp100.h,KernelParam_IOManager.hpp

hcn21.h   inc=gcn002.h,gcn00.h
vcn21.cpp inc=hcn90.h,hcn21.h,hcn29.h,heo06.h,heo02.h

hcn22.h   inc=gcn002.h,gcn00.h
vcn22.cpp inc=hcn90.h,hcn22.h,heo06.h

hcn23.h   inc=gcn002.h,gcn00.h
vcn23.cpp inc=hcn90.h,hcn23.h,hcn29.h

hcn28.h   inc=gcn00.h,gcn002.h
vcn28.cpp inc=hsp100.h,hcn28.h,hcn29.h,hcn90.h,KernelParam_IOManager.hpp,KernelParam_Converter.hpp

hcn29.h   inc=gcn002.h,gcn00.h
& if $MACH in [ PA11, PA20W, HP_IA64 ]
# Optimization leads to XParam files, where first entry is deleted with first direct_putparam command
vcn29.cpp -NO inc=hcn90.h,hcn80.h,hcn28.h,hcn29.h,heo02.h,hsp02.h,heo06.h,hcn21.h,hcn23.h,hcn52.h,hsp100.h,heo01.h
&else
vcn29.cpp     inc=hcn90.h,hcn80.h,hcn28.h,hcn29.h,heo02.h,hsp02.h,heo06.h,hcn21.h,hcn23.h,hcn52.h,hsp100.h,heo01.h
&endif

hcn30.h   inc=gcn003.h,gcn00.h
vcn30.cpp inc=hcn90.h,hcn42.h,hcn20.h,hcn30.h,hcn36.h,heo02.h,heo06.h,hcn50.h,hcn51.h,hcn80.h,\
              DBMSrv_Reply.hpp,DBMSrvMsg_Error.hpp

hcn31.h   inc=gcn003.h,gcn00.h
vcn31.cpp inc=hcn90.h,hcn31.h,hcn32.h,hin29.h,hcn20.h,hcn30.h,hcn53.h,hcn80.h,heo02.h,heo06.h,heo11.h,gkb03,hcn35b.h,hcn35c.h,geo002xp.h,hcn51.h,hsp77.h,DBMSrvKnl_Session.hpp

hcn32.h   inc=gcn003.h,gcn00.h
vcn32.cpp inc=DBMSrvBHist_History.hpp,DBMSrvBHist_EBIDList.hpp,hcn90.h,hcn32.h


hcn35.h     inc=hcn35d.h,hni33.h
vcn35.cpp   inc=hcn35.h,hcn351.h,hcn352.h,hcn353.h,hcn36.h,SAPDB_string.h

hcn35a.h    inc=hcn35.h,hcn35d.h
vcn35a.cpp  inc=gcn003.h,hcn35a.h,hni00b.h,hcn36.h

hcn35b.h    inc=DBMSrvBHist_EBIDList.hpp,gcn00.h,gcn003.h,hcn35a.h,hcn35e.h,hcn36.h,hcn90.h,hin29.h
vcn35b.cpp  inc=hcn20.h,hcn31.h,hcn32.h,hcn35b.h,hcn36.h,hcn42.h,hcn51.h,hcn53.h,hcn80.h,DBMSrv_Reply.hpp,DBMSrvHSS_Nodes.hpp,DBMSrvKnlSrv_ConnectInfo.hpp

hcn35c.h    inc=gcn00.h,gcn003.h,hcn35a.h,hcn35e.h
vcn35c.cpp  inc=hcn35c.h,hcn36.h,hcn42.h,hcn51.h,hcn90.h,DBMSrvBHist_History.hpp,DBMSrvBLabel_Label.hpp,DBMSrvHSS_Nodes.hpp

hcn35d.h    inc=hni34.h,hni35.h
vcn35d.cpp  inc=gcn003.h,hcn35d.h,hcn36.h

hcn35e.h    inc=gcn003.h,hni31.h,hcn35d.h
vcn35e.cpp  inc=gcn00.h,hcn20.h,hcn35e.h,hcn36.h,hcn42.h,hcn51.h,hcn53.h,SAPDB/ToolsCommon/Tools_List.hpp

hcn351.h    inc=hcn35.h,hcn35a.h
vcn351.cpp  inc=hcn351.h,hcn36.h,hni34.h,SAPDB_string.h

hcn352.h    inc=hni31.h,hcn35.h,hcn36.h,Tools_Vector.hpp
vcn352.cpp  inc=hcn352.h,hni34.h,hcn36.h,SAPDB_string.h

hcn353.h    inc=hni31.h,hcn35.h,hcn36.h
vcn353.cpp  inc=gcn003.h,hni34.h,hcn353.h,hcn36.h,hcn42.h

hcn36.h     inc=hni00b.h,hni33.h,hni34.h,hni35.h
vcn36.cpp   inc=hni31.h,hcn36.h,SAPDB_string.h

vcn37.cpp   inc=hni32.h,hni34.h,hni35.h,hcn36.h

hcn38.h     inc=hni00b.h,hni32.h,hni33.h,hni34.h
vcn38.cpp   inc=hcn38.h,hcn382.h,hcn383.h,hcn384.h,hcn36.h,hcn385.h,hcn386.h,SAPDB_string.h

hcn381.h    inc=hcn38.h
vcn381.cpp  inc=hcn36.h,hcn381.h,hcn385.h,SAPDB_string.h

hcn382.h    inc=hcn38.h,hcn381.h,hcn386.h
vcn382.cpp  inc=hcn36.h,hcn382.h,hcn385.h

hcn383.h    inc=hcn38.h,hcn381.h,hcn386.h
vcn383.cpp  inc=hcn36.h,hcn383.h,hcn385.h,SAPDB_string.h

hcn384.h    inc=hcn38.h,hcn381.h,hcn386.h
vcn384.cpp  inc=hcn36.h,hcn384.h,hcn385.h,SAPDB_string.h

hcn385.h    inc=hni34.h,hni35.h
vcn385.cpp  inc=hcn36.h,hcn385.h,SAPDB_string.h

vcn386.cpp  inc=hcn36.h,hcn385.h,hcn386.h

hcn40.h   inc=gcn00.h

vcn40*.cpp inc=hcn90.h,hcn42.h,hcn20.h,hcn30.h,hcn31.h,hcn40.h,hcn44.h,hcn46.h,\
hcn50.h,hcn80.h,hcn82.h,hcn84.h,hcn51.h,vsp001,gsp09.h,heo02.h,heo03.h,gip00.h,\
heo06.h,hsp100.h,geo28.h,geo43.h,heo11.h,hin110.h,hsp77.h,\
RTE_Types.h,RTEDiag_ClientCrashHist.h,Tools_System.hpp,DBMSrvHSS_Nodes.hpp,\
:SAPDB/DBM/Srv/Process/DBMSrvProc_ServerProcess.hpp,DBMSrvKnl_Session.hpp,\
RTE_UNIXAuthenticate.hpp,KernelParam_IOManager.hpp,RTE_ActiveDatabase.hpp,RTE_DBRegister.hpp,ToolsCommon/Tools_PipeCall.hpp,\
SAPDB_string.h,DBMSrvProc_EnvironmentVariable.hpp

vcn40-clu.cpp -DCLUSTER_SERVER_VERSION 

&if $MACH in [ NMP ]
&ifdef BIT64
# no optimization at SNI64 because with optimization the stack will
# not restored correctly after the call of ven904c::sqlxregisterinstNew()
# in vcn40.cpp::cn40InstReg()
vcn40.cpp -NO
&endif
&endif

hcn41.h   inc=gcn00.h
vcn41.cpp inc=hcn90.h,hcn41.h,hcn42.h,hcn50.h,hcn51.h,hcn53.h,hcn20.h,\
vsp009c,vsp001,geo28.h,SAPDB/DBM/Srv/DBMSrvHSS_Nodes.hpp,RTE_UNIXAuthenticate.hpp

hcn42.h   inc=gcn00.h
vcn42.cpp inc=geo43_0.h,hcn90.h,hcn20.h,hcn42.h,heo06.h,hcn54.h

hcn43.h   inc=gcn00.h
vcn43.cpp inc=:SAPDB/ToolsCommon/Tools_System.hpp,\
              :SAPDB/DBM/Srv/Process/DBMSrvProc_ServerProcess.hpp,\
              heo01.h,hcn40.h,hcn43.h,hcn50.h,hcn90.h

vcn44.cpp inc=hcn44.h,:extern/zlib/zlib.h,SAPDB_string.h

hcn45.h   inc=gcn00.h
vcn45.cpp inc=hcn45.h,hcn20.h,hcn40.h,hcn90.h,hcn80.h

hcn46.h   inc=gcn00.h
vcn46.cpp inc=hcn46.h,hsp100.h,hcn20.h,hcn40.h,hcn50.h,hcn85.h,hcn90.h,\
              DBMSrvHSS_Nodes.hpp,DBMSrvKnl_Session.hpp

hcn50.h   inc=gcn00.h
vcn50.cpp inc=hcn20.h,hcn29.h,hcn42.h,hcn50.h,hcn51.h,hcn80.h,hcn90.h,hsp02.h,geo47.h,heo11.h,geo28.h,heo02.h

hcn51.h   inc=geo200.h,gsp00
vcn51.cpp inc=hcn51.h,hcn90.h,hcn42.h,heo06.h

hcn52.h   inc=gsp00,gcn002.h
vcn52.cpp inc=hcn52.h,hcn42.h,hcn90.h,heo06.h,heo02.h

hcn53.h   inc=gsp00,geo200.h,gcn00_1.h
vcn53.cpp inc=hcn53.h,heo06.h,heo02.h,gcn00_1.h,hcn42.h

hcn54.h   inc=gsp00,geo200.h
vcn54.cpp inc=gcn00.h,hcn54.h,heo06.h,:extern/zlib/zlib.h

hcn80.h   inc=gcn00.h,hin29.h,hcn50.h
vcn80.cpp inc=hcn90.h,hcn20.h,hcn31.h,hcn51.h,hcn53.h,hcn80.h,heo02.h,hsp02.h,vsp001,vsp009c,DBMSrvKnlSrv_ConnectInfo.hpp

hcn81.h   inc=gcn00.h
vcn81.cpp inc=hcn90.h,hcn80.h,hcn81.h

hcn82.h   inc=gcn00.h
vcn82.cpp inc=hcn90.h,hcn51.h,hcn80.h,hcn82.h,geo47.h

hcn83.h   inc=gcn00.h
vcn83.cpp inc=hcn51.h,hcn90.h,hcn80.h,hcn83.h,hin110.h

hcn84.h   inc=gcn00.h
vcn84.cpp inc=hin110.h,hcn40.h,hcn51.h,hcn80.h,hcn90.h,hcn84.h

hcn85.h   inc=gcn00.h
vcn85.cpp inc=hcn50.h,hcn53.h,hcn80.h,hcn85.h,hcn90.h,DBMSrvKnl_Session.hpp

hcn90.h   inc=gcn00.h,SAPDBErr_MessageList.hpp
vcn90.cpp inc=hcn90.h,heo06.h,heo02.h,hsp02.h,heo01.h,vsp001,vsp009c,geo00_2.h,RTE_GetDBRootOfDB.h,RTE_ActiveDatabase.hpp,RTE_DBRegister.hpp

#Test
vcn800.cpp -x=compcpc++  -I$SAPDBSDK/incl

# RFC Server

&if $OSSPEC == LINUX && $LNX_VER == SLES_9
vcn900rfcsrv*.cpp	-DSLES_VER=9
vcn901dbmrfc*.cpp	-DSLES_VER=9
vcn902rfcmain*.cpp	-DSLES_VER=9
vcn904table*.cpp    -DSLES_VER=9
&endif

&if $OSSPEC == LINUX && ($MACH == X86_64 || ($MACH == IA64 && $LNX_VER == SLES_9))
hcn900rfcsrv.h       dep=:sap/700/saprfc.h,:sap/700/sapitab.h,:sap/700/sapuc.h,:sap/700/sapucx.h
&else
hcn900rfcsrv.h       dep=:extern/rfcsdk/saprfc.h,:extern/rfcsdk/sapitab.h,:extern/rfcsdk/sapuc.h,:extern/rfcsdk/sapucx.h
&endif
vcn900rfcsrv.cpp     inc=hcn900rfcsrv.h
vcn900rfcsrv-u.cpp   inc=hcn900rfcsrv.h -DSAPwithUNICODE

hcn901dbmrfc.h       inc=hin100.h,hcn900rfcsrv.h,hcn904table.h,:SAPDB/ToolsCommon/Tools_DynamicUTF8String.hpp
vcn901dbmrfc.cpp     inc=hcn901dbmrfc.h,hcn903dbmsrv.h,hsp100.h setbuildinfo
vcn901dbmrfc-u.cpp   inc=hcn901dbmrfc.h,hcn903dbmsrv.h,hsp100.h -DSAPwithUNICODE setbuildinfo

vcn902rfcmain.cpp    inc=heo670.h,hcn901dbmrfc.h,:SAPDB/ToolsCommon/Tools_DynamicUTF8String.hpp -except
vcn902rfcmain-u.cpp  inc=heo670.h,hcn901dbmrfc.h,:SAPDB/ToolsCommon/Tools_DynamicUTF8String.hpp -DSAPwithUNICODE -except

hcn903dbmsrv.h       inc=gsp00
vcn903dbmsrv.cpp     inc=hcn903dbmsrv.h,hcn14.h,heo02.h,heo13.h,hcn90.h

hcn904table.h        inc=hcn900rfcsrv.h
vcn904table.cpp      inc=hcn904table.h 
vcn904table-u.cpp    inc=hcn904table.h -DSAPwithUNICODE

cserv.pcf inc= ascii ->$INSTROOT/env/ unpack=no concom=yes \
&if defined LC_STATE
	LC_STATE=$LC_STATE
&else
	LC_STATE=DEV
&endif 

&if $OSSPEC == LINUX
   cserv.pcf LNX_VER=$LNX_VER
&endif

