/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.util;

import com.sap.dbtech.util.printf.PrintfException;
import com.sap.dbtech.util.printf.PrintfFormat;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class StringUtil {
    private static final byte blank_C = 32;
    public static final char[] hexDigits_C = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static byte[] bytes_iso8859_1(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            byArray[i] = c <= '\u00ff' ? (int)c : 63;
        }
        return byArray;
    }

    public static boolean isIso8859_1(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c <= '\u00ff') continue;
            return false;
        }
        return true;
    }

    public static byte[] bytes_ascii7bit(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            byArray[i] = c <= '\u007f' ? (int)c : 63;
        }
        return byArray;
    }

    public static String[] breakCommandLine(String string) {
        String string2;
        Vector<String> vector = new Vector<String>(10);
        int n = string.length();
        char[] cArray = string.toCharArray();
        char c = '\u0000';
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        char[] cArray2 = new char[cArray.length];
        block8: for (int i = 0; i < n; ++i) {
            char c2 = cArray[i];
            if (Character.isWhitespace(c2)) {
                switch (n2) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (bl) {
                            cArray2[n3] = c2;
                            ++n3;
                            break;
                        }
                        string2 = String.copyValueOf(cArray2, 0, n3);
                        vector.addElement(string2);
                        n3 = 0;
                    }
                }
                continue;
            }
            switch (c2) {
                case '\"': 
                case '\'': {
                    if (bl) {
                        if (c == c2) {
                            bl = false;
                            continue block8;
                        }
                        cArray2[n3] = c2;
                        ++n3;
                        continue block8;
                    }
                    bl = true;
                    c = c2;
                    n2 = 1;
                    continue block8;
                }
                case '\\': {
                    cArray2[n3] = c2 = cArray[++i];
                    ++n3;
                    n2 = 1;
                    continue block8;
                }
                default: {
                    cArray2[n3] = c2;
                    ++n3;
                    n2 = 1;
                }
            }
        }
        if (n2 == 1) {
            string2 = String.copyValueOf(cArray2, 0, n3);
            vector.addElement(string2);
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public static void fprintf(PrintStream printStream, String string, Object[] objectArray) throws PrintfException {
        printStream.print(StringUtil.sprintf(string, objectArray));
    }

    public static void fprintf(PrintWriter printWriter, String string, Object[] objectArray) throws PrintfException {
        printWriter.print(StringUtil.sprintf(string, objectArray));
    }

    public static void fprintfs(PrintStream printStream, String string, Object[] objectArray) {
        printStream.print(StringUtil.sprintfs(string, objectArray));
    }

    public static void fprintfs(PrintWriter printWriter, String string, Object[] objectArray) {
        printWriter.print(StringUtil.sprintfs(string, objectArray));
    }

    public static String hexDump(byte[] byArray) {
        return StringUtil.hexDump(byArray, 0, byArray.length, 0);
    }

    public static String hexDump(byte[] byArray, int n, int n2) {
        return StringUtil.hexDump(byArray, n, n2, 0);
    }

    public static String hexDump(byte[] byArray, int n, int n2, int n3) {
        int n4;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer(78);
        for (n4 = 0; n4 < 4; ++n4) {
            stringBuffer2.append('0');
        }
        for (n4 = 4; n4 < 78; ++n4) {
            stringBuffer2.append(' ');
        }
        stringBuffer2.append('\n');
        while (n < n2) {
            int n5 = n - n % 16;
            int n6 = n5 + 16;
            if (n6 > n2) {
                n6 = n2;
            }
            int n7 = n + n3;
            int n8 = 3;
            while (n7 > 0) {
                stringBuffer2.setCharAt(n8, hexDigits_C[n7 % 16]);
                n7 /= 16;
                --n8;
            }
            stringBuffer2.setCharAt(58, ' ');
            stringBuffer2.setCharAt(58 + n - n5, '\'');
            for (n4 = n - n5; n4 < n6 - n5; ++n4) {
                byte by = byArray[n4 + n5];
                char c = by >= 0 ? (char)by : (char)(256 + by);
                stringBuffer2.setCharAt(7 + n4 * 3 + 1, hexDigits_C[c / 16]);
                stringBuffer2.setCharAt(7 + n4 * 3 + 2, hexDigits_C[c % 16]);
                if (c < ' ') {
                    c = '.';
                }
                stringBuffer2.setCharAt(59 + n4, c);
            }
            stringBuffer2.setCharAt(59 + n6 - n5, '\'');
            for (n4 = n2 - n5; n4 < 16; ++n4) {
                stringBuffer2.setCharAt(7 + n4 * 3 + 1, ' ');
                stringBuffer2.setCharAt(7 + n4 * 3 + 2, ' ');
                stringBuffer2.setCharAt(59 + n4 + 1, ' ');
            }
            stringBuffer.append(stringBuffer2.toString());
            n = n6;
        }
        return stringBuffer.toString();
    }

    public static String join(Enumeration enumeration) {
        return StringUtil.join(enumeration, " ");
    }

    public static String join(Enumeration enumeration, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (enumeration.hasMoreElements()) {
            stringBuffer.append(enumeration.nextElement());
        }
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(string);
            stringBuffer.append(enumeration.nextElement());
        }
        return stringBuffer.toString();
    }

    public static String padLeft(String string, int n) {
        return StringUtil.padLeft(string, n, ' ');
    }

    public static String padLeft(String string, int n, char c) {
        int n2 = string.length();
        if (n <= n2) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = n2; i < n; ++i) {
            stringBuffer.append(c);
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static String padRight(String string, int n) {
        return StringUtil.padRight(string, n, ' ');
    }

    public static String padRight(String string, int n, char c) {
        int n2 = string.length();
        if (n <= n2) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append(string);
        for (int i = n2; i < n; ++i) {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String repeat(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(n * string.length());
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String replace(String string, String string2, String string3) {
        int n = 0;
        int n2 = 0;
        n2 = string.indexOf(string2, n);
        if (n2 == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = string2.length();
        while (n2 != -1) {
            stringBuffer.append(string.substring(n, n2));
            stringBuffer.append(string3);
            n = n2 + n3;
            n2 = string.indexOf(string2, n);
        }
        stringBuffer.append(string.substring(n, string.length()));
        return stringBuffer.toString();
    }

    public static String[] split(String string, String string2) {
        String string3;
        Vector<String> vector = new Vector<String>(10);
        int n = string2.length();
        int n2 = 0;
        int n3 = 0;
        n3 = string.indexOf(string2, n2);
        while (n3 != -1) {
            string3 = string.substring(n2, n3);
            vector.addElement(string3);
            n2 = n3 + n;
            n3 = string.indexOf(string2, n2);
        }
        string3 = string.substring(n2);
        vector.addElement(string3);
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public static String[] splitOnSpace(String string) {
        int n;
        Vector<String> vector = new Vector<String>(10);
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        char[] cArray = string.toCharArray();
        while (n3 < n4) {
            char c;
            n = 1;
            block7: while (n2 < n4 && n != 0) {
                c = cArray[n2];
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        ++n2;
                        continue block7;
                    }
                }
                n = 0;
            }
            n3 = n2;
            if (n3 >= n4) continue;
            n = 0;
            block8: while (n3 < n4 && n == 0) {
                c = cArray[n2];
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        n = 1;
                        continue block8;
                    }
                }
                ++n3;
            }
            String string2 = String.copyValueOf(cArray, n2, n3 - n2);
            vector.addElement(string2);
            n2 = n3;
        }
        String[] stringArray = new String[vector.size()];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = (String)vector.elementAt(n);
        }
        return stringArray;
    }

    public static String[] splitOnSpaceIsWhiteSpace(String string) {
        Vector<String> vector = new Vector<String>(10);
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        char[] cArray = string.toCharArray();
        while (n2 < n3) {
            while (n < n3 && Character.isWhitespace(cArray[n])) {
                ++n;
            }
            n2 = n;
            if (n2 >= n3) continue;
            while (n2 < n3 && !Character.isWhitespace(cArray[n2])) {
                ++n2;
            }
            String string2 = String.copyValueOf(cArray, n, n2 - n);
            vector.addElement(string2);
            n = n2;
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public static String[] splitOnSpaceRaw(String string) {
        int n;
        Vector<String> vector = new Vector<String>(10);
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        char[] cArray = string.toCharArray();
        while (n3 < n4) {
            char c;
            n = 1;
            block7: while (n2 < n4 && n != 0) {
                c = cArray[n2];
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        ++n2;
                        continue block7;
                    }
                }
                n = 0;
            }
            n3 = n2;
            if (n3 >= n4) continue;
            n = 0;
            block8: while (n3 < n4 && n == 0) {
                c = cArray[n2];
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        n = 1;
                        continue block8;
                    }
                }
                ++n3;
            }
            String string2 = String.copyValueOf(cArray, n2, n3 - n2);
            vector.addElement(string2);
            n2 = n3;
        }
        String[] stringArray = new String[vector.size()];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = (String)vector.elementAt(n);
        }
        return stringArray;
    }

    public static String[] splitOnSpaceStringTokenizer(String string) {
        Vector<String> vector = new Vector<String>(10);
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public static String sprintf(String string, Object[] objectArray) throws PrintfException {
        PrintfFormat printfFormat = new PrintfFormat(string);
        String string2 = printfFormat.format(objectArray);
        return string2;
    }

    public static String sprintfs(String string, Object[] objectArray) {
        try {
            return StringUtil.sprintf(string, objectArray);
        }
        catch (PrintfException printfException) {
            return "<PrintfError: " + printfException.getMessage() + " >";
        }
    }

    public static String substring(String string, int n, int n2) {
        int n3 = string.length();
        if (n < 0) {
            n = n3 - n;
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = n3 - n2;
        }
        if (n2 > n3) {
            n2 = n3;
        }
        String string2 = n > n3 || n2 < 0 ? "" : string.substring(n, n2);
        return string2;
    }

    public static String trimLeft(String string) {
        int n = string.length();
        for (int i = n - 1; i >= 0; --i) {
            if (string.charAt(i) == ' ') continue;
            if (i == n - 1) {
                return string;
            }
            return new String(string.substring(0, i + 1));
        }
        return "";
    }

    public static String formatMilliSeconds(Timestamp timestamp) {
        long l = timestamp.getNanos() / 10000;
        String string = Long.toString(l);
        return "00000".substring(0, 5 - string.length()) + string;
    }
}

