#!/usr/bin/perl
#
#    ========== licence begin  GPL
#    Copyright (C) 2001 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end
#

#
#    @(#)toolvars-tml.pl
#    included by several scripts, defines system specific values
#


use Env;
use Config;
use CCVers;

# CTS 1110865
@THREAD_CCFLAGS=();
@THREAD_LDFLAGS=();
@LDFLAGS=();
@LDXXFLAGS=();

if ($RELVER eq "")
{
	print "\n!!! WARNING:  RELVER not set!!!\n";
	exit 1;
}

if (! $ENV{INSTROOT})
{
	print "\n!!! WARNING:  INSTROOT not set!!!\n";
	exit 1;
}

# force set of compiler version
CCVers::setup_compiler_version();


$ADABAS_COPYRIGHT="Copyright (c) SAP AG 1997-2003";
if ($RELVER eq "R61") {
	$ADABAS_VERSION="6.1";
}
elsif ($RELVER eq "R62") {
	$ADABAS_VERSION="6.2";
}
elsif ($RELVER eq "R70") {
	$ADABAS_VERSION="7.0";
}
elsif ($RELVER eq "R71") {
	$ADABAS_VERSION="7.1";
}
elsif ($RELVER eq "R72") {
	$ADABAS_VERSION="7.2";
}
elsif ($RELVER eq "R73") {
	$ADABAS_VERSION="7.3";
}
elsif ($RELVER eq "R74") {
	$ADABAS_VERSION="7.4";
}
elsif ($RELVER eq "R75") {
	$ADABAS_VERSION="7.5";
}
elsif ($RELVER eq "R80") {
	$ADABAS_VERSION="8.0";
}


$SQLVERSION="REL30";$ENV{SQLVERSION} = $SQLVERSION; # export $SQLVERSION

$OSSPEC="WIN32";
$ENV{OSSPEC} = $OSSPEC;		# export $OSSPEC
$MACH = "I386";
$ENV{MACH} = $MACH;		# export $MACH
# OSBASE, CPU ist zwingend erforderlich!
# CTS 1106494 ->
if ($MACH eq "AMD64")
{
	$CPU = 'AMD64';
	$MACHINE = 'AMD64';
	$BIT64 = 1;
	$ENV{MACHINE} = $MACHINE;
	$ENV{CPU}	= $CPU;
	$ENV{BIT64} = $BIT64;
	$HAS_MSC_SECURITY_CHECKS = 1;
}
elsif ( $ENV{BIT64} eq "1" )
{
	$CPU		= "i386";
	$ENV{CPU}	= $CPU;			# export $CPU
	$MACHINE 	= "IA64";
	$ENV{MACHINE}	= $MACHINE;		# export $MACHINE
}
else
{
	$CPU		= "i386";
	$ENV{CPU}	= $CPU;			# export $CPU
	$MACHINE 	= "IX86";
	$ENV{MACHINE}	= $MACHINE;		# export $MACHINE
}
# <- CTS 1106494
$OSBASE	=$ENV{OS};
$ENV{OSBASE} = $OSBASE;		# export $OSBASE
$OS = 'WIN32';
$ENV{OS} = $OS;			# export $OS



$TOOL_LIB = "$TOOL/lib";
$ENV{TOOL_LIB} = $TOOL_LIB;

$COMP="PTOC";
if ($RELVER eq "R61") {
	#@CONCOMOPTS = ( "-REL=R61" );
	@CONCOMOPTS = ( "-$SQLVERSION=1", "-REL=R61" );
	#@CONCOMOPTS = ( "-SAG=1", "-$SQLVERSION=1", "-REL=R61" );
}
else
{
	#@CONCOMOPTS = ( );
	@CONCOMOPTS = ( "-$SQLVERSION=1" );
	#@CONCOMOPTS = ( "-SAG=1", "-$SQLVERSION=1" );
}
push @CONCOMOPTS, "-RELVER=$RELVER";
push @CONCOMOPTS, "-DIAGNOSE=1" if defined( $ENV{DIAGNOSE} );
push @CONCOMOPTS, "-LC_STATE=".(defined $ENV{'LC_STATE'} ? "$ENV{'LC_STATE'}" : "DEV");
push @CONCOMOPTS, "-COMPILER=".(defined $ENV{'COMPILER'} ? "$ENV{'COMPILER'}" : "UNDEF");
#
# Used for all systems using 64 bit compilation!
#
if ( $ENV{BIT64} eq "1" )
{
	push @CONCOMOPTS, "-BIT64=1";
	if ( $ENV{XCOMP} eq "1" )
	{
		push @CONCOMOPTS, "-XCOMP=1";
	}
}
# used for 32 KB pages  (PTS 1111111)
if ( $ENV{page32KB} )
{
	push @CONCOMOPTS, "-page32KB=1";
}

# jrg 2.9.1999

if ( not $CC )
{
    $CC = "cl";
}
#else take CC from the environment




# CTS 1107045
# $LDDLL_C         - command of link c objects to shared lib
# $LDDLL_CXX       - command of link c++ shared lib
# $LDDLL_CXX_C     - command of link c++ objects to c shared lib
# to initialize $LDDLL
#else take CXX from the environment PTS 1001861

$LD		= "link" if ( not $LD );
$LDDLL_C = $LD;       # PTS 1107045
$LDDLL_TYPE = "LDDLL_C";


# jrg 2.9.1999
# For relocatable objects (collection of object files) a different linker is used
# These definitions replace former system dependend setting in linkrel.pl!
#

$AS =
( $MACH eq 'I386' && $ENV{BIT64} eq '1' ) ?
	'ias'  :
( $MACH eq 'AMD64') ?
	'ml64' :
( $ENV{_MSC_VER} gt '12' ) ?
	'ml'   :
	'masm386';
$AR     = "lib";
$RC		= "rc";
$MC		= "mc";
$CVTRES = "cvtres";
$NULL = "nul";

# set C and CXX as environment variable
$ENV{CC} = $CC;
$ENV{CXX} = $CC;

#
# Additional compiler flags may be set temporary in the environment
# before calling vmake.
#

@ASFLAGS =
( $MACH eq 'I386' && $ENV{BIT64} eq '1' ) ?
	@ASFLAGS = ('-d', 'debug') :
( $MACH eq 'AMD64') ?
	( '-c', '-Cx', '-W2', '-nologo', '-D_AMD64_=1', '-D_WIN32=1' ) :
( $ENV{_MSC_VER} gt '12') ?
	( '-c', '-Cx', '-coff', '-W2', '-nologo', '-D_X86_=1', '-D_WIN32=1' ) :
	( '-Mx', '-w2', '-t', '-z', '-D_X86_=1', '-D_WIN32=1' );

# 98/06/19 &gar: for differences between C and C++-Compiling in UNIX !
# @CCFLAGS   -> FLAGS for both ( C, C++ )
# @CFLAGS    -> FLAGS for C only
# @CXXFLAGS  -> FLAGS for C++ only
@CCFLAGS = split /\s+/, $CCFLAGS;
push @CCFLAGS, "-D$SQLVERSION",  "-D$OSSPEC", "-D$MACH", "-DSAG";
if ($RELVER =~ /^R(\d)(\d)/)
{
push @CCFLAGS, "-DSDB_RELEASE_0${1}0${2}" . ((length ("$CORRECTION_LEVEL") == 2) ? "$CORRECTION_LEVEL" : "0$CORRECTION_LEVEL");
}
push @CCFLAGS, "-DDIAGNOSE" if defined( $ENV{DIAGNOSE} );
push @CCFLAGS, "-DSAPDBMem_USE_SYSTEM_ALLOC" if defined( $ENV{SAPDBMem_USE_SYSTEM_ALLOC} );
@CCMODEANSI = ();
@CCMODENORM = ();
@CCMODELINT = ();

if ($ENV{APOMAKE})
{
	push @CCFLAGS,  "-DAPO_COM_SHORT=$ENV{APO_COM_SHORT}";

	push @CCFLAGS,  "-DAPO_PATCH_LEVEL=$ENV{APO_PATCH_LEVEL}" if ($ENV{APO_PATCH_LEVEL});
	#  "-DAPO_COM_RELEASE=$APO_COM_RELEASE",
	#  "-DAPO_COM_BUILD=$APO_COM_BUILD",


	push @CCFLAGS,  "-DBRANCH_INFO=$ENV{BRANCH_INFO}",
	                "-DLATEST_CHANGE_LIST=$ENV{LATEST_CHANGE_LIST}";
#	                "-DBRANCH_INFO_STR=\"$BRANCH_INFO\"",
#					"-DLATEST_CHANGE_LIST_STR=\"$LATEST_CHANGE_LIST\"";

	# BRANCH_INFO, BRANCH_INFO
	push @CCFLAGS, "-DSAPonNT", "-D_WINDOWS";
	if ($MACHINE eq 'IA64')
	{
		push @CCFLAGS, "-DWIN64", "-D_WIN64", "-D_IA64_" ;
	}
	else
	{
		push @CCFLAGS, "-DWIN32", "-D_WIN32";
	}

}



# 1.8.2001 E.Z. PTS 1111111
if ( $ENV{page32KB} )
{
   push @CCFLAGS, "-Dpage32KB";
}


if ( $RELVER ge "R80" ) {
#
# gg 22.12.2001 put stlport directory in include search path
#
    push @CCFLAGS, "-I$WRK/incl/SAPDB/STLport/stlport";
#
# Some day this can be removed again if we can use src/SAPDB as new src...
#
    push @CCFLAGS, "-I$WRK/incl/SAPDB";
}
if ($ENV{BIT64} eq "1") {
     @EXCEPT_FLAG = "-EHs";
} else {
     @EXCEPT_FLAG = "-GX";
}
@RTTI_FLAG = "-GR";


# check for LC_INC for APO
die "LC_INC is not defined in environment!\n" if ( $ENV{APOMAKE} && ! $ENV{LC_INC} );
push @CCFLAGS, "-I$ENV{LC_INC}" if ( $ENV{APOMAKE} && $ENV{LC_INC} );



#
# Some day this can be removed again if we can use src/SAPDB as new src...
#
  if (( $RELVER ge "R73" ) && ( ! $ENV{APOMAKE} )) {
  		push @CCFLAGS, "-I$WRK/incl/SAPDB";
    }




$DEVELOPCCFLAGS = "-DDUMP_ENABLED";
push @CCFLAGS , $DEVELOPCCFLAGS;
push @CCFLAGS , "-D_WIN32" unless ($ENV{APOMAKE});


@RCFLAGS  = @CCFLAGS;

# switch security off
if ($HAS_MSC_SECURITY_CHECKS) {
	push @CCFLAGS, '-GS-';
}

if ( $ENV{BIT64} eq "1" )
{
	push @CCFLAGS, '-Wp64', '-Gy';

	if (defined ($ENV{POGO}))
	{
		push @CCFLAGS, '-GL';
	}

	if ($MACHINE eq 'IA64')
	{
		push @CCFLAGS, '-Op', '-QIPF_fma';
	}
}

if ( $RELVER ge "R80" ) {
#
# jrg 20.4.2000 always use exception handling code (-except no longer needed)
# must be here to prevent 'rc compiler from reporting illegal option -GX
#
    push @CXXFLAGS, @EXCEPT_FLAG;
}

if ($RELVER eq "R61") {
	push @CCFLAGS, "-DWINDOWS";
	push @CCFLAGS, "-DREL=R61";
	push @CCFLAGS, "-DREL611";
}
# PTS: 1107332
if ( $ENV{BIT64} eq "1" ) {
    push @CCFLAGS, "-DBIT64";
}

if ($ENV{MACHINE} eq "IX86" ) {
push @CCFLAGS, "-D_X86_=1";
}
if (($ENV{_MSC_VER} gt "12") && $ENV{'RTCHECK'}) {
	push @CCFLAGS, "-RTC1";
}

push @CCFLAGS, "-DCRTAPI1=_cdecl", "-DCRTAPI2=_cdecl", "-nologo", "-Gy";
push @CCFLAGS, "-Zm750" if ($ENV{APOMAKE});

@CCMODEANSI = "-W3";
@CCMODENORM = "-W2";
@CCMODELINT = "-W4";
if ($ENV{APOMAKE})
{
	$LINKMODE= "-MD";
}
else
{
	$LINKMODE= "-MT";
}

if ($ENV{APOMAKE})
{
	if ($ENV{BIT64} eq "1")
	{
		@OPTIMIZE = ("-Zi", "-Op", "-G2");
		push @OPTIMIZE, "-O2" unless ($ENV{'RTCHECK'} && ($ENV{_MSC_VER} gt "12"));
	}
	else
	{
		@OPTIMIZE = ("-Zi", "-Ot", "-Oi", "-Op", "-Og");
		push @OPTIMIZE, "-Ob1" if ($ENV{APO_COM_SHORT} lt "40000");
	}
}
# "OPTIMIZE" now depends on "VMAKE_VERSION" (needed on AIX)
elsif ($CURR_VERSION =~ /^f/i) {
    # the old value, it was used for everything
	if ($RELVER eq "R71") {
	   @OPTIMIZE = ("-Ogitb1","-Gs");
	}
	elsif ( (($RELVER eq "R74") || ($RELVER eq "R75")) && ($ENV{MACHINE} ne "IA64") )
	{
		push @OPTIMIZE, "-O2" unless ($ENV{'RTCHECK'} && ($ENV{_MSC_VER} gt "12"));
		push @OPTIMIZE, ("-Oy-");
	}
	elsif  ($RELVER eq "R72")
	{
		push @OPTIMIZE, "-O2" unless ($ENV{'RTCHECK'} && ($ENV{_MSC_VER} gt "12"));
		push @OPTIMIZE, ("-Oy-");
	}
	elsif ($ENV{MACHINE} eq "IA64") {
		@OPTIMIZE = ("-O2") unless ($ENV{'RTCHECK'} && ($ENV{_MSC_VER} gt "12"));
   	}
	else {
		push @OPTIMIZE, "-O2" unless ($ENV{'RTCHECK'} && ($ENV{_MSC_VER} gt "12"));
		push @OPTIMIZE, ("-Oy-");
	}
}
else {
	# VMAKE_VERSION is quick or slow
	# one level less than fast - not yet really tested
	# the idea is to combine range checks with less risky code
	@OPTIMIZE = ("-Od");
}

# CTS 1103440
@PDB_CC_FLAGS = ("-Zi");
# debug flags are the same as normal make
@PDB_DEBUG_FLAGS = @PDB_CC_FLAGS;
if ( ( $ENV{BIT64} eq "1" ) || ( $ENV{APOMAKE} ) ){
@DEBUG_FLAGS = @PDB_DEBUG_FLAGS;
} else {
	if (
		(($RELVER gt "R74") && ($RELVER ne "RTOOL")) ||
	    (($RELVER eq "R74") && ($ENV{CORRECTION_LEVEL} > 2))
	   )
	{
		@DEBUG_FLAGS = @PDB_DEBUG_FLAGS;
	}
	else
	{
		@DEBUG_FLAGS = ("-Z7");
	}
}

push @DEBUG_FLAGS, "-DSAPDB_DEBUG";



# CTS 1108431
@NO_FLAGS = ("-Od");



# cba 98/07/16 : cause of differeces of C- and C++-Linker
# we may have different linker options on some UNIX-platforms
# we use @LDFLAGS for C-linking and @LDXXFLAGS for C++-Linking
# &gar 99/06/03: for linkdll new variable DLDFLAGS and DLDXXFLAGS
# ( PTS 1103001 )
# initialize
# CTS 1107045
# @DLD_CXX_C_FLAGS_START, DLD_CXX_C_FLAGS_END
# @DLD_CXX_C_FLAGS_START  options before objects
# @DLD_CXX_C_FLAGS_END    options after objects
# CTS 1107008
@DEFAULTLIBS =("kernel32.lib", "user32.lib", "gdi32.lib",
               "winspool.lib", "comdlg32.lib", "advapi32.lib",
               "shell32.lib", "ole32.lib", "oleaut32.lib", "uuid.lib");

if ($HAS_MSC_SECURITY_CHECKS) {
	push @DEFAULTLIBS, 'bufferoverflowu.lib';
}

@LDEXEFLAGS = ( "-NODEFAULTLIB", "-RELEASE" ); # &gar , "-align:0x1000" );
# no XXFLAGS for WIN (no different linker call for c++)
if ($ENV{APOMAKE})
{ @LDFLAGS = @DLDFLAGS = ( "-nologo", "-MACHINE:$MACHINE" );}
else
{ @LDFLAGS = @DLDFLAGS = ( "-nologo" );}

if ( $ENV{BIT64} eq "1" && defined ($ENV{POGO})) {
    if (defined ($ENV{POGOOPTI}))
    {
        push @LDFLAGS, "-LTCG:PGOPTIMIZE";
    }
    else
    {
        push @LDFLAGS, "-LTCG:PGINSTRUMENT";
    }
}


#############################
# options for Multipasslink #
#############################

@KEEP_SYMBOLS_FIRST_OPTION = ();
@KEEP_SYMBOLS_OPTION_BEFORE_LIB = ();
@KEEP_SYMBOLS_OPTION_AFTER_LIB = ();


#
# For relocatable objects (collection of object files) a different linker is used
# These definitions replace system dependend setting in linkrel.pl!
#

# &jrg 14.9.1999
#
# C++ compilation sometimes needs to setup a path to a directory for
# the template cache. In this template cache instances of template
# functions with external linkage are stored.
# Since template instances may differ depending on
# VMAKE_VERSION (fast,slow...) for each version a seperate
# template cache is forced
#

# &gar PTS 1001828
if ($ENV{ICECAP} eq "1") {
  @PRF_FLAGS = "-fastcap -Zi";
  }else {
  @PRF_FLAGS = "-Gh";
  }


# &gar OFLAGS for call options
# used in link... and comp...
# always initialize here with ()
@OFLAGS=();

# PTS: 1107332
if ($ENV{_MSC_VER} gt "12")
{
  $SR_ID  = "#pragma comment(exestr, ";
  $MF_ID  = "#pragma comment(exestr, ";
  $PC_ID  = "#pragma comment(exestr, ";
  $CC_ID  = "#pragma comment(exestr, ";
  $ID_END = ")";
}
else
{
  $SR_ID  = "#ident";
  $MF_ID  = "#ident";
  $PC_ID  = "#ident";
  $CC_ID  = "#ident";
  $ID_END = "";
}

@PCFLAGS= ( "-qn", "-e" );
@ARFLAGS = ( "-nologo", "-MACHINE:$MACHINE" );
$RANLIB = "lib -list";

if ($ENV{APOMAKE})
{	@LIBPC=(); }
else
{
# PTS: 1107332
	if ( $ENV{BIT64} eq "1" )
	{
	    @LIBPC      = ( "$TOOL_LIB/ptocnts64.lib" );
	    @LIBPC_PROF = ( "$TOOL_LIB/ptocnts64.lib" );
	    if (defined ($ENV{POGO}))
	    {
	        @LIBPOGO    = ( "pogort70.lib");
	    }
	    else
	    {
	        @LIBPOGO    = ();
	    }
	}
	else
	{
	    @LIBPC      = ( "$TOOL_LIB/ptocnts.lib" );
	    @LIBPC_PROF = ( "$TOOL_LIB/ptocnts.lib" );
	    @LIBPOGO    = ();
	}
}



@LIBSCR = ( "user32.lib" );
@LIBMATH = ();
@DYNAMIC_LIB = ();
@LIBNET = ( "wsock32.lib" );
@LIBCSCI    = ();

#
# PTS 1002837 jrg 26.5.1999
@LIBMPROC =
( $ENV{APOMAKE} ) ?
	() :
( $MACH eq 'AMD64' ) ?
	( 'libcmt.lib', 'oldnames.lib', 'kernel32.lib', 'advapi32.lib', 'gdi32.lib' ) :
	( 'libcmt.lib', 'oldnames.lib', 'kernel32.lib', 'advapi32.lib', 'gdi32.lib' ) ;

if ($HAS_MSC_SECURITY_CHECKS) {
	push @LIBMPROC, 'bufferoverflowu.lib';
}

# CTS 1106257
@LIBLD=();
@LIB_PTHREAD=();



@LIBAIO = ();



# &gar PTS 1106517
if ($ENV{MACHINE} eq "IX86" ) {
@LDSHMFLAGS=("-LARGEADDRESSAWARE"); # PTS 1107131
}

# jrg PTS 1110802
@LDSHMLIBS=();

if ( $SQLVERSION eq "REL30" )  { $TRACETYPE = "tsp_trace" }
	else { $TRACETYPE = "tracetext" }


##########
$PATH_SEPARATOR=";";

###########
# $PREPROCESS_FLAGS
@PP_FLAGS=("-EP", "-P");

###########
if ($ENV{APOMAKE})
{
	$SYMBOL_DIR = "$INSTROOT/sap";
	$MAP_DIR    = "$INSTROOT/sap";
}
else
{
	$SYMBOL_DIR = "$INSTROOT/symbols";
	$MAP_DIR    = "$INSTROOT/Support/Mapfiles";
}

$SYMBOL_DIR = $ENV{FORCED_SYMBOL_DIR} if ($ENV{FORCED_SYMBOL_DIR});
$MAP_DIR = $ENV{FORCED_MAP_DIR} if ($ENV{FORCED_MAP_DIR});


#################################################
# vmake environment variables must be set by hand
#################################################

if ( ! $DEVENV ) {
#   $DEVENV = "YES";		# Pascal vsp-modules
    $DEVENV = "NO";		# Assembler or C vsp-modules
}
$ENV{DEVENV} = $DEVENV; 	# export $DEVENV



# ================================================================


$DLL_TYPE = "dll";
$ENV{DLL_TYPE} = $DLL_TYPE;		# can be exported even if not set

$ARCH_TYPE = ".lib";
$ENV{ARCH_TYPE} = $ARCH_TYPE;		# can be exported even if not set

#################################################
#  IGNORE following strings in output
#  separate with "|"
#################################################

# string for compile
#
$CC_IGNORE="";

# string for link
# $LNK_IGNORE="LNK4089";
$LNK_IGNORE="";

sub setvar {
    my ($varname, $commonDefault, $internalDefault) = @_;
    if (!defined ($internalDefault)) {
        $internalDefault = $commonDefault;
    }
    my ($value);
    if ($ENV{$varname}) {
        $value = $ENV{$varname};
    }
    else {
        if ($ENV{SAPDB_INTERNAL}) {
            $value = $internalDefault;
        }
        else {
            $value = $commonDefault;
        }
        $ENV{$varname} = $value;
    }
    eval '$' . "$varname = '$value'";
}

setvar ('PYTHON', 'NO', "$TOOL/Python");
# setvar ('PYTHON_INCLUDE', $ENV{PYTHON} . '/include');
if ( ($^O =~ /win32/i) && ( ${'BIT64'} =~ /1/ ))
{ setvar ('PYTHON_INCLUDE', $ENV{'TOOL'} . '/incl/extern/python/sdk-py21'); }
else
{ setvar ('PYTHON_INCLUDE', $ENV{'TOOL'} . '/incl/extern/python/sdk-py15'); }

setvar ('ACTIVEPERL_INCLUDE', $ENV{PERL} . '/lib/CORE');
setvar ('ACTIVEPERL_LIB', $ENV{PERL} . '/lib/CORE');
setvar ('COREPERL_INCLUDE', 'NO', $ENV{TOOL} . '/PerlCore/lib/CORE');
setvar ('COREPERL_LIB', 'NO', $ENV{TOOL} . '/PerlCore/lib/CORE');

#
# override default for perl lib depending on perl version
#
if (!defined ($ACTIVEPERL_LIBFILE)) {
    if ($] =~ /5.00([68])/) {
        $ACTIVEPERL_LIBFILE = "perl5$1";
        $ENV{ACTIVEPERL_LIBFILE} = $ACTIVEPERL_LIBFILE;
    }
}

setvar ('JDK_INCLUDE', 'NO', "$TOOL/java/include");
setvar ('JAVA_HOME', 'NO', "$TOOL/java");

unless (defined $ENV{INSTLIB}) {
	require GetInstDir;
	$ENV{INSTLIB} = GetInstDir::GetInstLib ();
}

unless (defined $ENV{INSTMISC}) {
	require GetInstDir;
	$ENV{INSTMISC} = GetInstDir::GetInstMisc ();
}

unless (defined $ENV{INSTLIBRELOC}) {
	require GetInstDir;
	$ENV{INSTLIBRELOC} = GetInstDir::GetInstLibReloc ();
}

unless (defined $ENV{INSTMISCRELOC}) {
	require GetInstDir;
	$ENV{INSTMISCRELOC} = GetInstDir::GetInstMiscReloc ();
}

unless (defined $ENV{INSTRUNTIME}) {
	require GetInstDir;
	$ENV{INSTRUNTIME} = GetInstDir::GetInstRuntime ();
}

unless (defined $ENV{INSTRUNTIMEBIN}) {
	require GetInstDir;
	$ENV{INSTRUNTIMEBIN} = GetInstDir::GetRuntimeBin ();
}

unless (defined $ENV{SAPDBSDK}) {
	require GetInstDir;
	$ENV{SAPDBSDK} = GetInstDir::GetSDKRoot ();
}

unless (defined $ENV{SAPDBSDKLIB}) {
	require GetInstDir;
	$ENV{SAPDBSDKLIB} = GetInstDir::GetSDKRootLib ();
}

unless (defined $ENV{SAPDBSDKPGM}) {
	require GetInstDir;
	$ENV{SAPDBSDKPGM} = GetInstDir::GetSDKRootPgm ();
}

$TraceFile = "$WRK/$VMAKE_VERSION/prot/trace.prot";
sub ToolTrace {
	# usage ToolTrace($string, \@daten)
	if ($ENV{TOOLTRACE}) {
		local($string, $r_daten) = @_;
		open(TOOLTRACE, ">>$TraceFile") ||
			die "Can't open $TraceFile (append): $!\n";
		print TOOLTRACE sprintf($string, @$r_daten);
		close(TOOLTRACE);
	}
}

#
# use variables from RTE_Configure.pl (DanielD)
#
if (-r "$WRK/config/toolvars_configure.pl") {
    do "$WRK/config/toolvars_configure.pl";
}

#
# Override toolvars variables through env variable
#    example: export TOOLVARS_PATCH="OS=WIN32;OSSPEC=WIN32;MACH=I386"
#    useful to generate vmake dependencies for any platform without
#    remote compilation (DanielD)
#
if ($ENV{TOOLVARS_PATCH}) {
    my @entries = split (';', $ENV{TOOLVARS_PATCH});
    foreach my $entry (@entries) {
        if ($entry =~ /(.*)=(.*)/) {
            eval '$' . $1 . "=" . $2 . ";";
            $ENV{$1} = $2;
        }
    }
}

#
# Search for toolvars overrides (DanielD)
#
foreach my $toolvarsext (("$TOOL/bin", "$OWN")) {
    if (-r "$toolvarsext/toolvarsext.pl") {
        do "$toolvarsext/toolvarsext.pl";
    }
}

# initializing flush of output buffer
$|=1; print "";

