#!/usr/bin/perl
# namelistx [-m] parameter   3.1.3   1993-12-07   kern   elke
#
# Parameter must be a standard module name, i.e. the directory
# "$SRC/$L, where L=`expr "parameter" : "v\(..\)"`, must exist.
# An implicit "iget -e0 parameter" is performed.
# If the option -m is specified, it is propagated to "iget".
# If an error occurred, the files "parameter.lst", which contains the
# macro lines to replaces the identifier within msdev, and "parameter.pre",
# which contains the generated output, are moved to "$WRK/fast/prot".
#
#    ========== licence begin  GPL
#    Copyright (C) 2001 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end
#

use Env;
use Getopt::Std;
use File::Copy;
use Win32::File;

getopts('mh');

if ( defined($opt_h) or @ARGV != 1 ) {
	print "Usage: namelistx [-m]  parameter\n";
	exit 11;
}
$Param = $ARGV[0];

$L = "";

if ( $Param !~ m!.*\\! ) {

	($L) = $Param =~ m!v(\w\w)\w+!;
	if ( ($L eq "") or (! -d "$SRC/$L") ) { $L = ""	} else { $DIR = "$SRC/$L" }
}

if ( $L eq "" ) {
	print "Error: module name $Param is illegal.\n";
	exit 12;
}

chdir("$WRK/fast/prot") || die "Can't change to directory $WRK/fast/prot: $!";

if ( -f "$DIR/$Param" ) {
	copy("$DIR/$Param", "./$Param") ;
} else {

        @ARGV = ("-e0", $Param);
		do "$TOOL/bin/iview$TOOLEXT";
		if ( $@ ) { die "Error while executing iview$TOOLEXT: $@" }
		Win32::File::SetAttributes("$TMP/$Param", NORMAL);
        copy("$TMP/$Param", "./$Param");
}
system("$TOOL/pgm/namelistx $Param");
$RET = $?;

unlink($Param, "$Param.pre");

if   ( $RET != 0 ) {
	if   ( -s "$Param.err" ) { open(FILE_IN, "<$Param.err"); print <FILE_IN>; close(FILE_IN) }
}
else { unlink("$Param.err") }

exit $RET;
