#!/usr/bin/perl
# @(#) ixref   6.2.8   1997-10-20   kern   Holger
#
# call of $TOOL/pgm/xref <modul>
#
#
#    ========== licence begin  GPL
#    Copyright (C) 2001 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end
#



use Env;
use Getopt::Std;

if ( !getopts('l') or (@ARGV == 0) ) {
	print "Usage: ixref [-l]  <modul>\n";
	exit 11;
}
$LOCAL = "-l" if defined($opt_l);

do "$TOOLVARS";
if ( $@ ) { die "Error while executing toolvars$TOOLEXT: $@" }

$BASEDIR = "$OWN/tmp";
$RESDIR  = "$WRK/fast/prot";

chdir ($BASEDIR);

system ("xref", @ARGV, $LOCAL,  " >$NULL");

unlink ("$RESDIR/xref.error"); rename ("xref.error", "$RESDIR/xref.error");
unlink ("$RESDIR/xref.vdn"); rename ("xref.vdn", "$RESDIR/xref.vdn");

print "copied xref.vdn and xref.error to $RESDIR";
