#  -----------------------------------------------------------------------------
#
#  module: idoc.pl
#
#  -----------------------------------------------------------------------------
#
#  special area: Development Environment
#
#  description:  generate and show doxygen docu
#
#  responsible:  Bernd Vorsprach
#
#  -----------------------------------------------------------------------------
#
#    ========== licence begin  GPL
#    Copyright (C) 2001 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end
#

use Env;
use Getopt::Std;
use ICopy;
use OLE;

#  -----------------------------------------------------------------------------
#  read arguments
#  -----------------------------------------------------------------------------
die "" if !getopts('hc');
if ( @ARGV != 1 && !defined($opt_h) ) {
  die <DATA>;
}

#  -----------------------------------------------------------------------------
#  help required?
#  -----------------------------------------------------------------------------
if ( $opt_h ) {
 print <DATA>;
 exit 0;
}

#  -----------------------------------------------------------------------------
#  retrieve full source name
#  -----------------------------------------------------------------------------
($source) = @ARGV;

( $vmakepath, $rel_source ) = ICopy::GetFilePath($source, 0, 1, 1);

if ( !defined($rel_source) ) {
  die "source not found!\n";
}

#  -----------------------------------------------------------------------------
#  translate source to hmtl
#  -----------------------------------------------------------------------------
if ( defined($opt_c) ) {
    my($RC)=system("python %TOOL%\\bin\\cppdoc.py -o $TMP $vmakepath/$rel_source");
    if ($RC != 0) {
      die "Can't generate HTML!\n";
    }
} else {
    my($RC)=system("gendoxy -o $TMP $vmakepath/$rel_source");
    if ($RC != 0) {
      die "Can't generate HTML!\n";
    }
}

#  -----------------------------------------------------------------------------
#  start internet explorer
#  -----------------------------------------------------------------------------
local $explorer ;
$explorer = GetObject OLE 'InternetExplorer.Application';
if (! defined($explorer)) {

  $explorer = CreateObject OLE 'InternetExplorer.Application'
	or die "Couldn't create new instance of Explorer App!!";
}

split (/\//, $rel_source);
$source = @_[@_ - 1];

if ( defined($opt_c) ) {
    split (/\./, $source);
    $explorer->Navigate("file://$TMP/@_[0].html");
} else {
    # split into name and extension
    split (/\./, $source);
    $source = @_[0];
    $ext    = @_[1];
    # split by underline to duplicate underlines
    split (/\_/, $source);
    $source  = @_[0];
    for ($i = 1; $i < @_; $i++) {
        $source = "${source}__@_[$i]";
    }
    if (-f "${TMP}/doxygen/${source}_8${ext}.html") {
        $explorer->Navigate("file://${TMP}/doxygen/${source}_8${ext}.html");
    } elsif (-f "${TMP}/doxygen/${source}_8${ext}-source.html") {
        $explorer->Navigate("file://${TMP}/doxygen/${source}_8${ext}-source.html");
    } else {
        $explorer->Navigate("file://${TMP}/doxygen/files.html");
    }

}
    $explorer->{'Visible'} = 1;
    $explorer->{'Active'}  = 1;

exit 0;

__DATA__

usage: idoc [-h] [-c] source
          -c  use cppdoc instead of doxygen

