#!/usr/bin/perl
#
# @(#)icp		1997-11-18
#
# G. Gromann, SAP AG
#
#
#    ========== licence begin  GPL
#    Copyright (C) 2001 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end
#

package icp;
use Env;
use Getopt::Std;
use ICopy;

$Usage = "usage: icp [-h] [-b] [-o] [-l level[x]] source [target]\n";

die "" if !getopts('hobl:');
if ( @ARGV == 0 && !defined($opt_h) )
{
	die $Usage;
}
if ( $opt_h ) {
	print <DATA>;
	exit 0;
}

if ( defined($opt_l) ) {
	die $Usage unless $opt_l =~ /^(\d)x?$/i;
	$level = $1; $exclusive = 1 if $opt_l =~ /x$/i;
}
$level = 0 unless defined($level);
$exclusive = 0 unless defined($exclusive);
if ( ICopy::_GetPathList($VMAKE_PATH) < $level+1 ) {
	die "The level value dont match! Use a lower level.\n";
}

($source, $target) = @ARGV;

if (defined($opt_b))
{
    if ( $source=ICopy::GetLastBackupName($source) )
    {
        my $rel_path;
		if ($^O =~ /mswin32/i )
			{ $target = "$OWN".substr($source, index($source, "\\sys\\")); }
		else
			{ $target = "$OWN".substr($source, index($source, "/sys/")); }
        ICopy::copy($source, $target, 0);
    }
    else
    {
        die "backup not found!\n";
    }
}
else
{
    ICopy::icp($source, $target, $level, $exclusive, 0) ||
        die "Can't copy $source to $target: $!\n";
}
exit 0;

__DATA__

usage: usage: icp [-h] [-b] [-o] [-l level[x]] source [target]


options:
 -o         : an old option / same effect as without target
              target is copied corresponding relative path into $OWN

 -b         : SAPDB internal option
              copy the last backup of the source in the corresponding
              directory

 -l<level>  : search the file from the specified level down to the final
              level and copy the first found to first level

 -l<level>x : search the file only in the specified level and
              copy it to first level (exclusive)

