# Copies all KERNEL-sources into $TMP and creates $TMP/sourcelist
#
#    ========== licence begin  GPL
#    Copyright (C) 2001 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end
#


#if [ "$OWN" = "/u1/kern" ]
#then
#	getkern
#else
#	LIST=$TMP/sourcelist
#
#	imf -m diagnose | sed 's/[a-z][a-z]\///' >> $LIST
#	imf -m audit    | sed 's/[a-z][a-z]\///' >> $LIST
#	imf -m prtprot  | sed 's/[a-z][a-z]\///' >> $LIST
#	ims -m slowci   | sed 's/[a-z][a-z]\///' >> $LIST
#	ims -m slowknl  | sed 's/[a-z][a-z]\///' >> $LIST
#	imf -m vtrace   | sed 's/[a-z][a-z]\///' >> $LIST
#
#	echo ven101 >> $LIST
#	echo ven102 >> $LIST
#	echo ven103 >> $LIST
#	echo vgg10  >> $LIST
#
#	sort -o $LIST -u $LIST
#
#	for F in `cat $LIST`
#		do
#			iview -e0 $F
#		done
#
#	rem -us cp $GRP/sys/man/kernel.xref $TMP
#fi

use Env;
use Getopt::Std;
use ICopy;

if (!getopts ('lh') || $opt_h) {
  print <DATA>;
  exit;
}

$LIST="$TMP/sourcelist";

print "collecting files ...\n";

open(SAVESTDOUT, ">&STDOUT"); close(STDOUT);
open(STDOUT, ">$LIST.tmp");

foreach $File ( "diagnose", "audit", "prtprot" ) {
@ARGV = ("-m", "$File");
$Returncode = do "$TOOL/bin/imf$TOOLEXT";
if ( $@ ) { die "Error while executing imf$TOOLEXT: $@" }
}

foreach $File ( "slowci", "slowknl" ) {
@ARGV = ("-m", "$File");
$Returncode = do "$TOOL/bin/ims$TOOLEXT";
if ( $@ ) { die "Error while executing imf$TOOLEXT: $@" }
}

close(STDOUT);
open(STDOUT, ">&SAVESTDOUT"); close(SAVESTDOUT);

system("$TOOL/Posix/sort -o $LIST.tmp -u $LIST.tmp");

open(INFILE, "<$LIST.tmp");
open(OUTFILE, ">$LIST");

print "getting files ... \n"  unless ($opt_l);

while ( <INFILE> ) {

    if ( m !/[a-z][a-z]/(.*)!) {
       ($MOD) = $_ =~ /([a-z]{3,}\d{2,}$)/i;
       print OUTFILE $_;
       ICopy::iview([$MOD], 0, 0, 0, 1) unless ($opt_l);
   }

}

close (INFILE); unlink ("$LIST.tmp");

foreach $File  ("ven101", "ven102", "ven103", "vgg10") {
    print OUTFILE "$_\n";
    ICopy::iview([$MOD], 0, 0, 0, 1) unless ($opt_l);
    }


close (OUTFILE);

__DATA__

 USAGE: getsource [-h] [-l]

           Creates a list of all modules used in
           slowknl, slowci, diagnose, audit and prtprot
           and copied them to $TMP

 OPTIONS:    -h    prints this help
             -l    only creates a list
