#!/usr/bin/env python
# alldesc.py

import string
import os

_extensions = {
    '.com': 1,
    '.lnk': 1,
    '.shm': 1,
    '.dld': 1,
    '.rel': 1,
    '.lib': 1,
    '.mac': 1,
    '.jpr': 1,
    '.shr': 1,
}


def writeDescriptionFiles (cygwin, dirname, files):
    splitext = os.path.splitext
    for file in files:
        ext = splitext (file) [1]
        if _extensions.has_key (ext):
            full = os.path.join (dirname, file)
            if cygwin:
                drive, path = os.path.splitdrive (full)
                if drive:
                    drive = '//' + drive [0]
                print drive + string.replace (path, '\\', '/')
            else:
                print full

def alldesc (cygwin):
    sys = os.path.join (os.environ ['OWN'], 'sys')
    paths = []
    for subdir in ['desc', os.path.join ('src', 'SAPDB')]:
        if os.path.isdir (os.path.join (sys, subdir)):
            paths.append (subdir)
    if len (paths) == 0:
        paths.append ('src')
    for path in paths:
        path = os.path.join (sys, path)
        os.path.walk (path, writeDescriptionFiles, cygwin)

def main (options, args):
    """write all description files to stdout

    The output is suitable for xargs
    """
    alldesc (options.cygwin)

def _options ():
    return [
        # (optstring, varname, typechar, default, help)
        ('cygwin', None, '', None, 'emit cygwin compatible names'),
        ]

if __name__ == '__main__':
    import optlib
    optlib.optMain2 (main, _options ())
