/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.util;

import com.sap.dbtech.util.StructuredBytes;
import java.math.BigDecimal;

public abstract class VDNNumber {
    private static final int zeroExponentValue_C = 128;
    private static final int tensComplement_C = 9;
    private static final int numberBytes_C = 20;
    private static final int numberDigits_C = 38;

    public static byte[] bigDecimal2number(BigDecimal decimal) {
        return VDNNumber.bigDecimal2number(decimal, 38);
    }

    public static byte[] bigDecimal2number(BigDecimal decimal, int validDigits) {
        int firstDigit;
        boolean isNegative;
        byte[] number = new byte[20];
        int scale = decimal.scale();
        String plain = decimal.toString();
        char[] chars = plain.toCharArray();
        int digitCount = chars.length;
        if (chars[0] == '-') {
            isNegative = true;
            firstDigit = 1;
        } else {
            isNegative = false;
            firstDigit = 0;
        }
        while ((chars[firstDigit] == '0' || chars[firstDigit] == '.') && firstDigit < digitCount - 1) {
            ++firstDigit;
        }
        int exponent = chars.length - firstDigit - scale;
        digitCount = chars.length - firstDigit;
        if (digitCount == 1 && chars[firstDigit] == '0') {
            number[0] = -128;
            return number;
        }
        if (exponent > 0 && scale > 0) {
            --exponent;
            --digitCount;
            System.arraycopy(chars, chars.length - scale, chars, chars.length - scale - 1, scale);
        }
        if (digitCount > validDigits) {
            if (chars[firstDigit + validDigits] >= '5') {
                int n = firstDigit + validDigits;
                chars[n] = (char)(chars[n] + '\u0001');
            }
            digitCount = validDigits;
        }
        int i = firstDigit;
        while (i < digitCount + firstDigit) {
            int n = i++;
            chars[n] = (char)(chars[n] - 48);
        }
        VDNNumber.packDigits(chars, firstDigit, digitCount, isNegative, number);
        exponent = isNegative ? 64 - exponent : (exponent += 192);
        number[0] = (byte)exponent;
        return number;
    }

    public static byte[] long2number(long value) {
        boolean isNegative = false;
        int negativeVal = 1;
        byte[] number = new byte[20];
        char[] scratch = new char[39];
        int scratchPos = 37;
        if (value == (long)0) {
            number[0] = -128;
            return number;
        }
        if (value < (long)0) {
            negativeVal = -1;
            isNegative = true;
        }
        while (value != (long)0) {
            char digit;
            scratch[scratchPos] = digit = (char)((long)negativeVal * (value % (long)10));
            value /= (long)10;
            --scratchPos;
        }
        int exponent = 38 - scratchPos - 1;
        VDNNumber.packDigits(scratch, ++scratchPos, 38 - scratchPos, isNegative, number);
        exponent = isNegative ? 64 - exponent : (exponent += 192);
        number[0] = (byte)exponent;
        return number;
    }

    public static BigDecimal number2BigDecimal(byte[] rawNumber) {
        int exponent;
        BigDecimal result = null;
        int digitCount = (rawNumber.length - 1) * 2;
        int lastSignificant = 2;
        int characteristic = rawNumber[0] & 0xFF;
        if (characteristic == 128) {
            return new BigDecimal(0.0);
        }
        byte[] digits = new byte[digitCount + 2];
        if (characteristic < 128) {
            exponent = -(characteristic - 64);
            digits[0] = 45;
            digits[1] = 46;
            for (int i = 1; i < rawNumber.length; ++i) {
                int value = ((char)rawNumber[i] & 0xFF) >> 4;
                if (value != 0) {
                    lastSignificant = i * 2;
                }
                digits[i * 2] = (byte)(9 - value + 48);
                value = (char)rawNumber[i] & 0xF;
                if (value != 0) {
                    lastSignificant = i * 2 + 1;
                }
                digits[i * 2 + 1] = (byte)(9 - value + 48);
            }
            int n = lastSignificant;
            digits[n] = (byte)(digits[n] + 1);
        } else {
            exponent = characteristic - 192;
            digits[0] = 48;
            digits[1] = 46;
            for (int i = 1; i < rawNumber.length; ++i) {
                int value = ((char)rawNumber[i] & 0xFF) >> 4;
                if (value != 0) {
                    lastSignificant = i * 2;
                }
                digits[i * 2] = (byte)(value + 48);
                value = (char)rawNumber[i] & 0xF;
                if (value != 0) {
                    lastSignificant = i * 2 + 1;
                }
                digits[i * 2 + 1] = (byte)(value + 48);
            }
        }
        String numberString = new String(digits, 0, lastSignificant + 1);
        result = new BigDecimal(numberString);
        result = result.movePointRight(exponent);
        return result;
    }

    public static long number2long(byte[] rawNumber) {
        boolean isNegative;
        long result = 0L;
        int numberDigits = rawNumber.length * 2 - 2;
        int characteristic = rawNumber[0] & 0xFF;
        if (characteristic == 128) {
            return 0L;
        }
        if (characteristic < 128) {
            int exponent = -(characteristic - 64);
            if (exponent < 0 || exponent > numberDigits) {
                BigDecimal bigD = VDNNumber.number2BigDecimal(rawNumber);
                return bigD.longValue();
            }
            isNegative = true;
            for (int i = 0; i < exponent; ++i) {
                int value = rawNumber[i / 2 + 1];
                if (i % 2 == 0) {
                    value &= 0xF0;
                    value >>>= 4;
                } else {
                    value &= 0xF;
                }
                result *= (long)10;
                result += (long)(9 - value);
            }
            ++result;
        } else {
            int exponent = characteristic - 192;
            if (exponent < 0 || exponent > numberDigits) {
                BigDecimal bigD = VDNNumber.number2BigDecimal(rawNumber);
                return bigD.longValue();
            }
            isNegative = false;
            for (int i = 0; i < exponent; ++i) {
                int value = rawNumber[i / 2 + 1];
                if (i % 2 == 0) {
                    value &= 0xF0;
                    value >>>= 4;
                } else {
                    value &= 0xF;
                }
                result *= (long)10;
                result += (long)value;
            }
        }
        if (isNegative) {
            result = -result;
        }
        return result;
    }

    public static BigDecimal number2BigDecimal(byte[] rawNumber, int scale) {
        return VDNNumber.number2BigDecimal(rawNumber).setScale(scale);
    }

    public static int number2int(byte[] rawBytes) {
        BigDecimal decimal = VDNNumber.number2BigDecimal(rawBytes);
        int result = decimal.intValue();
        return result;
    }

    private static void packDigits(char[] digits, int start, int count, boolean isNegative, byte[] number) {
        int i;
        int lastDigit = start + count - 1;
        if (isNegative) {
            for (i = start; i < lastDigit; ++i) {
                digits[i] = (char)(9 - digits[i]);
            }
            digits[lastDigit] = (char)(10 - digits[lastDigit]);
            int digitPos = lastDigit;
            while (digits[digitPos] == '\n') {
                digits[digitPos] = '\u0000';
                int n = digitPos - 1;
                digits[n] = (char)(digits[n] + '\u0001');
                --digitPos;
            }
        }
        i = 1;
        while (start <= lastDigit) {
            byte highNibble = (byte)digits[start];
            byte lowNibble = start + 1 <= lastDigit ? (byte)digits[start + 1] : (byte)0;
            number[i] = (byte)(highNibble << 4 | lowNibble);
            ++i;
            start += 2;
        }
    }

    public static void dumpVDN(String comment, byte[] number) {
        StructuredBytes struct = new StructuredBytes(number);
        System.out.println(comment);
        struct.traceOn(System.out);
    }

    static {
        zeroExponentValue_C = 128;
        tensComplement_C = 9;
        numberBytes_C = 20;
        numberDigits_C = 38;
    }
}

