#!/usr/bin/perl
#    ========== licence begin  GPL
#    Copyright (c) 2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end

package SAPDB::Install::Templates::MobileInfra;

sub BEGIN {
  my $repo = SAPDB::Install::Repository::GetCurrent ();
  my @neededPackages=qw(
                        Templates::Base  System
                       );
  @ISA = qw(SAPDB::Install::Templates::Base);
  @EXPORT=(  );
  foreach my $package (@neededPackages) {
    unless (defined $repo->Eval ("SAPDB::Install::$package", 1.01)) {
      print join ("\n", $repo->GetErr)."\n";
      die ("Error loading:  SAPDB::Install::$package\n");
    }
    SAPDB::Install::Exporter::import ("SAPDB::Install::$package"); 
  }
}
#endbecause


#Konstruktor fr MobileInfra-Instanzen
#+sub():MobileInfraRef:Default-Konstruktor
sub new(){
  my $this = createThis();
  bless $this;

  $this->setType('mi');
  if( $^O =~ /mswin/i){
    $this->setDrive("c"); #Implicitly sets dependend path, data path and log path
  }
  else{
    $this->setInstRootPath("/opt/sdb");
  }

  #defaults for volume sizes
  $this->setDataSize(102400);
#  $this->setDataSize(393216);
  $this->setLogSize(25600);
  $this->setDataVolCount(1);
  $this->setLogVolCount(1);

  #DB defaults for users and passwords
  $this->setDBA("dba");
  $this->setDBName("MIDB1");
  $this->setDBAPass("dba");
  $this->setDBM("dbm");
  $this->setDBMPass("dbm");
#  $this->setSQLU("miuser");
#  $this->setSQLPass("sap");
  $this->setDomainPass("domain");

  #set Autoextend and log overwrite on
  $this->setAutoExtend("YES");
  $this->setLogAutoOverwrite("YES");
  $this->setAutoRestart("YES");

  #DB-Defaults: database parameters
  $this->setDBParams({});
  $this->addDBParam("CACHE_SIZE","2500");
  $this->addDBParam("MAXDATAVOLUMES","64");
  $this->addDBParam("MAXUSERTASKS","20");
  $this->addDBParam("_UNICODE","YES");
  $this->addDBParam("SESSION_TIMEOUT","0");

  #Defaults for paths
  $this->setArchive("SDB" .  (uc $this->getDBName()) . ".TGZ");
  $this->setBackup( (uc $this->getDBName()) . ".data");

  #Strategies:
  $this->setCreationStrategy(4);
  $this->setDoUpdateStatistics(1);


  return $this;
}
#new





#+sub(String:name):void:Set the name of the Database
sub setDBName(){
  my ($this,$aName)=@_;
  $this->SUPER::setDBName($aName);
  $this->setDependendPath("");
  $this->setDataPath("");
  $this->setLogPath("");
}


sub getDBVolumes(){
my ($this)=@_;
$this->initializeVolumeDefinitions();
  return $this->SUPER::getDBVolumes();
}



#overwritten method
sub createInstance($){
  my ($this) = @_;
  my $aSID = $this->getDBName();

   my ($uid,$gid); 
  unless($^O =~ /mswin/i){
    $uid = getpwnam($SAPDB::Install::Values::owner);
    $gid = getgrnam($SAPDB::Install::Values::group);
  }

  my $aLogPath = $this->getLogPath();
  if ( (defined $aLogPath) and (not -d $aLogPath)){
    makedir($aLogPath, 0777,$uid,$gid);
    unless( -d $aLogPath){
      $this->showOutput("While creating database instance $aSID:\nError creating directory \"$aLogPath\"\n" .
                       "Therefore the database instance cannot be created!");
      return 1;
    }
  }

  my $aDataPath = $this->getDataPath();
  if ( (defined $aDataPath) and (not -d $aDataPath)){
    makedir($aDataPath, 0777,$SAPDB::Install::uid,$SAPDB::Install::gid);
    unless(-d $aDataPath){
      $this->showOutput("While creating database instance $aSID:\nError creating directory \"$aDataPath\"\n" .
                       "Therefore the database instance cannot be created!");
      return 1;
    }
  }
  $this->SUPER::createInstance();
}
#createInstance()






sub setDependendPath{
 my ($this,  $aPath) = @_;
 my $aDependendPath;
 if(defined $aPath){
   if(isPathAbsolute($aPath)){
     $aDependendPath = $aPath;
   }
   elsif("" eq $aPath){
     my $aSID = $this->getDBName();
     my $aRootPath = $this->getInstRootPath();
     $aDependendPath = catfile($aRootPath ,$aSID ,'db');
   }
   else{
     my $aSID = $this->getDBName();
     my $aRootPath = $this->getInstRootPath();
     $aDependendPath = catfile($aRootPath ,$aSID ,$aPath);
   }
 } 
 $this->SUPER::setDependendPath($aDependendPath);
 return  $aDependendPath;
}







#ifdef doc
#<h2>Configuration</h2>
#<ul class = "c1">
#<li>This template can be configured by a simple parameter file</li>
#<li>The parameter file is devided into sections. (Windows "ini"-Style)</li>
#<li>A section contains key value pairs.</li>
#</ul>
#<h3>Sample configuration file</h3>
#<p>A Sample can be found <a href="../mi/mi-example.txt">here.</a></p>
#<h2>Legal Parameters Described By Section</h2>
#<h3><code>Template-Section</code></h3>
#<ul>
#<li><strong>TYPE</strong>: Fixed for this template: "mi"</li>
#</ul>
#<h3><code>Software-Section</code></h3>
#<ul>
#<li><strong>DRIVE</strong>:
#    <p>Global drive for the installation (including software). This will
#      implicitly set <code>INSTROOTPATH</code>.</p>
#    <p>
#   (It will also implicitly set  <code>DATAPATH</code> and <code>LOGPATH</code>
#  in the Instance-Section.)
#   </p>
#   <p>DEFAULT: <code>c</code></p>
#</li>
#<li><strong>INSTROOTPATH</strong>: Root of the software installation
#   <p>DEFAULT: <code>&lt;DRIVE&gt;:/sdb</code></p>
#</li>
#
#
#</ul>
#<h3><code>Instance-Section</code></h3>
#<ul>
#
#<li><strong>DBNAME</strong>: Name of the database instance
#   <p>DEFAULT: <code>MIDB1</code></p></li>
#
#
#<li><strong>LOGPATH</strong>: Root path of log volumes
#   <p>DEFAULT: <code>&lt;INSTROOTPATH&gt;/&lt;DBNAME&gt;/log</code></p></li>
#
#<li><strong>DATAPATH</strong>: Root path of data volumes
#   <p>DEFAULT: <code>&lt;INSTROOTPATH&gt;/&lt;DBNAME&gt;/data</code></p></li>
#
#<li><strong>DEPENDPATH</strong>: "Dependend" path.
#   <p>DEFAULT: <code>&lt;INSTROOTPATH&gt;/&lt;DBNAME&gt;/db</code></p>
#</li>
#
#<li><strong>DBM</strong>: Name and password of database manager
#   <p>DEFAULT: <code>dbm,dbm</code></p></li>
#
#<li><strong>DBA</strong>: Name and password of database administrator
#   <p>DEFAULT: <code>dba,dba</code></p></li>
#
#<li><strong>DOMAINPASS</strong>: Password of domain user
#   <p>DEFAULT: <code>domain</code></p></li>
#
#<li><strong>SQLUSER</strong>: Name and password of an sql user.
#   <!--<p>DEFAULT: miuser,sap<code>domain</code></p>-->
#   <p>NO DEFAULT: No SQL User will be created by default! </p>
# </li>
#
#<li><strong>DATAVOLS</strong>: Number of data volumes
#   <p>DEFAULT: <code>1</code></p></li>
#
#<li><strong>DATASIZE</strong>: Size of data volumes (in pages)
#   <p>DEFAULT: <code>393216</code></p></li>
#
#<li><strong>LOGVOLS</strong>: Number of log volumes
#   <p>DEFAULT: <code>1</code></p></li>
#
#<li><strong>LOGSIZE</strong>: Size of log volumes (in pages)
#   <p>DEFAULT: <code>25600</code></p></li>
#
#<li><strong>ARCHIVE</strong>: NAME of a tgz archive containing a backup for <code>db_activate RECOVER</code>
#   <p>DEFAULT: <code>SDB&lt;DBNAME&gt;.TGZ</code></p></li>
#
#<li><strong>BACKUP</strong>: NAME of a backup to be used for <code>db_activate RECOVER</code> 
#   <p>DEFAULT: <code>&lt;DBNAME&gt;.data</code></p></li>
#</ul>
#
#<h3><code>DBParam-Section</code></h3>
#<p>Database parameters specified as key value pairs. Defaults are:</p>
#<ul>
#<li><strong>CACHE_SIZE</strong>:2500 </li>
#<li><strong>MAXDATAVOLUMES</strong>: 64</li>
#<li><strong>MAXUSERTASKS</strong>: 20</li>
#<li><strong>RESTART_SHUTDOWN</strong>: AUTO</li>
#<li><strong>_UNICODE</strong>: YES</li>
#<li><strong>SESSION_TIMEOUT</strong>: 0</li>
#</ul>
#endif

1;
# Local Variables: ***
# perl-dbg-flags:"-w      -I../../../../../../wrk/script -I../../../sdbrun  " ***
# sdbinst-defines: "-define SCRIPTING -define PERL5.6.1" ***
# sdbinst-testfile: "MobileInfraTest.pl" ***
# sdbinst-script-directory:  "sys/wrk/script/SAPDB/Install/Templates" ***
# End: ***



