#!/usr/bin/perl
#
# $Header: //sapdb/V74/develop/sys/src/install/perl/SAPDB/Install/WIN32API/Registry.pm#4 $
# $DateTime: 2002/10/08 19:11:33 $
# $Change: 28512 $
#
# Desc: 
#    ========== licence begin  GPL
#    Copyright (c) 2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end



package SAPDB::Install::System::Win32::Registry;


sub import {
	local $SAPDB::Install::Exporter::ExportLevel = 1;
	SAPDB::Install::Exporter::import (@_);
	bootstrap SAPDB::Install::System::Win32::Registry;
}

sub BEGIN {
	my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages=(
		'Exporter'
	);
	foreach my $package (@neededPackages){
	  	unless (defined $repo->Eval ("SAPDB::Install::$package", 1.01)) {
                print join ("\n", $repo->GetErr)."\n";
                die;
        	}
		import ("SAPDB::Install::$package"); 
	}
	@ISA = ('SAPDB::Install::Exporter');
	@EXPORT = (
		'RegOpenKeyEx', 'RegCloseKey', 'RegSetValueEx','RegDeleteKey','RegDeleteValue',
		'RegEnumValue', 'RegEnumKeyEx', 'RegCreateKeyEx',
		'RegQueryValueEx', 'RegQueryInfoKey', 'ExpandEnvironmentStrings',
		'HKEY_CLASSES_ROOT', 'HKEY_CLASSES_ROOT', 'HKEY_CURRENT_CONFIG',
		'HKEY_CURRENT_USER', 'HKEY_LOCAL_MACHINE', 'HKEY_USERS',
		'HKEY_PERFORMANCE_DATA', 'HKEY_DYN_DATA',
		'KEY_CREATE_LINK', 'KEY_CREATE_SUB_KEY', 'KEY_CREATE_SUB_KEY',
		'KEY_ENUMERATE_SUB_KEYS', 'KEY_EXECUTE', 'KEY_NOTIFY',
		'KEY_QUERY_VALUE', 'KEY_SET_VALUE', 'KEY_ALL_ACCESS',
		'KEY_READ', 'KEY_WRITE', 'REG_EXPAND_SZ', 'REG_MULTI_SZ', 'REG_BINARY',
		'REG_OPTION_NON_VOLATILE','REG_CREATED_NEW_KEY', 'REG_OPENED_EXISTING_KEY' 
	);
}


sub AUTOLOAD {
	die unless ($AUTOLOAD =~ "bootstrap");
	require DynaLoader;
	push @ISA, 'DynaLoader';
	bootstrap SAPDB::Install::System::Win32::Registry;
}

1;