#!/usr/bin/perl
#
# $Header: //sapdb/V75/c_00/develop/sys/src/install/perl/SAPDB/Install/StartInstall.pm#7 $
# $DateTime: 2004/02/05 13:06:13 $
# $Change: 63678 $
#
# Desc: start SAP DB installation/update/patch/instanceupgrade, called by SDBINST/SDBUPD
#    ========== licence begin  GPL
#    Copyright (c) 2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end



package SAPDB::Install::StartInstall;

$VERSION = 1.01;

sub BEGIN {
      my $repo = SAPDB::Install::Repository::GetCurrent ();
	#$SAPDB::Install::Start::DEBUG=1;		 # show all symbols of main package
	#$SAPDB::Install::Repository::DEBUG=1;   # show loading modules 
	#$SAPDB::Install::Exporter::DEBUG=1;	 # show importing symbols from other modules
	my @neededPackages=(
		'Log',
		'System',
		'StdIO',
		'Registry',
		'Version',
		'Cleaner',
		'Migrate::Registry',
		'InstallRegistry',
		'Instance',
		'DBMCmd',
		'Values',
		'MD5Sum',
		'SetDebug',
		'Tools',
		'Collector',
		'Cwd',
		'Getopt::Long',
		'Misc',
		'SigHandler',
		'Trace',
		'Comm',
		'SysInfo',
		'Jar',
#		'Templates::Setup',
		'InstallRegistry::Verify',
		'Templates::Setup'
	);

	push @neededPackages, 'Uninstall::RemoveFilesInUse' if $^O =~ /mswin/i;
	push @neededPackages, 'Migrate::DBRegistrations' unless $^O =~ /mswin/i;
	push @neededPackages, 'Term::ReadKey' if $SAPDB::Install::Config{'HasOwnConsole'};

	@EXPORT=('main');
	foreach my $package (@neededPackages){
	  	unless (defined $repo->Eval ("SAPDB::Install::$package", 1.01)) {
                print join ("\n", $repo->GetErr)."\n";
                die ("error loading:  SAPDB::Install::$package\n");
        	}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package"); 
	}
	#SAPDB::Install::Exporter::import ("SAPDB::Install::StartInstall");

}


$DEBUG=0;


# main symbol is called directly

sub main {
    local @ARGV = @_;
	
	# print version if commandlineoption -v | --version is set
	printVersion(\@ARGV);
	
	my $arglogline=join(' ',grep(!/^INSTANCE$/,@ARGV));
    {
    	# now remove passwords from arguments for printing in logfile
    	$arglogline=~/-ud\s*(\S*)/ and my $psswrd = $1;
    	$psswrd='*' x (length($psswrd));
    	$arglogline=~s/-ud\s*\S*/-ud $psswrd/;
    	$arglogline=~/-u\s*\S*,(\S*)/ and $psswrd = $1;
    	$psswrd='*' x (length($psswrd));
    	$arglogline=~s/-u\s*(\S*),\w*/-u $1,$psswrd/;
    }

	# set debug output for packages
	SetDebug(\@ARGV);
	

	# cleaner object you can give references to global variables, which have to be set back (to undefined)
	# important for object destruction (garbage collector work with simple refcounter)
	local $cleaner=SAPDB::Install::Cleaner->new();

	local $log = SAPDB::Install::Log->new();
	$SAPDB::Install::Values::log=$log;
	$cleaner->SetRef(\$SAPDB::Install::Values::log);
	
	setSigHandler();	
	
	$log->LogPath($SAPDB::Install::Values::curDir);
	$log->SetMsg("CALL: $SAPDB::Install::Config{'ProgramName'} $arglogline\n");	
	
	
	local $instRegistry;
	
	%opt_ctrl=(
		'archive_dir=s' => \$opt_archive_dir,
		'a=s' => \$opt_archive_dir, 
		'help' => \$opt_h,
		'h'		=> \$opt_h,
		'l' => \$opt_l,
		'list' => \$opt_l,
		'profile=s' => \$opt_profile,
		'package=s' => \$opt_package,
		'INSTANCE' => \$opt_INSTANCE,
		'b' => \$opt_b,
		'batch' => \$opt_b
				
	);	
	
	GetOptions(%opt_ctrl);
	
	if($opt_l){
		my $data = SAPDB::Install::Collector::getPackages(defined $opt_archive_dir ? genAbsPath($opt_archive_dir) : undef);	
		print2stderr("no packages found\n") unless defined $data;		
		print "possible profile(s):\n";
		print join("\n",sort { uc($a) cmp uc($b) } (@{$data->{'profiles'}},'all'))."\n\n\n";
		print "possible package(s):\n\n";
		my @table;
		foreach my $packdata (@{$data->{'packages'}}){
			push @table, [$packdata->{'DISPLAY_NAME'} ? $packdata->{'DISPLAY_NAME'} : $packdata->{'PACKAGE_NAME'},
						  $packdata->{'SOFTWARE_VERSION'}, $packdata->{'MODE'} ? $packdata->{'MODE'}.' bit' : ''];
		}
		@table = sort { uc($a->[0]) cmp uc($b->[0]) } @table;
		printTable(\@table,' ');
		if($SAPDB::Install::Config{'HasOwnConsole'}){
			print2stdout("\npress any key...");
			SAPDB::Install::Term::ReadKey::ReadMode('raw');
			SAPDB::Install::Term::ReadKey::ReadKey();
		}
		die ("\n\n\n");	
	}	
	
	my $archive_dir;
		
	unless($opt_l || $opt_h || $opt_v){
		
		# dont start installation in SAP DB depelopment environment
		if($ENV{'SAPDB_NO_INDEPPATH'} =~ /y/i){
			print2stderr("please do not start installation in SAP DB depelopment environment\n");
			diesoft($diemsg);
		} 


		# dont start installation in DBROOT environment
		if(defined $ENV{'DBROOT'}){
			print2stderr("please do not start installation in DBROOT environment\n");
			diesoft($diemsg);
		}

		unless ($< == 0){
			#user is not root -> cancel
			print2stderr("please restart installation as root\n");
			diesoft($SAPDB::Install::Values::diemsg);
		}
		
		
		$archive_dir =
		$SAPDB::Install::Config{'UsedSDBRUN'} eq 'kit' ? $SAPDB::Install::Config{'RuntimeDir'} :
		$SAPDB::Install::Config{'UsedSDBRUN'} eq 'installed' ? $SAPDB::Install::Config{'CallerDir'} :
		undef;

		if($opt_archive_dir =~ /\S/){
			$opt_archive_dir =~ s/\\/\//g; # replace '\' with '/'
			$opt_archive_dir =~ s/^.\///; # remove './' at bol
			$opt_archive_dir =~ s/([^\/])\/$/$1/; #remove slash at eol
			unless($opt_archive_dir =~ /^\/|^[a-z]:/i){
				$opt_archive_dir =
				defined $archive_dir ? $archive_dir.'/'.$opt_archive_dir : undef;
			}
		}

		$archive_dir =
		defined $opt_archive_dir ? genAbsPath($opt_archive_dir) :
		defined $archive_dir ? $archive_dir : 
		undef;
		
		
		$lcapps_exists = 0;

		if(-f "$archive_dir/APOCOM.TGZ" || -f "$archive_dir/APOLCA.TGZ"){
			$lcapps_exists = 1;
			$SAPDB::Install::Values::product = 'SAP liveCache Software';
			$SAPDB::Install::Values::TraceFileName = 'SAPlivecache_installer_trace';
		}
		
		

		if($opt_profile =~ /\S/ and $opt_profile ne 'all'){
			$SAPDB::Install::Values::product = $lcapps_exists ? "SAP liveCache $opt_profile" : "MaxDB $opt_profile"; 
			my $log_name = $product;
			$log_name =~ s/\s//g;
			$log->LogName($log_name); 
		}		
		if($opt_INSTANCE){
			$caption = $lcapps_exists ?  'SAP liveCache INSTANCE UPDATE' : 'MaxDB INSTANCE UPDATE';
			$SAPDB::Install::Values::diemsg = $lcapps_exists ? 'SAP liveCache instance update exited abnormally' : 
																'MaxDB instance update exited abnormally';
			$log->LogName($lcapps_exists ?  'SAPliveCacheUpdate' : 'MaxDBUpdate');
			
		}
		else{
			$caption="Installation of $product ";
		}
		
		$len_cap = length $caption;
		print2stdout("\n\n\t$caption\n");
		print2stdout("\t"."*"x$len_cap."\n\n\n");
		print2stdout("starting installation ".timeStamp()."\n");
		my $os;
		my $sysinfo = GetSystemInfo();
		if (defined $sysinfo){
			$os = $sysinfo->{'system'}.' '.$sysinfo->{'architecture'}.' '.$sysinfo->{'version'};
			$os .= ' '.$sysinfo->{'subversion'} if exists $sysinfo->{'subversion'}; 	
			$os .= ' '.$sysinfo->{'c_runtime'} if exists $sysinfo->{'c_runtime'}; 	
		}
		else{
			$os = $^O;
		}
		print2stdout("operating system: $os\n");
		print2stdout("callers working directory: $SAPDB::Install::Values::curDir\n");
		print2stdout("installer directory: $SAPDB::Install::Config{'RuntimeDir'}\n");
	}
	
	$opt_profile  or $opt_profile='';
	 
	($opt_h or $opt_l ) and $opt_profile eq '' and $opt_profile='all'; 
	
	
	local ($indep_data,$indep_prog)=readIndepPath(); # try to get independent pathes from earlier installation
	if($indep_data){
		# an independent data path is registered
		# now set path for installation logfile  and create installation registry object 
		$log->LogPath("$indep_data/wrk");
		$instRegistry=SAPDB::Install::InstallRegistry->new("$indep_data/config/install",1,$log);
	}
	
	if($indep_prog){
		# set indep program path in environment
		setPathInEnv("$indep_prog/bin");
		setPathInEnv("$indep_prog/pgm") if $^O =~ /mswin/i;
	}
	
	$cleaner->SetRef(\$instRegistry);

	unless($opt_l || $opt_h || $opt_v){
		print2stdout("archive directory: $archive_dir\n") if (defined $archive_dir);
		print2stdout("\n\n");
	}

	if ($SAPDB::Install::Config{'UsedSDBRUN'} eq 'installed') {
		if (
		-e $archive_dir."/sdbrun.dll" ||
		-e $archive_dir."/sdbrun.exe" ||
		-e $archive_dir."/sdbinst.exe" ||
		-e $archive_dir."/SDBINST" ||
		-e $archive_dir."/SDBRUN") {
			print2stderr("SDBINST exists in installation kit\n");
			print2stderr("use $archive_dir/SDBINST to install software\n");
			diesoft($SAPDB::Install::Values::diemsg);	
		}
	}

	(my $profile,local @packageref)=collect($opt_profile,$opt_package,$opt_b,
											\$instRegistry, $archive_dir); # now collect valid packages 
	
	if($profile =~ /\S/ and $profile ne 'all' and not $opt_INSTANCE){
		$SAPDB::Install::Values::product = $lcapps_exists ? "SAP liveCache $profile" : "MaxDB $profile"; 
		my $log_name = $product;
		$log_name =~ s/\s//g;
		$log->LogName($log_name); 
	}

		
	$cleaner->SetRef(\@packageref);
	
	if($#packageref==-1){
		# no packages found -> exit
		print2stderr("no valid package found for installation profile \"$profile\"\n");
		diesoft($SAPDB::Install::Values::diemsg);	
	}

	
	 # collect data from earlier installations (old installation procedure) and put it into install registry
     migrateReg($instRegistry,@packageref);

	
	
	#print2stdout("found packages for profile \"$profile\":\n");
	#foreach my $packobj (@packageref){
	#	print2stdout("\t".$packobj->DispName."\n");	
	#}
	
	
	%opt_ctrl=(); # reset option hash
		
	
	my $usage_part;
	my $usage_desc_part;
	
	unless($opt_INSTANCE){
		
		# if started by SBDUPD it isnt necessary to select a profile
		
		$usage_part = ' [-profile <installation profile>]';
		
		$usage_desc_part = "\t-profile <installation profile>\t\tselect an installation profile\n";
							 
	}
	
	
	$usage=$SAPDB::Install::Config{'ProgramName'}.
			' [-h | --help] [-l | --list] [-v | --version] [-b | --batch]'.
			' [-package <package 1,package 2, ... >] [-archive_dir <directory>]'.
			$usage_part;
	$usage_desc  =	"\t-h --help\t\t\t\tshow this\n".
					"\t-v --version\t\t\t\tshow installer version\n".
					"\t-l --list\t\t\t\tshow existing profiles and packagenames\n".
					"\t-b --batch\t\t\t\tstart installation in batch mode\n".
					"\t-a --archive_dir <directory>\t\tselect software packages in <directory>\n".
					"\t-package <package 1,package 2, ... >\tselect a package by package name\n".
					$usage_desc_part;#.
					#"\t-F --force\t\t\tignore most errors\n";

	unless($^O=~/mswin/i){
		$opt_ctrl{'o=s'} = \$opt_o;
		$opt_ctrl{'g=s'} = \$opt_g;
		$opt_ctrl{'diff_owner_group'} = \$opt_diff_owner_group;
		$usage=$usage.' [-o <owner>] [-g <group>]';
		$usage_desc=$usage_desc.
					#"\t-diff_owner_group\t\t\tpossible to select different owner/group for each package (not in batchmode)\n".
					"\t-o <owner>\t\t\t\tos user name and owner of MaxDB files - aka sdb user\n".
					"\t-g <group>\t\t\t\tos group name and group of MaxDB files - aka admin group\n";
	}		
	
	#execute existing scripts - collect command line options and func references of preinstall, postinstall, register, frames, ... and values like pathes, defaults,....  
	my @existing_profiles = ('all');
	my @existing_packages;
	foreach my $packobj (@packageref){
		$packobj->Script or $log->SetMsg("MSG: no script in signature of package \"".$packobj->DispName."\"\n") and next;	
		# now set all package specific options
		defined $packobj->Paths || print2stderr("fatal error: no paths defined!\n") && diesoft($SAPDB::Install::Values::diemsg); 
		foreach my $pathref (@{$packobj->Paths}){
			my %path=%$pathref;
			my $optname=$path{'opt'};
			#create global var $opt_<OPTION>
			$optname=~s/=.*//;
			$optname="opt_$optname";
			$DEBUG && print "DEBUG\nopt = \$$optname\n";
			$opt_ctrl{$path{'opt'}} = \${$optname};
		}
		
		foreach my $opt (@{$packobj->Opts}){
			my $optname=$opt;
			$optname=~s/=.*//;
			$optname="opt_$optname";
			$DEBUG && print "DEBUG\nopt = \$$optname\n";
			$opt_ctrl{$opt} = \${$optname};
		}
		$usage.=$packobj->Usage;
		$usage_desc.=$packobj->UsageDesc;
		# collect different profile names for usage output
		@existing_profiles = union(\@existing_profiles,[$packobj->TopOf]) if $packobj->TopOf =~ /\S/;
		push @existing_packages,[$packobj->DispName,$packobj->Version,$packobj->Mode, $packobj->Mode ? 'bit' : ''];
	}
 	
	#$profile eq 'all' and $usage_desc.= "\n\n\tinstallation profiles found: \n\t\t\t".join("\n\t\t\t",@existing_profiles)."\n\n\n";			
	
		
	SAPDB::Install::Getopt::Long::Configure ('no_pass_through');
	if(!GetOptions(%opt_ctrl) || defined $opt_help || defined $opt_h){
	    #unknown command line switch or -help  / -h
		print "\nusage: $usage\n";
		print "\n$usage_desc\n";
		if($SAPDB::Install::Config{'HasOwnConsole'}){
			print2stdout("\npress any key...");
			SAPDB::Install::Term::ReadKey::ReadMode('raw');
			SAPDB::Install::Term::ReadKey::ReadKey();
		}
		die ("\n\n\n"); 
	}

	
	if($opt_l){
		print "possible profile(s):\n";
		print join("\n",@existing_profiles)."\n\n\n";
		print "possible package(s):\n\n";
		printTable(\@existing_packages,' ');
		if($SAPDB::Install::Config{'HasOwnConsole'}){
			print2stdout("\npress any key...");
			SAPDB::Install::Term::ReadKey::ReadMode('raw');
			SAPDB::Install::Term::ReadKey::ReadKey();
		}	
		die ("\n\n\n");	
	}
	
			
	# call framestart functions for each package
	foreach my $packobj (@packageref){
		if (defined $packobj->framestart){
			eval{
				&{$packobj->framestart};
			}; $@ and print2stderr("error in framestart(): $@\n") and diesoft($diemsg);
		}
	}

	# history plays a role on instance upgrade only  
	
	#print "DB = $opt_DB\n";
	#print "software_ok = ".${($instRegistry->getInstanceData($opt_DB)}{'SOFTWARE_OK'}."\n";
	my %instance_data = $instRegistry->getInstanceData($opt_d)  if (defined $instRegistry and $opt_d =~ /\S/);
	#foreach $key (keys(%instance_data)){
	#	print "$key => $instance_data{$key}\n";
	#}



	unless($opt_INSTANCE && defined $instRegistry && $instRegistry->existInstanceData($opt_d) && $instance_data{'SOFTWARE_OK'}){
	
	my %hFileSystemInfo;

	defined $instRegistry and $instRegistry->RefreshAllFilesList;

		
	foreach my $packobj (@packageref){
		*paths = $packobj->Paths;
				
		my %registeredPackages=$instRegistry->getInstallPathes($packobj->Name,1) if defined $instRegistry;
			

		# write headline
		my $tmpstring='starting preparing phase of package '.$packobj->DispName.' '.$packobj->Version;
		$tmpstring .= ' '.$packobj->Mode.' bit' if $packobj->Mode =~ /32|64/;
		my $strlen=length($tmpstring);
		print2stdout("\n$tmpstring\n");
		print2stdout("-"x$strlen."\n\n");
				
				
		# run preinstall script of package
		if (defined $packobj->preinstall){
			eval{
				&{$packobj->preinstall}(\$instRegistry);
			}; $@ and print2stderr("error in preinstall(): $@\n") and diesoft($diemsg);
		}
		
		# if Skip is set continue with next package
		${$packobj->Skip} and print2stdout("skipping package\n") and next;
		
		
		local $regpackobj;	# object of class InstallRegistry::Package 
		 
		# if no package path set by preinstall: check command line option
		unless(${%{$packobj->MainPath}}{'value'}){
			if(${%{$packobj->MainPath}}{'opt'}){
				my $opt=${%{$packobj->MainPath}}{'opt'};
				$opt=~s/=.*$//g;
				my $opt_value=expandPath(${"opt_$opt"});
				normalizePath(\$opt_value);
				local *main=$packobj->MainPath;
				$main{'value'}=$opt_value;
			}
		}

		
		if($packobj->IsSubPackage){
			#my ($package,$opertor,$version,$mode) = 
			#		(${@{$packobj->Require}}[0] =~ /^(.*+/)\s*([<|>|=]*)\s*(.*)\s*(\d*)$/); 
			#my $req = {'operator' => $opertor,'bit' => $mode,'name' => $package, 'release' => $version};
			my ($req) = SAPDB::Install::Collector::parseRequire(${@{$packobj->Require}}[0]);
			my $parent_found = 0;
			foreach my $pack (@packageref){
				$packobj->Name eq $pack->Name and last; # no possible parent package found
				if(checkRequired('package_name' => $pack->Name,
								'version' => $pack->Version,
								'mode' => $pack->Mode,
								'required' => $req)){
					# treffer
					$parent_found = 1;
					$packobj->WithParent(1);
					local *subpackobjs = $pack->SubPackObjs;
					push @subpackobjs, \$packobj;
					local *main = $packobj->MainPath;
					$main{'value'} = ${%{$pack->MainPath}}{'value'};
					defined $packobj->SubDir and $packobj->SubDir =~ /\S/ and $main{'value'} .= '/'.$packobj->SubDir;			
					my @subpackages = @{$pack->RegData->SubPackages};
					my $found = 0;
					foreach my $subpackage (@subpackages){
						if($packobj->Name eq ${@$subpackage}[0] and $main{'value'} eq ${@$subpackage}[1]){
							$found =1;
							last;
						}	
					}
					normalizePath(\$main{'value'});
					unless($found){
						push @subpackages,[$packobj->Name,$main{'value'}];
						$pack->RegData->SubPackages(\@subpackages);
						$pack->RegData->setValues(); # dump registry data to disk
					}
					my $parent_path = ${%{$pack->MainPath}}{'value'};
					normalizePath(\$parent_path);
					$packobj->ParentPackage([$pack->Name,$parent_path]);
					unless($^O =~ /mswin/i){
						if($pack->User =~ /\S/){
							$packobj->User($pack->User);
                        }
						elsif($pack->RegData->User =~ /\S/){
							$packobj->User($pack->RegData->User);
						}
						else{
							print2stderr("cannot get software owner of parent package\n");
							diesoft($diemsg);
						}
						if($pack->Group){
							$packobj->Group($pack->Group);
                        }
						elsif($pack->RegData->Group){
							$packobj->Group($pack->RegData->Group);
						}
						else{
							print2stderr("cannot get software group of parent package\n");
							diesoft($diemsg);
						}
					}
				}
			}
			unless ($parent_found){
				if(defined $instRegistry){
					my @possible_parents = ();
					my @impossible_parents = ();
					my %parent_rels = $instRegistry->getInstallPathes(${%$req}{'name'});
					if(%parent_rels){
						foreach my $package_path (keys(%parent_rels)){
							my %package_data = $instRegistry->getPackageData(${%$req}{'name'},$package_path);
							if($package_data{'Valid'} and checkRequired('required' => $req,
											 'package_name' => ${%$req}{'name'},
											 'version' => $parent_rels{$package_path},
											 'mode' => $package_data{'Mode'}	
											)){
								push @possible_parents,[${%$req}{'name'},$package_path,\%package_data];
							}
							else{
								push @impossible_parents, [${%$req}{'name'},$package_path,\%package_data]; 								
							}
						}
						unless($#impossible_parents == -1 ){	
							print2stdout("invalid parent(s) for sub package ".$packobj->DispName.": \n");
							my @table = ();
							foreach my $info (@impossible_parents){
								my @info_list = @$info;
								push @table,[#$info_list[0],
											$info_list[1],
											 ${%{$info_list[2]}}{'Version'},
											${%{$info_list[2]}}{'Mode'} =~ /\S/ ? ${%{$info_list[2]}}{'Mode'}.' bit' : '',
											${%{$info_list[2]}}{'Valid'} ? 'valid' : 'invalid'];
							}
							printTable(\@table,' ' x 4);
							print2stdout("\n\n");
						}
						unless($#possible_parents == -1 ){
							my @table = ();
							my $opt_found = undef;
							my @info_list = @$info;
							$index = 0;
							my $opt=${%{$packobj->MainPath}}{'opt'};
							$opt=~s/=.*$//g;
							my $path_per_opt = ${"opt_$opt"};
							if(defined $path_per_opt and $packobj->SubDir =~ /\S/){
								$path_per_opt =~ s/\\/\//g;
								my $pattern = '\/+'.$packobj->SubDir.'\/*$';
								$path_per_opt =~ s/$pattern// or print2stderr("wrong option \"-$opt\": subdir \"".$packobj->SubDir."\" has to be part of it\n") and diesoft($diemsg);									
							}
							foreach my $info (@possible_parents){
								my @info_list = @$info;
								if(defined $path_per_opt){
										if(normalizePath(expandPath($path_per_opt)) eq normalizePath($info_list[1])){
											$opt_found = $index;
										} 							
								}
								push @table,[#$info_list[0],
											$info_list[1],
											 ${%{$info_list[2]}}{'Version'},
											${%{$info_list[2]}}{'Mode'} =~ /\S/ ? ${%{$info_list[2]}}{'Mode'}.' bit' : ''];
								$index++;
							}
							my $selection;							
							if(defined $path_per_opt){
								my $parent_string = ${@{$packobj->Require}}[0];
								defined $opt_found or print2stderr("wrong option \"-$opt\": no vaild parent \"$parent_string\" in $path_per_opt\n") and diesoft($diemsg);
								$selection = $opt_found;
							}
							else{
								$selection = ask4any(\@table,${%$req}{'name'},'select',$opt_b);
							}
							unless($selection == -1){
								$parent_found = 1;
								my $parent_path = ${@{$possible_parents[$selection]}}[1];
								normalizePath(\$parent_path);
								my %parent_data = %{${@{$possible_parents[$selection]}}[2]};
								local *main = $packobj->MainPath;
								$main{'value'} = $parent_path;
								defined $packobj->SubDir and $packobj->SubDir =~ /\S/ and $main{'value'} .= '/'.$packobj->SubDir;			
								my $regpackobj = $instRegistry->getPackage(${%$req}{'name'},$parent_path);
								defined $regpackobj or print2stderr("cannot get package from install registry\n") and diesoft($diemsg);
								my @subpackages = @{$regpackobj->SubPackages};
								my $found = 0;
								foreach my $subpackage (@subpackages){
									if($packobj->Name eq ${@$subpackage}[0] and $main{'value'} eq ${@$subpackage}[1]){
										$found =1;
										last;
									}	
								}
								unless($found){
									push @subpackages,[$packobj->Name,$main{'value'}];
									$regpackobj->SubPackages(\@subpackages);
									$regpackobj->setValues(); # dump registry data to disk
								}
								$packobj->ParentPackage([${%$req}{'name'},$parent_path]);
								$packobj->User($parent_data{'User'});
								$packobj->Group($parent_data{'Group'});
							}
						}	
					}
				}
			}
			unless($parent_found){
				print2stderr("no valid parent package ".${%$req}{'name'}." $version".($mode =~ /\S/ ? " $mode bit " : ' ')."found\n");
				diesoft($diemsg);
			}
					
			#
			# inintialize members UID and GID
			#
						
			unless($^O =~ /mswin/i){
				my $uid = getpwnam($packobj->User);
				defined $uid or print2stderr("cannot get uid of user \"".$packobj->User."\"\n") and diesoft($diemsg);
				$packobj->UID($uid);	
				my $gid = getgrnam($packobj->Group);
				defined $gid or print2stderr("cannot get gid of group \"".$packobj->Group."\"\n") and diesoft($diemsg);
				$packobj->GID($gid);						
			}
		}
		
		
		
		
		
		if(${%{$packobj->MainPath}}{'value'}){
			#path set by preinstall function or command line option
			if(defined $instRegistry and $instRegistry->existPackage($packobj->Name,${%{$packobj->MainPath}}{'value'},0)){
				#package exist -> update
				$packobj->Update(1);
				#$regpackobj=$instRegistry->getPackage($packobj->Name,${%{$packobj->MainPath}}{'value'});
			}
			else{
				# package dont exist -> new installation
				$regpackobj=$instRegistry->newPackage($packobj->Name,${%{$packobj->MainPath}}{'value'},1) if (defined $instRegistry and not defined $regpackobj);
				$packobj->Update(0);
			}
		}
		else{
			selectInstallation(\$instRegistry,$packobj,$opt_b || $opt_batch);
		}

		$packobj->Update and $regpackobj=$instRegistry->getPackage($packobj->Name,${%{$packobj->MainPath}}{'value'});

		if($packobj->Update){
			if($packobj->TestFile && $regpackobj->Valid){
				
				#check update
			
				my $fullpath;

				my $testfile;

				if(exists ${%$regpackobj}{'TestFile'} and $regpackobj->TestFile =~ /\S/){
					$fullpath=${%{$packobj->MainPath}}{'value'}.'/'.$regpackobj->TestFile;	
					$testfile = $regpackobj->TestFile;
				}
				else{
					$fullpath=${%{$packobj->MainPath}}{'value'}.'/'.$packobj->TestFile;
					$testfile = $packobj->TestFile;
					unless($^O =~ /mswin/i or -f $fullpath){
						if($packobj->TestFile =~ /^lib\//){
							if($packobj->TestFile !~ /\/lib64\//){
								my $new_file = $packobj->TestFile;
								$new_file =~ s/^lib\//lib\/lib64\//;
								my $new_path = ${%{$packobj->MainPath}}{'value'}.'/'.$new_file;
								if(-f $new_path){
									$fullpath = $new_path;
									$testfile = $new_file;  
								}	
							}
							else{
								my $new_file = $packobj->TestFile;
								$new_file =~ s/lib64\///;
								my $new_path = ${%{$packobj->MainPath}}{'value'}.'/'.$new_file;
								if(-f $new_path){
									$fullpath = $new_path;
									$testfile = $new_file;  
								} 
							}
						}
					}
				}
				
				if(-f $fullpath){
				
					#check if same package already installed
				
					if(release2num($packobj->Version) == release2num($regpackobj->Version) and 
									defined $packobj->CheckSum and defined $regpackobj->CheckSum){
						if($packobj->CheckSum eq $regpackobj->CheckSum){
							print2stdout("same package already installed\n");
							print2stdout("checking consistence of package data in install registry...\n");
							
							my %result = SAPDB::Install::InstallRegistry::Verify::checkPackage(\$regpackobj,1);
							if($result{'status'}){
								$packobj->RegData($regpackobj);
								$packobj->Skip(\1);
							}
							else{
								print2stdout("installed package is corrupted and has to be installed again\n");
							}
						}	
					}
					
					unless(${$packobj->Skip}){
					
						# 1. version
								
						my $rc = compareReleases($fullpath,$packobj->Version,$packobj->MinVersion);
					
						# min release to update not reached -> fatal error because of possible dependencies
						defined $rc or print2stderr("release file check failed - cannot update\n") and diesoft($SAPDB::Install::Values::diemsg);
					
						# newer package installed -> skip package, dependencies should be solved
						if($rc == 0){
							print2stderr("cannot downgrade package\n");
							if($packobj->AllowSkip){
								$packobj->Skip(\1);
							}
							else{
								diesoft($SAPDB::Install::Values::diemsg);	
							}
						}
						else{
							print2stdout("update release check... ok\n");
						}			
					
					
						# 2. what string
						if($packobj->MagicMode and !${$packobj->Skip}){
							$packobj->MagicString or print2stderr("no magic to test\n") and diesoft($diemsg);
							unless(compareMagics($packobj->MagicString,${%{$packobj->MainPath}}{'value'},$testfile,$packobj->MagicMode)){
								print2stderr("magic check failed\n");
								if($packobj->AllowSkip){
									$packobj->Skip(\1);
								}
								else{
									diesoft($SAPDB::Install::Values::diemsg);	
								}
							}
							print2stdout("update binary magic check... ok\n");
						}
					}
				}
				else{
					print2stderr("cannot do update check - test file \"$fullpath\" not found \n");
					diesoft($SAPDB::Install::Values::diemsg);
				}
			
			}
			elsif($regpackobj->Valid){
				
				#
				# no testfile defined - do version check with already known values
				#		
			
				if(release2num($packobj->MinVersion) < release2num($regpackobj->Version)){
					if(release2num($packobj->Version) < release2num($regpackobj->Version)){
						print2stderr("cannot downgrade package\n");
						if($packobj->AllowSkip){
							$packobj->Skip(\1);
						}
						else{
							diesoft($SAPDB::Install::Values::diemsg);	
						}
					}
					else{
						print2stdout("update release check... ok\n");
					}				
				}
				else{
					print2stderr("needed minimal version (".$packobj->MinVersion.") of installed package (".$regpackobj->Version.") not reached\n");
					diesoft($SAPDB::Install::Values::diemsg);	
				}

				#
				# object mode check 
				#
				
				if(not ${$packobj->Skip} and defined $packobj->MagicMode  and defined $packobj->Mode and
				   defined $regpackobj->Mode and $packobj->MagicMode !~ /NOBIT/){
					if($packobj->MagicMode =~ /32to64/i){
						if($packobj->Mode == 32 && $regpackobj->Mode == 64){
							print2stderr("object mode check... failed\n");
							diesoft($SAPDB::Install::Values::diemsg);
						}
						else{
							print2stdout("object mode check... ok\n");
						}
					}
					elsif($packobj->MagicMode =~ /64to32/i){
						if($packobj->Mode == 64 && $regpackobj->Mode == 32){
							print2stderr("object mode check... failed\n");
							diesoft($SAPDB::Install::Values::diemsg);
						}
						else{
							print2stdout("object mode check... ok\n");
						}
					}
					elsif($packobj->MagicMode =~ /equal/i){
						if($packobj->Mode != $regpackobj->Mode){
							print2stderr("object mode check... failed\n");
							diesoft($SAPDB::Install::Values::diemsg);
						}
						else{
							print2stdout("object mode check... ok\n");
						}
					}
					else{
						print2stdout("object mode check... not specified\n");
					}			
				}
			}



			${$packobj->Skip} and print2stdout("skipping package\n") and next;
			
						

			# get user / group info
			unless($^O=~/mswin/i && $packobj->IsSubPackage){
				if($packobj->Type eq 'PATCH'){
					unless($^O=~/mswin/i){
						$packobj->User($regpackobj->User);
						my $uid = (getpwnam($regpackobj->User))[2];
						$uid or print2stderr("cannot get uid of user \"$regpackobj->User\"\n") and diesoft($SAPDB::Install::Values::diemsg);
						$packobj->UID($uid);
						$packobj->Group($regpackobj->Group);
						my $gid = (getgrnam($regpackobj->Group))[2];
						$gid or print2stderr("cannot get gid of group \"$regpackobj->Group\"\n") and diesoft($SAPDB::Install::Values::diemsg);
						$packobj->GID($gid);
					}
				}
				else{
					
 					# reset user and group while updating from < 7.5 to >= 7.5
 					if (
 					$packobj->Name eq 'Base' &&
 					release2num($packobj->Version) >= release2num('7.5.0.0') &&
 					release2num($regpackobj->Version) < release2num('7.5.0.0')) {
 						$regpackobj->Group('');
 						$regpackobj->User('');
 					}

					# if no user/group info in registry set package default
					$regpackobj->Group or $regpackobj->Group($packobj->Group); 
					$regpackobj->User or $regpackobj->User($packobj->User);
					unless($packobj->IsSubPackage){
						checkGroup($regpackobj->Group,$packobj,$opt_g,$opt_b || $opt_batch);
						checkOwner($regpackobj->User,$packobj,$opt_o,$opt_b || $opt_batch);
					}
					# ask only once for owner/group - for first package (now all packages get same owner/group)
					unless($opt_diff_owner_group){
						$opt_g=$packobj->Group;
						$opt_o=$packobj->User;
					}
				}
								
			}
			foreach my $hrPath (@{$packobj->Paths}){
				local *hPath=$hrPath;
				my $opt=$hPath{'opt'};
                $opt=~s/=.*$//g;
				if($hPath{'value'}){
					if($opt){
						if(expandPath(${"opt_$opt"}) ne $hPath{'value'} and ${"opt_$opt"} =~ /\S/){
							$log->SetMsg("WRN: ignore commandline option \"$opt\" for \"".$hPath{'name'}.'" = "'.${"opt_$opt"}."\" - not changeable\n");
						}
					}
					next;
				}
			 }
		}
		else{
			# get pathes
			unless($^O=~/mswin/i){
				unless($packobj->IsSubPackage){
					checkGroup($packobj->Group,$packobj,$opt_g,$opt_b || $opt_batch);
					checkOwner($packobj->User,$packobj,$opt_o,$opt_b || $opt_batch);
				}
				# ask only once for owner/group - for first package (now all packages get same owner/group) 
				unless($opt_diff_owner_group){
					$opt_g=$packobj->Group;
					$opt_o=$packobj->User;
				}
			}
			foreach my $hrPath (@{$packobj->Paths}){
				local *hPath=$hrPath;
				my $opt=$hPath{'opt'};
                $opt=~s/=.*$//g;
				if($hPath{'value'}){
					if($opt){
						if(expandPath(${"opt_$opt"}) ne $hPath{'value'} and ${"opt_$opt"} =~ /\S/){
							$log->SetMsg("WRN: ignore commandline option \"$opt\" for \"".$hPath{'name'}.'" = "'.${"opt_$opt"}."\" - not changeable\n");
						}
					}
					next;
				} 
				
				my $new_path = getPath($hPath{'name'},$hPath{'default'},${"opt_$opt"},$opt_b || $opt_batch);
				normalizePath(\$new_path);
				$hPath{'value'}=$new_path;
				
								
				unless(defined $instRegistry){
					# SAP DB free machine -> create Install Registry
					if($hPath{'name'} eq 'independent data path'){
						makedir($hPath{'value'}."/config",0775,$packobj->UID,$packobj->GID) or print2stderr("cannot create directory $hPath{'name'} \"$hPath{'value'}/config\"") and diesoft($SAPDB::Install::Values::diemsg);
						makedir($hPath{'value'}."/config/install",0750,0,$packobj->GID) or print2stderr("cannot create directory $hPath{'name'} \"$hPath{'value'}/config/install\"") and diesoft($SAPDB::Install::Values::diemsg);
						$instRegistry=SAPDB::Install::InstallRegistry->new($hPath{'value'}."/config/install",1,$log);
						migrateReg($instRegistry,@packageref);
					}
					if($hPath{'name'} eq 'independent program path'){
						setPathInEnv("$hPath{value}/bin");
						setPathInEnv("$hPath{value}/pgm") if ($^O =~ /mswin/);
					}
					
                }

			}
			defined $regpackobj or $regpackobj=$instRegistry->newPackage($packobj->Name,${%{$packobj->MainPath}}{'value'},1);
		}

				
		
		defined $regpackobj and $packobj->RegData($regpackobj);
		
	
		do{
			my @pathes;
			my @newpathes;
			foreach my $path (@{$packobj->Paths}){
				my $found=0;
				defined $regpackobj->Pathes or @pathes=@{$packobj->Paths} and last;
				foreach my $regpath (@{$regpackobj->Pathes}){
					if (${%$regpath}{'name'} eq ${%$path}{'name'}){
						push @pathes,$regpath;
						$found=1;
						last;
					}		
				}
				$found or push @newpathes,$path;
			}	
			foreach my $newpath (@newpathes){
				local *path = $newpath;
				my $opt=$path{'opt'};
                $opt=~s/=.*$//g;
				if($path{'value'}){
					if($opt){
						if(expandPath(${"opt_$opt"}) ne $path{'value'}){
							$log->SetMsg("WRN: ignore commandline option \"$opt\" for \"".$path{'name'}.'" = "'.${"opt_$opt"}."\" - not changeable\n");
						}
					}
					next;
				} 
				my $new_path = getPath($path{'name'},$path{'default'},${"opt_$opt"},$opt_b || $opt_batch);
				normalizePath(\$new_path);
				$path{'value'} = $new_path;
			}
			$packobj->Paths(\@pathes);
			
			#
			# check possible file conficts with other packages
			#
			
			print2stdout("checking interferences to other packages... ");
			
			
			my @new_files = ();
			my @remove_later; 
			
			if($packobj->Update){
				if($^O =~ /mswin/i){
					#
					# normalize file names in case of win os
					#
			
					my @norm_new_list;
					my @norm_old_list;
			
					foreach my $file (keys(%{$packobj->FileList})){
						push @norm_new_list,normalizePath($file);
					}
					foreach my $file (keys(%{$regpackobj->FileList})){
						push @norm_old_list,normalizePath($file);
					}
					@new_files = minus(\@norm_new_list,\@norm_old_list);		
					unless($packobj->Type eq 'PATCH'){
						@remove_later = minus(\@norm_old_list,\@norm_new_list);
					}
				}
				else{
					@new_files = minus([keys(%{$packobj->FileList})],[keys(%{$regpackobj->FileList})]);
					unless($packobj->Type eq 'PATCH'){
						@remove_later = minus([keys(%{$regpackobj->FileList})],[keys(%{$packobj->FileList})]);
					}
				}
			}
			else{
				@new_files = keys(%{$packobj->FileList});
			}
		
			my %check_result = $instRegistry->CheckFilesOfNewPackage($packobj->Name,${%{$packobj->MainPath}}{'value'},\@new_files);	
			
			unless($check_result{'state'}){
				print2stdout("failed\n\n");
				print2stderr("there are conflicts with installed packages:\n");
				foreach my $file (keys(%{$check_result{'conflict_files'}})){
					print2stderr("$file is used by ".${@{${%{$check_result{'conflict_files'}}}{$file}}}[0].
								' ['.${@{${%{$check_result{'conflict_files'}}}{$file}}}[1]."]\n");
				}
				diesoft($diemsg); 			
			}
						
			print2stdout("ok\n\n");

			if($#remove_later > -1){
				$instRegistry->RemoveFromAllFiles(${%{$packobj->MainPath}}{'value'},\@remove_later);
			}
			
			
			print2stdout("collecting data finished:\n\n");
			foreach my $pathref (@paths){
					my %path=%$pathref;
					print2stdout("$path{'name'}: $path{'value'}\n");	
			}
			unless($^O=~/.*mswin.*/i){
				print2stdout("owner: ".$packobj->User."\n");
				print2stdout("group: ".$packobj->Group."\n");
			}
			if(0 && !$opt_b && !$opt_INSTANCE){								#disable 01.02.2001
				print2stdout("install \"".$packobj->DispName."\" (y/n)? ");
				$_=readstdin();
			}
			
			#if(/^n.*$/i){
			#	print2stdout("skip package \"".$packobj->DispName."\" (y/n)? ");
			#	$_=readstdin();
			#	/^y$/i and $packobj->Skip(\1);
			#}
			
			if(/^n.*$/i){
				print2stdout("abort installation (y/n)? ");
				$_=readstdin();
				/^y$/i and diesoft("installation aborted");
			}
		}until(1 || /^y$/i || $opt_b || $opt_batch || $opt_INSTANCE); #disable 01.02.2001		
				
		$regpackobj or $regpackobj=$instRegistry->newPackage($packobj->Name,${%{$packobj->MainPath}}{'value'},1);
		$packobj->RegData($regpackobj);
		
		${$packobj->Skip} and print2stdout("skipping package\n") and next;

		
		# create directories
		foreach my $pathref (@paths){
			my %path=%$pathref;
			-d $path{'value'} && next;
			makedir("$path{'value'}",($path{'mode'} > 0 and $path{'mode'} < 0777) ? $path{'mode'} : 0555, $packobj->UID,$packobj->GID) or print2stderr("cannot create directory $path{'name'} \"$path{'value'}\"") and diesoft($SAPDB::Install::Values::diemsg);
		}

		if($^O=~/.*aix.*/i){
			#on aix shared libs may stay in memory after ending related processes
			#slibclean remove all unused shared objects 
			sub ignore_all_errors{
				my ($text)=@_;
				$log->SetMsg("MSG: SYS: slibclean: $text\n");
				return 1;
			}
			callsystem("slibclean",\&ignore_all_errors,1);
		}
		
		#tgz extraction testrun
		(local *fsinfos, my $mapped_files, my $busy_files ) = unpackTGZ($packobj,${%{$packobj->MainPath}}{'value'},1,keys(%{$packobj->FileList}));
		
		if($#{@$busy_files} > -1){
			my $ps = SAPDB::Install::ProcState->new();
			my %processes;
			my $found_one = 0;
			foreach my $file (@$busy_files){
				my $pids = $ps->WhoUsesModule($file);
				if(defined $pids){
					foreach my $pid (@$pids){
						foreach my $proc (@{$ps->{'procs'}}){
							if($proc->{'pid'} == $pid){
								$found_one = 1;
								$processes{$pid} = $proc->{'cmd'}; 	
							}
						}
					}
				}

			}
			if($found_one){
				print2stdout("following programs are running: \n");
				foreach my $pid (keys(%processes)){
					print2stdout($processes{$pid}." [pid = $pid]\n");		
				}
				print2stderr("please stop all!\n");
			}
			else{
				print2stderr("test extraction failed\n");
			}
			diesoft($SAPDB::Install::Values::diemsg);
		}

		if($^O =~ /mswin/i and defined $mapped_files and $#{@$mapped_files} > -1){
			$packobj->MappedFiles($mapped_files);
		}
		
		# collect file system infos needed by space check
		foreach my $hrFSInfo (@fsinfos){
			my %hFSInfo = %$hrFSInfo;
			if(exists $hFileSystemInfo{$hFSInfo{'FSNAME'}}){
				$hFileSystemInfo{$hFSInfo{'FSNAME'}} = { 
						'AVAIL' => $hFSInfo{'AVAIL'},
						'NEEDED' => ($hFSInfo{'NEEDED'} + ${%{$hFileSystemInfo{$hFSInfo{'FSNAME'}}}}{'NEEDED'}),
						'USED' => ($hFSInfo{'USED'} + ${%{$hFileSystemInfo{$hFSInfo{'FSNAME'}}}}{'USED'})
					 };
			}
			else{
				$hFileSystemInfo{$hFSInfo{'FSNAME'}} = { 
							'AVAIL' => $hFSInfo{'AVAIL'} ,
							'NEEDED' => $hFSInfo{'NEEDED'},
							'USED' => $hFSInfo{'USED'}
					};
			} 	
		}
		
		
		if(defined $packobj->postprepare){
			eval{
				&{$packobj->postprepare};
			}; $@ and print2stderr("error in postprepare(): $@\n") and diesoft($diemsg);
		}
		
		print2stdout("\npackage ".$packobj->DispName." successfully checked\n\n\n");
	}

	
	
	# do space check
	my $space_ok = 1;
	foreach my $fsname (keys(%hFileSystemInfo)){
		if(${%{$hFileSystemInfo{$fsname}}}{'AVAIL'} > (${%{$hFileSystemInfo{$fsname}}}{'NEEDED'} - ${%{$hFileSystemInfo{$fsname}}}{'USED'})){
			print2stdout("checking filesystem \"$fsname\"... free disk space ok\n");
			$log->SetMsg("MSG: available = ".${%{$hFileSystemInfo{$fsname}}}{'AVAIL'}." kb\n");	
			$log->SetMsg("MSG: needed = ".(${%{$hFileSystemInfo{$fsname}}}{'NEEDED'} - ${%{$hFileSystemInfo{$fsname}}}{'USED'})." kb\n");
		}
		else{
			print2stderr("checking filesystem \"$fsname\"... not enough free disk space \n");	
			print2stdout("\tneeded = ".(${%{$hFileSystemInfo{$fsname}}}{'NEEDED'} - ${%{$hFileSystemInfo{$fsname}}}{'USED'})." kb\n");
			print2stdout("\tavailable = ".${%{$hFileSystemInfo{$fsname}}}{'AVAIL'}." kb\n");	
			$space_ok = 0;
		}
	}

	diesoft($diemsg) unless $space_ok;
	
		
	
	# after check phase its allowed to write into install registry file
	my $save_dirty = $instRegistry->dirty;
	$instRegistry->DenyWrite(0);
	$instRegistry->dirty(0) if $save_dirty == 0;
	
	$opt_INSTANCE && $instRegistry->setInstanceData($opt_d,{'SOFTWARE_OK' => 0});

	# real installalion phase -> unpack software & register it
	foreach my $packobj (@packageref){
		${$packobj->Skip} and next;
		$packobj->FlushIntoReg(1);
		my $regpackobj = $packobj->RegData;
		# write headline
		my $tmpstring='starting installation phase of package '.$packobj->DispName.' '.$packobj->Version;
		$tmpstring .= ' '.$packobj->Mode.' bit' if $packobj->Mode =~ /32|64/;
		my $strlen=length($tmpstring);
		print2stdout("\n$tmpstring\n");
		print2stdout("-"x$strlen."\n\n");
				
		# set package invalid
		$regpackobj->setValid(0);
		
		if($^O =~ /mswin/i and defined $packobj->MappedFiles){
			#
			#	WIN only: move mapped files
			#
			my @mapped_files = (); 
			foreach my $file (@{$packobj->MappedFiles}){
				push @mapped_files, ${%{$packobj->MainPath}}{'value'}.'/'.$file;
			}
			unless(killUsedFiles(@mapped_files)){
				print2stderr("unable to move mapped files - ". 
					"please terminate event viewer or other windows ".
					"management console tools to avoid mapped files\n");
				diesoft($diemsg);
			}
		}

		my $subpackobjs;

		if($packobj->Update){
			if($packobj->Type eq 'PATCH'){
				patch($packobj);
			}
			else{
				$subpackobjs = update($packobj);
			}
		}
		else{
			newinstall($packobj);
		}
		if(defined $packobj->postinstall){
			eval{
				&{$packobj->postinstall};
			}; $@ and print2stderr("error in postinstall(): $@\n") and diesoft($diemsg);
		}
		if(defined $packobj->register){
			eval{
				&{$packobj->register};
			}; $@ and print2stderr("error in register(): $@\n") and diesoft($diemsg);
		}

		$regpackobj->genFileInfos();

		#$packobj->freeSELFOBJ; # give garbage collection a chance
		$regpackobj->setValid(1);
		
		if(defined $subpackobjs){
			local *subs = $subpackobjs;
			foreach my $subpack (@subs){
				if(defined $$subpack->register){
					$$subpack->Registry->Log->SetMsg("register subpackage ".$$subpack->Name."\n");
					eval{
						&{$$subpack->register};
					}; $@ and print2stderr("WRN: error in register() of subpackage \"".$$subpack->Name."\": $@\n");
				}
				$$subpack->setValid(1);	
			}	
		}
	}

	print2stdout("installation of $product finished successfully ".timeStamp()."\n");
	$opt_INSTANCE && $instRegistry->setInstanceData($opt_d,{'SOFTWARE_OK' => 1});
	
	}
	
	if($instRegistry->DenyWrite == 1){
		# after check phase its allowed to write into install registry file
		my $save_dirty = $instRegistry->dirty;
		$instRegistry->DenyWrite(0);
		$instRegistry->dirty(0) if $save_dirty == 0;
	}
	
	
	
	# call frame end functions
	foreach my $packobj (@packageref){
		if(defined $packobj->framestop){
			eval{
				&{$packobj->framestop};
			}; $@ and print2stderr("error in framestop(): $@\n") and diesoft($diemsg);
		}
	}
	
	if($SAPDB::Install::Config{'HasOwnConsole'} and !$opt_b){
		print2stdout("\npress any key...");
		SAPDB::Install::Term::ReadKey::ReadMode('raw');
		SAPDB::Install::Term::ReadKey::ReadKey();
	}

	
	return 0;	
}

1;
