#!/usr/bin/perl
#
# $Header: //sapdb/V75/c_00/b_44/sys/src/install56/perl/SAPDB/Install/Instance/Upgrade.pm#1 $
# $DateTime: 2007/04/10 17:59:46 $
# $Change: 149411 $
#
#    ========== licence begin  GPL
#    Copyright (c) 2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end


package SAPDB::Install::Instance::Upgrade;

#
# usually these function are called in
# the pre- or postinstall step of SDBUPD
#
sub BEGIN {
	@ISA = ('SAPDB::Install::Exporter');
	@EXPORT = ();
	my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages = (
		'Instance::Base',
		'Instance::Check',
		'Instance::Operate',
		'Instance::ChVolPerm',
		'Tools'
	);

	foreach my $package (@neededPackages) {
	  	unless (
		defined $repo->Eval ("SAPDB::Install::$package", 1.01)) {
			print join ("\n", $repo->GetErr)."\n";
			die;
		}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package");
	} 
}

push @ISA,
	'SAPDB::Install::Instance::Base',
	'SAPDB::Install::Instance::Check',
	'SAPDB::Install::Instance::Operate'; 

#
# prepare ()
#
sub prepare {
	my ($self) = @_;

	$self->{keep_instance_data} = 1;

	my $count_max = 3;
	for (my $count = $count_max; $count > 0; $count--) {
		#
		# stop instance if all checks are passed 
		#
		if ($self->do_anycheck () == 0) {
			return 0;
		}

		my $state = $self->get_errorstate ();
		if ($state eq 'ERROR') {
			return -1;
		}

		$self->msgbegin ("preparing instance upgrade");
		$self->set_errorstate ('ERROR');

		if ($state eq 'OFFLINE_RESTART_REQUIRED') {
			my $rc =
			$self->switchto ('OFFLINE', "switch to offline\n");
			unless ($rc eq 'OFFLINE') {
				$self->msgend ();
				return -1;
			}
 
			if ($self->{'can_db_online'}) {
				$rc =
				$self->switchto ('ONLINE',"switch to online\n");
			} else {
				$rc =
				$self->switchto ('WARM',"switch to warm\n");
			}

			unless ($rc =~ /WARM|ONLINE/) {
				$self->get_errmsg_from_knldiag ();
				$self->msgend ();
				return -1;
			}

			next;
		}

		if ($state eq 'RESTART_SHUTDOWN_REQUIRED') {
			my $current = $self->{dbm}->db_state ();

			my $rc;
			if ($self->{'can_db_online'}) {
				$rc =
				$self->switchto ('ONLINE',"switch to online\n");
			} else {
				$rc =
				$self->switchto ('WARM',"switch to warm\n");
			}

			unless ($rc =~ /WARM|ONLINE/) {
				$self->get_errmsg_from_knldiag ();
				$self->msgend ();
				return -1;
			}

			$rc = $self->switchto ($current, 
			      "switch to ".$current."\n");
			unless ($rc eq $current) {
				$self->msgend ();
				return -1;
			}
			next;
		}
	}

	#
	# more then count_max loops without success
	#
	$self->msg1 ("performed more then ".$count_max.
	             " instance checks without success\n");
	$self->msgend ();
	return -1;
}

#
# finalize ()
#
sub finalize {
	my ($self) = @_;

	$self->{keep_instance_data} = 1;

	#
	# first of all do a db_register
	# for new installed server software
	#
	my $dbm = $self->{dbm};
	my $rc = $dbm->db_register ();
	unless (defined $rc && $rc eq 'OK') {
		$self->set_errorstate ('ERROR');
		$self->msgbegin ("registering database instance");
		$self->msg1 ($dbm->lastdialog ());
		$self->msgend ();
		return (-1);
	}

	$self->do_finalizecheck ();
	my $state = $self->get_errorstate ();
	unless (defined $state && $state ne 'ERROR') {
		$self->set_errorstate ('ERROR');
		return -1;
	}

	if ($state eq 'INIT_FOR_RECOVERY_REQUIRED') {
		#
		# we need a migration backup
		# migration backup was not already restored
		# prepare db instance complete recovery
		#
		$self->initialize_for_recovery ();
		$state = $self->get_errorstate ();
		unless (defined $state && $state eq 'OK') {
			$self->set_errorstate ('ERROR');
			return -1;
		}

		#
		# stop here to restore migration backup
		#		
		$self->msgbegin ("finalizing instance update");
		$self->msg0 ("\n");
		$self->msg0 (
		"restore migration backup and start SDBUPD ".
		"for instance ".$self->{dbname}." again\n");
		$self->msg0 ("\n");

		$self->set_errorstate ('OK');
		$self->msgend ();
		return 0;
	}

	if ($state eq 'INIT_FOR_REPORT_REQUIRED') {
		$self->initialize_for_report ();
		my $state = $self->get_errorstate ();
		unless (defined $state && $state eq 'OK') {
			$self->set_errorstate ('ERROR');
			return -1;
		}

		#
		# get encoding of livecache schema
		#
		# default is '', that means 'lcinit init' w/o any args
		#
		# if we come from apo 3.xx and
		# we are going to apo 4.xx, the encoding is ascii
		# because apo 3.xx is always ascii
		#
		my $encoding = '';
		if (
		$self->{'apo_starting_release'} =~ /^3\./ &&
		$self->{'apo_target_release'} =~ /^4\./) {
			$encoding = 'ascii';
		};

		#
		# do an exec_lcinit init
		# to migrate user profile container during activate
		#
		my $arg;
		$self->msgbegin ("setting up liveCache");
		if ($encoding eq 'ascii') {
			$self->msg0 ("setting up ascii liveCache...\n");
			$arg = 'init -e ascii';
		} elsif ($encoding eq 'unicode') {
			$self->msg0 ("setting up unicode liveCache...\n");
			$arg = 'init -e unicode';
		} else {
			$self->msg0 ("setting up liveCache...\n");
			$arg = 'init';
		}

		my $rc = $dbm->exec_lcinit ($arg);
		unless (defined $rc && $rc eq 'OK') {
			$self->set_errorstate ('ERROR');
			$self->msg1 ("setting up liveCache failed\n");
			$self->msg1 ($dbm->lastdialog ());
			$self->msgend ();
			return (-1);
		}
		$self->msgend ();
	}

	if ($state eq 'EXEC_MIGRATE_DATABASE_REQUIRED') {
		$self->exec_migrate_database ();

		my $state = $self->get_errorstate ();
		unless (defined $state && $state eq 'OK') {
			$self->set_errorstate ('ERROR');
			return -1;
		}
	}

	#
	# restart db instance
	# and load system tables if possible
	#
	unless ($state eq 'INIT_FOR_REPORT_REQUIRED') {
		$self->restart ();
		$state = $self->get_errorstate ();
		unless (defined $state && $state eq 'OK') {
			$self->set_errorstate ('ERROR');
			return -1;
		}
	}

	#
	# migrate catalog to unicode  for OLTP instances
	# during migration from 7.3 to 7.4.03 and higher or
	# from 7.3 to 7.5 and higher
	#
	my $target_release = $self->{target_release};
	
	if ($target_release =~ /^\d+\.\d+\.\d+$/){
		$target_release .= '.00';
	}
	
	if (
	$self->{'instancetype'} eq 'OLTP' &&
	release2num ($target_release) >= release2num ('7.4.03.00') && 
	$self->is_release_change ()) {
	
		$self->migrate_catalog_to_unicode ();
		$state = $self->get_errorstate ();
		unless (defined $state && $state eq 'OK') {
			$self->set_errorstate ('ERROR');
			return -1;
		}
	}

	#
	# switch livecaches back to offline
	#
	if ($self->{'instancetype'} eq 'LVC') {
		my $rc =
		$self->switchto ('OFFLINE', "switch to offline\n");
		unless ($rc eq 'OFFLINE') {
			$self->set_errorstate ('ERROR');
			$self->msgend ();
			return -1;
		}
	}

	$self->{keep_instance_data} = 0;
	return 0;
}

1;
