#!/usr/bin/perl
#
# $Header: //sapdb/V75/c_00/develop/sys/src/install/perl/SAPDB/Install/Instance/Check/Finalize.pm#3 $
# $DateTime: 2003/12/11 13:40:27 $
# $Change: 59245 $
#
#    ========== licence begin  GPL
#    Copyright (c) 2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end


package SAPDB::Install::Instance::Check::Finalize;

sub BEGIN {
	@ISA = ('SAPDB::Install::Exporter');
	@EXPORT = ();
	my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages = (
		'Instance::Base',
		'Instance::Check::Common',
		'Instance::Check::Conditions',
		'Instance::Check::Finalize::Generic',
		'Instance::Check::Finalize::ConData',
		'Instance::Check::Finalize::ExternalBackup',
		'Instance::Check::Finalize::ExtLVCCons'
	);

	foreach my $package (@neededPackages) {
	  	unless (defined $repo->Eval 
		("SAPDB::Install::$package", 1.01)) {
                	print join ("\n", $repo->GetErr)."\n";
                	die;
        	}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package");
	  } 
}

push @ISA, 
	'SAPDB::Install::Instance::Base',
	'SAPDB::Install::Instance::Check::Common',
	'SAPDB::Install::Instance::Check::Conditions';

#
# run any neccessary finalize check
# it depends on migration strategy
#
sub finalizecheck {
	my ($self) = @_; 

	#
	# find out instance type if not already known
	#
	unless (defined $self->{'instancetype'}) {
		my $rc = $self->conditions ();
		unless (defined $rc && $rc == 0) {
			$self->set_errorstate ('ERROR');
			return undef;
		}
	}

	$self->msgbegin ("running finalize check");
	$self->msg0 ("running finalize check...\n");

	my $migration_strategy = $self->{migration_strategy};
	unless (defined $migration_strategy && $migration_strategy ne 'NONE') {
		$self->msg0 ("unknown migration strategy\n");
		$self->msgend ();
		$self->set_errorstate ('ERROR');
		return undef;
	}
	
	#
	# find required check method
	# 	
	my $class = 'SAPDB::Install::Instance::Check::Finalize::';
	if ($migration_strategy eq 'EXTERNAL_CONSISTENT_BACKUP') {
		$class .= 'ExternalBackup';
	} elsif ($migration_strategy eq 'EXTERNAL_LIVECACHE_CONSISTENCE') {
		$class .= 'ExtLVCCons';
	} elsif ($migration_strategy eq 'CONSISTENT_DATA') {
		$class .= 'ConData';
	} else {
		$class .= 'Generic';
	}

	# save prev class before setting new class
	my ($prev) = ref ($self);

	bless ($self, $class);
	my $rc = $self->finalizecheck ();

	# restore prev class before returning
	bless ($self, $prev);
	return $rc;
}

1;
