#!/usr/bin/perl
#
# $Header: //sapdb/V75/c_00/develop/sys/src/install/perl/SAPDB/Install/InstallRegistry/Package.pm#3 $
# $DateTime: 2003/12/11 13:40:27 $
# $Change: 59245 $
#
# Desc: 
#    ========== licence begin  GPL
#    Copyright (c) 2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end


package SAPDB::Install::InstallRegistry::Package;

$VERSION = 1.01;

sub BEGIN {
    my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages=(
		'Base',
		'StdIO',
		'Registry',
		'MD5Sum',
		'Trace'
	);
	@EXPORT=('main');
	foreach my $package (@neededPackages){
	  	unless (defined $repo->Eval ("SAPDB::Install::$package", 1.01)) {
                print join ("\n", $repo->GetErr)."\n";
                die;
        	}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package"); 
	}
	@ISA=qw(SAPDB::Install::Base);
	
}

my $id=0;

# members of class 
my %members=(
	ID => undef,
	Name => undef,
	DispName => undef,
	Path => undef,
	Version => undef,
	Script => undef,
	Mode => undef,
	Profiles => undef,
	FileList => undef,
	FileInfos => undef,
	User => undef,
	Group => undef,
	Pathes => undef,
	Extra => undef,
	refData => undef,
	Registry => undef,
	PackageVersion => undef,
	Require => undef,
	Profiles => undef,
	Valid => 0,
	Date => undef,
	IsSubPackage => undef,
	SubPackages => undef,
	TestFile => undef,
	ParentPackage => undef,
	register => undef,
	unregister => undef,
	preuninstall => undef,
	postuninstall => undef,
	verify => undef,
    CheckSum => undef, 
	dirty => 0, 
	evaled => 0

);


unless ($^O =~ /mswin/i){
	$members{'UID'} = undef;
}




@SELFOBJ; # global package variable to set a self instance in to eval script (view sub evalScript) 


sub new{
	my ($type,$registry,$packagename,$packagepath,$hashRefData,$noSELFOBJ) = @_;
	if ($id == 0){
		my $level = 0;
		my $found_cleaner = 0;
		while(1){
			my @all_info_caller_package = (caller($level));
			$#all_info_caller_package == -1  and last;
			$level++;
			my $package = $all_info_caller_package[0];
			if(defined ${"${package}::cleaner"} and	ref(${"${package}::cleaner"}) eq 'SAPDB::Install::Cleaner'){ 
				TraceMsg("found cleaner object \$${package}::cleaner\n",3,\$DEBUG);
				${"${package}::cleaner"}->SetRef(\@SELFOBJ);
				$found_cleaner = 1;
				last;
			}
		}
		
		unless($found_cleaner or $registry->ReadOnly){
			print2stderr("WRN: no cleaner object of type SAPDB::Install::Cleaner found - possible installation data loss\n");
		}
	}
	my $self= SAPDB::Install::Base->new;
	foreach my $key (keys(%members)){
		$self->{$key}=$members{$key};
	}
	$self = bless $self,$type;
	$self->SubPackages([]);
	$self->Name($packagename);
	$self->Path($packagepath);
	$self->refData($hashRefData);
	my %packagedata=%$hashRefData;
	foreach my $varname ('Version','ParentPackage','IsSubPackage','SubPackages','Script',
						'Profiles','Require','FileList','FileInfos','User','Group','Pathes','Extra',
						'Valid','Date','Mode','PackageVersion','CheckSum','DispName','TestFile'){
		exists $packagedata{$varname} and $self->$varname($packagedata{$varname});
	}
	
	unless($self->DispName =~ /\S/){
		$self->DispName($self->Name);
	}


	unless($^O =~ /mswin/i){
		$self->UID(getpwnam($self->User));
	}

	$self->Registry($registry);
	unless($noSELFOBJ == 1){
		$self->ID($id++);
		$self->dirty(0);
		$SELFOBJ[$self->ID]=$self; # global package variable to set a self instance in temporary (to eval) package 
	}
	return $self;
}


sub evalScript{
	my ($self)=@_;
	if($self->evaled){
		$self->Registry->Log->SetMsg("MSG: script already evaled\n");
		return 0;
	}
	if($self->Script){
		my $save_dirty = $self->dirty;
		$self->evaled(1);
		my $newpackagename='SAPDB::Install::Uninst'.$self->ID;
		my $script="package $packagename;\n".$self->Script;
		sub getPerlPackageName{
			my ($package,$filename,$line)=caller;
			return $package;
		}
		my $packagename=getPerlPackageName();	
		my $varname='SELFOBJ['.$self->ID.']';
		my $script= "package $newpackagename;\n".${$self->Script};
		$script=~s/\$regpackobj|\$packobj/\$$packagename\::$varname/g;
		#if($DEBUG){
		#	my @text= split("\n",$script);
		#	my $linecount=1;
		#	foreach my $line (@text){
		#		print2stdout("$linecount: $line\n");
		#		$linecount++;
		#	}
		#}
		defined(%{"${newpackagename}::"}) and $self->Registry->Log->SetMsg("WRN: generated package exists in mem - now overwrite it\n");
		eval($script) or print2stderr("Package ".$self->DispName.": cannot eval script - $@\n");# and diesoft("$SAPDB::Install::Values::diemsg");
		foreach my $func ('register','unregister','preuninstall','postuninstall','verify'){
			if(defined &{"${newpackagename}::$func"}){
				$self->Registry->Log->SetMsg("MSG: set function reference \"$func\" in package ".$self->DispName."\n");
				$self->$func(\&{"${newpackagename}::$func"});
			}
			else{
				$self->Registry->Log->SetMsg("MSG: no function \"$func\" in package ".$self->DispName."\n");
			}
			
		}
		$self->dirty(0) unless $save_dirty;
		
		
		#
		#	register functions use $main_path which is only defined during installation time
		#	set it here, so register function can be used by now with registry package object	
		#			
		local *mainpath = ${"${newpackagename}::main_path"}; 	
		$mainpath{'value'} = $self->Path;
	}
	else{
		$self->Registry->Log->SetMsg("MSG: no registered script for package ".$self->DispName." found\n");
		return 0;
	}
	return 1;
}


sub mergeList{
	my ($self,%list)=@_;
	#defined {$self->FileList} or $self->Registry->Log->SetMsg("MSG: cannot merge list - no list in registry found\n") and return 0;
	local *hash_filelist=$self->FileList;
	foreach my $file (keys(%list)){
		$hash_filelist{$file} = $list{$file};
	}
	$self->dirty(1);
}


sub updateMd5Sum{
	my ($self,@files)=@_;
	defined {$self->FileList} or $self->Registry->Log->SetMsg("WRN: InstallRegistry::updateMd5Sum(): member FileList not set\n") and return 0;
	defined $self->Path or $self->Registry->Log->SetMsg("WRN: InstallRegistry::updateMd5Sum(): member Path not set\n") and return 0;
	local *hash_filelist=$self->FileList;
	foreach my $file (@files){
		my $fullname = $self->Path.'/'.$file;
		-f $fullname or $self->Registry->Log->SetMsg("WRN: InstallRegistry::updateMd5Sum(): file \"$fullname\" not found\n") and next;
		$hash_filelist{$file} = MD5Sum($fullname);
	}
	$self->dirty(1);
	#$self->setValues;
	#$self->Registry->dump;
}



sub updateFileInfos{
	my ($self,@files) = @_;
	$^O =~ /mswin/i and return 1;
	my %md5sums = %{$self->FileList};
	defined $self->FileInfos or $self->FileInfos({});
	local *infos = $self->FileInfos;
	foreach (@files){ 
		exists $md5sums{$_} or print2stderr("cannot update file infos: file \"$_\" not registered\n") and next;
		my $fullname = $self->Path.'/'.$_;
		my @statbuf = stat($fullname) or print2stderr("cannot stat file $fullpath: $!\n") and next; 	
		$infos{$md5sums{$_}} = {} unless (exists $infos{$md5sums{$_}});
		local *struct = $infos{$md5sums{$_}};
		$struct{'mode'} = $statbuf[2];
		$struct{'uid'} = $statbuf[4];
		$struct{'gid'} = $statbuf[5];
	}
	return 1;
}


sub genFileInfos{
	my ($self) = @_;
	$^O =~ /mswin/i and return 1;
	my %md5sums = %{$self->FileList};
	#first reset
	$self->FileInfos({});
	local *infos = $self->FileInfos;
	foreach my $file (keys(%md5sums)){
		my $fullname = 	$self->Path.'/'.$file;
		my @statbuf = stat($fullname) or print2stderr("cannot stat file $fullpath: $!\n") and next; 	
		$infos{$md5sums{$file}} = {};
		local *struct = $infos{$md5sums{$file}};
		$struct{'mode'} = $statbuf[2];
		$struct{'uid'} = $statbuf[4];
		$struct{'gid'} = $statbuf[5];
	}
	return 1;
}




sub setValid{
	my ($self,$value)=@_;
	if($value ne $self->Valid){
		$self->Valid($value);
		$self->dirty(1);
		$self->setValues;
		#print "########TEST: ".$self->Name." VALID=$value\n";
		$self->Registry->dump;
		#$self->dirty(0);
	}
}


sub compare_structs{
	my ($struct1,$struct2) = @_;
	#TraceMsg("compare $struct1 with $struct2\n",4,\$DEBUG);
	not defined $struct1 and not defined $struct2 and return 1; # both undefined -> equal 
	(defined $struct1 xor defined $struct2) and return 0; # one of both defined -> not equal
	ref($struct1) and ref($struct2) and ref($struct1) ne ref($struct2) and return 0; # different types -> not equal
	TraceMsg("is ".(ref($struct1) ? ref($struct1) : 'no reference')."\n",4,\$DEBUG);
	if(ref($struct1) eq 'REF'){
			my $rc = compare_structs($$struct1,$$struct2);
			if($rc){
				TraceMsg("REFs are equal\n",5,\$DEBUG);
			}
			else{
				TraceMsg("REFs are not equal\n",5,\$DEBUG); 
			}
			return $rc;
	}
	elsif(ref($struct1) eq 'ARRAY'){
		$#{@$struct1} == $#{@$struct2} or TraceMsg("ARRAY number of elements not equal\n",5,\$DEBUG) and return 0; 
		for (my $i=0;$i <= $#{@$struct1};$i++){
			compare_structs(${@$struct1}[$i],${@$struct2}[$i]) or TraceMsg("ARRAY element not equal\n",5,\$DEBUG) and return 0; 
			TraceMsg("ARRAY element equal\n",5,\$DEBUG);
		}
	}
	elsif(ref($struct1) eq 'HASH'){
		my @arr1 = keys(%$struct1);
		my @arr2 = keys(%$struct2);
		$#arr1 == $#arr2 or TraceMsg("HASH number of keys not equal\n",5,\$DEBUG) and return 0;
		foreach my $key (@arr1){
			exists ${%$struct2}{$key} or return 0;
			compare_structs(${%$struct1}{$key},${%$struct2}{$key}) or TraceMsg("HASH element not equal\n",5,\$DEBUG) and return 0;
			TraceMsg("HASH element equal\n",5,\$DEBUG); 	
		}
	}
	elsif(ref($struct1) eq 'GLOB'){
		return 1;
	}
	elsif(ref($struct1) eq 'CODE'){
		return 1;
	}
	elsif(ref($struct1) eq 'SCALAR'){
		return compare_structs($$struct1,$$struct2); 
	}
	elsif(not ref($struct1)){
		if($struct1 eq $struct2){
			TraceMsg("SCALAR values are equal\n",5,\$DEBUG);
		}
		else{
			TraceMsg("SCALAR values are not equal\n",5,\$DEBUG);
			return 0;
		}
	}
	else{
		return 1;
	}
	TraceMsg("structs are equal\n",5,\$DEBUG);
	return 1;
}




sub setValues{
	my ($self)=@_;
	$self->dirty or return undef;
	my $hashref=$self->refData;
	local *packagedata=$hashref;
	my @datamems = keys (%packagedata);
	if($#datamems == -1){
		TraceMsg("package already removed\n",3,\$DEBUG);
		return undef;	
	}
	
	foreach my $varname ('Version','Script','IsSubPackage','SubPackages','ParentPackage','DispName',
						'Profiles','Require','FileList','FileInfos','User','Group','Pathes','Extra','Valid',
						'Date','Mode','PackageVersion','CheckSum','TestFile'){
		
		
		#
		#	don't store DispName in install registry when its identical with it's real name 
		#
		
		if($varname eq 'DispName' and $self->DispName eq $self->Name){
			delete $packagedata{$varname} if exists $packagedata{$varname}; 
			next;
		}				
		
		if(exists ${%$self}{$varname}){
			TraceMsg("compare member $varname\n",5,\$DEBUG);
			if(compare_structs($packagedata{$varname},$self->{$varname})){
				TraceMsg("member $varname is equal\n",5,\$DEBUG);	
			}
			else{
				$self->Registry->InstRegLog->setEntry('PACKAGE_DATA',
					('package_name' => $self->Name,
						'package_path' => $self->Path,
						'value_name' => $varname,
						'value' => $self->{$varname}));
				$packagedata{$varname}=$self->{$varname};
				TraceMsg("set value of \"$varname\" in data struct\n",5,\$DEBUG);# and print "\n##########################\nset $varname\n#######################\n";
			}
		}
	}
		
		
	
	my ($sec,$min,$hour,$day,$mon,$year)=localtime(time);
	$year+=1900;
	$mon++;
	$day = "0$day" if length($day) == 1;
	$mon = "0$mon" if length($mon) == 1;
	my $date="$day.$mon.$year";
	$self->Date($date);
	if($packagedata{'Date'} ne $date){
		$self->Registry->InstRegLog->setEntry('PACKAGE_DATA',
					('package_name' => $self->Name,
						'package_path' => $self->Path,
						'value_name' => 'Date',
						'value' => $date));
		$packagedata{'Date'}=$date;
		TraceMsg("set value of \"Date\" in data struct\n",5,\$DEBUG);
	}
	$self->dirty and $self->Registry->dirty(1);
}

sub DESTROY{
	my $self=shift;
	if($self->dirty){
		$self->Registry->dirty(1);
		$self->Registry->Log->SetMsg("MSG: packagedata of package ".$self->DispName." changed\n");
	}
	else{
		$self->Registry->Log->SetMsg("MSG: packagedata of package ".$self->DispName." not changed\n");
		$self->SAPDB::Install::Base::DESTROY;
		return;
	}
	$self->setValues;
	$self->SAPDB::Install::Base::DESTROY;
		
}

1;