#  Calling Hierarchy
#  =================
#  LSYSTAB ----------+---- SAPDBLOADER.py
#                    |-----INFO.py
#                    |---- SYSDBA.py
#                    |---- PRECOM.py
#                    |---- CNR3TAB.py
#                    |---- ODBC.py
#                    |---- ORADD.py
#                    |---- QP.py
#                    |---- WA.py
#                    |---- WEBDAV.py
#					 |---- XMLIMAPI.py
#                    |---- XDD.py       (with DOMAIN account)
#                    |---- XDDCOM.py
#                    |---- SHOWCMD.py
#                    |---- DBMVIEWS.py
#                    |---- SYSINFO.py   (with SYSINFO account)
#                    |---- SYSINFOCOM.py
#
#
#
#    ========== licence begin  GPL
#    Copyright (c) 2000-2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end

from installib import *

def install (session,options):
    """Installing tables for instance
    """
    stopIfSqlNotErr (session, -4024, 'DROP PACKAGE SYS_PACKAGE')
    stopIfSqlNotErr (session, -6006,
        'CREATE USER DOMAIN PASSWORD %s DBA NOT EXCLUSIVE' % options.dompwd)
    sqlOK (session, "ALTER USER DOMAIN NOT EXCLUSIVE")
    sqlOK (session, "COMMIT")

    loaderCmd (session, 'USE USER DOMAIN %s' % options.dompwd)

    loaderCmd (session, 'INSTALLATION ON')
    loaderCmd (session, 'AUTOCOMMIT OFF')

    rc = sqlRC (session, """SELECT PACKAGE
        FROM SYSDD.DBPROCEDURES
        WHERE OWNER = USER AND PACKAGE = 'SYS_DDL_PACKAGE'""")

    if rc == 0:

        stopIfSqlNotOK (session, 'DROP PACKAGE SYS_DDL_PACKAGE')

    stopIfSqlNotOK (session, """CREATE PACKAGE SYS_DDL_PACKAGE FILE 'dbpinstall' INPROC""")

    sqlOK (session, "COMMIT")

    switchToDefaultUser (session, options)

    #
    # ---------------------------------------

# PTS 1113919: all create domain statements are done here before calling all other scripts

    rc = sqlRC (session, """SELECT DESCRIPTION
        FROM SYSDD.XPARAMETERS
        WHERE DESCRIPTION = '_UNICODE'
        AND "VALUE" = 'YES'""")

    if rc == 0:

        if (options.migrate):

            stopIfSqlNotErr (session, -4006, 'DROP DOMAIN SYSID')
            stopIfSqlNotErr (session, -4006, 'DROP DOMAIN SYSQPNAME')
            stopIfSqlNotErr (session, -4006, 'DROP DOMAIN SYSCOMMENT')
            stopIfSqlNotErr (session, -4006, 'DROP DOMAIN SYSMSGTEXT')
            stopIfSqlNotErr (session, -4006, 'DROP DOMAIN SYSLONG')
            stopIfSqlNotErr (session, -4006, 'DROP DOMAIN SYSJOB')
            stopIfSqlNotErr (session, -4006, 'DROP DOMAIN SYSSTATEMENT')
            stopIfSqlNotErr (session, -4006, 'DROP DOMAIN SYSDATATYPE')
            stopIfSqlNotErr (session, -4006, 'DROP DOMAIN SYSDATA')

            stopIfSqlNotErr (session, -4006, 'DROP DOMAIN SYSWEBDAV_NAME')
            stopIfSqlNotErr (session, -4006, 'DROP DOMAIN SYSWEBDAV_NAME_SPACE')
            stopIfSqlNotErr (session, -4006, 'DROP DOMAIN SYSWEBDAV_PROPERTY_NAME_PREFIX')
            stopIfSqlNotErr (session, -4006, 'DROP DOMAIN SYSWEBDAV_PROPERTY_NAME')
            stopIfSqlNotErr (session, -4006, 'DROP DOMAIN SYSWEBDAV_PROPERTY_SHORT_VALUE')

            stopIfSqlNotErr (session, -4006, 'DROP DOMAIN SYSXML_CHAR_SHORT')
            stopIfSqlNotErr (session, -4006, 'DROP DOMAIN SYSXML_CHAR_MIDDLE')
            stopIfSqlNotErr (session, -4006, 'DROP DOMAIN SYSXML_CHAR_LONG')

        stopIfSqlNotErr (session, -6006, 'CREATE DOMAIN SYSID CHAR(32) UNICODE')
        stopIfSqlNotErr (session, -6006, 'CREATE DOMAIN SYSQPNAME CHAR(75) UNICODE')
        stopIfSqlNotErr (session, -6006, 'CREATE DOMAIN SYSCOMMENT CHAR(1000) UNICODE')
        stopIfSqlNotErr (session, -6006, 'CREATE DOMAIN SYSMSGTEXT CHAR(80) UNICODE')
        stopIfSqlNotErr (session, -6006, 'CREATE DOMAIN SYSLONG LONG UNICODE')
        stopIfSqlNotErr (session, -6006, 'CREATE DOMAIN SYSJOB CHAR(20) UNICODE')
        stopIfSqlNotErr (session, -6006, 'CREATE DOMAIN SYSSTATEMENT CHAR(3900) UNICODE')
        stopIfSqlNotErr (session, -6006, 'CREATE DOMAIN SYSDATATYPE CHAR(6) UNICODE')
        stopIfSqlNotErr (session, -6006, 'CREATE DOMAIN SYSDATA CHAR(2000) UNICODE')

        stopIfSqlNotErr (session, -6006, 'CREATE DOMAIN SYSWEBDAV_NAME CHAR(499) UNICODE')
        stopIfSqlNotErr (session, -6006, 'CREATE DOMAIN SYSWEBDAV_NAME_SPACE CHAR(499) UNICODE')
        stopIfSqlNotErr (session, -6006, 'CREATE DOMAIN SYSWEBDAV_PROPERTY_NAME_PREFIX CHAR(300) UNICODE')
        stopIfSqlNotErr (session, -6006, 'CREATE DOMAIN SYSWEBDAV_PROPERTY_NAME CHAR(2000) UNICODE')
        stopIfSqlNotErr (session, -6006, 'CREATE DOMAIN SYSWEBDAV_PROPERTY_SHORT_VALUE CHAR(450) UNICODE')

        stopIfSqlNotErr (session, -6006, 'CREATE DOMAIN SYSXML_CHAR_SHORT CHAR(128) UNICODE')
        stopIfSqlNotErr (session, -6006, 'CREATE DOMAIN SYSXML_CHAR_MIDDLE CHAR(256) UNICODE')
        stopIfSqlNotErr (session, -6006, 'CREATE DOMAIN SYSXML_CHAR_LONG CHAR(512) UNICODE')

    else:
        stopIfSqlNotErr (session, -6006, 'CREATE DOMAIN SYSID CHAR(64) ASCII')
        stopIfSqlNotErr (session, -6006, 'CREATE DOMAIN SYSQPNAME CHAR(150) ASCII')
        stopIfSqlNotErr (session, -6006, 'CREATE DOMAIN SYSCOMMENT CHAR(2000) ASCII')
        stopIfSqlNotErr (session, -6006, 'CREATE DOMAIN SYSMSGTEXT CHAR(160) ASCII')
        stopIfSqlNotErr (session, -6006, 'CREATE DOMAIN SYSLONG LONG ASCII')
        stopIfSqlNotErr (session, -6006, 'CREATE DOMAIN SYSJOB CHAR(40) ASCII')
        stopIfSqlNotErr (session, -6006, 'CREATE DOMAIN SYSSTATEMENT CHAR(7800) ASCII')
        stopIfSqlNotErr (session, -6006, 'CREATE DOMAIN SYSDATATYPE CHAR(12) ASCII')
        stopIfSqlNotErr (session, -6006, 'CREATE DOMAIN SYSDATA CHAR(4000) ASCII')

        stopIfSqlNotErr (session, -6006, 'CREATE DOMAIN SYSWEBDAV_NAME CHAR(499) ASCII')
        stopIfSqlNotErr (session, -6006, 'CREATE DOMAIN SYSWEBDAV_NAME_SPACE CHAR(499) ASCII')
        stopIfSqlNotErr (session, -6006, 'CREATE DOMAIN SYSWEBDAV_PROPERTY_NAME_PREFIX CHAR(300) ASCII')
        stopIfSqlNotErr (session, -6006, 'CREATE DOMAIN SYSWEBDAV_PROPERTY_NAME CHAR(2000) ASCII')
        stopIfSqlNotErr (session, -6006, 'CREATE DOMAIN SYSWEBDAV_PROPERTY_SHORT_VALUE CHAR(450) ASCII')

        stopIfSqlNotErr (session, -6006, 'CREATE DOMAIN SYSXML_CHAR_SHORT CHAR(128) ASCII')
        stopIfSqlNotErr (session, -6006, 'CREATE DOMAIN SYSXML_CHAR_MIDDLE CHAR(256) ASCII')
        stopIfSqlNotErr (session, -6006, 'CREATE DOMAIN SYSXML_CHAR_LONG CHAR(512) ASCII')

    sqlOK (session, "COMMIT")

    include (session, options,
     "GARBAGE",
     "SAPDBLOADER",
     "INFO",
     "SYSDBA",
     "SYSDBACOM",
     "PRECOM",
     "CNR3TAB",
     "ODBC",
     "ORADD",
     "QP",
     "WA",
     "WEBDAV",
     "XMLIMAPI",
     "XDD",
     "XDDCOM",
     "SHOWCMD",
     "DBMVIEWS",
     "SYSINFO",
     "SYSINFOCOM"
        )

    stopIfSqlNotOK (session, "CALL SYSVERIFYCATALOG");

    sqlOK (session, "COMMIT")

if __name__ == '__main__':
    connectAndInstall (install, install.__doc__)
