# =====================================================
# @(#) CNR3DATA.py                   7.2.01  1999-11-11
# =====================================================
#
#
#
#    ========== licence begin  GPL
#    Copyright (c) 2000-2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end

from installib import *
from CNR3TAB   import *

def install (session,options):
    """Installing backup history
    """

    loaderCmd (session, 'INSTALLATION ON')

    loaderCmd (session, 'AUTOCOMMIT OFF')

#
#   Create tables definition in CNR3TAB
#
    include (session,options,'CNR3TAB')

    print options.fdir

    if existsTable (session, "CNHIST"):

        loaderCmd (session,
            """DATALOAD
            TABLE CNHIST
            IF POS 23-23 = '|'
            IGNORE DUPLICATES
            CMD_ID             1-12
            LABEL              14-22
            ACTION             24-32
            START_LPNO_DATE    34-43
            START_LPNO_TIME    45-52
            STOP_LPNO_DATE     54-63
            STOP_LPNO_TIME     65-72
            BEGIN_DATE         74-83
            BEGIN_TIME         85-92
            END_DATE           94-103
            END_TIME           105-112
            START_LPNO         114-123 DEFAULT NULL
            STOP_LPNO          125-134 DEFAULT NULL
            LOGREQUESTED       136-138
            MEDIANAME          140-147
            PAGECOUNT          205-214 DEFAULT NULL
            VOLUMES            216-225 DEFAULT NULL
            RETCODE            227-236 DEFAULT NULL
            RETTEXT            238-277
         INFILE '%s/dbm.knl'
         NULL ' '
         DATE 'YYYY-MM-DD'
         TIME 'HH:MM:SS'
         FORMATTED""" %options.fdir )


        loaderCmd (session,
            """DATALOAD
            TABLE CNHIST
            IF POS 27-27 = '|'
            IGNORE DUPLICATES
            CMD_ID             1-12
            LABEL              14-26
            ACTION             28-36
            START_LPNO_DATE    38-47
            START_LPNO_TIME    49-56
            STOP_LPNO_DATE     58-67
            STOP_LPNO_TIME     69-76
            BEGIN_DATE         78-87
            BEGIN_TIME         89-96
            END_DATE           98-107
            END_TIME           109-116
            START_LPNO         118-127 DEFAULT NULL
            STOP_LPNO          129-138 DEFAULT NULL
            LOGREQUESTED       140-142
            MEDIANAME          144-151
            PAGECOUNT          209-218 DEFAULT NULL
            VOLUMES            220-229 DEFAULT NULL
            RETCODE            231-240 DEFAULT NULL
            RETTEXT            242-281
         INFILE '%s/dbm.knl'
         NULL ' '
         DATE 'YYYY-MM-DD'
         TIME 'HH:MM:SS'
         FORMATTED""" %options.fdir )

    if existsTable (session, "CNREPRT"):

#
#   PTS: 1112051
#
        loaderCmd (session,
            """DATALOAD
               TABLE CNREPRT
               IF  (POS 1-4 <> 'Date')
               AND (POS 1-4 <> '    ')
               AND (POS 1-4 <> '----')
               AND (POS 1-4 <> '====')
               IGNORE DUPLICATES
               REP_DATE        1-10
               REP_TIME       12-19
               CMD_ID         21-32
               LINENO         34-37
               CMDTYP         41-43
               LINE           45-299
               INFILE '%s/dbm.utl'
               FORMATTED""" %options.fdir)

    loaderCmd (session, 'COMMIT')

    loaderCmd (session, 'INSTALLATION OFF')

if __name__ == '__main__':
    connectAndInstall (install, install.__doc__)





