#!/usr/bin/env python
#
#    ========== licence begin  GPL
#    Copyright (c) 2003-2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end

import sys
import re
import string
import sapdb.sql

def main ():
    dbname = getDBName (sys.argv)
    username, password = getUserAndPass (sys.argv)
    username = string.upper (username)
    password = string.upper (password)

    packages = getPackageNames (dbname, username, password)
    for package in packages:
        print package

def getDBName (argv):
    for i in range (0, len (argv)):
        if argv[i] == '-d':
            return argv[i + 1]

    return

def getUserAndPass (argv):
    usrpwd = ''

    for i in range (0, len (argv)):
        if argv[i] == '-u':
            return re.split (',', argv[i + 1])

    return

def getPackageNames (dbname, username, password):
    session = sapdb.sql.connect (username, password, dbname)
    cursor = session.sql (
    """SELECT DISTINCT PACKAGE FROM DBPROCEDURES WHERE OWNER = '%s'""" %
    username)

    packages = []
    while 1:
        row = cursor.next ()
        if not row:
            break

        (result,) = row
        packages.append (result)

    return packages

if __name__ == "__main__":
    main ()

