#
# =====================================================
# @(#) ORADDCOM                  7.2        1999-07-29
# =====================================================
# Changes in  7.2:
#
#
#    ========== licence begin  GPL
#    Copyright (c) 2000-2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end

from installib import *

def install (session,options):
    """Installing comments on oracle sytem tables
    """
    loaderCmd (session, 'SQLMODE INTERNAL')

    loaderCmd (session, 'USE USER sys sys')

    loaderCmd (session, 'AUTOCOMMIT OFF')

    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.all_catalog IS
          'All tables, views, synonyms, sequences accessible to the user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_catalog.owner IS
          'Owner of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_catalog.table_name IS
          'Name of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_catalog.table_type IS
          'Type of the object'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.all_col_comments IS
          'Comments on columns of accessible tables and views'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_col_comments.owner IS
          'Owner of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_col_comments.table_name IS
          'Name of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_col_comments.column_name IS
          'Name of the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_col_comments.comments IS
          'Comment on the column'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.all_col_privs IS
        'Grants on columns for which the user is the grantor, grantee, owner,
         or an enabled role or PUBLIC is the grantee'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_col_privs.grantor IS
          'Name of the user who performed the grant'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_col_privs.grantee IS
          'Name of the user to whom access was granted'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_col_privs.table_schema IS
          'Schema of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_col_privs.table_name IS
          'Name of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_col_privs.column_name IS
          'Name of the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_col_privs.privilege IS
          'Column Privilege'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_col_privs.grantable IS
          'Privilege is grantable'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.all_col_privs_made IS
          'Grants on columns for which the user is owner or grantor'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_col_privs_made.grantee IS
          'Name of the user to whom access was granted'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_col_privs_made.owner IS
          'Username of the owner of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_col_privs_made.table_name IS
          'Name of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_col_privs_made.column_name IS
          'Name of the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_col_privs_made.grantor IS
          'Name of the user who performed the grant'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_col_privs_made.privilege IS
          'Column Privilege'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_col_privs_made.grantable IS
          'Privilege is grantable'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.all_col_privs_recd IS
        'Grants on columns for which the user, PUBLIC or
         enabled role is the grantee'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_col_privs_recd.grantee IS
          'Name of the user to whom access was granted'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_col_privs_recd.owner IS
          'Username of the owner of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_col_privs_recd.table_name IS
          'Name of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_col_privs_recd.column_name IS
          'Name of the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_col_privs_recd.grantor IS
          'Name of the user who performed the grant'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_col_privs_recd.privilege IS
          'Column privilege'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_col_privs_recd.grantable IS
          'Privilege is grantable'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.all_constraints IS
          'Constraint definitions on accessible tables'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_constraints.owner IS
          'Owner of the table'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_constraints.constraint_name IS
          'Name associated with constraint definition'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_constraints.constraint_type IS
          'Type of constraint definition'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_constraints.table_name IS
          'Name associated with table with constraint definition'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_constraints.search_condition IS
          'Text of search condition for table check'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_constraints.r_owner IS
          'Owner of table used in referential constraint'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_constraints.r_constraint_name IS
          'Name of unique constraint definition for referenced table'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_constraints.delete_rule IS
          'The delete rule for a referential constraint'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_constraints.status IS
          'enforcement status of constraint - ENABLED or DISABLED'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_constraints.deferrable IS
          'Is the constraint deferrable - DEFERRABLE or NOT DEFERRABLE'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_constraints.deferred IS
          'Is the constraint deferred by default -  DEFERRED or IMMEDIATE'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_constraints.validated IS
          'Was this constraint system validated? -  VALIDATED or NOT VALIDATED'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_constraints.generated IS
          'Was the constraint name system generated? -  GENERATED NAME or USER NAME'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_constraints.bad IS
          'Creating this constraint should give ORA-02436.  Rewrite it before 2000 AD.'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_constraints.rely IS
          'If set, this flag will be used in optimizer'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_constraints.last_change IS
          'The date when this column was last enabled or disabled'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.all_cons_columns IS
          'Information about accessible columns in constraint definitions'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_cons_columns.owner IS
          'Owner of the constraint definition'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_cons_columns.constraint_name IS
          'Name associated with the constraint definition'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_cons_columns.table_name IS
          'Name associated with table with constraint definition'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_cons_columns.column_name IS
          'Name associated with column specified in the constraint definition'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_cons_columns.position IS
          'Original position of column in definition'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.all_db_links IS
          'Database links accessible to the user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_db_links.owner IS
          'Username of the owner of the database link'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_db_links.db_link IS
          'Name of the database link'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_db_links.username IS
          'Name of user to log on as'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_db_links.host IS
          'SQL*Net string for connect'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_db_links.created IS
          'Creation time of the database link'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.all_def_audit_opts IS
          'Auditing options for newly created objects'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_def_audit_opts.alt IS
          'Auditing ALTER WHENEVER SUCCESSFUL / UNSUCCESSFUL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_def_audit_opts.aud IS
          'Auditing AUDIT WHENEVER SUCCESSFUL / UNSUCCESSFUL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_def_audit_opts.com IS
          'Auditing COMMENT WHENEVER SUCCESSFUL / UNSUCCESSFUL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_def_audit_opts.del IS
          'Auditing DELETE WHENEVER SUCCESSFUL / UNSUCCESSFUL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_def_audit_opts.gra IS
          'Auditing GRANT WHENEVER SUCCESSFUL / UNSUCCESSFUL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_def_audit_opts.ind IS
          'Auditing INDEX WHENEVER SUCCESSFUL / UNSUCCESSFUL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_def_audit_opts.ins IS
          'Auditing INSERT WHENEVER SUCCESSFUL / UNSUCCESSFUL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_def_audit_opts.loc IS
          'Auditing LOCK WHENEVER SUCCESSFUL / UNSUCCESSFUL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_def_audit_opts.ren IS
          'Auditing RENAME WHENEVER SUCCESSFUL / UNSUCCESSFUL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_def_audit_opts.sel IS
          'Auditing SELECT WHENEVER SUCCESSFUL / UNSUCCESSFUL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_def_audit_opts.upd IS
          'Auditing UPDATE WHENEVER SUCCESSFUL / UNSUCCESSFUL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_def_audit_opts.ref IS
          'Auditing REFERENCES WHENEVER SUCCESSFUL / UNSUCCESSFUL (not used)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_def_audit_opts.exe IS
          'Auditing EXECUTE WHENEVER SUCCESSFUL / UNSUCCESSFUL'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.all_dependencies IS
          'Dependencies to and from objects accessible to the user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_dependencies.owner IS
          'Owner of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_dependencies.name IS
          'Name of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_dependencies.type IS
          'Type of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_dependencies.referenced_owner IS
          'Owner of referenced object (remote owner if remote object)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_dependencies.referenced_name IS
          'Name of referenced object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_dependencies.referenced_type IS
          'Type of referenced object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_dependencies.referenced_link_name IS
          'Name of dblink if this is a remote object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_dependencies.dependency_type IS
          'Two values: REF when the dependency is a REF dependency, HARD otherwise'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.all_errors IS
          'Current errors on stored objects that user is allowed to create'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_errors.owner IS
          'Owner of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_errors.name IS
          'Name of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_errors.type IS
        'Type of object: "VIEW", "PROCEDURE", "FUNCTION", "PACKAGE" or "PACKAGE BODY"'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_errors.sequence IS
          'Sequence number used for ordering purposes'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_errors.line IS
          'Line number at which this error occurs'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_errors.position IS
          'Position in the line at which this error occurs'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_errors.text IS
          'Text of the error'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.all_indexes IS
          'Descriptions of indexes on tables accessible to the user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.owner IS
          'Username of the owner of the index'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.index_name IS
          'Name of the index'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.index_type IS
          'Type of index'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.table_owner IS
          'Owner of the indexed object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.table_name IS
          'Name of the indexed object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.table_type IS
          'Type of the indexed object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.uniqueness IS
          'Uniqueness status of the index:  "UNIQUE" or "NONUNIQUE"'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.compression IS
          'Compression property of the index: "ENABLED",  "DISABLED", or NULL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.prefix_length IS
          'Number of key columns in the prefix used for compression'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.tablespace_name IS
          'Name of the tablespace containing the index'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.ini_trans IS
          'Initial number of transactions'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.max_trans IS
          'Maximum number of transactions'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.initial_extent IS
          'Size of the initial extent'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.next_extent IS
          'Size of secondary extents'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.min_extents IS
          'Minimum number of extents allowed in the segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.max_extents IS
          'Maximum number of extents allowed in the segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.pct_increase IS
          'Percentage increase in extent size'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.pct_threshold IS
          'Threshold percentage of block space allowed per index entry'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.include_column IS
          'User column-id for last column to be included in index-organized table top index'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.freelists IS
          'Number of process freelists allocated in this segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.freelist_groups IS
          'Number of freelist groups allocated to this segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.pct_free IS
          'Minimum percentage of free space in a block'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.logging IS
          'Logging attribute'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.blevel IS
          'B-Tree level'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.leaf_blocks IS
          'The number of leaf blocks in the index'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.distinct_keys IS
          'The number of distinct keys in the index'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.avg_leaf_blocks_per_key IS
          'The average number of leaf blocks per key'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.avg_data_blocks_per_key IS
          'The average number of data blocks per key'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.clustering_factor IS
        'A measurement of the amount of (dis)order of the table this index is for'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.status IS
          'Whether index is in Direct Load State or not'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.num_rows IS
          'Number of rows in this index'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.sample_size IS
          'The sample size used in analyzing this index'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.last_analyzed IS
          'The date of the most recent time this index was analyzed'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.degree IS
          'The number of threads per instance for scanning the partitioned index'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.instances IS
          'Number of instances across which the indexes to be scanned'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.partitioned IS
          'Is this index partitioned? YES or NO'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.temporary IS
          'Can the current session only see data that it place in this object itself?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.generated IS
          'Was the name of this index system generated?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.secondary IS
          'Is the index object created as part of icreate for domain indexes?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.buffer_pool IS
          'The default buffer pool to be used for index blocks'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.user_stats IS
          'Were the statistics entered directly by the user?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.duration IS
          'If index on temporary table, then duration is sys$session or sys$transaction else NULL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.pct_direct_access IS
          'If index on IOT, then this is percentage of rows with Valid guess'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.ityp_owner IS
          'If domain index, then this is the indextype owner'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.ityp_name IS
          'If domain index, then this is the name of the associated indextype'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.parameters IS
          'If domain index, then this is the parameter string'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_indexes.global_stats IS
          'Are the statistics calculated without merging underlying partitions?'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.all_ind_columns IS
          'COLUMNs comprising INDEXes on accessible TABLES'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_ind_columns.index_owner IS
          'Index owner'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_ind_columns.index_name IS
          'Index name'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_ind_columns.table_owner IS
          'Table or cluster owner'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_ind_columns.table_name IS
          'Table or cluster name'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_ind_columns.column_name IS
          'Column name'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_ind_columns.column_position IS
          'Position of column within index'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_ind_columns.column_length IS
          'Indexed length of the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_ind_columns.descend IS
          'Y/N, Y if this column is sorted in descending order'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.all_objects IS
          'Objects accessible to the user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_objects.owner IS
          'Username of the owner of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_objects.object_name IS
          'Name of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_objects.subobject_name IS
          'Name of the sub-object (for example, partititon)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_objects.object_id IS
          'Object number of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_objects.data_object_id IS
          'Object number of the segment which contains the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_objects.object_type IS
          'Type of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_objects.created IS
          'Timestamp for the creation of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_objects.last_ddl_time IS
        'Timestamp for the last DDL change (including GRANT and REVOKE) to the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_objects.timestamp IS
          'Timestamp for the specification of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_objects.status IS
          'Status of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_objects.temporary IS
          'Can the current session only see data that it placed in this object itself?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_objects.generated IS
          'Was the name of this object system generated?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_objects.secondary IS
          'Is this a secondary object created as part of icreate for domain indexes?'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.all_sequences IS
          'Description of SEQUENCEs accessible to the user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_sequences.sequence_owner IS
          'Name of the owner of the sequence'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_sequences.sequence_name IS
          'SEQUENCE name'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_sequences.min_value IS
          'Minimum value of the sequence'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_sequences.max_value IS
          'Maximum value of the sequence'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_sequences.increment_by IS
          'Value by which sequence is incremented'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_sequences.cycle_flag IS
          'Does sequence wrap around on reaching limit?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_sequences.order_flag IS
          'Are sequence numbers generated in order?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_sequences.cache_size IS
          'Number of sequence numbers to cache'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_sequences.last_number IS
          'Last sequence number written to disk'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.all_snapshots IS
          'Snapshots the user can look at'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_snapshots.owner IS
          'Owner of the snapshot'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_snapshots.name IS
          'The view used by users and applications for viewing the snapshot'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_snapshots.table_name IS
        'Table the snapshot is stored in -- has an extra column for the master rowid'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_snapshots.master_view IS
        'View of the master table, owned by the snapshot owner, used for refreshes'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_snapshots.master_owner IS
          'Owner of the master table'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_snapshots.master IS
          'Name of the master table that this snapshot is a copy of'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_snapshots.master_link IS
          'Database link name to the master site'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_snapshots.can_use_log IS
          'If NO, this snapshot is complex and will never use a log'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_snapshots.updatable IS
          'If NO, the snapshot is read only.  Look up REPLICATION'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_snapshots.refresh_method IS
          'The values used to drive a fast refresh of the snapshot'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_snapshots.last_refresh IS
          'SYSDATE from the master site at the time of the last refresh'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_snapshots.error IS
          'The error returned last time an automatic refresh was attempted'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_snapshots.fr_operations IS
          'Status of generated fast refresh operations: (REGENERATE, VALID)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_snapshots.cr_operations IS
          'Status of generated complete refresh operations: (REGENERATE, VALID)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_snapshots.type IS
          'The type of refresh (complete,fast,force) for all automatic refreshes'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_snapshots.next IS
          'The date function used to compute next refresh dates'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_snapshots.start_with IS
          'The date function used to compute next refresh dates'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_snapshots.refresh_group IS
          'All snapshots in a given refresh group get refreshed in the same transaction'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_snapshots.update_trig IS
          'The name of the trigger which fills the UPDATE_LOG'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_snapshots.update_log IS
          'The table which logs changes made to an updatable snapshots'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_snapshots.query IS
          'The original query that this snapshot is an instantiation of'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_snapshots.master_rollback_seg IS
          'Rollback segment to use at the master site'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_snapshots.status IS
          'The status of the contents of the snapshot'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_snapshots.refresh_mode IS
          'This indicates how and when the snapshot will be refreshed'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_snapshots.prebuilt IS
          'If YES, this snapshot uses a prebuilt table as the base table'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.all_source IS
          'Current source on stored objects that user is allowed to create'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_source.owner IS
          'Owner of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_source.name IS
          'Name of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_source.type IS
          'Type of the object: "PROCEDURE", "FUNCTION", "PACKAGE" or "PACKAGE BODY"'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_source.line IS
          'Line number of this line of source'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_source.text IS
          'Source text'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.all_synonyms IS
          'All synonyms accessible to the user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_synonyms.owner IS
          'Owner of the synonym'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_synonyms.synonym_name IS
          'Name of the synonym'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_synonyms.table_owner IS
          'Owner of the object referenced by the synonym'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_synonyms.table_name IS
          'Name of the object referenced by the synonym'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_synonyms.db_link IS
          'Name of the database link referenced in a remote synonym'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.all_tables IS
          'Description of tables accessible to the user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tables.owner IS
          'Owner of the table'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tables.table_name IS
          'Name of the table'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tables.tablespace_name IS
          'Name of the tablespace containing the table'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tables.cluster_name IS
          'Name of the cluster, if any, to which the table belongs'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tables.iot_name IS
          'Name of the index-only table, if any, to which the overflow entry belongs'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tables.pct_free IS
          'Minimum percentage of free space in a block'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tables.pct_used IS
          'Minimum percentage of used space in a block'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tables.ini_trans IS
          'Initial number of transactions'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tables.max_trans IS
          'Maximum number of transactions'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tables.initial_extent IS
          'Size of the initial extent in bytes'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tables.next_extent IS
          'Size of secondary extents in bytes'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tables.min_extents IS
          'Minimum number of extents allowed in the segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tables.max_extents IS
          'Maximum number of extents allowed in the segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tables.pct_increase IS
          'Percentage increase in extent size'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tables.freelists IS
          'Number of process freelists allocated in this segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tables.freelist_groups IS
          'Number of freelist groups allocated in this segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tables.logging IS
          'Logging attribute'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tables.backed_up IS
          'Has table been backed up since last modification?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tables.num_rows IS
          'The number of rows in the table'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tables.blocks IS
          'The number of used blocks in the table'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tables.empty_blocks IS
          'The number of empty (never used) blocks in the table'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tables.avg_space IS
          'The average available free space in the table'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tables.chain_cnt IS
          'The number of chained rows in the table'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tables.avg_row_len IS
          'The average row length, including row overhead'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tables.avg_space_freelist_blocks IS
          'The average freespace of all blocks on a freelist'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tables.num_freelist_blocks IS
          'The number of blocks on the freelist'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tables.degree IS
          'The number of threads per instance for scanning the table'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tables.instances IS
          'The number of instances across which the table is to be scanned'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tables.cache IS
          'Whether the table is to be cached in the buffer cache'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tables.table_lock IS
          'Whether table locking is enabled or disabled'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tables.sample_size IS
          'The sample size used in analyzing this table'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tables.last_analyzed IS
          'The date of the most recent time this table was analyzed'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tables.partitioned IS
          'Is this table partitioned? YES or NO'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tables.iot_type IS
          'If index-only table, then IOT_TYPE is IOT or IOT_OVERFLOW else NULL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tables.temporary IS
          'Can the current session only see data that it place in this object itself?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tables.secondary IS
          'Is this table object created as part of icreate for domain indexes?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tables.nested IS
          'Is the table a nested table?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tables.buffer_pool IS
          'The default buffer pool to be used for table blocks'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tables.row_movement IS
          'Whether partitioned row movement is enabled or disabled'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tables.global_stats IS
          'Are the statistics calculated without merging underlying partitions?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tables.user_stats IS
          'Were the statistics entered directly by the user?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tables.duration IS
          'If temporary table, then duration is sys$session or sys$transaction else NULL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tables.skip_corrupt IS
          'Whether skip corrupt blocks is enabled or disabled'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tables.monitoring IS
          'Should we keep track of the amount of modification?'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.all_tab_columns IS
          'Columns of all tables, views and clusters'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_columns.owner IS
          'Owner of the table, view or cluster'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_columns.table_name IS
          'Table, view or cluster name'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_columns.column_name IS
          'Column name'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_columns.data_type IS
          'Datatype of the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_columns.data_type_mod IS
          'Datatype modifier of the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_columns.data_type_owner IS
          'Owner of the datatype of the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_columns.data_length IS
          'Length of the column in bytes'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_columns.data_precision IS
          'Length: decimal digits (NUMBER) or binary digits (FLOAT)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_columns.data_scale IS
          'Digits to right of decimal point in a number'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_columns.nullable IS
          'Does column allow NULL values?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_columns.column_id IS
          'Sequence number of the column as created'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_columns.default_length IS
          'Length of default value for the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_columns.data_default IS
          'Default value for the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_columns.num_distinct IS
          'The number of distinct values for the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_columns.low_value IS
          'The second smallest value for the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_columns.high_value IS
          'The second highest value for the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_columns.density IS
          'The density of the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_columns.num_nulls IS
          'The number of nulls in the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_columns.num_buckets IS
          'The number of buckets in histogram for the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_columns.last_analyzed IS
          'The date of the most recent time this column was analyzed'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_columns.sample_size IS
          'The sample size used in analyzing this column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_columns.character_set_name IS
          'Character set name'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_columns.char_col_decl_length IS
          'Declaration length of character type column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_columns.global_stats IS
          'Are the statistics calculated without merging underlying partitions?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_columns.user_stats IS
          'Were the statistics entered directly by the user?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_columns.avg_col_len IS
          'The average length of the column in bytes'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.all_tab_comments IS
          'Comments on tables and views accessible to the user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_comments.owner IS
          'Owner of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_comments.table_name IS
          'Name of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_comments.table_type IS
          'Type of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_comments.comments IS
          'Comments on tables and views accessible to the user'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.all_tab_privs IS
        'Grants on objects for which the user is the grantor, grantee, owner,
         or an enabled role or PUBLIC is the grantee'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_privs.grantor IS
          'Name of the user who performed the grant'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_privs.grantee IS
          'Name of the user to whom access was granted'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_privs.table_schema IS
          'Schema of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_privs.table_name IS
          'Name of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_privs.privilege IS
          'Table Privilege'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_privs.grantable IS
          'Privilege is grantable'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.all_tab_privs_made IS
          'User''s grants and grants on user''s objects'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_privs_made.grantee IS
          'Name of the user to whom access was granted'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_privs_made.owner IS
          'Owner of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_privs_made.table_name IS
          'Name of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_privs_made.grantor IS
          'Name of the user who performed the grant'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_privs_made.privilege IS
          'Table Privilege'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_privs_made.grantable IS
          'Privilege is grantable'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.all_tab_privs_recd IS
        'Grants on objects for which the user, PUBLIC or enabled role
         is the grantee'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_privs_recd.grantee IS
          'Name of the user to whom access was granted'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_privs_recd.owner IS
          'Owner of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_privs_recd.table_name IS
          'Name of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_privs_recd.grantor IS
          'Name of the user who performed the grant'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_privs_recd.privilege IS
          'Table Privilege'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_tab_privs_recd.grantable IS
          'Privilege is grantable'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.all_triggers IS
          'Triggers accessible to the current user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_triggers.owner IS
          'Owner of the trigger'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_triggers.trigger_name IS
          'Name of the trigger'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_triggers.trigger_type IS
          'When the trigger fires - BEFORE/AFTER and STATEMENT/ROW'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_triggers.triggering_event IS
          'Statement that will fire the trigger - INSERT, UPDATE and/or DELETE'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_triggers.table_owner IS
          'Owner of the table that this trigger is associated with'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_triggers.base_object_type IS
          'The base object on which the trigger is defined: TABLE, VIEW, SCHEMA, or DATABASE'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_triggers.table_name IS
          'Name of the table that this trigger is associated with'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_triggers.column_name IS
          'The name of the column on which the trigger is defined over'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_triggers.referencing_names IS
          'Names used for referencing to OLD and NEW values within the trigger'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_triggers.when_clause IS
        'WHEN clause must evaluate to true in order for triggering body to execute'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_triggers.status IS
          'If DISABLED then trigger will not fire'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_triggers.description IS
          'Trigger description, useful for re-creating trigger creation statement'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_triggers.action_type IS
          'The action type of the trigger body: CALL or PL/SQL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_triggers.trigger_body IS
          'Action taken by this trigger when it fires'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.all_trigger_cols IS
          'Column usage in user''s triggers or in triggers on user''s tables'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_trigger_cols.trigger_owner IS
          'Owner of the trigger'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_trigger_cols.trigger_name IS
          'Name of the trigger'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_trigger_cols.table_owner IS
          'Owner of the table'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_trigger_cols.table_name IS
          'Name of the table on which the trigger is defined'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_trigger_cols.column_name IS
          'Name of the column used in trigger definition'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_trigger_cols.column_list IS
          'Is column specified in UPDATE OF clause?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_trigger_cols.column_usage IS
          'Usage of column within trigger body'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.all_users IS
          'Information about all users of the database'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_users.username IS
          'Name of the user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_users.user_id IS
          'ID number of the user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_users.created IS
          'User creation date'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.all_views IS
          'Text of views accessible to the user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_views.owner IS
          'Owner of the view'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_views.view_name IS
          'Name of the view'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_views.text_length IS
          'Length of the view text'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_views.text IS
          'View text'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_views.type_text_length IS
          'Length of the type clause of the object view'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_views.type_text IS
          'Type clause of the object view'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_views.oid_text_length IS
          'Length of the WITH OBJECT OID clause of the object view'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_views.oid_text IS
          'WITH OBJECT OID clause of the object view'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_views.view_type_owner IS
          'Owner of the type of the view if the view is an object view'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.all_views.view_type IS
          'Type of the view if the view is an object view'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_2pc_neighbors IS
        'information about incoming and outgoing connections
         for pending transactions'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_2pc_neighbors.local_tran_id IS
          'Local identifier of a transaction'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_2pc_neighbors.in_out IS
          '"in" for incoming connections, "out" for outgoing'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_2pc_neighbors.database IS
          'in: client database name; out: outgoing db link'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_2pc_neighbors.dbuser_owner IS
          'in: name of local user; out: owner of db link'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_2pc_neighbors.interface IS
          '"C" for request commit, else "N" for prepare or request readonly commit'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_2pc_neighbors.dbid IS
          'the database id at the other end of the connection'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_2pc_neighbors."SESS#" IS
          'session number at this database of the connection'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_2pc_neighbors.branch IS
          'transaction branch ID at this database of the connection'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_2pc_pending IS
          'info about distributed transactions awaiting recovery'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_2pc_pending.local_tran_id IS
          'string of form: n.n.n, n a number'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_2pc_pending.global_tran_id IS
          'globally unique transaction id'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_2pc_pending.state IS
          'collecting, prepared, committed, forced commit, or forced rollback'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_2pc_pending.mixed IS
        'yes => part of the transaction committed and part rolled back
         (commit or rollback with the FORCE option was used)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_2pc_pending.advice IS
          'C for commit, R for rollback, else null'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_2pc_pending.tran_comment IS
          'text for "commit work comment <text>"'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_2pc_pending.fail_time IS
          'value of SYSDATE when the row was inserted (tx or system recovery)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_2pc_pending.force_time IS
          'time of manual force decision (null if not forced locally)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_2pc_pending.retry_time IS
          'time automatic recovery (RECO) last tried to recover the transaction'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_2pc_pending.os_user IS
          'operating system specific name for the end-user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_2pc_pending.os_terminal IS
          'operating system specific name for the end-user terminal'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_2pc_pending.host IS
          'name of the host machine for the end-user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_2pc_pending.db_user IS
          'Oracle user name of the end-user at the topmost database'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_2pc_pending."COMMIT#" IS
          'global commit number for committed transactions'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_audit_exists IS
          'Lists audit trail entries produced by AUDIT NOT EXISTS and AUDIT EXISTS'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_audit_exists IS
          'All audit trail entries'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_exists.os_username IS
          'Operating System logon user name of the user whose actions were audited'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_exists.username IS
          'Name (not ID number) of the user whose actions were audited'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_exists.userhost IS
        'Numeric instance ID for the Oracle instance from which the user is
         accessing the database.  Used only in environments with distributed
         file systems and shared database files (e.g., clustered Oracle on DEC
         VAX/VMS clusters)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_exists.terminal IS
          'Identifier for the user''s terminal'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_exists.timestamp IS
        'Timestamp for the creation of the audit trail entry (Timestamp for the
         user''s logon for entries created by AUDIT SESSION)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_exists.owner IS
          'Creator of object affected by the action'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_exists.obj_name IS
          'Name of the object affected by the action'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_exists.action_name IS
          'Name of the action type corresponding to the numeric code in ACTION'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_exists.new_owner IS
          'The owner of the object named in the NEW_NAME column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_exists.new_name IS
        'New name of object after RENAME, or name of underlying object
         (e.g. CREATE INDEX owner.obj_name ON new_owner.new_name)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_exists.obj_privilege IS
          'Object privileges granted/revoked by a GRANT/REVOKE statement'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_exists.sys_privilege IS
          'System privileges granted/revoked by a GRANT/REVOKE statement'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_exists.grantee IS
          'The name of the grantee specified in a GRANT/REVOKE statement'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_exists.sessionid IS
          'Numeric ID for each Oracle session'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_exists.entryid IS
          'Numeric ID for each audit trail entry in the session'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_exists.statementid IS
          'Numeric ID for each statement run (a statement may cause many actions)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_exists.returncode IS
          'Oracle error code generated by the action.  Zero if the action succeeded'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_audit_object IS
        'Audit trail records for statements concerning objects, specifically:
         table, cluster, view, index, sequence,  [public] database link,
         [public] synonym, procedure, trigger, rollback segment, tablespace,
         role, user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_object.os_username IS
          'Operating System logon user name of the user whose actions were audited'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_object.username IS
          'Name (not ID number) of the user whose actions were audited'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_object.userhost IS
        'Numeric instance ID for the Oracle instance from which the user is
         accessing the database.  Used only in environments with distributed
         file systems and shared database files (e.g., clustered Oracle on DEC
         VAX/VMS clusters)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_object.terminal IS
          'Identifier for the user''s terminal'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_object.timestamp IS
        'Timestamp for the creation of the audit trail entry (Timestamp for the
         user''s logon for entries created by AUDIT SESSION)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_object.owner IS
          'Creator of object affected by the action'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_object.obj_name IS
          'Name of the object affected by the action'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_object.action_name IS
          'Name of the action type corresponding to the numeric code in ACTION'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_object.new_owner IS
          'The owner of the object named in the NEW_NAME column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_object.new_name IS
        'New name of object after RENAME, or name of underlying object
         (e.g. CREATE INDEX owner.obj_name ON new_owner.new_name)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_object.ses_actions IS
        'Session summary. A string of 11 characters, one for each action type,
         in this order: Alter, Audit, Comment, Delete, Grant, Index, Insert,
         Lock, Rename, Select, Update.  Values:  "-" = None, "S" = Success,
         "F" = Failure, "B" = Both'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_object.comment_text IS
          'Text comment on the audit trail entry'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_object.sessionid IS
          'Numeric ID for each Oracle session'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_object.entryid IS
          'Numeric ID for each audit trail entry in the session'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_object.statementid IS
          'Numeric ID for each statement run (a statement may cause many actions)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_object.returncode IS
          'Oracle error code generated by the action.  Zero if the action succeeded'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_object.priv_used IS
          'System privilege used to execute the action'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_object.object_label IS
          'Optional Trusted ORACLE label associated with object being audited'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_object.session_label IS
          'Trusted ORACLE label associated with user session'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_audit_session IS
          'All audit trail entries concerning connect and disconnect'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_session.os_username IS
          'Operating System logon user name of the user whose actions were audited'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_session.username IS
          'Name (not ID number) of the user whose actions were audited'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_session.userhost IS
        'Numeric instance ID for the Oracle instance from which the user is
         accessing the database.  Used only in environments with distributed
         file systems and shared database files (e.g., clustered Oracle on DEC
         VAX/VMS clusters)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_session.terminal IS
          'Identifier for the user''s terminal'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_session.timestamp IS
        'Timestamp for the creation of the audit trail entry (Timestamp for the
         user''s logon for entries created by AUDIT SESSION)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_session.action_name IS
          'Name of the action type corresponding to the numeric code in ACTION'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_session.logoff_time IS
          'Timestamp for user logoff'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_session.logoff_lread IS
          'Logical reads for the session'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_session.logoff_pread IS
          'Physical reads for the session'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_session.logoff_lwrite IS
          'Logical writes for the session'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_session.logoff_dlock IS
          'Deadlocks detected during the session'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_session.sessionid IS
          'Numeric ID for each Oracle session'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_session.returncode IS
          'Oracle error code generated by the action.  Zero if the action succeeded'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_session.session_label IS
          'Trusted ORACLE label associated with user session'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_audit_statement IS
        'Audit trail records concerning  grant, revoke, audit, noaudit
         and alter system'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_statement.os_username IS
          'Operating System logon user name of the user whose actions were audited'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_statement.username IS
          'Name (not ID number) of the user whose actions were audited'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_statement.userhost IS
        'Numeric instance ID for the Oracle instance from which the user is
         accessing the database.  Used only in environments with distributed
         file systems and shared database files (e.g., clustered Oracle on DEC
         VAX/VMS clusters)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_statement.terminal IS
          'Identifier for the user''s terminal'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_statement.timestamp IS
        'Timestamp for the creation of the audit trail entry (Timestamp for the
         user''s logon for entries created by AUDIT SESSION)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_statement.owner IS
          'Creator of object affected by the action'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_statement.obj_name IS
          'Name of the object affected by the action'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_statement.action_name IS
          'Name of the action type corresponding to the numeric code in ACTION'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_statement.new_name IS
        'New name of object after RENAME, or name of underlying object
         (e.g. CREATE INDEX owner.obj_name ON new_owner.new_name)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_statement.obj_privilege IS
          'Object privileges granted/revoked by a GRANT/REVOKE statement'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_statement.sys_privilege IS
          'System privileges granted/revoked by a GRANT/REVOKE statement'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_statement.admin_option IS
          'If role/sys_priv was granted WITH ADMIN OPTION, A/-'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_statement.grantee IS
          'The name of the grantee specified in a GRANT/REVOKE statement'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_statement.audit_option IS
          'Auditing option set with the audit statement'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_statement.ses_actions IS
        'Session summary. A string of 11 characters, one for each action type,
         in this order: Alter, Audit, Comment, Delete, Grant, Index, Insert,
         Lock, Rename, Select, Update.  Values:  "-" = None, "S" = Success,
         "F" = Failure, "B" = Both'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_statement.comment_text IS
          'Text comment on the audit trail entry'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_statement.sessionid IS
          'Numeric ID for each Oracle session'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_statement.entryid IS
          'Numeric ID for each audit trail entry in the session'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_statement.statementid IS
          'Numeric ID for each statement run (a statement may cause many actions)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_statement.returncode IS
          'Oracle error code generated by the action.  Zero if the action succeeded'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_statement.priv_used IS
          'System privilege used to execute the action'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_statement.session_label IS
          'Trusted ORACLE label associated with user session'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_audit_trail IS
          'All audit trail entries'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_trail.os_username IS
          'Operating System logon user name of the user whose actions were audited'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_trail.username IS
          'Name (not ID number) of the user whose actions were audited'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_trail.userhost IS
        'Numeric instance ID for the Oracle instance from which the user is
         accessing the database.  Used only in environments with distributed
         file systems and shared database files (e.g., clustered Oracle on DEC
         VAX/VMS clusters)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_trail.terminal IS
          'Identifier for the user''s terminal'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_trail.timestamp IS
        'Timestamp for the creation of the audit trail entry (Timestamp for the
         user''s logon for entries created by AUDIT SESSION)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_trail.owner IS
          'Creator of object affected by the action'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_trail.obj_name IS
          'Name of the object affected by the action'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_trail.action IS
        'Numeric action type code. The corresponding name of the action type
         (CREATE TABLE, INSERT, etc.) is in the column ACTION_NAME'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_trail.action_name IS
          'Name of the action type corresponding to the numeric code in ACTION'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_trail.new_owner IS
          'The owner of the object named in the NEW_NAME column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_trail.new_name IS
        'New name of object after RENAME, or name of underlying object
         (e.g. CREATE INDEX owner.obj_name ON new_owner.new_name)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_trail.obj_privilege IS
          'Object privileges granted/revoked by a GRANT/REVOKE statement'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_trail.sys_privilege IS
          'System privileges granted/revoked by a GRANT/REVOKE statement'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_trail.admin_option IS
          'If role/sys_priv was granted WITH ADMIN OPTION, A/-'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_trail.grantee IS
          'The name of the grantee specified in a GRANT/REVOKE statement'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_trail.audit_option IS
          'Auditing option set with the audit statement'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_trail.ses_actions IS
        'Session summary. A string of 11 characters, one for each action type,
         in this order: Alter, Audit, Comment, Delete, Grant, Index, Insert,
         Lock, Rename, Select, Update.  Values:  "-" = None, "S" = Success,
         "F" = Failure, "B" = Both'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_trail.logoff_time IS
          'Timestamp for user logoff'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_trail.logoff_lread IS
          'Logical reads for the session'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_trail.logoff_pread IS
          'Physical reads for the session'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_trail.logoff_lwrite IS
          'Logical writes for the session'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_trail.logoff_dlock IS
          'Deadlocks detected during the session'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_trail.comment_text IS
          'Text comment on the audit trail entry'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_trail.sessionid IS
          'Numeric ID for each Oracle session'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_trail.entryid IS
          'Numeric ID for each audit trail entry in the session'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_trail.statementid IS
          'Numeric ID for each statement run (a statement may cause many actions)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_trail.returncode IS
          'Oracle error code generated by the action.  Zero if the action succeeded'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_trail.priv_used IS
          'System privilege used to execute the action'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_trail.object_label IS
          'Optional Trusted ORACLE label associated with object being audited'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_audit_trail.session_label IS
          'Trusted ORACLE label associated with user session'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_blockers IS
        'All sessions that have someone waiting on a lock they hold that are
         not themselves waiting on a lock'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_blockers.holding_session IS
          'Session holding a lock'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_catalog IS
          'All database Tables, Views, Synonyms, Sequences'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_catalog.owner IS
          'Owner of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_catalog.table_name IS
          'Name of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_catalog.table_type IS
          'Type of the object'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_clusters IS
          'Description of all clusters in the database'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_clusters.owner IS
          'Owner of the cluster'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_clusters.cluster_name IS
          'Name of the cluster'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_clusters.tablespace_name IS
          'Name of the tablespace containing the cluster'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_clusters.pct_free IS
          'Minimum percentage of free space in a block'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_clusters.pct_used IS
          'Minimum percentage of used space in a block'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_clusters.key_size IS
          'Estimated size of cluster key plus associated rows'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_clusters.ini_trans IS
          'Initial number of transactions'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_clusters.max_trans IS
          'Maximum number of transactions'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_clusters.initial_extent IS
          'Size of the initial extent in bytes'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_clusters.next_extent IS
          'Size of secondary extents in bytes'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_clusters.min_extents IS
          'Minimum number of extents allowed in the segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_clusters.max_extents IS
          'Maximum number of extents allowed in the segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_clusters.pct_increase IS
          'Percentage increase in extent size'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_clusters.freelists IS
          'Number of process freelists allocated in this segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_clusters.freelist_groups IS
          'Number of freelist groups allocated in this segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_clusters.avg_blocks_per_key IS
          'Average number of blocks containing rows with a given cluster key'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_clusters.cluster_type IS
          'Type of cluster: b-tree index or hash'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_clusters.function IS
          'If a hash cluster, the hash function'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_clusters.hashkeys IS
          'If a hash cluster, the number of hash keys (hash buckets)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_clusters.degree IS
          'The number of threads per instance for scanning the cluster'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_clusters.instances IS
          'The number of instances across which the cluster is to be scanned'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_clusters.cache IS
          'Whether the cluster is to be cached in the buffer cache'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_clusters.buffer_pool IS
          'The default buffer pool to be used for cluster blocks'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_clusters.single_table IS
          'Whether the cluster can contain only a single table'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_clu_columns IS
          'Mapping of table columns to cluster columns'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_clu_columns.owner IS
          'Owner of the cluster'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_clu_columns.cluster_name IS
          'Cluster name'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_clu_columns.clu_column_name IS
          'Key column in the cluster'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_clu_columns.table_name IS
          'Clustered table name'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_clu_columns.tab_column_name IS
          'Key column in the table'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_col_comments IS
          'Comments on columns of all tables and views'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_col_comments.owner IS
          'Name of the owner of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_col_comments.table_name IS
          'Name of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_col_comments.column_name IS
          'Name of the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_col_comments.comments IS
          'Comment on the object'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_col_privs IS
          'All grants on columns in the database'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_col_privs.grantee IS
          'Name of the user to whom access was granted'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_col_privs.owner IS
          'Username of the owner of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_col_privs.table_name IS
          'Name of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_col_privs.column_name IS
          'Name of the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_col_privs.grantor IS
          'Name of the user who performed the grant'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_col_privs.privilege IS
          'Column Privilege'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_col_privs.grantable IS
          'Privilege is grantable'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_constraints IS
          'Constraint definitions on all tables'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_constraints.owner IS
          'Owner of the table'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_constraints.constraint_name IS
          'Name associated with constraint definition'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_constraints.constraint_type IS
          'Type of constraint definition'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_constraints.table_name IS
          'Name associated with table with constraint definition'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_constraints.search_condition IS
          'Text of search condition for table check'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_constraints.r_owner IS
          'Owner of table used in referential constraint'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_constraints.r_constraint_name IS
          'Name of unique constraint definition for referenced table'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_constraints.delete_rule IS
          'The delete rule for a referential constraint'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_constraints.status IS
          'enforcement status of constraint - ENABLED or DISABLED'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_constraints.deferrable IS
          'Is the constraint deferrable - DEFERRABLE or NOT DEFERRABLE'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_constraints.deferred IS
          'Is the constraint deferred by default -  DEFERRED or IMMEDIATE'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_constraints.validated IS
          'Was this constraint system validated? -  VALIDATED or NOT VALIDATED'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_constraints.generated IS
          'Was the constraint name system generated? -  GENERATED NAME or USER NAME'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_constraints.bad IS
          'Creating this constraint should give ORA-02436.  Rewrite it before 2000 AD.'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_constraints.rely IS
          'If set, this flag will be used in optimizer'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_constraints.last_change IS
          'The date when this column was last enabled or disabled'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_cons_columns IS
          'Information about accessible columns in constraint definitions'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_cons_columns.owner IS
          'Owner of the constraint definition'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_cons_columns.constraint_name IS
          'Name associated with the constraint definition'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_cons_columns.table_name IS
          'Name associated with table with constraint definition'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_cons_columns.column_name IS
          'Name associated with column specified in the constraint definition'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_cons_columns.position IS
          'Original position of column in definition'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_data_files IS
          'Information about database files'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_data_files.file_name IS
          'Name of the database file'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_data_files.file_id IS
          'ID of the database file'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_data_files.tablespace_name IS
          'Name of the tablespace to which the file belongs'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_data_files.bytes IS
          'Size of the file in bytes'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_data_files.blocks IS
          'Size of the file in ORACLE blocks'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_data_files.status IS
          'File status:  "INVALID" or "AVAILABLE"'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_db_links IS
          'All database links in the database'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_db_links.owner IS
          'Owner of the database link'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_db_links.db_link IS
          'Name of the database link'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_db_links.username IS
          'Name of user to log on as'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_db_links.password IS
          'Password for logon'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_db_links.host IS
          'SQL*Net string for connect'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_db_links.created IS
          'Creation time of the database link'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_ddl_locks IS
        'All DDL locks held in the database and all outstanding requests for
         a DDL lock'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_ddl_locks.session_id IS
          'Session identifier'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_ddl_locks.owner IS
          'Owner of the lock'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_ddl_locks.name IS
          'Name of the lock'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_ddl_locks.type IS
          'Lock type: Cursor, Table/Procedure, Body, Trigger, Index, Cluster'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_ddl_locks.mode_held IS
          'Lock mode: None, Null, Share, Exclusive'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_ddl_locks.mode_requested IS
          'Lock request type: None, Null, Share, Exclusive'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_dependencies IS
          'Dependencies to and from objects'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_dependencies.owner IS
          'Owner of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_dependencies.name IS
          'Name of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_dependencies.type IS
          'Type of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_dependencies.referenced_owner IS
          'Owner of referenced object (remote owner if remote object)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_dependencies.referenced_name IS
          'Name of referenced object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_dependencies.referenced_type IS
          'Type of referenced object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_dependencies.referenced_link_name IS
          'Name of dblink if this is a remote object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_dependencies.dependency_type IS
          'Two values: REF when the dependency is a REF dependency; HARD otherwise'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_dml_locks IS
        'All DML locks held in the database and all outstanding requests for
         a DML lock'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_dml_locks.session_id IS
          'Session holding or aquiring the lock'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_dml_locks.owner IS
          'Owner of the lock'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_dml_locks.name IS
          'Name of the lock'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_dml_locks.mode_held IS
          'Lock mode'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_dml_locks.mode_requested IS
          'Lock request type: None, Null, Share, Exclusive'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_dml_locks.last_convert IS
          'The last convert'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_dml_locks.blocking_others IS
          'Blocking others'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_errors IS
          'Current errors on all stored objects in the database'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_errors.owner IS
          'The owner of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_errors.name IS
          'Name of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_errors.type IS
        'Type of object: "VIEW", "PROCEDURE", "FUNCTION", "PACKAGE" or "PACKAGE BODY"'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_errors.sequence IS
          'Sequence number used for ordering purposes'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_errors.line IS
          'Line number at which this error occurs'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_errors.position IS
          'Position in the line at which this error occurs'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_errors.text IS
          'Text of the error'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_exp_files IS
          'Description of export files'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_exp_files.exp_version IS
          'Version number of the export session'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_exp_files.exp_type IS
          'Type of export file (full, cumulative or incremental)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_exp_files.file_name IS
          'Name of the export file'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_exp_files.user_name IS
          'Name of user who executed export'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_exp_files.timestamp IS
          'Timestamp of the export session'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_exp_objects IS
          'Objects that have been incrementally exported'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_exp_objects.owner IS
          'Owner of exported object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_exp_objects.object_name IS
          'Name of exported object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_exp_objects.object_type IS
          'Type of exported object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_exp_objects.cumulative IS
          'Timestamp of last cumulative export'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_exp_objects.incremental IS
          'Timestamp of last incremental export'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_exp_objects.export_version IS
          'The id of the export session'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_exp_version IS
          'Version number of the last export session'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_exp_version.exp_version IS
          'Version number of the last export session'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_extents IS
          'Extents comprising all segments in the database'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_extents.owner IS
          'Owner of the segment associated with the extent'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_extents.segment_name IS
          'Name of the segment associated with the extent'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_extents.segment_type IS
          'Type of the segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_extents.tablespace_name IS
          'Name of the tablespace containing the extent'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_extents.extent_id IS
          'Extent number in the segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_extents.file_id IS
          'Name of the file containing the extent'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_extents.block_id IS
          'Starting block number of the extent'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_extents.bytes IS
          'Size of the extent in bytes'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_extents.blocks IS
          'Size of the extent in ORACLE blocks'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_extents.relative_fno IS
          'Relative number of the file containing the segment header'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_extents.partition_name IS
          'Partition/Subpartition Name, if any, of the segment'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_free_space IS
          'Free extents in all tablespaces'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_free_space.tablespace_name IS
          'Name of the tablespace containing the extent'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_free_space.file_id IS
          'ID number of the file containing the extent'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_free_space.block_id IS
          'Starting block number of the extent'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_free_space.bytes IS
          'Size of the extent in bytes'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_free_space.blocks IS
          'Size of the extent in ORACLE blocks'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_free_space.relative_fno IS
          'Relative number of the file containing the extent'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_indexes IS
          'Description for all indexes in the database'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.owner IS
          'Username of the owner of the index'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.index_name IS
          'Name of the index'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.index_type IS
          'Type of index'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.table_owner IS
          'Owner of the indexed object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.table_name IS
          'Name of the indexed object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.table_type IS
          'Type of the indexed object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.uniqueness IS
          'Uniqueness status of the index: "UNIQUE",  "NONUNIQUE", or "BITMAP"'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.compression IS
          'Compression property of the index: "ENABLED",  "DISABLED", or NULL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.prefix_length IS
          'Number of key columns in the prefix used for compression'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.tablespace_name IS
          'Name of the tablespace containing the index'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.ini_trans IS
          'Initial number of transactions'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.max_trans IS
          'Maximum number of transactions'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.initial_extent IS
          'Size of the initial extent'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.next_extent IS
          'Size of secondary extents'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.min_extents IS
          'Minimum number of extents allowed in the segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.max_extents IS
          'Maximum number of extents allowed in the segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.pct_increase IS
          'Percentage increase in extent size'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.pct_threshold IS
          'Threshold percentage of block space allowed per index entry'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.include_column IS
          'User column-id for last column to be included in index-organized table top index'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.freelists IS
          'Number of process freelists allocated in this segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.freelist_groups IS
          'Number of freelist groups allocated to this segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.pct_free IS
          'Minimum percentage of free space in a block'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.logging IS
          'Logging attribute'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.blevel IS
          'B-Tree level'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.leaf_blocks IS
          'The number of leaf blocks in the index'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.distinct_keys IS
          'The number of distinct keys in the index'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.avg_leaf_blocks_per_key IS
          'The average number of leaf blocks per key'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.avg_data_blocks_per_key IS
          'The average number of data blocks per key'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.clustering_factor IS
        'A measurement of the amount of (dis)order of the table this index is for'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.status IS
          'Whether index is in Direct Load State or not'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.num_rows IS
          'Number of rows in this index'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.sample_size IS
          'The sample size used in analyzing this index'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.last_analyzed IS
          'The date of the most recent time this index was analyzed'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.degree IS
          'The number of threads per instance for scanning the partitioned index'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.instances IS
          'Number of instances across which the indexes to be scanned'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.partitioned IS
          'Is this index partitioned? YES or NO'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.temporary IS
          'Can the current session only see data that it place in this object itself?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.generated IS
          'Was the name of this index system generated?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.secondary IS
          'Is the index object created as part of icreate for domain indexes?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.buffer_pool IS
          'The default buffer pool to be used for index blocks'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.user_stats IS
          'Were the statistics entered directly by the user?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.duration IS
          'If index on temporary table, then duration is sys$session or sys$transaction else NULL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.pct_direct_access IS
          'If index on IOT, then this is percentage of rows with Valid guess'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.ityp_owner IS
          'If domain index, then this is the indextype owner'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.ityp_name IS
          'If domain index, then this is the name of the associated indextype'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.parameters IS
          'If domain index, then this is the parameter string'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_indexes.global_stats IS
          'Are the statistics calculated without merging underlying partitions?'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_ind_columns IS
          'COLUMNs comprising INDEXes on all TABLEs and CLUSTERs'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_ind_columns.index_owner IS
          'Index owner'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_ind_columns.index_name IS
          'Index name'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_ind_columns.table_owner IS
          'Table or cluster owner'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_ind_columns.table_name IS
          'Table or cluster name'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_ind_columns.column_name IS
          'Column name'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_ind_columns.column_expression IS
          'For virtual columns, the expression defining the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_ind_columns.column_position IS
          'Position of column within index'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_ind_columns.column_length IS
          'Indexed length of the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_ind_columns.descend IS
          'Y/N, Y if this column is sorted in descending order'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_locks IS
        'All locks or latch held in the database, and all outstanding requests for
         a lock or latch. This view includes DML locks and DDL locks'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_locks.session_id IS
          'Session holding or aquiring the lock'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_locks.lock_type IS
          'Lock type'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_locks.mode_held IS
         'Lock mode'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_locks.mode_requested IS
          'Lock request type'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_locks.lock_id1 IS
          'Type-specific lock identifier, part 1'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_locks.lock_id2 IS
          'Type-specific lock identifier, part 2'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_locks.last_convert IS
          'The last convert'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_locks.blocking_others IS
          'Blocking others'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_objects IS
          'All objects in the database'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_objects.owner IS
          'Username of the owner of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_objects.object_name IS
          'Name of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_objects.subobject_name IS
          'Name of the sub-object (for example, partititon)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_objects.object_id IS
          'Object number of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_objects.data_object_id IS
          'Object number of the segment which contains the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_objects.object_type IS
          'Type of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_objects.created IS
          'Timestamp for the creation of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_objects.last_ddl_time IS
        'Timestamp for the last DDL change (including GRANT and REVOKE) to the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_objects.timestamp IS
          'Timestamp for the specification of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_objects.status IS
          'Status of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_objects.temporary IS
          'Can the current session only see data that it placed in this object itself?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_objects.generated IS
          'Was the name of this object system generated?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_objects.secondary IS
          'Is this a secondary object created as part of icreate for domain indexes?'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_object_size IS
          'Sizes, in bytes, of various pl/sql objects'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_object_size.owner IS
          'Owner of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_object_size.name IS
          'Name of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_object_size.type IS
        'Type of the object: "TABLE", "VIEW", "SYNONYM", "SEQUENCE", "PROCEDURE",
         "FUNCTION", "PACKAGE" or "PACKAGE BODY"'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_object_size.source_size IS
        'Size of the source, in bytes.  Must be in memory during compilation, or
         dynamic recompilation'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_object_size.parsed_size IS
        'Size of the parsed form of the object, in bytes.  Must be in memory when
         an object is being compiled that references this object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_object_size.code_size IS
          'Code size, in bytes.  Must be in memory when this object is executing'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_object_size.error_size IS
        'Size of error messages, in bytes.  In memory during the compilation of
         the object when there are compilation errors'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_obj_audit_opts IS
          'Auditing options for all tables and views'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_obj_audit_opts.owner IS
          'Owner of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_obj_audit_opts.object_name IS
          'Name of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_obj_audit_opts.object_type IS
          'Type of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_obj_audit_opts.alt IS
          'Auditing ALTER WHENEVER SUCCESSFUL / UNSUCCESSFUL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_obj_audit_opts.aud IS
          'Auditing AUDIT WHENEVER SUCCESSFUL / UNSUCCESSFUL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_obj_audit_opts.com IS
          'Auditing COMMENT WHENEVER SUCCESSFUL / UNSUCCESSFUL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_obj_audit_opts.del IS
          'Auditing DELETE WHENEVER SUCCESSFUL / UNSUCCESSFUL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_obj_audit_opts.gra IS
          'Auditing GRANT WHENEVER SUCCESSFUL / UNSUCCESSFUL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_obj_audit_opts.ind IS
          'Auditing INDEX WHENEVER SUCCESSFUL / UNSUCCESSFUL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_obj_audit_opts.ins IS
          'Auditing INSERT WHENEVER SUCCESSFUL / UNSUCCESSFUL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_obj_audit_opts.loc IS
          'Auditing LOCK WHENEVER SUCCESSFUL / UNSUCCESSFUL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_obj_audit_opts.ren IS
          'Auditing RENAME WHENEVER SUCCESSFUL / UNSUCCESSFUL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_obj_audit_opts.sel IS
          'Auditing SELECT WHENEVER SUCCESSFUL / UNSUCCESSFUL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_obj_audit_opts.upd IS
          'Auditing UPDATE WHENEVER SUCCESSFUL / UNSUCCESSFUL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_obj_audit_opts.ref IS
          'Auditing REFERENCES WHENEVER SUCCESSFUL / UNSUCCESSFUL (not used)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_obj_audit_opts.exe IS
          'Auditing EXECUTE WHENEVER SUCCESSFUL / UNSUCCESSFUL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_obj_audit_opts.cre IS
          'Auditing CREATE WHENEVER SUCCESSFUL / UNSUCCESSFUL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_obj_audit_opts.rea IS
          'Auditing READ WHENEVER SUCCESSFUL / UNSUCCESSFUL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_obj_audit_opts.wri IS
          'Auditing WRITE WHENEVER SUCCESSFUL / UNSUCCESSFUL'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_priv_audit_opts IS
        'Describes current system privileges being audited across the system
         and by user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_priv_audit_opts.user_name IS
          'User name if by user auditing, else null for system wide auditing'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_priv_audit_opts.proxy_name IS
        'Name of the proxy user if auditing is being done for operations
         being done on behalf of a client. Null if auditing is being done
         for operations done by the client directly'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_priv_audit_opts.privilege IS
          'Name of the system privilege being audited'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_priv_audit_opts.success IS
          'Mode for WHENEVER SUCCESSFUL system auditing'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_priv_audit_opts.failure IS
          'Mode for WHENEVER NOT SUCCESSFUL system auditing'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_profiles IS
          'Display all profiles and their limits'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_profiles.profile IS
          'Profile name'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_profiles.resource_name IS
          'Resource name'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_profiles.resource_type IS
          'Indicates whether the resource profile is a KERNEL or a PASSWORD parameter'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_profiles.limit IS
          'Limit placed on this resource for this profile'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_roles IS
          'All Roles which exist in the database'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_roles.role IS
          'Role Name'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_roles.password_required IS
          'Indicates if the role requires a password to be enabled'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_role_privs IS
          'Roles granted to users and roles'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_role_privs.grantee IS
          'Grantee Name, User or Role receiving the grant'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_role_privs.granted_role IS
          'Granted role name'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_role_privs.admin_option IS
          'Grant was with the ADMIN option'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_role_privs.default_role IS
          'Role is designated as a DEFAULT ROLE for the user'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_rollback_segs IS
          'Description of rollback segments'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_rollback_segs.segment_name IS
          'Name of the rollback segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_rollback_segs.owner IS
          'Owner of the rollback segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_rollback_segs.tablespace_name IS
          'Name of the tablespace containing the rollback segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_rollback_segs.segment_id IS
          'ID number of the rollback segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_rollback_segs.file_id IS
          'ID number of the file containing the segment header'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_rollback_segs.block_id IS
          'ID number of the block containing the segment header'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_rollback_segs.initial_extent IS
          'Initial extent size in bytes'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_rollback_segs.next_extent IS
          'Secondary extent size in bytes'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_rollback_segs.min_extents IS
          'Minimum number of extents'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_rollback_segs.max_extents IS
          'Maximum number of extents'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_rollback_segs.pct_increase IS
          'Percent increase for extent size'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_rollback_segs.status IS
          'Rollback segment status'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_rollback_segs.instance_num IS
          'Rollback segment owning parallel server instance number'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_rollback_segs.relative_fno IS
          'Relative number of the file containing the segment header'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_segments IS
          'Storage allocated for all database segments'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_segments.owner IS
          'Username of the segment owner'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_segments.segment_name IS
          'Name, if any, of the segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_segments.partition_name IS
          'Partition/Subpartition Name, if any, of the segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_segments.segment_type IS
        'Type of segment:  "TABLE", "CLUSTER", "INDEX", "ROLLBACK",
         "DEFERRED ROLLBACK", "TEMPORARY", or "CACHE"'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_segments.tablespace_name IS
          'Name of the tablespace containing the segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_segments.header_file IS
          'ID of the file containing the segment header'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_segments.header_block IS
          'ID of the block containing the segment header'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_segments.bytes IS
          'Size, in bytes, of the segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_segments.blocks IS
          'Size, in Oracle blocks, of the segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_segments.extents IS
          'Number of extents allocated to the segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_segments.initial_extent IS
          'Size, in Oracle blocks, of the initial extent of the segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_segments.next_extent IS
        'Size, in Oracle blocks, of the next extent to be allocated
         to the segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_segments.min_extents IS
          'Minimum number of extents allowed in the segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_segments.max_extents IS
          'Maximum number of extents allowed in the segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_segments.pct_increase IS
        'Percent by which to increase the size of the next extent
         to be allocated'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_segments.freelists IS
          'Number of process freelists allocated in this segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_segments.freelist_groups IS
          'Number of freelist groups allocated in this segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_segments.relative_fno IS
          'Relative number of the file containing the segment header'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_segments.buffer_pool IS
          'The default buffer pool to be used for segments blocks'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_sequences IS
          'Description of all SEQUENCEs in the database'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_sequences.sequence_owner IS
          'Name of the owner of the sequence'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_sequences.sequence_name IS
          'SEQUENCE name'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_sequences.min_value IS
          'Minimum value of the sequence'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_sequences.max_value IS
          'Maximum value of the sequence'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_sequences.increment_by IS
          'Value by which sequence is incremented'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_sequences.cycle_flag IS
          'Does sequence wrap around on reaching limit?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_sequences.order_flag IS
          'Are sequence numbers generated in order?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_sequences.cache_size IS
          'Number of sequence numbers to cache'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_sequences.last_number IS
          'Last sequence number written to disk'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_snapshots IS
          'All snapshots in the database'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_snapshots.owner IS
          'Owner of the snapshot'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_snapshots.name IS
          'The view used by users and applications for viewing the snapshot'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_snapshots.table_name IS
        'Table the snapshot is stored in -- has an extra column for the master rowid'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_snapshots.master_view IS
        'View of the master table, owned by the snapshot owner, used for refreshes'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_snapshots.master_owner IS
          'Owner of the master table'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_snapshots.master IS
          'Name of the master table that this snapshot is a copy of'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_snapshots.master_link IS
          'Database link name to the master site'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_snapshots.can_use_log IS
          'If NO, this snapshot is complex and will never use a log'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_snapshots.updatable IS
          'If NO, the snapshot is read only.  Look up REPLICATION'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_snapshots.last_refresh IS
          'SYSDATE from the master site at the time of the last refresh'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_snapshots.error IS
          'The number of failed automatic refreshes since last successful refresh'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_snapshots.type IS
          'The type of refresh (complete,fast,force) for all automatic refreshes'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_snapshots.next IS
          'The date function used to compute next refresh dates'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_snapshots.start_with IS
          'The date function used to compute next refresh dates'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_snapshots.refresh_group IS
          'All snapshots in a given refresh group get refreshed in the same transaction'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_snapshots.refresh_method IS
          'The values used to drive a fast refresh of the snapshot'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_snapshots.update_trig IS
          'The name of the trigger which fills the UPDATE_LOG'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_snapshots.update_log IS
          'The table which logs changes made to an updatable snapshots'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_snapshots.query IS
          'The original query that this snapshot is an instantiation of'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_snapshots.fr_operations IS
          'If REGENERATE, then the fast refresh operations have not been generated'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_snapshots.cr_operations IS
          'If REGENERATE, then the complete refresh operations have not been generated'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_snapshots.master_rollback_seg IS
          'Rollback segment to use at the master site'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_snapshots.status IS
          'The status of the contents of the snapshot'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_snapshots.refresh_mode IS
          'This indicates how and when the snapshot will be refreshed'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_snapshots.prebuilt IS
          'If YES, this snapshot uses a prebuilt table as the base table'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_snapshot_logs IS
          'All snapshot logs in the database'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_snapshot_logs.log_owner IS
          'Owner of the snapshot log'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_snapshot_logs.master IS
          'Name of the master table which the log logs changes of'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_snapshot_logs.log_table IS
        'Log table; holds rowids and timestamps of rows which changed in the
         master'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_snapshot_logs.log_trigger IS
          'An after-row trigger on the master which inserts rows into the log'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_snapshot_logs.filter_columns IS
          'If YES, the snapshot log records filter column information'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_snapshot_logs.rowids IS
          'If YES, the snapshot log records rowid information'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_snapshot_logs.primary_key IS
          'If YES, the snapshot log records primary key information'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_snapshot_logs.current_snapshots IS
        'One date per snapshot -- the date the snapshot of the master
         last refreshed'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_snapshot_logs.snapshot_id IS
          'Unique identifier of the snapshot'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_source IS
          'Source of all stored objects in the database'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_source.owner IS
          'Owner of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_source.name IS
          'Name of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_source.type IS
          'Type of the object: "PROCEDURE", "FUNCTION", "PACKAGE" or "PACKAGE BODY"'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_source.line IS
          'Line number of this line of source'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_source.text IS
          'Source text'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_stmt_audit_opts IS
          'Describes current system auditing options across the system and by user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_stmt_audit_opts.user_name IS
          'User name if by user auditing, else null for system wide auditing'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_stmt_audit_opts.proxy_name IS
        'Name of the proxy user if auditing is being done for operations being done on
        behalf of a client. Null if auditing is being done for operations done by the
        client directly'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_stmt_audit_opts.audit_option IS
          'Name of the system auditing option'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_stmt_audit_opts.success IS
          'Mode for WHENEVER SUCCESSFUL system auditing'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_stmt_audit_opts.failure IS
          'Mode for WHENEVER NOT SUCCESSFUL system auditing'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_synonyms IS
          'All synonyms in the database'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_synonyms.owner IS
          'Username of the owner of the synonym'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_synonyms.synonym_name IS
          'Name of the synonym'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_synonyms.table_owner IS
          'Owner of the object referenced by the synonym'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_synonyms.table_name IS
          'Name of the object referenced by the synonym'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_synonyms.db_link IS
          'Name of the database link referenced in a remote synonym'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_sys_privs IS
          'System privileges granted to users and roles'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_sys_privs.grantee IS
          'Grantee Name, User or Role receiving the grant'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_sys_privs.privilege IS
          'System privilege'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_sys_privs.admin_option IS
          'Grant was with the ADMIN option'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_tables IS
          'Description of all tables in the database'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tables.owner IS
          'Owner of the table'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tables.table_name IS
          'Name of the table'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tables.tablespace_name IS
          'Name of the tablespace containing the table'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tables.cluster_name IS
          'Name of the cluster, if any, to which the table belongs'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tables.iot_name IS
          'Name of the index-only table, if any, to which the overflow entry belongs'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tables.pct_free IS
          'Minimum percentage of free space in a block'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tables.pct_used IS
          'Minimum percentage of used space in a block'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tables.ini_trans IS
          'Initial number of transactions'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tables.max_trans IS
          'Maximum number of transactions'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tables.initial_extent IS
          'Size of the initial extent in bytes'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tables.next_extent IS
          'Size of secondary extents in bytes'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tables.min_extents IS
          'Minimum number of extents allowed in the segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tables.max_extents IS
          'Maximum number of extents allowed in the segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tables.pct_increase IS
          'Percentage increase in extent size'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tables.freelists IS
          'Number of process freelists allocated in this segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tables.freelist_groups IS
          'Number of freelist groups allocated in this segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tables.logging IS
          'Logging attribute'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tables.backed_up IS
          'Has table been backed up since last modification?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tables.num_rows IS
          'The number of rows in the table'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tables.blocks IS
          'The number of used blocks in the table'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tables.empty_blocks IS
          'The number of empty (never used) blocks in the table'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tables.avg_space IS
          'The average available free space in the table'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tables.chain_cnt IS
          'The number of chained rows in the table'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tables.avg_row_len IS
          'The average row length, including row overhead'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tables.avg_space_freelist_blocks IS
          'The average freespace of all blocks on a freelist'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tables.num_freelist_blocks IS
          'The number of blocks on the freelist'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tables.degree IS
          'The number of threads per instance for scanning the table'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tables.instances IS
          'The number of instances across which the table is to be scanned'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tables.cache IS
          'Whether the table is to be cached in the buffer cache'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tables.table_lock IS
          'Whether table locking is enabled or disabled'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tables.sample_size IS
          'The sample size used in analyzing this table'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tables.last_analyzed IS
          'The date of the most recent time this table was analyzed'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tables.partitioned IS
          'Is this table partitioned? YES or NO'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tables.iot_type IS
          'If index-only table, then IOT_TYPE is IOT or IOT_OVERFLOW else NULL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tables.temporary IS
          'Can the current session only see data that it place in this object itself?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tables.secondary IS
          'Is this table object created as part of icreate for domain indexes?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tables.nested IS
          'Is the table a nested table?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tables.buffer_pool IS
          'The default buffer pool to be used for table blocks'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tables.row_movement IS
          'Whether partitioned row movement is enabled or disabled'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tables.global_stats IS
          'Are the statistics calculated without merging underlying partitions?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tables.user_stats IS
          'Were the statistics entered directly by the user?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tables.duration IS
          'If temporary table, then duration is sys$session or sys$transaction else NULL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tables.skip_corrupt IS
          'Whether skip corrupt blocks is enabled or disabled'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tables.monitoring IS
          'Should we keep track of the amount of modification?'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_tablespaces IS
          'Description of all tablespaces'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tablespaces.tablespace_name IS
          'Tablespace name'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tablespaces.initial_extent IS
          'Default initial extent size'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tablespaces.next_extent IS
          'Default incremental extent size'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tablespaces.min_extents IS
          'Default minimum number of extents'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tablespaces.max_extents IS
          'Default maximum number of extents'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tablespaces.pct_increase IS
          'Default percent increase for extent size'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tablespaces.min_extlen IS
          'Minimum extent size for the tablespace'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tablespaces.status IS
          'Tablespace status: "ONLINE" or "OFFLINE"'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tablespaces.contents IS
          'Tablespace contents: "PERMANENT", or "TEMPORARY"'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tablespaces.logging IS
          'Default logging attribute'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tablespaces.extent_management IS
          'Extent management tracking: "DICTIONARY" or "LOCAL"'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tablespaces.allocation_type IS
          'Type of extent allocation in effect for this tablespace'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tablespaces.plugged_in IS
          'YES - the tablespace is plugged in; NO - it is not plugged in'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_tab_columns IS
          'Columns of all tables, views and clusters'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tab_columns.owner IS
          'Owner of the table, view or cluster'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tab_columns.table_name IS
          'Table, view or cluster name'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tab_columns.column_name IS
          'Column name'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tab_columns.data_type IS
          'Datatype of the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tab_columns.data_type_mod IS
          'Datatype modifier of the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tab_columns.data_type_owner IS
          'Owner of the datatype of the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tab_columns.data_length IS
          'Length of the column in bytes'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tab_columns.data_precision IS
          'Length: decimal digits (NUMBER) or binary digits (FLOAT)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tab_columns.data_scale IS
          'Digits to right of decimal point in a number'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tab_columns.nullable IS
          'Does column allow NULL values?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tab_columns.column_id IS
          'Sequence number of the column as created'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tab_columns.default_length IS
          'Length of default value for the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tab_columns.data_default IS
          'Default value for the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tab_columns.num_distinct IS
          'The number of distinct values for the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tab_columns.low_value IS
          'The second smallest value for the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tab_columns.high_value IS
          'The second highest value for the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tab_columns.density IS
          'The density of the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tab_columns.num_nulls IS
          'The number of nulls in the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tab_columns.num_buckets IS
          'The number of buckets in histogram for the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tab_columns.last_analyzed IS
          'The date of the most recent time this column was analyzed'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tab_columns.sample_size IS
          'The sample size used in analyzing this column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tab_columns.character_set_name IS
          'Character set name'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tab_columns.char_col_decl_length IS
          'Declaration length of character type column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tab_columns.global_stats IS
          'Are the statistics calculated without merging underlying partitions?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tab_columns.user_stats IS
          'Were the statistics entered directly by the user?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tab_columns.avg_col_len IS
          'The average length of the column in bytes'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_tab_comments IS
          'Comments on all tables and views in the database'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tab_comments.owner IS
          'Owner of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tab_comments.table_name IS
          'Name of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tab_comments.table_type IS
          'Type of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tab_comments.comments IS
          'Comment on the object'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_tab_privs IS
          'All grants on objects in the database'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tab_privs.grantee IS
          'User to whom access was granted'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tab_privs.owner IS
          'Owner of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tab_privs.table_name IS
          'Name of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tab_privs.grantor IS
          'Name of the user who performed the grant'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tab_privs.privilege IS
          'Table Privilege'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_tab_privs.grantable IS
          'Privilege is grantable'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_triggers IS
          'All triggers in the database'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_triggers.owner IS
          'Owner of the trigger'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_triggers.trigger_name IS
          'Name of the trigger'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_triggers.trigger_type IS
          'When the trigger fires - BEFORE/AFTER and STATEMENT/ROW'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_triggers.triggering_event IS
          'Statement that will fire the trigger - INSERT, UPDATE and/or DELETE'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_triggers.table_owner IS
          'Owner of the table that this trigger is associated with'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_triggers.base_object_type IS
          'The base object on which the trigger is defined: TABLE, VIEW, SCHEMA, or DATABASE'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_triggers.table_name IS
          'Name of the table that this trigger is associated with'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_triggers.column_name IS
          'The name of the column on which the trigger is defined over'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_triggers.referencing_names IS
          'Names used for referencing to OLD and NEW values within the trigger'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_triggers.when_clause IS
        'WHEN clause must evaluate to true in order for triggering body
         to execute'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_triggers.status IS
          'If DISABLED then trigger will not fire'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_triggers.description IS
          'Trigger description, useful for re-creating trigger creation statement'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_triggers.action_type IS
          'The action type of the trigger body: CALL or PL/SQL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_triggers.trigger_body IS
          'Action taken by this trigger when it fires'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_trigger_cols IS
          'Column usage in all triggers'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_trigger_cols.trigger_owner IS
          'Owner of the trigger'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_trigger_cols.trigger_name IS
          'Name of the trigger'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_trigger_cols.table_owner IS
          'Owner of the table'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_trigger_cols.table_name IS
          'Name of the table on which the trigger is defined'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_trigger_cols.column_name IS
          'Name of the column used in trigger definition'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_trigger_cols.column_list IS
          'Is column specified in UPDATE OF clause?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_trigger_cols.column_usage IS
          'Usage of column within trigger body'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_ts_quotas IS
          'Tablespace quotas for all users'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_ts_quotas.tablespace_name IS
          'Tablespace name'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_ts_quotas.username IS
          'User with resource rights on the tablespace'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_ts_quotas.bytes IS
          'Number of bytes charged to the user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_ts_quotas.max_bytes IS
          'User''s quota in bytes.  NULL if no limit'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_ts_quotas.blocks IS
          'Number of ORACLE blocks charged to the user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_ts_quotas.max_blocks IS
          'User''s quota in ORACLE blocks.  NULL if no limit'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_users IS
          'Information about all users of the database'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_users.username IS
          'Name of the user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_users.user_id IS
          'ID number of the user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_users.password IS
          'Encrypted password'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_users.account_status IS
          'Indicates if the account is locked, expired, or unlocked'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_users.lock_date IS
          'Date the account was locked if account status was locked'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_users.expiry_date IS
          'Date of expiration of the account'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_users.default_tablespace IS
          'Default tablespace for data'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_users.temporary_tablespace IS
          'Default tablespace for temporary tables'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_users.created IS
          'User creation date'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_users.profile IS
          'User resource profile name'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_users.initial_rsrc_consumer_group IS
          'User''s initial consumer group'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_users.external_name IS
          'User external name'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_views IS
          'Text of all views in the database'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_views.owner IS
          'Owner of the view'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_views.view_name IS
          'Name of the view'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_views.text_length IS
          'Length of the view text'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_views.text IS
          'View text'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_views.type_text_length IS
          'Length of the type clause of the object view'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_views.type_text IS
          'Type clause of the object view'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_views.oid_text_length IS
          'Length of the WITH OBJECT OID clause of the object view'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_views.oid_text IS
          'WITH OBJECT OID clause of the object view'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_views.view_type_owner IS
          'Owner of the type of the view if the view is an object view'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_views.view_type IS
          'Type of the view if the view is an object view'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dba_waiters IS
        'All locks or latch held in the database, and all outstanding requests
         for a lock or latch. This view includes DML locks and DDL locks'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_waiters.waiting_session IS
          'Session waiting for a lock'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_waiters.holding_session IS
          'Session holding a lock'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_waiters.type IS
          'Lock type'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_waiters.mode_held IS
         'Lock mode: Row-S (SS), Row-X (SX), Share, S/Row-X(SSX), Exclusive'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_waiters.mode_requested IS
        'Lock request type: Null, Row-S (SS), Row-X (SX), Share, S/Row-X(SSX),
         Exclusive'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_waiters.lock_id1 IS
          'Type-specific lock identifier, part 1'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dba_waiters.lock_id2 IS
          'Type-specific lock identifier, part 2'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.user_audit_object IS
        'Audit trail records for statements concerning objects, specifically:
         table, cluster, view, index, sequence,  [public] database link,
         [public] synonym, procedure, trigger, rollback segment, tablespace,
         role, user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_object.os_username IS
          'Operating System logon user name of the user whose actions were audited'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_object.username IS
          'Name (not ID number) of the user whose actions were audited'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_object.userhost IS
        'Numeric instance ID for the Oracle instance from which the user is
         accessing the database.  Used only in environments with distributed
         file systems and shared database files (e.g., clustered Oracle on DEC
         VAX/VMS clusters)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_object.terminal IS
          'Identifier for the user''s terminal'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_object.timestamp IS
        'Timestamp for the creation of the audit trail entry (Timestamp for the
         user''s logon for entries created by AUDIT SESSION)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_object.owner IS
          'Creator of object affected by the action'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_object.obj_name IS
          'Name of the object affected by the action'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_object.action_name IS
          'Name of the action type corresponding to the numeric code in ACTION'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_object.new_owner IS
          'The owner of the object named in the NEW_NAME column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_object.new_name IS
        'New name of object after RENAME, or name of underlying object
         (e.g. CREATE INDEX owner.obj_name ON new_owner.new_name)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_object.ses_actions IS
        'Session summary. A string of 11 characters, one for each action type,
         in this order: Alter, Audit, Comment, Delete, Grant, Index, Insert,
         Lock, Rename, Select, Update.  Values:  "-" = None, "S" = Success,
         "F" = Failure, "B" = Both'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_object.comment_text IS
          'Text comment on the audit trail entry'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_object.sessionid IS
          'Numeric ID for each Oracle session'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_object.entryid IS
          'Numeric ID for each audit trail entry in the session'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_object.statementid IS
          'Numeric ID for each statement run (a statement may cause many actions)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_object.returncode IS
          'Oracle error code generated by the action.  Zero if the action succeeded'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_object.priv_used IS
          'System privilege used to execute the action'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_object.object_label IS
          'Optional Trusted ORACLE label associated with object being audited'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_object.session_label IS
          'Trusted ORACLE label associated with user session'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.user_audit_session IS
          'All audit trail entries concerning connect and disconnect'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_session.os_username IS
          'Operating System logon user name of the user whose actions were audited'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_session.username IS
          'Name (not ID number) of the user whose actions were audited'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_session.userhost IS
        'Numeric instance ID for the Oracle instance from which the user is
         accessing the database.  Used only in environments with distributed
         file systems and shared database files (e.g., clustered Oracle on DEC
         VAX/VMS clusters)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_session.terminal IS
          'Identifier for the user''s terminal'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_session.timestamp IS
        'Timestamp for the creation of the audit trail entry (Timestamp for the
         user''s logon for entries created by AUDIT SESSION)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_session.action_name IS
          'Name of the action type corresponding to the numeric code in ACTION'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_session.logoff_time IS
          'Timestamp for user logoff'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_session.logoff_lread IS
          'Logical reads for the session'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_session.logoff_pread IS
          'Physical reads for the session'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_session.logoff_lwrite IS
          'Logical writes for the session'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_session.logoff_dlock IS
          'Deadlocks detected during the session'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_session.sessionid IS
          'Numeric ID for each Oracle session'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_session.returncode IS
          'Oracle error code generated by the action.  Zero if the action succeeded'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_session.session_label IS
          'Trusted ORACLE label associated with user session'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.user_audit_statement IS
        'Audit trail records concerning  grant, revoke, audit, noaudit and
         alter system'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_statement.os_username IS
          'Operating System logon user name of the user whose actions were audited'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_statement.username IS
          'Name (not ID number) of the user whose actions were audited'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_statement.userhost IS
        'Numeric instance ID for the Oracle instance from which the user is
         accessing the database.  Used only in environments with distributed
         file systems and shared database files (e.g., clustered Oracle on DEC
         VAX/VMS clusters)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_statement.terminal IS
          'Identifier for the user''s terminal'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_statement.timestamp IS
        'Timestamp for the creation of the audit trail entry (Timestamp for the
         user''s logon for entries created by AUDIT SESSION)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_statement.owner IS
          'Creator of object affected by the action'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_statement.obj_name IS
          'Name of the object affected by the action'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_statement.action_name IS
          'Name of the action type corresponding to the numeric code in ACTION'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_statement.new_name IS
        'New name of object after RENAME, or name of underlying object
         (e.g. CREATE INDEX owner.obj_name ON new_owner.new_name)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_statement.obj_privilege IS
          'Object privileges granted/revoked by a GRANT/REVOKE statement'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_statement.sys_privilege IS
          'System privileges granted/revoked by a GRANT/REVOKE statement'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_statement.admin_option IS
          'If role/sys_priv was granted WITH ADMIN OPTION, A/-'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_statement.grantee IS
          'The name of the grantee specified in a GRANT/REVOKE statement'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_statement.audit_option IS
          'Auditing option set with the audit statement'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_statement.ses_actions IS
        'Session summary. A string of 11 characters, one for each action type,
         in this order: Alter, Audit, Comment, Delete, Grant, Index, Insert,
         Lock, Rename, Select, Update.  Values:  "-" = None, "S" = Success,
         "F" = Failure, "B" = Both'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_statement.comment_text IS
          'Text comment on the audit trail entry'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_statement.sessionid IS
          'Numeric ID for each Oracle session'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_statement.entryid IS
          'Numeric ID for each audit trail entry in the session'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_statement.statementid IS
          'Numeric ID for each statement run (a statement may cause many actions)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_statement.returncode IS
          'Oracle error code generated by the action.  Zero if the action succeeded'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_statement.priv_used IS
          'System privilege used to execute the action'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_statement.session_label IS
          'Trusted ORACLE label associated with user session'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.user_audit_trail IS
          'Audit trail entries relevant to the user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_trail.os_username IS
          'Operating System logon user name of the user whose actions were audited'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_trail.username IS
          'Name (not ID number) of the user whose actions were audited'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_trail.userhost IS
        'Numeric instance ID for the Oracle instance from which the user is
         accessing the database.  Used only in environments with distributed
         file systems and shared database files (e.g., clustered Oracle on DEC
         VAX/VMS clusters)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_trail.terminal IS
          'Identifier for the user''s terminal'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_trail.timestamp IS
        'Timestamp for the creation of the audit trail entry (Timestamp
         for the user''s logon for entries created by AUDIT SESSION)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_trail.owner IS
          'Creator of object affected by the action'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_trail.obj_name IS
          'Name of the object affected by the action'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_trail.action IS
        'Numeric action type code.  The corresponding name of the action type
         (CREATE TABLE, INSERT, etc.) is in the column ACTION_NAME'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_trail.action_name IS
          'Name of the action type corresponding to the numeric code in ACTION'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_trail.new_owner IS
          'The owner of the object named in the NEW_NAME column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_trail.new_name IS
        'New name of object after RENAME, or name of underlying object
         (e.g. CREATE INDEX owner.obj_name ON new_owner.new_name)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_trail.obj_privilege IS
          'Object privileges granted/revoked by a GRANT/REVOKE statement'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_trail.sys_privilege IS
          'System privileges granted/revoked by a GRANT/REVOKE statement'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_trail.admin_option IS
          'If role/sys_priv was granted WITH ADMIN OPTION, A/-'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_trail.grantee IS
          'The name of the grantee specified in a GRANT/REVOKE statement'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_trail.audit_option IS
          'Auditing option set with the audit statement'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_trail.ses_actions IS
        'Session summary.  A string of 11 characters, one for each action type,
         in this order: Alter, Audit, Comment, Delete, Grant, Index, Insert,
         Lock, Rename, Select, Update.  Values:  "-" = None, "S" = Success,
         "F" = Failure, "B" = Both'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_trail.logoff_time IS
          'Timestamp for user logoff'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_trail.logoff_lread IS
          'Logical reads for the session'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_trail.logoff_pread IS
          'Physical reads for the session'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_trail.logoff_lwrite IS
          'Logical writes for the session'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_trail.logoff_dlock IS
          'Deadlocks detected during the session'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_trail.comment_text IS
          'Text comment on the audit trail entry'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_trail.sessionid IS
          'Numeric ID for each Oracle session'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_trail.entryid IS
          'Numeric ID for each audit trail entry in the session'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_trail.statementid IS
          'Numeric ID for each statement run (a statement may cause many actions)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_trail.returncode IS
          'Oracle error code generated by the action.  Zero if the action succeeded'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_trail.priv_used IS
          'System privilege used to execute the action'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_trail.object_label IS
          'Optional Trusted ORACLE label associated with object being audited'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_audit_trail.session_label IS
          'Trusted ORACLE label associated with user session'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.user_catalog IS
          'Tables, Views, Synonyms and Sequences owned by the user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_catalog.table_name IS
          'Name of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_catalog.table_type IS
          'Type of the object'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.user_clusters IS
          'Descriptions of user''s own clusters'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_clusters.cluster_name IS
          'Name of the cluster'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_clusters.tablespace_name IS
          'Name of the tablespace containing the cluster'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_clusters.pct_free IS
          'Minimum percentage of free space in a block'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_clusters.pct_used IS
          'Minimum percentage of used space in a block'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_clusters.key_size IS
          'Estimated size of cluster key plus associated rows'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_clusters.ini_trans IS
          'Initial number of transactions'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_clusters.max_trans IS
          'Maximum number of transactions'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_clusters.initial_extent IS
          'Size of the initial extent in bytes'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_clusters.next_extent IS
          'Size of secondary extents in bytes'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_clusters.min_extents IS
          'Minimum number of extents allowed in the segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_clusters.max_extents IS
          'Maximum number of extents allowed in the segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_clusters.pct_increase IS
          'Percentage increase in extent size'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_clusters.freelists IS
          'Number of process freelists allocated in this segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_clusters.freelist_groups IS
          'Number of freelist groups allocated in this segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_clusters.avg_blocks_per_key IS
          'Average number of blocks containing rows with a given cluster key'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_clusters.cluster_type IS
          'Type of cluster: b-tree index or hash'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_clusters.function IS
          'If a hash cluster, the hash function'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_clusters.hashkeys IS
          'If a hash cluster, the number of hash keys (hash buckets)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_clusters.degree IS
          'The number of threads per instance for scanning the cluster'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_clusters.instances IS
          'The number of instances across which the cluster is to be scanned'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_clusters.cache IS
          'Whether the cluster is to be cached in the buffer cache'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_clusters.buffer_pool IS
          'The default buffer pool to be used for cluster blocks'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_clusters.single_table IS
          'Whether the cluster can contain only a single table'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.user_clu_columns IS
          'Mapping of table columns to cluster columns'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_clu_columns.cluster_name IS
          'Cluster name'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_clu_columns.clu_column_name IS
          'Key column in the cluster'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_clu_columns.table_name IS
          'Clustered table name'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_clu_columns.tab_column_name IS
          'Key column in the table'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.user_col_comments IS
          'Comments on columns of user''s tables and views'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_col_comments.table_name IS
          'Object name'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_col_comments.column_name IS
          'Column name'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_col_comments.comments IS
          'Comment on the column'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.user_col_privs IS
          'Grants on columns for which the user is the owner, grantor or grantee'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_col_privs.grantee IS
          'Name of the user to whom access was granted'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_col_privs.owner IS
          'Username of the owner of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_col_privs.table_name IS
          'Name of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_col_privs.column_name IS
          'Name of the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_col_privs.grantor IS
          'Name of the user who performed the grant'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_col_privs.privilege IS
          'Column Privilege'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_col_privs.grantable IS
          'Privilege is grantable'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.user_col_privs_made IS
          'All grants on columns of objects owned by the user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_col_privs_made.grantee IS
          'Name of the user to whom access was granted'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_col_privs_made.table_name IS
          'Name of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_col_privs_made.column_name IS
          'Name of the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_col_privs_made.grantor IS
          'Name of the user who performed the grant'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_col_privs_made.privilege IS
          'Column Privilege'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_col_privs_made.grantable IS
          'Privilege is grantable'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.user_col_privs_recd IS
          'Grants on columns for which the user is the grantee'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_col_privs_recd.owner IS
          'Username of the owner of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_col_privs_recd.table_name IS
          'Name of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_col_privs_recd.column_name IS
          'Name of the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_col_privs_recd.grantor IS
          'Name of the user who performed the grant'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_col_privs_recd.privilege IS
          'Column Privilege'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_col_privs_recd.grantable IS
          'Privilege is grantable'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.user_constraints IS
          'Constraint definitions on user''s own tables'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_constraints.owner IS
          'Owner of the table'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_constraints.constraint_name IS
          'Name associated with constraint definition'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_constraints.constraint_type IS
          'Type of constraint definition'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_constraints.table_name IS
          'Name associated with table with constraint definition'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_constraints.search_condition IS
          'Text of search condition for table check'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_constraints.r_owner IS
          'Owner of table used in referential constraint'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_constraints.r_constraint_name IS
          'Name of unique constraint definition for referenced table'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_constraints.delete_rule IS
          'The delete rule for a referential constraint'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_constraints.status IS
          'enforcement status of constraint -  ENABLED or DISABLED'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_constraints.deferrable IS
          'Is the constraint deferrable - DEFERRABLE or NOT DEFERRABLE'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_constraints.deferred IS
          'Is the constraint deferred by default -  DEFERRED or IMMEDIATE'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_constraints.validated IS
          'Was this constraint system validated? -  VALIDATED or NOT VALIDATED'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_constraints.generated IS
          'Was the constraint name system generated? -  GENERATED NAME or USER NAME'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_constraints.bad IS
          'Creating this constraint should give ORA-02436.  Rewrite it before 2000 AD.'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_constraints.rely IS
          'If set, this flag will be used in optimizer'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_constraints.last_change IS
          'The date when this column was last enabled or disabled'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.user_cons_columns IS
          'Information about accessible columns in constraint definitions'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_cons_columns.owner IS
          'Owner of the constraint definition'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_cons_columns.constraint_name IS
          'Name associated with the constraint definition'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_cons_columns.table_name IS
          'Name associated with table with constraint definition'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_cons_columns.column_name IS
          'Name associated with column specified in the constraint definition'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_cons_columns.position IS
          'Original position of column in definition'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.user_db_links IS
          'Database links owned by the user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_db_links.db_link IS
          'Name of the database link'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_db_links.username IS
          'Name of user to log on as'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_db_links.password IS
          'Password for logon'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_db_links.host IS
          'SQL*Net string for connect'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_db_links.created IS
          'Creation time of the database link'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.user_dependencies IS
          'Dependencies to and from a users objects'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_dependencies.name IS
          'Name of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_dependencies.type IS
          'Type of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_dependencies.referenced_owner IS
          'Owner of referenced object (remote owner if remote object)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_dependencies.referenced_name IS
          'Name of referenced object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_dependencies.referenced_type IS
          'Type of referenced object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_dependencies.referenced_link_name IS
          'Name of dblink if this is a remote object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_dependencies.schemaid IS
          'The schema ID'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_dependencies.dependency_type IS
          'Two values: REF when the dependency is a REF dependency; HARD otherwise'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.user_errors IS
          'Current errors on stored objects owned by the user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_errors.name IS
          'Name of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_errors.type IS
        'Type of object: "VIEW", "PROCEDURE", "FUNCTION", "PACKAGE" or "PACKAGE BODY"'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_errors.sequence IS
          'Sequence number used for ordering purposes'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_errors.line IS
          'Line number at which this error occurs'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_errors.position IS
          'Position in the line at which this error occurs'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_errors.text IS
          'Text of the error'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.user_extents IS
          'Extents comprising segments owned by the user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_extents.segment_name IS
          'Name of the segment associated with the extent'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_extents.segment_type IS
          'Type of the segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_extents.tablespace_name IS
          'Name of the tablespace containing the extent'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_extents.partition_name IS
          'Partition/Subpartition Name, if any, of the segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_extents.extent_id IS
          'Extent number in the segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_extents.bytes IS
          'Size of the extent in bytes'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_extents.blocks IS
          'Size of the extent in ORACLE blocks'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.user_free_space IS
          'Free extents in tablespaces accessible to the user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_free_space.tablespace_name IS
          'Name of the tablespace containing the extent'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_free_space.file_id IS
          'ID number of the file containing the extent'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_free_space.block_id IS
          'Starting block number of the extent'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_free_space.bytes IS
          'Size of the extent in bytes'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_free_space.blocks IS
          'Size of the extent in ORACLE blocks'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_free_space.relative_fno IS
          'Relative number of the file containing the extent'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.user_indexes IS
          'Description of the user''s own indexes'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.index_name IS
          'Name of the index'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.index_type IS
          'Type of index'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.table_owner IS
          'Owner of the indexed object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.table_name IS
          'Name of the indexed object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.table_type IS
          'Type of the indexed object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.uniqueness IS
          'Uniqueness status of the index:  "UNIQUE" or "NONUNIQUE"'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.compression IS
          'Compression property of the index: "ENABLED",  "DISABLED", or NULL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.prefix_length IS
          'Number of key columns in the prefix used for compression'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.tablespace_name IS
          'Name of the tablespace containing the index'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.ini_trans IS
          'Initial number of transactions'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.max_trans IS
          'Maximum number of transactions'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.initial_extent IS
          'Size of the initial extent in bytes'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.next_extent IS
          'Size of secondary extents in bytes'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.min_extents IS
          'Minimum number of extents allowed in the segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.max_extents IS
          'Maximum number of extents allowed in the segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.pct_increase IS
          'Percentage increase in extent size'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.pct_threshold IS
          'Threshold percentage of block space allowed per index entry'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.include_column IS
          'User column-id for last column to be included in index-organized table top index'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.freelists IS
          'Number of process freelists allocated in this segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.freelist_groups IS
          'Number of freelist groups allocated to this segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.pct_free IS
          'Minimum percentage of free space in a block'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.logging IS
          'Logging attribute'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.blevel IS
          'B-Tree level'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.leaf_blocks IS
          'The number of leaf blocks in the index'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.distinct_keys IS
          'The number of distinct keys in the index'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.avg_leaf_blocks_per_key IS
          'The average number of leaf blocks per key'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.avg_data_blocks_per_key IS
          'The average number of data blocks per key'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.clustering_factor IS
        'A measurement of the amount of (dis)order of the table this index is for'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.status IS
          'Whether index is in Direct Load State or not'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.num_rows IS
          'Number of rows in this index'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.sample_size IS
          'The sample size used in analyzing this index'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.last_analyzed IS
          'The date of the most recent time this index was analyzed'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.degree IS
          'The number of threads per instance for scanning the partitioned index'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.instances IS
          'Number of instances across which the indexes to be scanned'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.partitioned IS
          'Is this index partitioned? YES or NO'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.temporary IS
          'Can the current session only see data that it place in this object itself?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.generated IS
          'Was the name of this index system generated?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.secondary IS
          'Is the index object created as part of icreate for domain indexes?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.buffer_pool IS
          'The default buffer pool to be used for index blocks'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.user_stats IS
          'Were the statistics entered directly by the user?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.duration IS
          'If index on temporary table, then duration is sys$session or sys$transaction else NULL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.pct_direct_access IS
          'If index on IOT, then this is percentage of rows with Valid guess'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.ityp_owner IS
          'If domain index, then this is the indextype owner'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.ityp_name IS
          'If domain index, then this is the name of the associated indextype'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.parameters IS
          'If domain index, then this is the parameter string'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_indexes.global_stats IS
          'Are the statistics calculated without merging underlying partitions?'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.user_ind_columns IS
          'COLUMNs comprising user''s INDEXes or on user''s TABLES'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_ind_columns.index_name IS
          'Index name'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_ind_columns.table_name IS
          'Table or cluster name'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_ind_columns.column_name IS
          'Column name'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_ind_columns.column_position IS
          'Position of column within index'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_ind_columns.column_length IS
          'Indexed length of the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_ind_columns.descend IS
          'Y/N, Y if this column is sorted in descending order'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.user_objects IS
          'Objects owned by the user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_objects.object_name IS
          'Name of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_objects.subobject_name IS
          'Name of the sub-object (for example, partititon)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_objects.object_id IS
          'Object number of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_objects.data_object_id IS
          'Object number of the segment which contains the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_objects.object_type IS
          'Type of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_objects.created IS
          'Timestamp for the creation of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_objects.last_ddl_time IS
        'Timestamp for the last DDL change (including GRANT and REVOKE) to the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_objects.timestamp IS
          'Timestamp for the specification of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_objects.status IS
          'Status of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_objects.temporary IS
          'Can the current session only see data that it placed in this object itself?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_objects.generated IS
          'Was the name of this object system generated?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_objects.secondary IS
          'Is this a secondary object created as part of icreate for domain indexes?'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.user_object_size IS
          'Sizes, in bytes, of various pl/sql objects'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_object_size.name IS
          'Name of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_object_size.type IS
        'Type of the object: "TABLE", "VIEW", "SYNONYM", "SEQUENCE", "PROCEDURE",
         "FUNCTION", "PACKAGE" or "PACKAGE BODY"'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_object_size.source_size IS
        'Size of the source, in bytes.  Must be in memory during compilation, or
         dynamic recompilation'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_object_size.parsed_size IS
        'Size of the parsed form of the object, in bytes. Must be in memory when
         an object is being compiled that references this object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_object_size.code_size IS
          'Code size, in bytes.  Must be in memory when this object is executing'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_object_size.error_size IS
        'Size of error messages, in bytes.  In memory during the compilation of
         the object when there are compilation errors'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.user_obj_audit_opts IS
          'Auditing options for user''s own tables and views'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_obj_audit_opts.object_name IS
          'Name of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_obj_audit_opts.object_type IS
          'Type of the object:  "TABLE" or "VIEW"'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_obj_audit_opts.alt IS
          'Auditing ALTER WHENEVER SUCCESSFUL / UNSUCCESSFUL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_obj_audit_opts.aud IS
          'Auditing AUDIT WHENEVER SUCCESSFUL / UNSUCCESSFUL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_obj_audit_opts.com IS
          'Auditing COMMENT WHENEVER SUCCESSFUL / UNSUCCESSFUL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_obj_audit_opts.del IS
          'Auditing DELETE WHENEVER SUCCESSFUL / UNSUCCESSFUL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_obj_audit_opts.gra IS
          'Auditing GRANT WHENEVER SUCCESSFUL / UNSUCCESSFUL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_obj_audit_opts.ind IS
          'Auditing INDEX WHENEVER SUCCESSFUL / UNSUCCESSFUL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_obj_audit_opts.ins IS
          'Auditing INSERT WHENEVER SUCCESSFUL / UNSUCCESSFUL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_obj_audit_opts.loc IS
          'Auditing LOCK WHENEVER SUCCESSFUL / UNSUCCESSFUL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_obj_audit_opts.ren IS
          'Auditing RENAME WHENEVER SUCCESSFUL / UNSUCCESSFUL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_obj_audit_opts.sel IS
          'Auditing SELECT WHENEVER SUCCESSFUL / UNSUCCESSFUL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_obj_audit_opts.upd IS
          'Auditing UPDATE WHENEVER SUCCESSFUL / UNSUCCESSFUL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_obj_audit_opts.ref IS
          'Auditing REFERENCES WHENEVER SUCCESSFUL / UNSUCCESSFUL (no used)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_obj_audit_opts.exe IS
          'Auditing EXECUTE WHENEVER SUCCESSFUL / UNSUCCESSFUL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_obj_audit_opts.cre IS
          'Auditing CREATE WHENEVER SUCCESSFUL / UNSUCCESSFUL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_obj_audit_opts.rea IS
          'Auditing READ WHENEVER SUCCESSFUL / UNSUCCESSFUL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_obj_audit_opts.wri IS
          'Auditing WRITE WHENEVER SUCCESSFUL / UNSUCCESSFUL'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.user_resource_limits IS
          'Display resource limit of the user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_resource_limits.resource_name IS
          'Resource name'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_resource_limits.limit IS
          'Limit placed on this resource'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.user_role_privs IS
          'Roles granted to current user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_role_privs.username IS
          'User Name or PUBLIC'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_role_privs.granted_role IS
          'Granted role name'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_role_privs.admin_option IS
          'Grant was with the ADMIN option'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_role_privs.default_role IS
          'Role is designated as a DEFAULT ROLE for the user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_role_privs.os_granted IS
          'Role is granted via the operating system (using OS_ROLES = TRUE)'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.user_segments IS
          'Storage allocated for all database segments'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_segments.segment_name IS
          'Name, if any, of the segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_segments.partition_name IS
          'Partition/Subpartition Name, if any, of the segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_segments.segment_type IS
        'Type of segment:  "TABLE", "CLUSTER", "INDEX", "ROLLBACK",
         "DEFERRED ROLLBACK", "TEMPORARY", or "CACHE"'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_segments.tablespace_name IS
          'Name of the tablespace containing the segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_segments.bytes IS
          'Size, in bytes, of the segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_segments.blocks IS
          'Size, in Oracle blocks, of the segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_segments.extents IS
          'Number of extents allocated to the segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_segments.initial_extent IS
          'Size, in Oracle blocks, of the initial extent of the segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_segments.next_extent IS
        'Size, in Oracle blocks, of the next extent to be allocated to
         the segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_segments.min_extents IS
          'Minimum number of extents allowed in the segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_segments.max_extents IS
          'Maximum number of extents allowed in the segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_segments.pct_increase IS
        'Percent by which to increase the size of the next extent to
         be allocated'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_segments.freelists IS
          'Number of process freelists allocated to this segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_segments.freelist_groups IS
          'Number of freelist groups allocated to this segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_segments.buffer_pool IS
          'The default buffer pool to be used for segments blocks'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.user_sequences IS
          'Description of the user''s own SEQUENCEs'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_sequences.sequence_name IS
          'SEQUENCE name'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_sequences.min_value IS
          'Minimum value of the sequence'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_sequences.max_value IS
          'Maximum value of the sequence'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_sequences.increment_by IS
          'Value by which sequence is incremented'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_sequences.cycle_flag IS
          'Does sequence wrap around on reaching limit?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_sequences.order_flag IS
          'Are sequence numbers generated in order?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_sequences.cache_size IS
          'Number of sequence numbers to cache'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_sequences.last_number IS
          'Last sequence number written to disk'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.user_snapshots IS
          'Snapshots the user can look at'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_snapshots.owner IS
          'Owner of the snapshot'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_snapshots.name IS
          'The view used by users and applications for viewing the snapshot'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_snapshots.table_name IS
        'Table the snapshot is stored in -- has an extra column for the master rowid'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_snapshots.master_view IS
        'View of the master table, owned by the snapshot owner, used for refreshes'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_snapshots.master_owner IS
          'Owner of the master table'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_snapshots.master IS
          'Name of the master table that this snapshot is a copy of'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_snapshots.master_link IS
          'Database link name to the master site'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_snapshots.can_use_log IS
          'If NO, this snapshot is complex and will never use a log'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_snapshots.updatable IS
          'If NO, the snapshot is read only.  Look up REPLICATION'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_snapshots.last_refresh IS
          'SYSDATE from the master site at the time of the last refresh'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_snapshots.error IS
          'The error returned last time an automatic refresh was attempted'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_snapshots.type IS
          'The type of refresh (complete,fast,force) for all automatic refreshes'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_snapshots.next IS
          'The date function used to compute next refresh dates'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_snapshots.start_with IS
          'The date function used to compute next refresh dates'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_snapshots.refresh_group IS
          'All snapshots in a given refresh group get refreshed in the same transaction'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_snapshots.refresh_method IS
          'The values used to drive a fast refresh of the snapshot'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_snapshots.update_trig IS
          'The name of the trigger which fills the UPDATE_LOG'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_snapshots.update_log IS
          'The table which logs changes made to an updatable snapshots'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_snapshots.query IS
          'The original query that this snapshot is an instantiation of'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_snapshots.fr_operations IS
          'If REGENERATE, then the fast refresh operations have not been generated'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_snapshots.cr_operations IS
          'If REGENERATE, then the complete refresh operations have not been generated'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_snapshots.master_rollback_seg IS
          'Rollback segment to use at the master site'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_snapshots.status IS
          'The status of the contents of the snapshot'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_snapshots.refresh_mode IS
          'This indicates how and when the snapshot will be refreshed'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_snapshots.prebuilt IS
          'If YES, this snapshot uses a prebuilt table as the base table'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.user_snapshot_logs IS
          'All snapshot logs owned by the user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_snapshot_logs.log_owner IS
          'Owner of the snapshot log'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_snapshot_logs.master IS
          'Name of the master table which the log logs changes of'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_snapshot_logs.log_table IS
        'Log table; holds rowids and timestamps of rows which changed in the
         master'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_snapshot_logs.log_trigger IS
          'Trigger on master table; fills the snapshot log'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_snapshot_logs.filter_columns IS
          'If YES, the snapshot log records filter column information'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_snapshot_logs.rowids IS
          'If YES, the snapshot log records rowid information'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_snapshot_logs.primary_key IS
          'If YES, the snapshot log records primary key information'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_snapshot_logs.current_snapshots IS
        'One date per snapshot -- the date the snapshot of the master
         last refreshed'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_snapshot_logs.snapshot_id IS
          'Unique identifier of the snapshot'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.user_source IS
          'Source of stored objects accessible to the user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_source.name IS
          'Name of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_source.type IS
          'Type of the object: "PROCEDURE", "FUNCTION", "PACKAGE" or "PACKAGE BODY"'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_source.line IS
          'Line number of this line of source'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_source.text IS
          'Source text'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.user_synonyms IS
          'The user''s private synonyms'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_synonyms.synonym_name IS
          'Name of the synonym'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_synonyms.table_owner IS
          'Owner of the object referenced by the synonym'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_synonyms.table_name IS
          'Name of the object referenced by the synonym'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_synonyms.db_link IS
          'Database link referenced in a remote synonym'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.user_sys_privs IS
          'System privileges granted to current user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_sys_privs.username IS
          'User Name or PUBLIC'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_sys_privs.privilege IS
          'System privilege'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_sys_privs.admin_option IS
          'Grant was with the ADMIN option'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.user_tables IS
          'Description of the user''s own tables'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tables.table_name IS
          'Name of the table'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tables.tablespace_name IS
          'Name of the tablespace containing the table'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tables.cluster_name IS
          'Name of the cluster, if any, to which the table belongs'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tables.iot_name IS
          'Name of the index-only table, if any, to which the overflow entry belongs'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tables.pct_free IS
          'Minimum percentage of free space in a block'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tables.pct_used IS
          'Minimum percentage of used space in a block'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tables.ini_trans IS
          'Initial number of transactions'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tables.max_trans IS
          'Maximum number of transactions'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tables.initial_extent IS
          'Size of the initial extent in bytes'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tables.next_extent IS
          'Size of secondary extents in bytes'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tables.min_extents IS
          'Minimum number of extents allowed in the segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tables.max_extents IS
          'Maximum number of extents allowed in the segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tables.pct_increase IS
          'Percentage increase in extent size'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tables.freelists IS
          'Number of process freelists allocated in this segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tables.freelist_groups IS
          'Number of freelist groups allocated in this segment'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tables.logging IS
          'Logging attribute'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tables.backed_up IS
          'Has table been backed up since last modification?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tables.num_rows IS
          'The number of rows in the table'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tables.blocks IS
          'The number of used blocks in the table'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tables.empty_blocks IS
          'The number of empty (never used) blocks in the table'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tables.avg_space IS
          'The average available free space in the table'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tables.chain_cnt IS
          'The number of chained rows in the table'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tables.avg_row_len IS
          'The average row length, including row overhead'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tables.avg_space_freelist_blocks IS
          'The average freespace of all blocks on a freelist'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tables.num_freelist_blocks IS
          'The number of blocks on the freelist'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tables.degree IS
          'The number of threads per instance for scanning the table'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tables.instances IS
          'The number of instances across which the table is to be scanned'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tables.cache IS
          'Whether the table is to be cached in the buffer cache'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tables.table_lock IS
          'Whether table locking is enabled or disabled'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tables.sample_size IS
          'The sample size used in analyzing this table'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tables.last_analyzed IS
          'The date of the most recent time this table was analyzed'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tables.partitioned IS
          'Is this table partitioned? YES or NO'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tables.iot_type IS
          'If index-only table, then IOT_TYPE is IOT or IOT_OVERFLOW else NULL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tables.temporary IS
          'Can the current session only see data that it place in this object itself?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tables.secondary IS
          'Is this table object created as part of icreate for domain indexes?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tables.nested IS
          'Is the table a nested table?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tables.buffer_pool IS
          'The default buffer pool to be used for table blocks'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tables.row_movement IS
          'Whether partitioned row movement is enabled or disabled'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tables.global_stats IS
          'Are the statistics calculated without merging underlying partitions?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tables.user_stats IS
          'Were the statistics entered directly by the user?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tables.duration IS
          'If temporary table, then duration is sys$session or sys$transaction else NULL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tables.skip_corrupt IS
          'Whether skip corrupt blocks is enabled or disabled'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tables.monitoring IS
          'Should we keep track of the amount of modification?'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.user_tablespaces IS
          'Description of accessible tablespaces'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tablespaces.tablespace_name IS
          'Tablespace name'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tablespaces.initial_extent IS
          'Default initial extent size'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tablespaces.next_extent IS
          'Default incremental extent size'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tablespaces.min_extents IS
          'Default minimum number of extents'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tablespaces.max_extents IS
          'Default maximum number of extents'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tablespaces.pct_increase IS
          'Default percent increase for extent size'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tablespaces.min_extlen IS
          'Minimum extent size for the tablespace'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tablespaces.status IS
          'Tablespace status: "ONLINE" or "OFFLINE"'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tablespaces.contents IS
          'Tablespace contents: "PERMANENT", or "TEMPORARY"'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tablespaces.logging IS
          'Default logging attribute'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tablespaces.extent_management IS
          'Extent management tracking: "DICTIONARY" or "LOCAL"'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tablespaces.allocation_type IS
          'Type of extent allocation in effect for this tablespace'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.user_tab_columns IS
          'Columns of user''s tables, views and clusters'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tab_columns.table_name IS
          'Table, view or cluster name'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tab_columns.column_name IS
          'Column name'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tab_columns.data_type IS
          'Datatype of the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tab_columns.data_type_mod IS
          'Datatype modifier of the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tab_columns.data_type_owner IS
          'Owner of the datatype of the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tab_columns.data_length IS
          'Length of the column in bytes'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tab_columns.data_precision IS
          'Length: decimal digits (NUMBER) or binary digits (FLOAT)'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tab_columns.data_scale IS
          'Digits to right of decimal point in a number'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tab_columns.nullable IS
          'Does column allow NULL values?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tab_columns.column_id IS
          'Sequence number of the column as created'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tab_columns.default_length IS
          'Length of default value for the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tab_columns.data_default IS
          'Default value for the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tab_columns.num_distinct IS
          'The number of distinct values for the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tab_columns.low_value IS
          'The second smallest value for the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tab_columns.high_value IS
          'The second highest value for the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tab_columns.density IS
          'The density of the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tab_columns.num_nulls IS
          'The number of nulls in the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tab_columns.num_buckets IS
          'The number of buckets in histogram for the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tab_columns.last_analyzed IS
          'The date of the most recent time this column was analyzed'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tab_columns.sample_size IS
          'The sample size used in analyzing this column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tab_columns.character_set_name IS
          'Character set name'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tab_columns.char_col_decl_length IS
          'Declaration length of character type column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tab_columns.global_stats IS
          'Are the statistics calculated without merging underlying partitions?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tab_columns.user_stats IS
          'Were the statistics entered directly by the user?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tab_columns.avg_col_len IS
          'The average length of the column in bytes'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.user_tab_comments IS
          'Comments on the tables and views owned by the user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tab_comments.table_name IS
          'Name of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tab_comments.table_type IS
          'Type of the object:  "TABLE" or "VIEW"'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tab_comments.comments IS
          'Comment on the object'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.user_tab_privs IS
          'Grants on objects for which the user is the owner, grantor or grantee'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tab_privs.grantee IS
          'Name of the user to whom access was granted'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tab_privs.owner IS
          'Owner of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tab_privs.table_name IS
          'Name of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tab_privs.grantor IS
          'Name of the user who performed the grant'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tab_privs.privilege IS
          'Table Privilege'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tab_privs.grantable IS
          'Privilege is grantable'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.user_tab_privs_made IS
          'All grants on objects owned by the user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tab_privs_made.grantee IS
          'Name of the user to whom access was granted'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tab_privs_made.table_name IS
          'Name of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tab_privs_made.grantor IS
          'Name of the user who performed the grant'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tab_privs_made.privilege IS
          'Table Privilege'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tab_privs_made.grantable IS
          'Privilege is grantable'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.user_tab_privs_recd IS
          'Grants on objects for which the user is the grantee'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tab_privs_recd.owner IS
          'Owner of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tab_privs_recd.table_name IS
          'Name of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tab_privs_recd.grantor IS
          'Name of the user who performed the grant'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tab_privs_recd.privilege IS
          'Table Privilege'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_tab_privs_recd.grantable IS
          'Privilege is grantable'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.user_triggers IS
          'Triggers owned by the user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_triggers.trigger_name IS
          'Name of the trigger'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_triggers.trigger_type IS
          'Type of the trigger (when it fires) - BEFORE/AFTER and STATEMENT/ROW'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_triggers.triggering_event IS
          'Statement that will fire the trigger - INSERT, UPDATE and/or DELETE'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_triggers.table_owner IS
          'Owner of the table that this trigger is associated with'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_triggers.base_object_type IS
          'The base object on which the trigger is defined: TABLE, VIEW, SCHEMA, or DATABASE'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_triggers.table_name IS
          'Name of the table that this trigger is associated with'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_triggers.column_name IS
          'The name of the column on which the trigger is defined over'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_triggers.referencing_names IS
          'Names used for referencing to OLD and NEW values within the trigger'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_triggers.when_clause IS
        'WHEN clause must evaluate to true in order for triggering body
         to execute'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_triggers.status IS
          'If DISABLED then trigger will not fire'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_triggers.description IS
          'Trigger description, useful for re-creating trigger creation statement'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_triggers.action_type IS
          'The action type of the trigger body: CALL or PL/SQL'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_triggers.trigger_body IS
          'Action taken by this trigger when it fires'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.user_trigger_cols IS
          'Column usage in user''s triggers'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_trigger_cols.trigger_owner IS
          'Owner of the trigger'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_trigger_cols.trigger_name IS
          'Name of the trigger'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_trigger_cols.table_owner IS
          'Owner of the table'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_trigger_cols.table_name IS
          'Name of the table on which the trigger is defined'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_trigger_cols.column_name IS
          'Name of the column used in trigger definition'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_trigger_cols.column_list IS
          'Is column specified in UPDATE OF clause?'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_trigger_cols.column_usage IS
          'Usage of column within trigger body'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.user_ts_quotas IS
          'Tablespace quotas for the user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_ts_quotas.tablespace_name IS
          'Tablespace name'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_ts_quotas.bytes IS
          'Number of bytes charged to the user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_ts_quotas.max_bytes IS
          'User''s quota in bytes.  NULL if no limit'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_ts_quotas.blocks IS
          'Number of ORACLE blocks charged to the user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_ts_quotas.max_blocks IS
          'User''s quota in ORACLE blocks.  NULL if no limit'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.user_users IS
          'Information about the current user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_users.username IS
          'Name of the user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_users.user_id IS
          'ID number of the user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_users.account_status IS
          'Indicates if the account is locked, expired, or unlocked'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_users.lock_date IS
          'Date the account was locked if account status was locked'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_users.expiry_date IS
          'Date of expiration of the account'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_users.default_tablespace IS
          'Default tablespace for data'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_users.temporary_tablespace IS
          'Default tablespace for temporary tables'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_users.created IS
          'User creation date'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_users.initial_rsrc_consumer_group IS
          'User''s initial consumer group'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_users.external_name IS
          'User external name'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.user_views IS
          'Text of views owned by the user'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_views.view_name IS
          'Name of the view'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_views.text_length IS
          'Length of the view text'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_views.text IS
          'View text'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_views.type_text_length IS
          'Length of the type clause of the object view'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_views.type_text IS
          'Type clause of the object view'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_views.oid_text_length IS
          'Length of the WITH OBJECT OID clause of the object view'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_views.oid_text IS
          'WITH OBJECT OID clause of the object view'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_views.view_type_owner IS
          'Owner of the type of the view if the view is an object view'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.user_views.view_type IS
          'Type of the view if the view is an object view'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.audit_actions IS
        'Description table for audit trail action type codes. Maps action type
         numbers to action type names'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.audit_actions.action IS
          'Numeric audit trail action type code'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.audit_actions.name IS
          'Name of the type of audit trail action'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dictionary IS
          'Description of data dictionary tables and views'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dictionary.table_name IS
          'Name of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dictionary.comments IS
          'Text comment on the object'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.dict_columns IS
          'Description of columns in data dictionary tables and views'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dict_columns.table_name IS
          'Name of the object that contains the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dict_columns.column_name IS
          'Name of the column'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.dict_columns.comments IS
          'Text comment on the object'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.exceptions IS
          'Violations of integrity constraints'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.exceptions.row_id IS
          'Row that caused the violation'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.exceptions.owner IS
          'Owner of the table'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.exceptions.table_name IS
          'Name of the table'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.exceptions.constraint IS
          'Integrity constraint that was violated'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.global_name IS
          'Global database name'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.global_name.global_name IS
          'Global name of the database'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.resource_cost IS
          'Cost for each resource'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.resource_cost.resource_name IS
          'Name of the resource'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.resource_cost.unit_cost IS
          'Cost of the resource'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.role_role_privs IS
          'Roles which are granted to roles'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.role_role_privs.role IS
          'Name of the role'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.role_role_privs.granted_role IS
          'Role that was granted'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.role_role_privs.admin_option IS
          'Signifies that the role was granted with ADMIN option'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.role_sys_privs IS
          'System privileges granted to roles'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.role_sys_privs.role IS
          'Name of the role'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.role_sys_privs.privilege IS
          'System privilege granted to the role'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.role_sys_privs.admin_option IS
          'Signifies the grant was with the ADMIN option'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.role_tab_privs IS
          'Table privileges granted to roles'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.role_tab_privs.role IS
          'Name of the role'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.role_tab_privs.owner IS
          'Owner of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.role_tab_privs.table_name IS
          'Name of the object'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.role_tab_privs.column_name IS
          'Name of the column, if applicable'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.role_tab_privs.privilege IS
          'Object privilege granted to the role'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.role_tab_privs.grantable IS
          'YES if the role was granted with ADMIN OPTION, otherwise NO'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.session_privs IS
          'Privileges which the user currently has set'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.session_privs.privilege IS
          'Name of the privilege'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.session_roles IS
          'Roles which the user currently has enabled.'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.session_roles.role IS
          'Name of the role'"""))


        # only for Oracle-6-compatibility, not necessary any more

        # stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.column_privileges IS
        # 'Grants on columns for which the user is the grantor, grantee, owner, or
        #  an enabled role or PUBLIC is the grantee'"""))
        # *
        # stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.column_privileges.grantee IS
        #   'Name of the user to whom access is granted'"""))
        # *
        # stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.column_privileges.owner IS
        #   'Username of the object''s owner'"""))
        # *
        # stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.column_privileges.table_name IS
        #   'Name of the object'"""))
        # *
        # stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.column_privileges.column_name IS
        #   'Name of the column'"""))
        # *
        # stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.column_privileges.grantor IS
        #   'Name of the user who performed the grant'"""))
        # *
        # stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.column_privileges.insert_priv IS
        #   'Permission to insert into the column'"""))
        # *
        # stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.column_privileges.update_priv IS
        #   'Permission to update the column'"""))
        # *
        # stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.column_privileges.references_priv IS
        #   'Permission to reference the column'"""))
        # *
        # stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.column_privileges.created IS
        #   'Timestamp for the grant'"""))
        # *

        # only for Oracle-6-compatibility, not necessary any more


        # stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.table_privileges IS
        # 'Grants on objects for which the user is the grantor, grantee, owner,
        #  or an enabled role or PUBLIC is the grantee'"""))
        # *
        # stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.table_privileges.grantee IS
        #   'Name of the user to whom access is granted'"""))
        # *
        # stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.table_privileges.owner IS
        #   'Owner of the object'"""))
        # *
        # stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.table_privileges.table_name IS
        #   'Name of the object'"""))
        # *
        # stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.table_privileges.grantor IS
        #   'Name of the user who performed the grant'"""))
        # *
        # stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.table_privileges.select_priv IS
        #   'Permission to select from the object'"""))
        # *
        # stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.table_privileges.insert_priv IS
        #   'Permission to insert into the object'"""))
        # *
        # stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.table_privileges.delete_priv IS
        #   'Permission to delete from the object'"""))
        # *
        # stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.table_privileges.update_priv IS
        #   'Permission to update the object'"""))
        # *
        # stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.table_privileges.references_priv IS
        #   'Permission to reference the object'"""))
        # *
        # stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.table_privileges.alter_priv IS
        #   'Permission to alter the object'"""))
        # *
        # stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.table_privileges.index_priv IS
        #   'Permission to create or drop an index on the object'"""))
        # *
        # stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.table_privileges.created IS
        #   'Timestamp for the grant'"""))
        # *

    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.table_privilege_map IS
          'Access privilege codes'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.table_privilege_map.privilege IS
          'Numeric privilege (auditing option) type code'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.table_privilege_map.name IS
          ' Name of the type of privilege (auditing option)'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.public_dependency IS
          'Dependencies to and from objects, by object number'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.public_dependency.object_id IS
          'Object number'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.public_dependency.referenced_object_id IS
          'Referenced object (the parent object)'"""))


    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys.stmt_audit_option_map IS
          'Auditing option type codes'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.stmt_audit_option_map."OPTION#" IS
          'Numeric auditing option type code'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.stmt_audit_option_map.name IS
          'Name of the auditing option'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys.stmt_audit_option_map.property IS
          'Value 0 / 1'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE sys."V$NLS_PARAMETERS" IS
          'Current values of NLS parameters'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys."V$NLS_PARAMETERS".parameter IS
          'Parameter name'"""))

    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN sys."V$NLS_PARAMETERS".value IS
          'Parameter value'"""))


    loaderCmd (session, 'COMMIT')

    loaderCmd (session, 'SQLMODE INTERNAL')

    switchToDefaultUser (session, options)

    # End of Install


if __name__ == '__main__':
    connectAndInstall (install, install.__doc__)


