#!/usr/bin/env python
#
#    ========== licence begin  GPL
#    Copyright (c) 2002-2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end

import sys
import string
import sapdb.dbm
import demodbData

def showState (session):
    output = session.cmd ('db_state')
    lines = string.split (output, '\n')
    try:
        state = lines [1]
        print 'database state:', state
    except IndexError:
        print 'unexpected output:', output

def createSession (username, password, dbname, host):
    session = sapdb.dbm.DBM (host, dbname, '', username + ',' + password)
    return session

def main ():
    username, password, dbname, host = demodbData.parseDbmArgs (sys.argv [1:])
    session = createSession (username, password, dbname, host)
    showState (session)

if __name__ == "__main__":
    main ()
