/*


    ========== licence begin  GPL
    Copyright (c) 2002-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end




*/

class DemodbData
{
    String username;
    String password;
    String dbname;
    String host;

    DemodbData (
            String usernameP,
            String passwordP,
            String dbnameP,
            String hostP)
    {
        this.username = usernameP;
        this.password = passwordP;
        this.dbname = dbnameP;
        this.host = hostP;
    }
    static DemodbData defaultUser ()
    {
        return new DemodbData ("MONA", "RED", "MAXDB1", "");
    }

    static DemodbData dbmUser ()
    {
        return new DemodbData ("DBM", "DBM", "MAXDB1", "");
    }

    private void parseArgs (
            String [] args)
    {
        if (args.length > 3) {
            this.host = args [3];
        }
        if (args.length > 2) {
            this.dbname = args [2];
        }
        if (args.length > 1) {
            this.password = args [1];
        }
        if (args.length > 0) {
            this.username = args [0];
        }
    }

    static DemodbData parseUserArgs (
            String [] args)
    {
        DemodbData result = defaultUser ();
        result.parseArgs (args);
        return result;
    }

    static DemodbData parseDbmArgs (
            String [] args)
    {
        DemodbData result = dbmUser ();
        result.parseArgs (args);
        return result;
    }
}
