/*
 abaphndl.h - definitions/declarations for standard processing
       of abap IO streams. This file extended the general
       declaration from cpc.h of the SAPDB C/C++ Precompiler




    ========== licence begin  GPL
    Copyright (c) 1998-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end




*/
#ifndef __gpi00abaphndl_h__
#define __gpi00abaphndl_h__
#include <windows.h>
#include <lcstream.h> /* nocheck */

typedef SQLStreamDesc sqlstream;

/*
  Oracle conform data types for using in Oracle SQLDA
*/
enum SQLORATypes {
        SQL_ORA_VARCHAR2             =  1,   /* char[n] */
        SQL_ORA_NUMBER               =  2,
        SQL_ORA_FIXEDPOINTINTEGER    =  3,
        SQL_ORA_FLOATPOINT           =  4,
        SQL_ORA_NULLTERMINATEDSTRING =  5,
        SQL_ORA_VARNUM               =  6,
        SQL_ORA_PACKEDDECIMAL        =  7,
        SQL_ORA_LONG                 =  8,
        SQL_ORA_VARCHAR              =  9,
        SQL_ORA_ROWID                = 11,
        SQL_ORA_INTERNDATE           = 12,
	SQL_ORA_INTERNJULIAN         = 14,
        SQL_ORA_VARRAW               = 15,
	SQL_ORA_RAW                  = 23,
        SQL_ORA_LONGRAW              = 24,
        SQL_ORA_VFILE                = 39,   /* datafile Cobol */
        SQL_ORA_VFILEC               = 40,   /* datafile C */
	SQL_ORA_UNSIGNED             = 68,
	SQL_ORA_DISPLAY              = 91,
	SQL_ORA_LONGVARCHAR          = 94,
        SQL_ORA_LONGVARRAW           = 95,
        SQL_ORA_CHAR                 = 96,
        SQL_ORA_CHARZ                = 97,
	SQL_ORA_MLSLABEL             =106,
	SQL_ORA_LONG_UNICODE         =201,
        SQL_ORA_ABAP_HANDL           =SQL_ORA_STREAM_HANDLE, /* 301 */
        SQL_ORA_VARCHAR_WITHOUT_LEN  =302,
	SQL_ORA_LONG_DESC            =401,  /* descriptor for long column */
        SQL_ORA_TCHAR                =410,  /* TCHAR if unicode null terminated UCS2 else null terminated char*/
        SQL_ORA_TVARCHAR             =411,  /* TCHAR if unicode -> UCS2[n+2] else -> ora_varchar[n+2]*/
        SQL_ORA_TVARCHAR4            =412,  /* TCHAR if unicode -> UCS2[n+4] else -> ora_varchar4[n+4]*/
	SQL_ORA_UCS2                 =420,  /* null terminated UCS2  string */
	SQL_ORA_UTF16                =421,  /* null terminated UTF16 string */
	SQL_ORA_VARUCS2_2            =422   /* UCS2 string without null termination and length info */
    }; /* ORACLE types */

#define SQL_ABAP_OK           SQL_STREAM_OK
#define SQL_ABAP_ERROR        SQL_STREAM_ERROR
#define SQL_ABAP_EXCEPTION    SQL_STREAM_EXCEPTION
#define SQL_ABAP_NO_MORE_DATA SQL_STREAM_NO_MORE_DATA

#define SQLABAPReadProc       SQLStreamReadProc
#define SQLABAPWriteProc      SQLStreamWriteProc
#define SQLABAPDesc           SQLStreamDesc
#define SQL_LC_ABAPTabParm    SQL_LC_StreamParm
#define SQL_ORA_ABAP_HANDLE   SQL_ORA_STREAM_HANDLE

#endif
