#!/usr/bin/perl
#
# $Header: //sapdb/V75/c_00/develop/sys/src/install/perl/SAPDB/Install/Instance/Check/Common.pm#3 $
# $DateTime: 2003/12/11 13:40:27 $
# $Change: 59245 $
#
#    ========== licence begin  GPL
#    Copyright (c) 2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end


package SAPDB::Install::Instance::Check::Common;

sub BEGIN {
	@ISA = ('SAPDB::Install::Exporter');
	@EXPORT = ();
	my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages = (
		'Instance::Base'
	);

	foreach my $package (@neededPackages) {
	  	unless (defined $repo->Eval 
		("SAPDB::Install::$package", 1.01)) {
                	print join ("\n", $repo->GetErr)."\n";
                	die;
        	}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package");
	  } 
}

push @ISA, 
	'SAPDB::Install::Instance::Base';

#
# get_restartinfo ()
#
# try to get db restartinfo by using dbm command 'db_restartinfo'
#
# if this does not work or it does not return the 'Consistence' flag
# like some 7.2.04 and early 7.2.05 do, it uses diagnose 'get restart version'
# the output looks like the output from dbm
#
sub get_restartinfo {
	my ($self) = @_;
	my $dbm = $self->{dbm};

	my %restartinfo = $dbm->db_restartinfo ();
	if (defined %restartinfo) {
		$self->msg1 ("restart info by dbm:\n");
		$self->msg1 ("\n");
		while (my ($key, $val) = each %restartinfo) {
			$self->msg1 ("  ".$key ." => ". $val ."\n");
		}
		$self->msg1 ("\n");

		#
		# some older dbm does not return 'Consistent' field
		#
		if (defined $restartinfo{'Consistent'}) {
			return (\%restartinfo);
		}
	}	

	#
	# dbm command failed, probably old version of dbmsrv
	# we try diagnose to execute utility command 'get restart info' 
	#
	$self->msg1 ("using diagnose to get restart info\n");

	#
	# looking for diagnose in dependent program path
	#
	my %version = $dbm->dbm_version ();
	unless (defined %version) {
		$self->msg1 ($dbm->lastdialog ());
		return undef;
	}

	my $cmd;
	if (defined $version{'INSTROOT'}) {
		$cmd = $version{'INSTROOT'};
		$cmd .= ($^O =~ /^mswin/i) ? '/bin/x_diag.exe': 
		                             '/bin/x_diagnose';
		$cmd = undef unless (-x $cmd);
	}

	#
	# looking in indep prog path
	#
	unless (defined $cmd) {
		$cmd = $dbm->dbm_getpath ('IndepProgPath');
		unless (defined $cmd) {
			$self->msg1 ($dbm->lastdialog ());
			return undef;
		}
		$cmd .= ($^O =~ /^mswin/i) ? '/bin/x_diag.exe': 
		                             '/bin/x_diagnose';
		$cmd = undef unless (-x $cmd);
	}

	#
	# without diagnose we are completely lost
	# 
	unless (defined $cmd) {
		$self->msg1 ("cannot find executable ".
		(($^O =~ /mswin/i) ? 'x_diag.exe' : 'x_diagnose')."\n");
		return undef;
	}
	
	$self->msg1 ("found diagnose in ".$cmd."\n");

	$cmd .= ' -d '.$self->{'dbname'}.' -u '.$self->{'userpwd'};
	$cmd .= ' get restart version';

	my $txt = `${cmd}`;
	unless (defined $txt) {
		$self->msg1 ("execution of \n");
		$self->msg1 ($cmd."\n");
		$self->msg1 ("failed: ".$!."\n");
		return undef;
	}
	
	#
	# dump output
	#
	$self->msg1 ("restart info by diagnose:\n");
	foreach (split ('\n', $txt)) {
		$self->msg1 ($_."\n");
	}
	$self->msg1 ("\n");

	#
	# make output look like 'db_restartinfo' from dbm
	#
	my $state = '';	
	foreach (split ('\n', $txt)) {
		if ($state eq '') {
			if ($_ =~ /FIRST\sUSED\:\s+(\d+)/) {
				$restartinfo{'Used LOG Page'} = $1;
			}
			if ($_ =~ /FIRST\sLPNO\:\s+(\d+)/) {
				$restartinfo{'First LOG Page'} = $1;
			}
			if ($_ =~ /RESTARTABLE\:\s+(\d+)/) {
				$restartinfo{'Restartable'} = $1;
			}
			if ($_ =~ /RESTART\sW\/O\sLOG\s+(\d+)/) {
				$restartinfo{'Consistent'} = $1;
			}
			if ($_ =~ /DB_IDENT \(R\-REC\)/) {
				$state = 'IdRestartRecord';
				next;
			}
			if ($_ =~ /DB_IDENT \(LOG\-INF\)/) {
				$state = 'IdLogInfo';
				next;
			}
		} elsif ($state eq 'IdLogInfo') {
			$restartinfo{'Id LOG Info'} = $_;
			$state = '';
			next;
		} elsif ($state eq 'IdRestartRecord') {
			$restartinfo{'Id Restart Record'} = $_;
			$state = '';
			next;
		}
	}
	
	return (\%restartinfo);
}

#
# get_dbmutl ()
#
sub get_dbmutl {
	my ($self, $wanted) = @_;
	my $dbm = $self->{'dbm'};

	#
	# try to get a handle to 'dbm.utl'
	#	
	my $dbmgetf = $dbm->dbmgetf ('UTLPRT');
	unless (defined $dbmgetf) {
		$self->msg1 ($dbm->lastdialog ());
		return undef;
	}

	#
	# create empty table for result
	#
	my $out = {};
	foreach my $key ('DATE', 'TIME', 'CMDID', 'LINENO', 'TYPE', 'TEXT') {
		my @tmp = ();
		$out->{$key} = \@tmp;
	}

	while (my $line = $dbmgetf->readline ()) {
		#
		# skip useless lines
		# useful lines are starting with date and time
		# 
		# at this time (2001-09-19) we know two date formats
		# the first own is used by 7.2.xx and looks like 'mm-dd'
		# the second own is used by 7.3.xx and looks like 'yyyy-mm-dd'
		#
		next unless ($line =~ /^\d\d\d\d\-\d\d\-\d\d\s|^\d\d\-\d\d\s/); 

		#
		# split date
		# two formats are know 
		# they look like 'yyyy-mm-dd' and 'mm-dd'
		# in both cases the next field is separated by space
		#
		my $date = ($line =~ s/^(\d\d\d\d\-\d\d\-\d\d)\s//) ? $1 :
		           ($line =~ s/^(\d\d\-\d\d)\s//) ? $1 : undef;

		#
		# split time
		# the format is hh:mm:ss
		# next field can be separated by space, 
		# but may not by separated
		#
		my $time = ($line =~ s/^(\d\d\:\d\d\:\d\d)\s//) ? $1 :
		           ($line =~ s/^(\d\d\:\d\d\:\d\d)//) ? $1 : undef;

		#
		# split cmdid
		# the format is 12 hexadecimal digits
		# with heading zeros
		# sometimes the fill in 12 spaces
		# next field is separated by space 
		#
		my $cmdid = 
		($line =~ s/^(\w\w\w\w\w\w\w\w\w\w\w\w)\s//) ? $1 : 
		($line =~ s/^(\s\s\s\s\s\s\s\s\s\s\s\s)\s//) ? '' : 
		undef;

		#
		# skip line if cmdid is requested but does not match
		#
		next if (defined $wanted && $wanted ne $cmdid);

		#
		# split line number
		# this is a 4 digit hex number with heading zeros	
		#
		my $lineno = ($line =~ s/^(\w\w\w\w)\s+//) ? hex ($1) : undef;

		#
		# split type
		# this is a three letter acronym
		#
		my $type = ($line =~ s/^(\w\w\w)\s+//) ? $1 : undef;

		#
		# message is remaining
		#
		my $text = $line;

		#
		# put it to result table
		#

		push @{$out->{'DATE'}}, $date;
		push @{$out->{'TIME'}}, $time;
		push @{$out->{'CMDID'}}, $cmdid;
		push @{$out->{'LINENO'}}, $lineno;
		push @{$out->{'TYPE'}}, $type;
		push @{$out->{'TEXT'}}, $text;
	}
	return ($out);
}

1;

