#
# =====================================================
# @(#) QP                        7.4        2000-10-13
# =====================================================
# Changes in  7.4:
#
#
#    ========== licence begin  GPL
#    Copyright (c) 2000-2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end

from installib import *

def install (session,options):
    """Installing tables for SQL Studio
    """

    include (session, options, 'AS')

    loaderCmd (session, 'INSTALLATION ON')

    loaderCmd (session, 'AUTOCOMMIT OFF')

    #ADIS #1001953/1002033
    requireSysdba (session)

    #----------------------------------------------------------------------------
    # Create table for favorites
    #----------------------------------------------------------------------------

    if not existsTable (session, "SYSQP_ALL_FAVORITES"):
        stopIfSqlNotOK (session, """
            CREATE TABLE SYSQP_ALL_FAVORITES
            (
                    FOWNER          SYSID,
                    FITEMOWNER      SYSID,
                    FITEMNAME       CHAR (64)       ,
                    FITEMTYPE       INT             ,
                    FCOMMENT        VARCHAR (512) ASCII,
                    FINFO           VARCHAR (512) BYTE,
                    CONSTRAINT SYSQP_ALL_FAVORITES_PK
                        PRIMARY KEY(FOWNER,FITEMOWNER,FITEMNAME,FITEMTYPE)

            ) INTERNAL""")
    else:
        if (options.migrate):
            stopIfSqlNotOK  (session, 'ALTER TABLE SYSQP_ALL_FAVORITES MODIFY (FOWNER     SYSID)')
            stopIfSqlNotOK  (session, 'ALTER TABLE SYSQP_ALL_FAVORITES MODIFY (FITEMOWNER SYSID)')


    #----------------------------------------------------------------------------
    # Create the view for favorites
    #----------------------------------------------------------------------------


    dropView (session, "SYSQP_MY_FAVORITES")
    stopIfSqlNotOK (session, """
        CREATE VIEW SYSQP_MY_FAVORITES AS
            SELECT  *
            FROM    SYSQP_ALL_FAVORITES
            WHERE   FOWNER = USERGROUP
        WITH CHECK OPTION INTERNAL""")

    #----------------------------------------------------------------------------
    # Grant for the view SYSQP_MY_FAVORITES
    #----------------------------------------------------------------------------

    stopIfSqlNotOK (session, """
        GRANT   SELECT, UPDATE, DELETE, INSERT
        ON      SYSQP_MY_FAVORITES
        TO      PUBLIC""")


    #----------------------------------------------------------------------------
    # Commit the data definitions
    #----------------------------------------------------------------------------

    loaderCmd (session, 'COMMIT')

    loaderCmd (session, 'INSTALLATION OFF')

    # End of Install


if __name__ == '__main__':
    connectAndInstall (install, install.__doc__)


