
#
#    ========== licence begin  GPL
#    Copyright (c) 2002-2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end

sub defaultUser {
    #      user,   password, dbname, host (None = local)
    return 'MONA', 'RED',   'MAXDB1',  '';
}

sub dbmUser {
    #      user,   password, dbname, host (None = local)
    return 'DBM',  'DBM',    'MAXDB1',  '';
}

sub _parseArgs {
    my ($args, @defaults) = @_;
    my ($username, $password, $dbname, $host) = @defaults;
    my ($arglen);
    if (@$args > 3) {
        $host = $args->[3];
    }
    if (@$args > 2) {
        $dbname = $args->[2];
    }
    if (@$args > 1) {
        $password = $args->[1];
    }
    if (@$args > 0) {
        $username = $args->[0];
    }
    return $username, $password, $dbname, $host
}

sub parseUserArgs {
    return &_parseArgs (\@_, &defaultUser ())
}

sub parseDbmArgs {
    return &_parseArgs (\@_, &dbmUser ())
}

1;

