#!/usr/bin/perl
#
# $Header: //sapdb/V75/c_00/develop/sys/src/install/perl/SAPDB/Install/Log.pm#3 $
# $DateTime: 2003/12/11 13:40:27 $
# $Change: 59245 $
#
# Desc: 
#    ========== licence begin  GPL
#    Copyright (c) 2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end


package SAPDB::Install::Log;


$VERSION = 1.01;

sub BEGIN {
        my $repo = SAPDB::Install::Repository::GetCurrent ();
        my @neededPackages=(
		'Base',
		'System',
		'StdIO',
		'Values',
		'Registry',
		'Trace'
	  );
	  foreach my $package (@neededPackages){
	  	unless (defined $repo->Eval ("SAPDB::Install::$package", 1.01)) {
                print join ("\n", $repo->GetErr)."\n";
                die;
        	}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package");
	  } 
}



@ISA=qw(SAPDB::Install::Base);


my @messages;

my %members=(
				LogPath => undef,
				LogOff  => undef,
				LogName => undef,
				Messages => \@messages, 
				Filename => 'SDBINST'
			);

sub new{
	my ($type,$path) = @_;
	my $self= SAPDB::Install::Base->new;
	foreach my $key (keys(%members)){
		$self->{$key}=$members{$key};
	}
	$self = bless $self,$type;
	
	if($path){
		$self->LogPath($path);
	}
	return $self;
}


sub SetMsg{
    my ($self,$msg)=@_;
    TraceMsg($msg,2,\$DEBUG,2) unless($msg =~ /^STD/);
	*prot=$self->Messages;
	push @prot,$msg;
	return 1;
}

sub writeLog{
    my ($self)=@_;
	$self->LogOff and return;
	unless($self->LogPath){
		my ($indep_data,$indep_prog)=readIndepPath();
		if($indep_data){
			$self->LogPath("$indep_data/wrk");
		}
		else{
			$self->LogPath($SAPDB::Install::Values::curDir);
		}
	}
	defined &SAPDB::Install::History::writeHistory && SAPDB::Install::History::writeHistory();
	unless(-d $self->LogPath){
		makedir($self->LogPath, 0777,$SAPDB::Install::uid,$SAPDB::Install::gid);
	}
	my $name="MaxDB Software";
	$self->LogName =~ /\S/ and $name = $self->LogName; 
	$name=~s/\s//g; # delete whitespaces
	my $hour=(localtime)[2];
	my $minute = (localtime)[1];
	my $second= (localtime)[0];
	my $day= (localtime)[3];
	my $month=((localtime)[4]+1);
	$hour = "0$hour" if(length($hour)==1);
	$minute = "0$minute" if(length($minute)==1); 
    $second = "0$second" if(length($second)==1);
	$day = "0$day" if(length($day)==1);
	$month = "0$month" if(length($month)==1);
	my $fullname=$self->LogPath.'/'.$name."_install-$day.$month.".((localtime)[5]+1900)."-$hour.$minute.log";
	open(LOG,">$fullname") or print2stderr("cannot create logfile \"$fullname\"\n");
    *prot=$self->Messages;
	foreach $line (@prot){
		print LOG $line;
    }
    close(LOG);
	
	if($ENV{'SDBINSTLOGFILE'} =~ /\S/){
		print2stdout("saving installation logfile as ".$ENV{'SDBINSTLOGFILE'}."...\n");
		copy($fullname,$ENV{'SDBINSTLOGFILE'});
	}
	 
}

sub DESTROY{
	my ($self)=@_;
	$self->writeLog;
	$self->SAPDB::Install::Base::DESTROY;
	WriteTrace();
}


1;