#!/usr/bin/perl
#
# $Header: //sapdb/V75/c_00/b_44/sys/src/install56/perl/SAPDB/Install/Collector.pm#1 $
# $DateTime: 2007/04/10 17:59:46 $
# $Change: 149411 $
#
# Desc: 
#    ========== licence begin  GPL
#    Copyright (c) 2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end


package SAPDB::Install::Collector;


$VERSION = 1.01;

sub BEGIN {
      @ISA = ('SAPDB::Install::Exporter');
      @EXPORT = ('collect','checkRequired');
	my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages=(
		'System',
		'StdIO',
		'Tools',
		'PackageObj',
		'Values',
		'Trace',
		'SysInfo'
	);
	foreach my $package (@neededPackages) {
	  	unless (defined $repo->Eval ("SAPDB::Install::$package", 1.01)) {
                print join ("\n", $repo->GetErr)."\n";
                die;
        	}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package");
	  } 
}


$DEBUG=0;

$sysinfo = GetSystemInfo();


#sub reads package signatur and return it as hash
sub readPackageData{
	my %values = %SAPDB::Install::Values::package_interface;
	my ($untgz)=@_;
	my $datastring = readFileInTGZ($untgz,'PACKAGEDATA');
	$datastring or return undef;
	my @filedata=split("\n",$datastring);
	@filedata or $SAPDB::Install::StartInstall::log->SetMsg("WRN: package \"$tgzfile\" has no package signature\n") and return undef;
	TraceMsg("found following signature in archive \"$tgzfile\":\n",5,\$DEBUG);
	foreach my $line (@filedata){
		foreach my $key (keys(%values)){
			if($line =~ /^\s*$key\s*=\s*"(.*)"\s*$/){
				$values{$key} = $1;
				TraceMsg("\t* \"$key\" = \"$1\"\n",5,\$DEBUG);
				last;
			}
		}
	}
	#$values{'ARCHIVE_NAME'}=$tgzfile;
	return %values;
}


sub removeElementFromList{
	my ($delete,@list)=@_;
	my @newlist;
	foreach my $element (@list){
		$element == $delete or push @newlist,$element;
	}
	return @newlist;
}

# parse require strings like "Packegename 1 = 7.2.5.3 , Packegename 2 >= 7.3.0.0"

sub parseRequire{
	my ($reqString)=@_;
	my @ops=('>=','<=','=','>','<'); # operators in search order
	my $delimiter = ',';
	my @packages = split($delimiter,$reqString);
	my @returnvalue;
	my $first = 1;
	foreach my $package (@packages){
		$_ = $package;
		my %required_package;
		foreach my $operator (@ops){
			if(/$operator/){
				if(/^\s*(\S.*\S)\s*$operator\s*([0-9]{1,}\.[0-9]{1,}\.[0-9]{1,}\.[0-9]{1,})\s*(\d*)\s*/){
					# found valid operator and release -> set hash 
					$required_package{'name'} = $1;
					$required_package{'operator'} = $operator;
					$required_package{'release'} = $2;
					$required_package{'bit'} = $3 if ($3 == 32 or $3 == 64); 		
					last;
				}

				# found operand without valid release -> ignore operator and wrong release
				s/\s*$operator.*$//; 
				s/^\s*//;
				$required_package{'name'} = $_;
				last;
			}
		}
		$required_package{'first'} = $first;
		$first = 0;
		unless(exists $required_package{'name'}){
			s/^\s*//;
			s/\s*$//;
			$required_package{'name'} = $_;	
		}
		push(@returnvalue,\%required_package);
	}
	return @returnvalue; # return an array of hash references; hashes with keys: name (required), operator (optional) and release (optional) 
}


sub checkRequired{
	my (%args) = @_;
	my %required = %{$args{'required'}};
	my $pack_ok = 0;
	if($args{'package_name'} eq $required{'name'}){
		if(exists $required{'operator'}){
			TraceMsg("TEST WITH OTHER PACKAGE ".release2num($args{'version'})." $required{'operator'} ".release2num($required{'release'})."\n",4,\$DEBUG); 
			$_=$required{'operator'};
			SWITCH:{
				/^=$/ && do{
								release2num($args{'version'}) == release2num($required{'release'}) or last SWITCH;
								if($required{'bit'}){
									$required{'bit'} eq $args{'mode'} or TraceMsg("object mode dont match\n",4,\$DEBUG) and last SWITCH;
								}
								$pack_ok=1;
								last SWITCH;
							};	
				/^>$/ && do{
								release2num($args{'version'}) > release2num($required{'release'}) or last SWITCH;
								if($required{'bit'}){
									$required{'bit'} eq $args{'mode'} or TraceMsg("object mode dont match\n",4,\$DEBUG) and last SWITCH;
								}
								$pack_ok=1;
								last SWITCH;
							};
				/^<$/ && do{
								release2num($args{'version'}) < release2num($required{'release'}) or last SWITCH;
								if($required{'bit'}){
									$required{'bit'} eq $args{'mode'} or TraceMsg("object mode dont match\n",4,\$DEBUG) and last SWITCH;
								}
								$pack_ok=1;
								last SWITCH;
							};
				/^>=$/ && do{
								release2num($args{'version'}) >= release2num($required{'release'}) or last SWITCH;
								if($required{'bit'}){
									$required{'bit'} eq $args{'mode'} or TraceMsg("object mode dont match\n",4,\$DEBUG) and last SWITCH;
								}
								$pack_ok=1;
								last SWITCH;
							};
				/^<=$/ && do{
								release2num($args{'version'}) <= release2num($required{'release'}) or last SWITCH;
								if($required{'bit'}){
									$required{'bit'} eq $args{'mode'} or TraceMsg("object mode dont match\n",4,\$DEBUG) and last SWITCH;
								}
								$pack_ok=1;
								last SWITCH;
							};
			}
		}
		else{
			
			$pack_ok = 1;
		}
	}
	return $pack_ok;
}





#resolve dependencies

sub resolve{
	my ($instRegistry_ref,$packages_ref,$dependency_ref)=@_;
	my $instRegistry = $$instRegistry_ref;
	local *packages = $packages_ref; #array of hash references
	local *dependency=$dependency_ref; # hash, keys: name (required), operator (optional) and release (optional)
	exists $dependency{'name'} or return;
	my $pack_ok=0;
	my @nextdependencies;
	my $found_package;
	foreach my $package_ref (@packages){
		local *package=$package_ref; #hash, keys: see INTERFACE in package Values
		
		$pack_ok = checkRequired('mode' => $package{'MODE'},
								'version' => $package{'SOFTWARE_VERSION'},
								'package_name' => $package{'PACKAGE_NAME'},
								'required' => $dependency_ref);
		if($pack_ok){
				@nextdependencies=parseRequire($package{'REQUIRE'});	
				$found_package=$package_ref;
				TraceMsg("DEPENDENCY CHECK WITH OTHER PACKAGES: package \"$dependency{'name'}\" ok\n",4,\$DEBUG);
				$SAPDB::Install::StartInstall::log->SetMsg("dependencies for package \"$dependency{'name'}\" resolved\n");
				if($#nextdependencies == -1){
					#TraceMsg("package \"$dependency{'name'}\" has no dependencies\n",4,\$DEBUG);
					$SAPDB::Install::StartInstall::log->SetMsg("package \"$dependency{'name'}\" has no dependencies\n");
					return (\%package);
				}				
			last;
		}
	}
	if($pack_ok){
		my @returnlist;
		foreach my $next_one (@nextdependencies){
			push(@returnlist,resolve($instRegistry_ref,$packages_ref,$next_one));
		}
		push @returnlist,$found_package;
		return @returnlist;
	}
	elsif(defined $instRegistry){
		
		my %releases = $instRegistry->getInstallPathes($dependency{'name'},1);
		my $pack_ok=0;
		foreach my $install_path (keys(%releases)){
			#print "$install_path -> $releases{$install_path}\n";
			
			
			my %data = ();
			
			if($dependency{'bit'} == 32 or $dependency{'bit'} == 64){
				%data = $instRegistry->getPackageData($dependency{'name'},$install_path,1);
			}
			
			$pack_ok = checkRequired(
							'required' => \%dependency,
							'package_name' => $dependency{'name'},
							'version' => $releases{$install_path},	
							'mode' => $data{'Mode'}
			);
			
			$pack_ok and last; 
		}
		if($pack_ok){
			TraceMsg("DEPENDENCY CHECK IN REGISTRY: package \"$dependency{'name'}\" ok\n",4,\$DEBUG);
			$SAPDB::Install::StartInstall::log->SetMsg("reqired package $dependency{'name'} $dependency{'operator'} $dependency{'release'} in package registry found\n");
			return ();
		}
		
		# unresolved dependency - no such package collected or installed 
		
	}
	print2stderr("unresolved dependency - package $dependency{'name'} $dependency{'operator'} $dependency{'release'} not found\n");
	diesoft($SAPDB::Install::Values::diemsg);
	
}


sub removeDoubles{
	my (@input)=@_;
	my @return;
	foreach my $element (@input){
		my $check=0;
		foreach my $inner (@return){
			$inner eq $element and $check=1 and last;
		}
		$check or push @return,$element;
	}
	return @return;
}



# resolve dependencies and sort packages in install order

sub sortpackages{
	my ($instRegistry_ref,@hashref)=@_;
	my $instRegistry=$$instRegistry_ref;
	my @sortlist;
	foreach my $pack_ref (@hashref){
		local *package=$pack_ref;
		my @depends=parseRequire($package{'REQUIRE'});
		foreach my $dep (@depends){
			push @sortlist,resolve($instRegistry_ref,\@hashref,$dep);
		}
		push @sortlist,$pack_ref;
	}
	@sortlist=removeDoubles(@sortlist);
	return @sortlist;
}



sub getPackages{
	my ($dir) = @_;
	$dir = '.' unless $dir =~ /\S/;
	unless($dir){
		print2stderr("cannot find packages: search directory \"$dir\" non found\n");
		diesoft($diemsg);
	}
	my @tgzfiles;
	opendir(DH,$dir) or print2stderr("cannot open directory \"$dir\"\n") and diesoft($SAPDB::Install::Values::diemsg);
	@tgzfiles = grep { /\.tgz$/i && -f $_ && ! /sdbinst.tgz/i } readdir(DH);
	closedir(DH);
	($#tgzfiles == -1) and return; #no tgz file found
	my @profiles;
	my @packages;
	foreach my $file (@tgzfiles){
			TraceMsg("found archive \"$file\" in directory $dir\n",3,\$DEBUG);
			my $untgz = SAPDB::Install::Untgz::new();
			$untgz->Open($file);
			if($untgz->GetErr){
				TraceMsg("cannot open archive $file: ".join(': ',$untgz->GetErr)."\n");
				next;
			}
			my %packdata = readPackageData($untgz);
			push @packages,\%packdata;
			@profiles = union(\@profiles,[$packdata{'IS_TOP_OF'}]) if exists $packdata{'IS_TOP_OF'};
	}
	return {'profiles' => \@profiles, 'packages' => \@packages};
}




#collect all valid packages in cwd and return it in install order
sub collect{
	my ($profile,$package,$batch,$instRegistry_ref,$search_dir)=@_; #installation profile (server,client,develop,web, ...)
	my $instRegistry = $$instRegistry_ref;
	my @tgzfiles;
	my @packages;
	my @returnvalue;
	unless($search_dir =~ /\S/){
		$search_dir = '.';
	}

	opendir(DH,$search_dir) or print2stderr("cannot open directory \"$search_dir\"\n") and diesoft($SAPDB::Install::Values::diemsg);
	@tgzfiles = grep { /\.tgz$/i && -f "$search_dir/$_" && ! /sdbinst.tgz/i } readdir(DH);
	closedir(DH);
		
	($#tgzfiles == -1) and return $profile,(); #no tgz file found
	
	unless($search_dir eq '.'){
		my @tmp_list = ();
		foreach my $file (@tgzfiles){
			push @tmp_list,$search_dir.'/'.$file;	
		}
		@tgzfiles = @tmp_list;
	}
	
	
	
	my @tgzfiles_with_packagedata = ();
	
	if( ($profile eq '' or !$profile)  and ($package eq '' or !$package) ){
		
		if($SAPDB::Install::StartInstall::opt_b){
			print2stderr("run in batch mode - profile unknown\n");
			diesoft($SAPDB::Install::Values::diemsg);
		}
		
		# search for profiles in archives
		my @profiles=();
		my @existingprofiles =();
		foreach my $tgzfile (@tgzfiles){
			TraceMsg("found archive \"$tgzfile\" in current working directory\n",3,\$DEBUG);
			my $untgz = SAPDB::Install::Untgz::new();
			$untgz->Open($tgzfile);
			if($untgz->GetErr){
				TraceMsg("cannot open $tgzname: ".join(': ',$untgz->GetErr)."\n");
				next;
			}
			my %tmp = readPackageData($untgz);
			$tmp{'UNTGZ'} = $untgz;
			($tmp{'INTERFACE_VERSION'} == $SAPDB::Install::Values::interface_version) or next;
			TraceMsg("archive \"$tgzfile\" has correct interface version\n",3,\$DEBUG);
			my @newlist=split(',',$tmp{'IS_TOP_OF'});
			my @exlist = split(',',$tmp{'PART_OF'});
			push @tgzfiles_with_packagedata,[$tgzfile,\%tmp];
			@profiles=union(\@profiles,\@newlist);
			@existingprofiles = union(\@existingprofiles,\@exlist);
		}
		($#existingprofiles == -1) && print2stdout("no valid profile found\n") && diesoft('installation exited ');		
		push @profiles, 'all';
		# select an existing profile
		my $sel=ask4any(\@profiles,'profile','select',$batch);
		$sel == -1 && diesoft('installation aborted ');	
		$profile=$profiles[$sel];
	}
	
	if($profile eq ''){
		$profile = 'all';
	}

	@tgzfiles = @tgzfiles_with_packagedata if ($#tgzfiles_with_packagedata > -1);

	my %selected_packages;
	
	foreach my $tgz (@tgzfiles){
		my $tgzfile;
		my %tmp;
		if(ref($tgz) eq 'ARRAY' and exists ${%{${@$tgz}[1]}}{'UNTGZ'}){
					$tgzfile = ${@$tgz}[0];
					%tmp = %{${@$tgz}[1]};
		}
		else{
			$tgzfile = $tgz;
		}
		TraceMsg("found archive \"$tgzfile\" in current working directory\n",3,\$DEBUG);
		
		unless(exists $tmp{'UNTGZ'}){
			my $untgz = SAPDB::Install::Untgz::new();
			$untgz->Open($tgzfile);
			if($untgz->GetErr){
				TraceMsg("cannot open $tgzname: ".join(': ',$untgz->GetErr)."\n");
				next;
			}
			%tmp = readPackageData($untgz);
			$tmp{'UNTGZ'} = $untgz;
		}
		
		$tmp{'ARCHIVE_NAME'}=$tgzfile;
		
		($tmp{'INTERFACE_VERSION'} == $SAPDB::Install::Values::interface_version) or next;
		TraceMsg("archive \"$tgzfile\" has correct interface version\n",3,\$DEBUG);
				
		# filter packages by profiles
		$profile=~/^all$/i or $tmp{'PART_OF'} =~ /^$profile$|^$profile\s*,|,\s*$profile$|,\s*$profile\s*,/ or 
			TraceMsg("filter out package $tmp{'PACKAGE_NAME'} - caused by profile\n",4,\$DEBUG) and next;
		
		TraceMsg("archive \"$tgzfile\" is part of installation profile \"$profile\"\n",3,\$DEBUG);
		
		if($package){
			# filter packages by package names
			my $found = 0;
			foreach my $packname (split(',',$package)){
				my $pattern = '^\s*'.$packname.'\s*$';
				$pattern =~ s/\s/\\s/g;
				if($tmp{'DISPLAY_NAME'} =~ /$pattern/ or $tmp{'PACKAGE_NAME'} =~ /$pattern/){
					$found = 1;
					last;
				}
			}
			unless($found){
				TraceMsg("filter out package ".
					($tmp{'DISPLAY_NAME'} =~ /\S/ ? $tmp{'DISPLAY_NAME'} : $tmp{'PACKAGE_NAME'}).
					" - caused by package name\n",4,\$DEBUG);
				next;
			}
		} 
		
		if(exists $selected_packages{$tmp{'PACKAGE_NAME'}}){
			print2stderr("package \"".$tmp{'PACKAGE_NAME'}."\" exists more than once in installation kit\n");
			diesoft($diemsg);
		}


		# check sysinfo
		if ($tmp{'TEST_FILE'} =~ /\S/){
			#
			#	let PCR 7300, PCR 7301 and PCR 7403 linux i386 installable on linux opteron
			#	let PCR 7300, PCR 7301 and PCR 7403 windows i386 installable on Windows X64
			#	fake sysinfo.architecture to pass IsRunnable()
			#

			local $sysinfo = $sysinfo;
			my $pack_buildinfo = getBuildInfoTGZ($tmp{'UNTGZ'},$tmp{'TEST_FILE'});
			if (	$tmp{'PACKAGE_NAME'} =~ /^PCR\s73\d\d$|^PCR\s7403$/ && defined $pack_buildinfo &&
					(
						(
							$sysinfo->{'system'} eq 'Windows' &&
							$sysinfo->{'architecture'} eq 'AMD64' &&
							$pack_buildinfo->{magic} =~ /windows.*i386/i 
							
						) || 
						
						(	
							${%$pack_buildinfo}{'sysinfo'}->{'architecture'} eq 'I386' &&
							${%$pack_buildinfo}{'sysinfo'}->{'system'} eq 'Linux' &&
							$sysinfo->{'system'} eq 'Linux' && $sysinfo->{'architecture'} eq 'X86-64'
						)
					 )	
				 ){
				my %hSysinfo = %$sysinfo;
				$hSysinfo{'architecture'} = 'I386';						
				$sysinfo = \%hSysinfo;
			}
			
			if(defined $pack_buildinfo and not IsRunnable($sysinfo,$pack_buildinfo->{'sysinfo'},$pack_buildinfo->{'magic'})){
				my $pack_name = $tmp{'PACKAGE_NAME'};
				$pack_name = $tmp{'DISPLAY_NAME'} if (defined $tmp{'DISPLAY_NAME'});
				print2stderr("software in package $pack_name is not runnable on your system\n");
				if (exists $pack_buildinfo->{magic}){
					print2stderr("FILE MAGIC: ".$pack_buildinfo->{magic}."\n");
				}
				
				foreach my $key (sort keys(%{${%$pack_buildinfo}{'sysinfo'}})){
					$key eq 'magic' && next;
					print2stderr("MAKE SYSTEM: $key = ".${%{${%$pack_buildinfo}{'sysinfo'}}}{$key}."\n");
				}
				print2stderr("\n");
								
				foreach my $key (sort keys(%$sysinfo)){
					$key eq 'magic' && next;
					print2stderr("YOUR SYSTEM: $key = ".${%$sysinfo}{$key}."\n");
				}
				diesoft($diemsg);
			}
			$tmp{'MAGIC'} = ${%$pack_buildinfo}{'magic'};
		}
		push @packages,\%tmp;
		$selected_packages{$tmp{'PACKAGE_NAME'}} = 1;
	}
	@packages=sortpackages($instRegistry_ref,@packages);
	
	
	#
	# search for subpackages and its parents
	#
	my %subpackages;
	foreach my $packagedata (@packages){
		if (defined ${%$packagedata}{'IS_SUBPACKAGE'} and ${%$packagedata}{'IS_SUBPACKAGE'}){
			foreach my $dep (parseRequire(${%$packagedata}{'REQUIRE'})){
				if (${%$dep}{'first'}){
					TraceMsg(${%$packagedata}{'PACKAGE_NAME'}."is subpackage of a ".${%$dep}{name}." package\n",4,\$DEBUG);
					$subpackages{${%$packagedata}{'PACKAGE_NAME'}} = %$dep;				
				}
			}	
			
		}
	}

	foreach my $packagedata (@packages){
		
		my $newpackage = SAPDB::Install::PackageObj->new;
		TraceMsg("initialize packobj ".${%$packagedata}{'PACKAGE_NAME'}."\n",4,\$DEBUG);
		$newpackage->initData($packagedata);
		if(${%$packagedata}{'PACKAGE_NAME'} eq 'APO COM'){
			$SAPDB::Install::Values::APO_release = ${%$packagedata}{'SOFTWARE_VERSION'};
		}
		push @returnvalue,$newpackage;
	}	
	return $profile,@returnvalue;
}

1;
