<!-------------------------------------------------------------------------------->
<!--																			-->
<!--  module: Navigation.js														-->
<!--																			-->
<!--  ------------------------------------------------------------------------  -->
<!--																			-->
<!--  responsible:  Markus Oezgen												-->
<!--																			-->
<!--  special area: Web Navigation												-->
<!--																			-->
<!--  description:  Web navigation control										-->
<!--																			-->
<!--  see also:																	-->
<!--																			-->
<!--  ------------------------------------------------------------------------  -->
<!--																			-->
<!--  ========== licence begin LGPL												-->
<!--  Copyright (c) 2000-2004 SAP AG													-->
<!--																			-->
<!--  This library is free software; you can redistribute it and/or				-->
<!--  modify it under the terms of the GNU Lesser General Public				-->
<!--  License as published by the Free Software Foundation; either				-->
<!--  version 2.1 of the License, or (at your option) any later version.		-->
<!--																			-->
<!--  This library is distributed in the hope that it will be useful,			-->
<!--  but WITHOUT ANY WARRANTY; without even the implied warranty of			-->
<!--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU			-->
<!--  Lesser General Public License for more details.							-->
<!--																			-->
<!--  You should have received a copy of the GNU Lesser General Public			-->
<!--  License along with this library; if not, write to the Free Software		-->
<!--  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA -->
<!--  ========== licence end													-->
<!--																			-->
<!-------------------------------------------------------------------------------->


// Global variables
var Navigations = new navigations();

// Basic collection of navigation objects
function navigations() {

  this.navigationId = 0;
  this.items = new Array();
  this.addNavigation = addNavigation;
  this.justOneNavigation = justOneNavigation;

}

function addNavigation(navigation)
{
  this.items[this.items.length] = navigation;
  navigation.navigationId = this.navigationId++;
}


function justOneNavigation(navigation)
{
  if(this.items.length < 1)
  {
	this.items[this.items.length] = navigation;
	navigation.navigationId = this.navigationId++;
  }
  else
  {
	for (i = 0; i < this.items[this.items.length-1].nodes.length; i++)
	{
		this.items[this.items.length-1].nodes[i] = null;
		delete this.items[this.items.length-1].nodes[i]
	}
	this.items[this.items.length-1].nodes.length = 0;

	//if (navigator.appName == "Netscape" && parseInt(navigator.appVersion) == 4) {

	  //location.reload();
	//}
  }
}


// Navigation object
function navigation(name, rootLabel, frameName, picturesURL, backgroundPicturesURL, withPlus, withToolTip, cookieDays)
{

  this.navigationId = -1;


  this.name      = name;
  this.rootLabel = rootLabel;
  this.frameName = frameName;

  this.picturesURL          = picturesURL;
  this.backgroundPictureURL = backgroundPicturesURL;
  this.withPlus             = withPlus;
  this.withToolTip          = withToolTip;


  this.cookieDays = cookieDays;

  this.selectedNodeId = 0;
  this.expandedNodes = null;
  this.scrollX = 0;
  this.scrollY = 0;

  this.colorBackground             = "#DEDEC8";
  this.colorForeground             = "#000000";
  this.colorBackgroundSelectedNode = "#008080";
  this.colorForegroundSelectedNode = "#ffffff";

  //onClick will mark the item
  this.bMarkSelectedItem = false;

  this.sHRefFunction = "";


  this.nodeId = 0;
  this.nodes = new Array();
  this.addNode = addNode;
}

function setNavigationColors(navigationId,
                             inColorBackground,
                             inColorForeground,
                             inColorBackgroundSelectedNode,
                             inColorForegroundSelectedNode,
                             inColorScrollbarBase,
                             inColorScrollbarShadow) {
    var navigation;
	navigation = Navigations.items[navigationId];
	if(navigation) {
        navigation.colorBackground               = inColorBackground;
        navigation.colorForeground               = inColorForeground;
        navigation.colorBackgroundSelectedNode   = inColorBackgroundSelectedNode;
        navigation.colorForegroundSelectedNode   = inColorForegroundSelectedNode;
        navigation.colorScrollbarBase            = inColorScrollbarBase;
        navigation.colorScrollbarShadow          = inColorScrollbarShadow;
    }
}

// Node object
function node(label, url, targetFrame, picture) {

  this.navigationId = -1;
  this.id = -1;

  // Set node label
  this.label = label;

  // Set URL
  if (url)
    this.url = escapeSpaces(url);
  else
    this.url = "";

  // Set target frame
  if (targetFrame)
    this.targetFrame = targetFrame;
  else
    this.targetFrame = "";

  // Set node picture
  if (picture)
    this.picture = picture;
  else
    this.picture = "";

  this.nodes = new Array();
  this.addNode = addNode;
}

function addNode(node) {

  this.nodes[this.nodes.length] = node;
  node.navigationId = this.navigationId;
  node.id = Navigations.items[this.navigationId].nodeId++;

}

function markSelectedItem(navigationId,bMarkSelectedItem)

{
	var navigation;
	// Get current navigation
	navigation = Navigations.items[navigationId];

	if(navigation)
		navigation.bMarkSelectedItem = bMarkSelectedItem;
}

function hRefAsFunction(navigationId,hRefFunction)

{
	var navigation;
	// Get current navigation
	navigation = Navigations.items[navigationId];

	if(navigation)
		navigation.sHRefFunction = hRefFunction;
}


function nodeSearch(navigation,subList,counter,path)
{
	this.counter = counter;
	this.subList = subList;
	this.navigation = navigation;
	this.path = path;
}

function getSelectedItemName(navigationId)

{
	var navigation, selectedNode,oSearch,parent;

	// Get current navigation
	navigation = Navigations.items[navigationId];

	oSearch	 = new nodeSearch(navigation, navigation.nodes, 0,'/');

	if(navigation.selectedNodeId > -1) {

		if(navigation.nodes.length > 0) {

			selectedNode = getSelectedNode(oSearch);
			if(selectedNode != null)
				return selectedNode.label;
		}

	}
	return '';
}

function getSelectedItemParent(navigationId)

{
	var navigation, selectedNode,oSearch,parent;

	// Get current navigation
	navigation = Navigations.items[navigationId];

	oSearch	 = new nodeSearch(navigation, navigation.nodes, 0,'/');

	if(navigation.selectedNodeId > -1) {

		if(navigation.nodes.length > 0) {

			selectedNode = getSelectedNode(oSearch);

			if(oSearch.path == '/') return '';

			if(selectedNode != null){

				if(oSearch.path.length - selectedNode.label.length > 0)
					return  oSearch.path.substring(0,(oSearch.path.length - selectedNode.label.length));
			}
		}
	}

	return '';
}

function getSelectedItemPath(navigationId)

{
	var navigation, selectedNode,oSearch;

	// Get current navigation
	navigation = Navigations.items[navigationId];

	oSearch	 = new nodeSearch(navigation, navigation.nodes, 0,'/');

	if(navigation.selectedNodeId > -1) {

		if(navigation.nodes.length > 0)
			selectedNode = getSelectedNode(oSearch);
	}

	return oSearch.path
}

function isSelectedItemAPath(navigationId)

{
	var navigation, selectedNode,oSearch;

	// Get current navigation
	navigation = Navigations.items[navigationId];

	if(!navigation) return false;

	oSearch	 = new nodeSearch(navigation, navigation.nodes, 0,'/');
	if(navigation.selectedNodeId < 0){

		//the root folder is selected
		return true;
	}
	if(navigation.nodes.length < 1) return false;

	selectedNode = getSelectedNode(oSearch);

	if (oSearch.path == '/'){

		return true;
	}
	else{
		if(selectedNode)
		{
			if(selectedNode.url == '')

				return true;
			else
				return false;
		}
		else
			return false;
	}
}


function getSelectedNode (oSearch) {

	var oSubSearch;
	var subListIndex;
	var currentNode;
	var newPath;

	subListIndex = 0;
	currentNode = oSearch.subList[subListIndex];

	while ( oSearch.counter != oSearch.navigation.selectedNodeId ) {

		oSearch.counter++;

		if ( currentNode.nodes.length > 0) {

			if (oSearch.path == '/')

				newPath= oSearch.path + currentNode.label;
			else
				newPath = oSearch.path + '/' + currentNode.label;

			oSubSearch	 = new nodeSearch(oSearch.navigation, currentNode.nodes, oSearch.counter,newPath);
			currentNode = getSelectedNode(oSubSearch);
			oSearch.counter = oSubSearch.counter;
			if(currentNode != null) {

				oSearch.path = oSubSearch.path
				return currentNode;
			}
		}

		subListIndex++;

		if(subListIndex <oSearch.subList.length)		{
			currentNode = oSearch.subList[subListIndex];
		}
		else{
			return null; //error invalid index
		}
	}

	if (oSearch.path == '/')

		oSearch.path = oSearch.path + currentNode.label;
	else
		oSearch.path = oSearch.path + '/' + currentNode.label;


	return currentNode;

}

///////////////////////////////////////////////////////////////////////////////
//
// Displays one navigation object with all its nodes
//
///////////////////////////////////////////////////////////////////////////////
function showNavigation(navigationId) {

  var i, cookie, currentDocument, navigation;

  // Get current navigation
  navigation = Navigations.items[navigationId];

  // Is there a cookie with settings for current navigation object?
  cookie = getCookie(navigation.name);
  if (!cookie) {
    if (!navigation.expandedNodes) {
	  // Initialize expanded nodes settings
      navigation.expandedNodes = new Array();
      for (i = 0; i < navigation.nodeId; i++){

        navigation.expandedNodes[i] = 0;
		//alert("navigation.expandedNodes[i]:"+navigation.expandedNodes[i]+","+i)
	  }

	  // Initialize selected node
      navigation.selectedNodeId = -1;
    }
  }
  else {
    // Get expanded nodes settings
    navigation.expandedNodes = cookie.split(",");

	// Get selected node
    cookie = getCookie(navigation.name + "-selectedNodeId");
	//alert("cookie:"+cookie)
    if (!cookie)
      navigation.selectedNodeId = -1;
    else
      navigation.selectedNodeId = cookie;
  }

  // Get current document
  currentDocument = window.frames[navigation.frameName].document;

  // Intialize scroll settings.
  navigation.scrollX = 36;
  navigation.scrollY = 18;

  // Show navigation
  if (document.images)
    currentDocument.open("text/html", "replace");
  else
    currentDocument.open("text/html");

  currentDocument.clear();

  currentDocument.writeln('<html>');
  currentDocument.writeln('<head>');
  currentDocument.writeln('<title>' + navigation.rootLabel + '</title>');
  currentDocument.write('<style type="text/css">a {text-decoration:none;} a:active {background:' + navigation.colorBackgroundSelectedNode + ';color:' + navigation.colorForegroundSelectedNode + ';}');
  if(navigation.colorScrollbarBase && navigation.colorScrollbarShadow) {
    currentDocument.write(' body {');
    currentDocument.write(' scrollbar-base-color:' + navigation.colorScrollbarBase + '; ');
    currentDocument.write(' scrollbar-shadow-color:' + navigation.colorScrollbarShadow + ';');
    currentDocument.write('}');
  }
  currentDocument.writeln('</style>');
  currentDocument.writeln('<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">');
  currentDocument.writeln('</head>');

  currentDocument.writeln('<body background="' + navigation.backgroundPictureURL + '" bgcolor="' + navigation.colorBackground + '" text="' + navigation.colorForeground + '" link="' + navigation.colorForeground + '" alink="' + navigation.colorForeground+ '" vlink="' + navigation.colorForeground + '" onLoad=parent.navigationScroll("' + navigation.frameName + '");>');
  currentDocument.writeln('<table border=0 cellpadding=0 cellspacing=0>');

  if (navigation.selectedNodeId == -1 && navigation.bMarkSelectedItem == true)
  	currentDocument.write('<tr valign=top><td bgcolor="'+navigation.colorBackgroundSelectedNode+'">');
  else
	currentDocument.write('<tr valign=top><td>');


  currentDocument.write('<a href="#" onClick="return parent.navigationRootClick(' + navigationId + ');">');

  if (node.id == navigation.selectedNodeId && navigation.bMarkSelectedItem == true)
  	  currentDocument.write('<font color="'+navigation.colorForegroundSelectedNode+'">');

  currentDocument.write('<font face="MS Sans Serif,Arial,Helvetica" size=1>&nbsp;');

  if(navigation.selectedNodeId == -1 && navigation.bMarkSelectedItem == true)
  	  currentDocument.write('<font color="'+navigation.colorForegroundSelectedNode+'">');

  currentDocument.write(navigation.rootLabel + '&nbsp;</font>');
  currentDocument.writeln('</td></tr>');

  showNodes(navigationId, false, navigation.nodes, 0);

  currentDocument.writeln('</table>');

  currentDocument.writeln('</body>');
  currentDocument.writeln('</html>');

  currentDocument.close();

}

///////////////////////////////////////////////////////////////////////////////
//
// Displays all nodes of a navigation object
//
///////////////////////////////////////////////////////////////////////////////

function showNodes(navigationId, parentIsLastNode, nodes, nodeLevel) {

  var i;

  for (i = 0; i < nodes.length; i++) {
    if (i == nodes.length - 1)
	  showNode(navigationId, nodes[i], nodeLevel, parentIsLastNode, true);
    else
	  showNode(navigationId, nodes[i], nodeLevel, parentIsLastNode, false);
  }
}

///////////////////////////////////////////////////////////////////////////////
//
// Displays one node of a navigation object
//
///////////////////////////////////////////////////////////////////////////////

function showNode(navigationId, node, nodeLevel, parentIsLastNode, isLastNode) {

  var navigation, statement, image, toolTip, urlExists, nodeIsExpanded, childNodeExists, childNodesHasChildNodes;
  var i

  // Get current navigation
  navigation = Navigations.items[navigationId];

  // Get current document
  currentDocument = window.frames[navigation.frameName].document;

  // If node is selected node the update vertical scroll value
  if (node.id == navigation.selectedNodeId)
    navigation.scrollY += 18;

  // Is this node expanded?
  if (navigation.expandedNodes[node.id] == 1)
    nodeIsExpanded = true;
  else
    nodeIsExpanded = false;

  // Are there child nodes?
  if (node.nodes.length > 0)
    childNodeExists = true;
  else
    childNodeExists = false;

  // Is there a defined URL for this node?
  if (node.url != "")
    urlExists = true;
  else
    urlExists = false;

  // Create nodeClick statement for onClick event of current node
  statement = "return parent.nodeClick(" + navigationId + ", " + node.id + ", " + urlExists + ", " + childNodeExists + ");";

  // Start displaying current node
  if (node.id == navigation.selectedNodeId && navigation.bMarkSelectedItem == true)
  	currentDocument.write('<tr valign=top><td style="white-space:nowrap;" bgcolor="'+navigation.colorBackgroundSelectedNode+'">');
  else
	currentDocument.write('<tr valign=top><td style="white-space:nowrap;">');


  // Display lines and set horizontal scroll value
  for (i = 0; i < nodeLevel; i++) {
    if (!parentIsLastNode) {
      currentDocument.write('<img src="' + navigation.picturesURL + 'WANav1.gif" align=left border=0 vspace=0 hspace=0>');
    }
    else {
      currentDocument.write('<img src="' + navigation.picturesURL + 'WANav9.gif" align=left border=0 vspace=0 hspace=0>');
    }

    if (node.id == navigation.selectedNodeId)
      navigation.scrollX += 18;
  }

  // If current node has a child, check whether these childs has also one child at least
  childNodesHasChildNodes = false;
  if (node.nodes.length > 0 && navigation.withPlus)
    for (i = 0; i < node.nodes.length; i++)
      if (node.nodes[i].nodes.length > 0 || navigation.withPlus)
        childNodesHasChildNodes = true;

  // If there are no childs and these childs has also no childs
  if (!childNodesHasChildNodes) {
	// If this is the last node
    if (isLastNode) {
	  // Display a corner
      image = "WANav2.gif";
    }
	// if this is not the last node
    else {
	  // Display a tee
      image = "WANav10.gif";
    }

	// Display image
    currentDocument.write('<img src="' + navigation.picturesURL + image + '" align=left border=0 vspace=0 hspace=0>');
  }

  // If there was a URL create a hyperlink statement
  if (node.url != ""){

	if(navigation.sHRefFunction != "")
		currentDocument.write('<a href="javascript:' + navigation.sHRefFunction + '(\'' + node.url + '\')"' + '" onClick="' + statement + '">');
	else
		currentDocument.write('<a href="' + node.url + '" target="' + node.targetFrame + '" onClick="' + statement + '">');
  }
  else
    currentDocument.write('<a href="#" onClick="' + statement + '">');

  if (node.id == navigation.selectedNodeId  && navigation.bMarkSelectedItem == true)
  	  currentDocument.write('<font color="'+navigation.colorForegroundSelectedNode+'">');

  // If there is a child and these childs has also one child at least
  if (childNodesHasChildNodes) {
    // If node is expanded
    if (nodeIsExpanded) {
	  // And node is last node
      if (isLastNode) {
	    // Display a corner with minus
        image = "treebranch_open.gif";
      }
	  // And node is not the last node
      else {
		// Display a tee with minus
        image = "treebranch_open.gif";
      }
    }
	// Or node is not expanded
    else {
	  // And node is last node
      if (isLastNode) {
		// Display a corner with plus
        image = "treebranch_closed.gif";
      }
	  // And node is not the last node
      else {
	    // Display a tee with plus
        image = "treebranch_closed.gif";
      }
    }

	// Display image
    currentDocument.write('<img src="' + navigation.picturesURL + image + '" align=left border=0 vspace=0 hspace=0>');
  }

  // If a child node exists
  if (childNodeExists || node.url == "") {
      // Display a close folder
      image = "treefolder.gif";
  }
  // If there are no childs
  else {
    // If node has its own picture
    if (node.picture != "")
	  // Display node's own picture
      image = node.picture;
	// If node's URL is an external hyperlink
    else if (node.url.indexOf("http://") == 0)
	  // Display hyperlink
      image = "WANav13.gif";
    else
	  // Display service internal hyperlink picture
      image = "treeleaf.gif";
  }

  // If a tool tip is desired
  if (navigation.withToolTip)
    // Display node's label as tool tip
    toolTip = ' alt="' + node.label + '"';
  else
    toolTip = '';

  // Display image and tool tip
  currentDocument.write('<img src="' + navigation.picturesURL + image + '"' + toolTip + ' align=left border=0 vspace=0 hspace=0>');

  // Display node's label
  currentDocument.write('<font face="MS Sans Serif,Arial,Helvetica" size=1> ' + node.label + '</font>');

  // Close displaying current node
  currentDocument.write('</a>');
  currentDocument.writeln('</td></tr>');

  // If current node is expanded, and node has childs,
  // call this function recursive to display node's childs
  if (childNodeExists > 0  && nodeIsExpanded) {
    nodeLevel++;
    showNodes(navigationId, isLastNode, node.nodes, nodeLevel);
    nodeLevel--;
  }
}

///////////////////////////////////////////////////////////////////////////////
//
// Handling of node clicks
//
///////////////////////////////////////////////////////////////////////////////

function nodeClick(navigationId, nodeId, nodeURL, childNodeExists) {

  var navigation, date, cookie, statement;

  // Get current navigation
  navigation = Navigations.items[navigationId];
  if (!navigation ) {


    refreshNavigation();

	statement = "nodeClick(" + navigationId + ", " + nodeId + ", " + nodeURL + ", " + childNodeExists + ")";
    setTimeout(statement, 10);

	//alert("Site has to be refreshed!\nPlease, make your selection again!");
	return nodeURL;
  }

  // If selected node has childs
  if (childNodeExists  || !nodeURL){

		// Switch its expanded flag
		navigation.expandedNodes[nodeId] = 1 - navigation.expandedNodes[nodeId];
  }


  // Set selected node id
  navigation.selectedNodeId = nodeId;


  // Write updated cookie to store navigation's settings
  date = new Date ();
  date.setTime (date.getTime() + (86400000 * navigation.cookieDays));
  cookie = navigation.expandedNodes.toString();
  setCookie(navigation.name, cookie, date)
  setCookie(navigation.name + "-selectedNodeId", navigation.selectedNodeId, date)

  // Show navigation with a delay of 10 ms
  statement = "showNavigation(" + navigationId + ")";
  setTimeout(statement, 10);

  // Return node's URL
  return nodeURL;
}

///////////////////////////////////////////////////////////////////////////////
//
// Handling of root node clicks
//
///////////////////////////////////////////////////////////////////////////////

function navigationRootClick(navigationId) {

  var navigation, statement;

  // Get current navigation
  navigation = Navigations.items[navigationId];

  // Reset navigation settings
  navigation.expandedNodes = null;
  navigation.selectedNodeId = null;

  // Delete cookies
  deleteCookie(navigation.name);
  deleteCookie(navigation.name + "-selectedNodeId");

  // Show navigation with a delay of 10 ms
  statement = "showNavigation(" + navigationId + ")";
  setTimeout(statement, 10);

  return false;
}

///////////////////////////////////////////////////////////////////////////////
//
// Scroll navigation to display selected node
//
///////////////////////////////////////////////////////////////////////////////

function navigationScroll(frameName) {

  var frame, height, width;

  // Get current frame
  frame = window.frames[frameName];

  // Get frame sizes
  if (document.layers) {
    height = frame.innerHeight;
    width = frame.innerWidth;
  }
  else if (document.all) {
    height = frame.document.body.clientHeight;
    width = frame.document.body.clientWidth;
  }
  else if (document.images) {
    frame.scroll(0, navigation.scrollY);
    return;
  }
  else
    return;

  // Scroll frame
  if (navigation.scrollY > height)
    frame.scrollBy(0, navigation.scrollY);
  if (navigation.scrollX > width)
    frame.scrollBy(navigation.scrollX, 0);
}

///////////////////////////////////////////////////////////////////////////////
//
// Set cookie
//
///////////////////////////////////////////////////////////////////////////////

function setCookie (name, value, expires) {

  document.cookie = name + "=" + escape(value) + "; expires=" + expires.toGMTString() +  "; path=/";

}

///////////////////////////////////////////////////////////////////////////////
//
// Get cookie
//
///////////////////////////////////////////////////////////////////////////////

function getCookie(name) {

  var search;

  search = name + "="
  offset = document.cookie.indexOf(search)

  if (offset != -1) {
    offset += search.length ;
    end = document.cookie.indexOf(";", offset) ;

    if (end == -1)
      end = document.cookie.length;

    return unescape(document.cookie.substring(offset, end));
  }
  else
    return "";

}

///////////////////////////////////////////////////////////////////////////////
//
// Delete cookie
//
///////////////////////////////////////////////////////////////////////////////

function deleteCookie(name)
{

  var exp = new Date();
  exp.setTime(exp.getTime() - 1);
  setCookie(name, "", exp);

}

///////////////////////////////////////////////////////////////////////////////
//
// Set focus
//
///////////////////////////////////////////////////////////////////////////////

function setFocus(object) {

  object.focus();
  object.select();

}


function escapeSpaces(input)
{
	var out;
	out = input.replace(/ /g,"%20");
	return out;
}
