#
# =====================================================
# @(#) WA                        7.4        2000-10-13
# =====================================================
# Created in  7.4:
#
#
#    ========== licence begin  GPL
#    Copyright (c) 2000-2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end

from installib import *

def install (session,options):
    """Installing tables for WebAgent
    """

    loaderCmd (session, 'INSTALLATION ON')

    loaderCmd (session, 'AUTOCOMMIT OFF')

    #ADIS #1001953/1002033
    requireSysdba (session)

    #----------------------------------------------------------------------------
    # Create tables for database filesystem
    #----------------------------------------------------------------------------

    #----------------------------------------------------------------------------
    # Create table container
    #----------------------------------------------------------------------------
    if not existsTable (session, "WA_CONTAINER"):
        stopIfSqlNotOK (session, """
            CREATE TABLE WA_CONTAINER
            (
             ViewOwner              SYSID,
             ContainerId            CHAR (8) BYTE NOT NULL DEFAULT STAMP,
             Inode                  CHAR (8) BYTE NOT NULL,
             Data                   LONG BYTE,
             Size                   INT,
             Compressed             CHAR(1) ASCII,
             PRIMARY KEY (ContainerId),
             CONSTRAINT WA_CONTAINER_INDEX UNIQUE (Inode)
            ) INTERNAL""")
    else:
        if (options.migrate):
            stopIfSqlNotOK  (session, 'ALTER TABLE WA_CONTAINER MODIFY (ViewOwner SYSMSGTEXT)')

    #----------------------------------------------------------------------------
    # Create table inode
    #----------------------------------------------------------------------------
    if not existsTable (session, "WA_INODE"):
        stopIfSqlNotOK (session, """
         CREATE TABLE WA_INODE
          (
             ViewOwner              SYSID,
             PartitionId            INT,
             InodeId                CHAR (8) BYTE DEFAULT STAMP,
             ParentDirectory        CHAR (8) BYTE,
             Name                   CHAR(245)       NOT NULL,
             Type                   CHAR(4)  ASCII,
             Protection             CHAR(9)  ASCII,
             Owner                  CHAR(16),
             UGroup                 CHAR(16),
             CreationDate           DATE,
             CreationTime           TIME,
             ModificationDate       DATE,
             ModificationTime       TIME,
             Container              CHAR (8) BYTE,
             LinkInode              CHAR (8) BYTE,
             Size                   INT,
             PRIMARY KEY (PartitionId,InodeId),
             CONSTRAINT WA_INODE_INDEX_1 UNIQUE (ViewOwner,ParentDirectory, Name),
             CONSTRAINT WA_INODE_INDEX_2 UNIQUE (Container)
            ) INTERNAL""")
    else:
        if (options.migrate):
            stopIfSqlNotOK  (session, 'ALTER TABLE WA_INODE MODIFY (ViewOwner SYSMSGTEXT)')

    #----------------------------------------------------------------------------
    # alter dbfs tables
    #----------------------------------------------------------------------------
    # This kind of foreign key definition is restricted in SAP DB 7.4
    # The referential delete on index is not implemented (Thomas Anhaus)
    # WebAgent tries to delete all referential depending data entries
    #stopIfSqlNotOK (session, "ALTER TABLE WA_CONTAINER FOREIGN KEY (Inode) REFERENCES WA_INODE (InodeId)  ON DELETE CASCADE")
    #stopIfSqlNotOK (session, "ALTER TABLE WA_INODE FOREIGN KEY (LinkInode) REFERENCES WA_INODE (InodeId)  ON DELETE CASCADE")

    stopIfSqlNotOK (session, "COMMENT ON TABLE WA_INODE IS 'Inode describes a UNIX-like directory  structure.'")


    #----------------------------------------------------------------------------
    # Create the view of dbfs container
    #----------------------------------------------------------------------------
    dropView (session, "WA_MY_CONTAINER")
    stopIfSqlNotOK (session, """
            CREATE VIEW WA_MY_CONTAINER AS
            SELECT  *
            FROM    WA_CONTAINER
            WHERE   VIEWOWNER = USERGROUP
        WITH CHECK OPTION INTERNAL""")

    #----------------------------------------------------------------------------
    # Create the view of dbfs inode
    #----------------------------------------------------------------------------
    dropView (session, "WA_MY_INODE")
    stopIfSqlNotOK (session, """
            CREATE VIEW WA_MY_INODE AS
            SELECT  *
            FROM    WA_INODE
            WHERE   VIEWOWNER = USERGROUP
        WITH CHECK OPTION INTERNAL""")
    #----------------------------------------------------------------------------
    # Grant for the view WA_MY_CONTAINER
    #----------------------------------------------------------------------------
    stopIfSqlNotOK (session, """
            GRANT   SELECT, UPDATE, DELETE, INSERT
            ON      WA_MY_CONTAINER
            TO      PUBLIC""")

    #----------------------------------------------------------------------------
    # Grant for the view WA_MY_INODE
    #----------------------------------------------------------------------------
    stopIfSqlNotOK (session, """
            GRANT   SELECT, UPDATE, DELETE, INSERT
            ON      WA_MY_INODE
            TO      PUBLIC""")

    stopIfSqlNotErr (session, -4016, 'DROP DBPROC SYSDDLTRIGGERPL')

    stopIfSqlNotOK (session,
        """CREATE DBPROC SYSDDLTRIGGERPL as
        VAR
        action     char(32);
        objtype    char(32);
        param1     char(32);
        param2     char(32);
        param3     char(32);
        param4     char(32);
        owner      char(32);
        tablename  char(32);
        columnname char(32);
        rc         integer;
        DECLARE SYSRESULT CURSOR FOR SELECT ACTION, OBJECTTYPE, PARAM1, PARAM2, PARAM3, PARAM4
            FROM SYSDD.PARAMETERS;
        WHILE $RC = 0 DO
          BEGIN
          FETCH  SYSRESULT INTO :ACTION, :OBJTYPE,
              :PARAM1, :PARAM2, :PARAM3, :PARAM4;
          if $RC = 0
          THEN
            BEGIN
            IF ACTION = 'DROP'
            THEN
              BEGIN
              IF OBJTYPE = 'USER'
              THEN
                BEGIN
                DELETE SYSDBA.SYSQP_MY_FAVORITES
                  WHERE SYSQP_MY_FAVORITES.FITEMNAME = :PARAM2 AND
                  SYSQP_MY_FAVORITES.FITEMTYPE = 7;
                IF $RC = 0 OR $RC = 100 OR $RC = -4004
                THEN
                  DELETE  SYSDBA.WA_INODE WHERE "VIEWOWNER" = :PARAM2;
                IF $RC = 0 OR $RC = 100 OR $RC = -4004
                THEN
                  DELETE  SYSDBA.WA_CONTAINER WHERE "VIEWOWNER" = :PARAM2;
                IF $RC = 0 OR $RC = 100 OR $RC = -4004
                THEN
                  DELETE  SYSDBA.SYSUPDSTATWANTED WHERE OWNER = :PARAM2;
                IF $RC = 100 OR $RC = -4004 THEN $RC = 0;
                CONTINUE;
                END; /* USER */
              IF OBJTYPE IN ('SYNONYM', 'TABLE', 'VIEW')
              THEN
                BEGIN
                DELETE SYSDBA.SYSQP_MY_FAVORITES WHERE
                  SYSQP_MY_FAVORITES.FITEMOWNER = :PARAM1 AND
                  SYSQP_MY_FAVORITES.FITEMNAME  = :PARAM2  AND
                  SYSQP_MY_FAVORITES.FITEMTYPE  BETWEEN  1 AND 6;
                IF $RC = 0 OR $RC = 100 OR $RC = -4004
                THEN
                  DELETE SYSDBA.SYSUPDSTATWANTED WHERE OWNER = :PARAM1 AND
                    TABLENAME = :PARAM2;
                IF $RC = 100 OR $RC = -4004 THEN $RC = 0;
                CONTINUE;
                END; /* TABLE */
              IF OBJTYPE = 'COLUMN'
              THEN
                BEGIN
                DELETE  SYSDBA.SYSUPDSTATWANTED WHERE OWNER = :PARAM1 AND
                   TABLENAME   = :PARAM2 AND
                   COLUMNNAME  = :PARAM3;
                IF $RC = 100 OR $RC = -4004 THEN $RC = 0;
                CONTINUE;
                END; /* COLUMN */
              END; /* DROP */
            IF ACTION = 'RENAME'
            THEN
              BEGIN
              IF OBJTYPE = 'USER'
              THEN
                BEGIN
                UPDATE SYSDBA.SYSQP_MY_FAVORITES SET "FITEMNAME" = :PARAM3 WHERE SYSQP_MY_FAVORITES.FITEMNAME = :PARAM2 AND SYSQP_MY_FAVORITES.FITEMTYPE = 7;
                IF $RC = 0 OR $RC = 100 OR $RC = -4004
                THEN
                  UPDATE SYSDBA.WA_INODE SET "VIEWOWNER" = :PARAM3 WHERE "VIEWOWNER" = :PARAM2;
                IF $RC = 0 OR $RC = 100 OR $RC = -4004
                THEN
                  UPDATE SYSDBA.WA_CONTAINER SET "VIEWOWNER" = :PARAM3 WHERE "VIEWOWNER" = :PARAM2;
                IF $RC = 0 OR $RC = 100 OR $RC = -4004
                THEN
                  BEGIN
                  SELECT SYSUPDSTAT_CURSOR (OWNER, TABLENAME, COLUMNNAME) FROM SYSDBA.SYSUPDSTATWANTED WHERE OWNER = :PARAM2 FOR REUSE;
                  IF $RC = 0
                  THEN
                    BEGIN
                    DELETE SYSDBA.SYSUPDSTATWANTED WHERE OWNER = :PARAM2;
                    WHILE $RC = 0 DO
                      BEGIN
                      FETCH SYSUPDSTAT_CURSOR INTO :OWNER, :TABLENAME, :COLUMNNAME;
                      IF $RC = 0
                      THEN
                        INSERT INTO SYSDBA.SYSUPDSTATWANTED VALUES (:PARAM3,:TABLENAME,:COLUMNNAME);
                      END;
                    END;
                  CLOSE SYSUPDSTAT_CURSOR;
                  END;
                IF $RC = -4000 OR $RC = -4004 THEN $RC = 0;
                CONTINUE;
                END;
              IF OBJTYPE IN ('SYNONYM', 'TABLE', 'VIEW')
              THEN
                BEGIN
                UPDATE SYSDBA.SYSQP_MY_FAVORITES SET "FITEMNAME"  = :PARAM3 WHERE SYSQP_MY_FAVORITES.FITEMOWNER = :PARAM1 AND SYSQP_MY_FAVORITES.FITEMNAME = :PARAM2 AND SYSQP_MY_FAVORITES.FITEMTYPE BETWEEN  1 AND 6;
                IF $RC = 0 OR $RC = 100 OR $RC = -4004
                THEN
                  BEGIN
                  SELECT SYSUPDSTAT_CURSOR (COLUMNNAME) FROM SYSDBA.SYSUPDSTATWANTED WHERE OWNER = :PARAM1 AND TABLENAME = :PARAM2 FOR REUSE;
                  IF $RC = 0
                  THEN
                    BEGIN
                    DELETE SYSDBA.SYSUPDSTATWANTED WHERE OWNER = :PARAM1 AND TABLENAME = :PARAM2;
                    WHILE $RC = 0 DO
                      BEGIN
                      FETCH SYSUPDSTAT_CURSOR INTO :COLUMNNAME;
                      IF $RC = 0
                      THEN
                        INSERT INTO SYSDBA.SYSUPDSTATWANTED VALUES (:PARAM1,:PARAM3,:COLUMNNAME);
                      END;
                    END;
                  CLOSE SYSUPDSTAT_CURSOR;
                  END;
                IF $RC = -4000 OR $RC = -4004 THEN $RC = 0;
                CONTINUE;
                END;
              IF OBJTYPE = 'COLUMN'
              THEN
                BEGIN
                DELETE  SYSDBA.SYSUPDSTATWANTED WHERE OWNER = :PARAM1 AND TABLENAME = :PARAM2 AND COLUMNNAME = :PARAM3;
                IF $RC = 0
                THEN
                  INSERT INTO SYSDBA.SYSUPDSTATWANTED VALUES (:PARAM1,:PARAM3,:PARAM4);
                IF $RC = 100 OR $RC = -4004 THEN $RC = 0;
                CONTINUE;
                END;
              END; /* RENAME */
            END; /* FETCH */
          END; /* WHILE */
          rc = $RC;
          CLOSE SYSRESULT;
          IF $RC = 0
          THEN
            $RC = rc;
          IF $RC <> 0 AND $RC <> 100 AND $RC <> -4004
          THEN
            STOP (-9406, 'DDL Trigger failed : ' || CHR($RC));""")

    #----------------------------------------------------------------------------
    # Commit the data definitions
    #----------------------------------------------------------------------------

    loaderCmd (session, 'COMMIT')

    loaderCmd (session, 'INSTALLATION OFF')

    # End of Install


if __name__ == '__main__':
    connectAndInstall (install, install.__doc__)


