#
# =====================================================
# @(#) SAP DB LOADER     7.4.3        21.06.2002
# =====================================================
#
#
#    ========== licence begin  GPL
#    Copyright (c) 2002-2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end

from installib import *


def install (session,options):
    """Installing Loader tables
    """

    loaderCmd (session, 'INSTALLATION  ON')

    loaderCmd (session, 'AUTOCOMMIT OFF')

    # ********************************
    #  Table TRANSFORMATIONMODEL
    # ********************************

    dropTable (session, "TRANSFORMATIONMODEL")

    stopIfSqlNotOK (session,
    """
    CREATE TABLE TRANSFORMATIONMODEL (
    PACKAGEGUID            CHAR  (24)    BYTE                 ,
    TASKID                 FIXED (6,0)   DEFAULT      0       ,
    SERVERNODE             CHAR  (32)    DEFAULT      NULL    ,
    SERVERDB               CHAR  (32)    DEFAULT      NULL    ,
    USERNAME               CHAR  (32)    DEFAULT      NULL    ,
    CODEPAGEID             CHAR  (32)    DEFAULT      NULL    ,
    STORAGEDEVICE          CHAR  (32)    DEFAULT      NULL    ,
    TRANSACTIONSIZE        FIXED (6,0)   DEFAULT      0       ,
    TRANSFORMATION         CHAR  (32)    DEFAULT      NULL    ,
    PART                   CHAR  (8)     DEFAULT      NULL    ,
    STEPID                 FIXED (6,0)   DEFAULT      0       ,
    OWNER                  CHAR  (32)                         ,
    TABLENAME              CHAR  (32)                         ,
    TABLETYPE              CHAR  (8 )    ASCII                ,
    CATALOGSTREAMNAME      CHAR  (254)   DEFAULT      NULL    ,
    CATALOGSTREAMTYPE      CHAR  (32)    DEFAULT      NULL    ,
    CATALOGSTREAMEBID      CHAR  (32)    DEFAULT      NULL    ,
    CATALOGSTREAMFORMAT    CHAR  (32)    DEFAULT      NULL    ,
    DATASTREAMNAME         CHAR  (254)   DEFAULT      NULL    ,
    DATASTREAMTYPE         CHAR  (32)    DEFAULT      NULL    ,
    DATASTREAMEBID         CHAR  (32)    DEFAULT      NULL    ,
    DATASTREAMFORMAT       CHAR  (32)    DEFAULT      NULL    ,
    CODETYPE               CHAR  (32)    DEFAULT      NULL    ,
    DATASTREAMHEADERBLOCK  Fixed (6,0)   DEFAULT      0       ,
    DATASTREAMHEADERPOS    Fixed (10,0)  DEFAULT      0       ,
    DATASTREAMDATABLOCK    Fixed (6,0)   DEFAULT      0       ,
    DATASTREAMDATAPOS      Fixed (10,0)  DEFAULT      0       ,
    DATASTREAMTRAILERBLOCK Fixed (6,0)   DEFAULT      0       ,
    DATASTREAMTRAILERPOS   Fixed (10,0)  DEFAULT      0       ,
    EXCLUDE                BOOLEAN       DEFAULT      FALSE   ,
    RESTART                BOOLEAN       DEFAULT      TRUE    ,
    RESTORE                BOOLEAN       DEFAULT      FALSE   ,
    PAGECOUNT              Fixed (10,0)  DEFAULT      0       ,
    ROWCOUNT               Fixed (10,0)  DEFAULT      0       ,
    STARTTIME              TIMESTAMP     DEFAULT      NULL    ,
    ENDTIME                TIMESTAMP     DEFAULT      NULL    ,
    REQUESTTIME            Fixed (15,10) DEFAULT      0       ,
    RECEIVETIME            Fixed (15,10) DEFAULT      0       ,
    IOTIME                 Fixed (15,10) DEFAULT      0       ,
    LOGTIME                Fixed (15,10) DEFAULT      0       ,
    SEQ_NO                 Fixed (6,0)   DEFAULT      0       ,
    CMD                    CHAR  (254)   ASCII                ,
    PRIMARY KEY ( PACKAGEGUID, TASKID, STEPID, OWNER, TABLENAME, SEQ_NO),
    CONSTRAINT "STORAGEDEVICE"       CHECK \"STORAGEDEVICE\"       IS NULL OR \"STORAGEDEVICE\"       IN ('NONE'   , 'ADSM', 'BACK', 'NSR' ) ,
    CONSTRAINT "TRANSFORMATION"      CHECK \"TRANSFORMATION\"      IS NULL OR \"TRANSFORMATION\"      IN ('EXTRACT', 'LOAD', 'UPDATE' ) ,
    CONSTRAINT "PART"                CHECK \"PART\"                IS NULL OR \"PART\"                IN ('ALL'    , 'USER', 'TABLE'  ) ,
    CONSTRAINT "TABLETYPE"           CHECK \"TABLETYPE\"           IS NULL OR \"TABLETYPE\"           IN ('TABLE'  , 'VIEW', 'SYNONYM') ,
    CONSTRAINT "CATALOGSTREAMTYPE"   CHECK \"CATALOGSTREAMTYPE\"   IS NULL OR \"CATALOGSTREAMTYPE\"   IN ('FILE'   , 'PIPE', 'TAPE'   ) ,
    CONSTRAINT "CATALOGSTREAMFORMAT" CHECK \"CATALOGSTREAMFORMAT\" IS NULL OR \"CATALOGSTREAMFORMAT\" IN ('DDL'    , 'XML' ) ,
    CONSTRAINT "DATASTREAMTYPE"      CHECK \"DATASTREAMTYPE\"      IS NULL OR \"DATASTREAMTYPE\"      IN ('FILE'   , 'PIPE', 'TAPE' ) ,
    CONSTRAINT "DATASTREAMFORMAT"    CHECK \"DATASTREAMFORMAT\"    IS NULL OR \"DATASTREAMFORMAT\"    IN ('PAGES'  , 'RECORDS', 'COMPRESSED', 'FORMATTED' ),
    CONSTRAINT "CODETYPE"            CHECK \"CODETYPE\"            IS NULL OR \"CODETYPE\"            IN ('ASCII'  , 'UCS2', 'UTF8' )
    )
    INTERNAL
    """)

    stopIfSqlNotOK (session, 'CREATE INDEX PACKAGE_INDEX ON TRANSFORMATIONMODEL (PACKAGEGUID,OWNER,TABLENAME)')

    # grant on TRANSFORMATIONMODEL
    stopIfSqlNotOK (session, 'GRANT SELECT,INSERT,UPDATE,DELETE ON TRANSFORMATIONMODEL TO PUBLIC')

    #comments on TRANSFORMATIONMODEL columns
    stopIfSqlNotOK (session, flatString ("""COMMENT ON TABLE  TRANSFORMATIONMODEL IS
    ' ' """))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONMODEL.PACKAGEGUID IS
    'Unique Identifier of the TransformationPackage ' """))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONMODEL.TASKID IS
    'TransformationTask Identifier '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONMODEL.SERVERNODE IS
    'Node of the Database to transform '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONMODEL.SERVERDB IS
    'Name of the Database to transform '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONMODEL.CODETYPE IS
    'Encoding type of the Database to transform '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONMODEL.USERNAME IS
    'Name of User running Loader Session '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONMODEL.CODEPAGEID IS
    'Identifier of a ASCII Codepage associated to Loader Command '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONMODEL.STORAGEDEVICE IS
    'External Backuptool associated to Loader Session '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONMODEL.TRANSACTIONSIZE IS
    'Number of Records that are transformed within a transaction  '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONMODEL.TRANSFORMATION IS
    'TransformationType '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONMODEL.PART IS
    'TransformationPart '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONMODEL.STEPID IS
    'TransformationStep Identifier'"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONMODEL.OWNER IS
    'Owner of TableType to transform '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONMODEL.TABLENAME IS
    'Name of TableType to transform'"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONMODEL.TABLETYPE IS
    'TableType to transform '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONMODEL.CATALOGSTREAMNAME IS
    'Identifier of CatalogStream associated to Loader Command '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONMODEL.CATALOGSTREAMTYPE IS
    'DeviceType of CatalogStream associated to Loader Command '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONMODEL.CATALOGSTREAMEBID IS
    'External Backup Identifier of CatalogStream associated to Loader Command '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONMODEL.CATALOGSTREAMFORMAT IS
    'Format of CatalogStream associated to Loader Command '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONMODEL.DATASTREAMNAME IS
    'Identifier of DataStream associated to Loader Command '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONMODEL.DATASTREAMTYPE IS
    'Type of DataStream associated to Loader Command  '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONMODEL.DATASTREAMEBID IS
    'External Backup Identifier of DataStream associated to Loader Command '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONMODEL.DATASTREAMFORMAT IS
    'Format of DataStream associated to Loader Command '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONMODEL.DATASTREAMHEADERBLOCK IS
    'StartPosition of DataStreamHeader counted in 2 GB Blocks '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONMODEL.DATASTREAMHEADERPOS IS
    'StartPosition of DataStreamHeader counted in Bytes less than 2 GB '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONMODEL.DATASTREAMDATABLOCK IS
    'StartPosition of DataStreamData counted in 2 GB Blocks  '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONMODEL.DATASTREAMDATAPOS IS
    'StartPosition of DataStreamData counted in Bytes less than 2 GB  '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONMODEL.DATASTREAMTRAILERBLOCK IS
    'StartPosition of DataStreamTrailer counted in 2 GB Blocks  '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONMODEL.DATASTREAMTRAILERPOS IS
    'StartPosition of DataStreamTrailer counted in Bytes less than 2 GB  '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONMODEL.EXCLUDE IS
    'TransformationStep excluded '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONMODEL.RESTART IS
    'TransformationStep succeeded '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONMODEL.RESTORE IS
    'Transform TransformationStep to Loader Command '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONMODEL.PAGECOUNT IS
    'Number of Pages transformed by a TransformationStep '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONMODEL.ROWCOUNT IS
    'Number of Rows transformed by a TransformationStep'"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONMODEL.STARTTIME IS
    'StartTime of TransformationStep '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONMODEL.ENDTIME IS
    'EndTime of TransformationStep '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONMODEL.REQUESTTIME IS
    'Total execution time of kernel requests within a TransformationStep '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONMODEL.RECEIVETIME IS
    'Total execution time of kernel receives within a TransformationStep '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONMODEL.IOTIME  IS
    'Total iotime within a TransformationStep'"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONMODEL.LOGTIME IS
    'Total logtime within a TransformationStep'"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONMODEL.SEQ_NO IS
    'Authorization statement exceeding a columnwidth '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONMODEL.CMD IS
    'Authorization statement '"""))

    # ********************************
    #  Table CodePage
    # ********************************

    dropTable (session, "CODEPAGE")

    stopIfSqlNotOK (session,
    """
    CREATE TABLE \"CODEPAGE\" (
    CODEPAGEID                  CHAR (32)                  NOT NULL,
    CODEPAGETABLE               CHAR (512)    BYTE         NOT NULL,
    PRIMARY KEY (CODEPAGEID)) INTERNAL
    """)

    # grant on CODEPAGE
    stopIfSqlNotOK (session, 'GRANT ALL ON CODEPAGE TO PUBLIC')

    # fill table with most known code page mappings ASCII->UCS2 (not swapped)
    stopIfSqlNotOK (session,
    """
    INSERT INTO CODEPAGE VALUES('ISO-8859-2', x'0000000100020003000400050006000700080009000A000B000C000D000E000F0010001100120013001400150016001700180019001A001B001C001D001E001F0020002100220023002400250026002700280029002A002B002C002D002E002F0030003100320033003400350036003700380039003A003B003C003D003E003F0040004100420043004400450046004700480049004A004B004C004D004E004F0050005100520053005400550056005700580059005A005B005C005D005E005F0060006100620063006400650066006700680069006A006B006C006D006E006F0070007100720073007400750076007700780079007A007B007C007D007E007F0080008100820083008400850086008700880089008A008B008C008D008E008F0090009100920093009400950096009700980099009A009B009C009D009E009F00A0010402D8014100A4013D015A00A700A80160015E0164017900AD017D017B00B0010502DB014200B4013E015B02C700B80161015F0165017A02DD017E017C015400C100C2010200C40139010600C7010C00C9011800CB011A00CD00CE010E01100143014700D300D4015000D600D70158016E00DA017000DC00DD016200DF015500E100E2010300E4013A010700E7010D00E9011900EB011B00ED00EE010F01110144014800F300F4015100F600F70159016F00FA017100FC00FD016302D9')
    """)

    stopIfSqlNotOK (session,
    """
    INSERT INTO CODEPAGE VALUES('ISO-8859-3', x'0000000100020003000400050006000700080009000A000B000C000D000E000F0010001100120013001400150016001700180019001A001B001C001D001E001F0020002100220023002400250026002700280029002A002B002C002D002E002F0030003100320033003400350036003700380039003A003B003C003D003E003F0040004100420043004400450046004700480049004A004B004C004D004E004F0050005100520053005400550056005700580059005A005B005C005D005E005F0060006100620063006400650066006700680069006A006B006C006D006E006F0070007100720073007400750076007700780079007A007B007C007D007E007F0080008100820083008400850086008700880089008A008B008C008D008E008F0090009100920093009400950096009700980099009A009B009C009D009E009F00A0012602D800A300A4FFFF012400A700A80130015E011E013400ADFFFF017B00B0012700B200B300B400B5012500B700B80131015F011F013500BDFFFF017C00C000C100C2FFFF00C4010A010800C700C800C900CA00CB00CC00CD00CE00CFFFFF00D100D200D300D4012000D600D7011C00D900DA00DB00DC016C015C00DF00E000E100E2FFFF00E4010B010900E700E800E900EA00EB00EC00ED00EE00EFFFFF00F100F200F300F4012100F600F7011D00F900FA00FB00FC016D015D02D9')
    """)

    stopIfSqlNotOK (session,
    """
    INSERT INTO CODEPAGE VALUES('ISO-8859-4', x'0000000100020003000400050006000700080009000A000B000C000D000E000F0010001100120013001400150016001700180019001A001B001C001D001E001F0020002100220023002400250026002700280029002A002B002C002D002E002F0030003100320033003400350036003700380039003A003B003C003D003E003F0040004100420043004400450046004700480049004A004B004C004D004E004F0050005100520053005400550056005700580059005A005B005C005D005E005F0060006100620063006400650066006700680069006A006B006C006D006E006F0070007100720073007400750076007700780079007A007B007C007D007E007F0080008100820083008400850086008700880089008A008B008C008D008E008F0090009100920093009400950096009700980099009A009B009C009D009E009F00A001040138015600A40128013B00A700A8016001120122016600AD017D00AF00B0010502DB015700B40129013C02C700B80161011301230167014A017E014B010000C100C200C300C400C500C6012E010C00C9011800CB011600CD00CE012A01100145014C013600D400D500D600D700D8017200DA00DB00DC0168016A00DF010100E100E200E300E400E500E6012F010D00E9011900EB011700ED00EE012B01110146014D013700F400F500F600F700F8017300FA00FB00FC0169016B02D9')
    """)
    stopIfSqlNotOK (session,
    """
    INSERT INTO CODEPAGE VALUES('ISO-8859-5', x'0000000100020003000400050006000700080009000A000B000C000D000E000F0010001100120013001400150016001700180019001A001B001C001D001E001F0020002100220023002400250026002700280029002A002B002C002D002E002F0030003100320033003400350036003700380039003A003B003C003D003E003F0040004100420043004400450046004700480049004A004B004C004D004E004F0050005100520053005400550056005700580059005A005B005C005D005E005F0060006100620063006400650066006700680069006A006B006C006D006E006F0070007100720073007400750076007700780079007A007B007C007D007E007F0080008100820083008400850086008700880089008A008B008C008D008E008F0090009100920093009400950096009700980099009A009B009C009D009E009F00A0040104020403040404050406040704080409040A040B040C00AD040E040F0410041104120413041404150416041704180419041A041B041C041D041E041F0420042104220423042404250426042704280429042A042B042C042D042E042F0430043104320433043404350436043704380439043A043B043C043D043E043F0440044104420443044404450446044704480449044A044B044C044D044E044F2116045104520453045404550456045704580459045A045B045C00A7045E045F')
    """)

    stopIfSqlNotOK (session,
    """
    INSERT INTO CODEPAGE VALUES('ISO-8859-6', x'0000000100020003000400050006000700080009000A000B000C000D000E000F0010001100120013001400150016001700180019001A001B001C001D001E001F0020002100220023002400250026002700280029002A002B002C002D002E002F0030003100320033003400350036003700380039003A003B003C003D003E003F0040004100420043004400450046004700480049004A004B004C004D004E004F0050005100520053005400550056005700580059005A005B005C005D005E005F0060006100620063006400650066006700680069006A006B006C006D006E006F0070007100720073007400750076007700780079007A007B007C007D007E007F0080008100820083008400850086008700880089008A008B008C008D008E008F0090009100920093009400950096009700980099009A009B009C009D009E009F00A0FFFFFFFFFFFF00A4FFFFFFFFFFFFFFFFFFFFFFFFFFFF060C00ADFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF061BFFFFFFFFFFFF061FFFFF062106220623062406250626062706280629062A062B062C062D062E062F0630063106320633063406350636063706380639063AFFFFFFFFFFFFFFFFFFFF0640064106420643064406450646064706480649064A064B064C064D064E064F065006510652FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF')
    """)

    stopIfSqlNotOK (session,
    """
    INSERT INTO CODEPAGE VALUES('ISO-8859-7', x'0000000100020003000400050006000700080009000A000B000C000D000E000F0010001100120013001400150016001700180019001A001B001C001D001E001F0020002100220023002400250026002700280029002A002B002C002D002E002F0030003100320033003400350036003700380039003A003B003C003D003E003F0040004100420043004400450046004700480049004A004B004C004D004E004F0050005100520053005400550056005700580059005A005B005C005D005E005F0060006100620063006400650066006700680069006A006B006C006D006E006F0070007100720073007400750076007700780079007A007B007C007D007E007F0080008100820083008400850086008700880089008A008B008C008D008E008F0090009100920093009400950096009700980099009A009B009C009D009E009F00A02018201900A3FFFFFFFF00A600A700A800A9FFFF00AB00AC00ADFFFF201500B000B100B200B303840385038600B703880389038A00BB038C00BD038E038F0390039103920393039403950396039703980399039A039B039C039D039E039F03A003A1FFFF03A303A403A503A603A703A803A903AA03AB03AC03AD03AE03AF03B003B103B203B303B403B503B603B703B803B903BA03BB03BC03BD03BE03BF03C003C103C203C303C403C503C603C703C803C903CA03CB03CC03CD03CEFFFF')
    """)

    stopIfSqlNotOK (session,
    """
    INSERT INTO CODEPAGE VALUES('ISO-8859-8', x'0000000100020003000400050006000700080009000A000B000C000D000E000F0010001100120013001400150016001700180019001A001B001C001D001E001F0020002100220023002400250026002700280029002A002B002C002D002E002F0030003100320033003400350036003700380039003A003B003C003D003E003F0040004100420043004400450046004700480049004A004B004C004D004E004F0050005100520053005400550056005700580059005A005B005C005D005E005F0060006100620063006400650066006700680069006A006B006C006D006E006F0070007100720073007400750076007700780079007A007B007C007D007E007F0080008100820083008400850086008700880089008A008B008C008D008E008F0090009100920093009400950096009700980099009A009B009C009D009E009F00A0FFFF00A200A300A400A500A600A700A800A900D700AB00AC00AD00AE00AF00B000B100B200B300B400B500B600B700B800B900F700BB00BC00BD00BEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF201705D005D105D205D305D405D505D605D705D805D905DA05DB05DC05DD05DE05DF05E005E105E205E305E405E505E605E705E805E905EAFFFFFFFF200E200FFFFF')
    """)

    stopIfSqlNotOK (session,
    """
    INSERT INTO CODEPAGE VALUES('ISO-8859-9', x'0000000100020003000400050006000700080009000A000B000C000D000E000F0010001100120013001400150016001700180019001A001B001C001D001E001F0020002100220023002400250026002700280029002A002B002C002D002E002F0030003100320033003400350036003700380039003A003B003C003D003E003F0040004100420043004400450046004700480049004A004B004C004D004E004F0050005100520053005400550056005700580059005A005B005C005D005E005F0060006100620063006400650066006700680069006A006B006C006D006E006F0070007100720073007400750076007700780079007A007B007C007D007E007F0080008100820083008400850086008700880089008A008B008C008D008E008F0090009100920093009400950096009700980099009A009B009C009D009E009F00A000A100A200A300A400A500A600A700A800A900AA00AB00AC00AD00AE00AF00B000B100B200B300B400B500B600B700B800B900BA00BB00BC00BD00BE00BF00C000C100C200C300C400C500C600C700C800C900CA00CB00CC00CD00CE00CF011E00D100D200D300D400D500D600D700D800D900DA00DB00DC0130015E00DF00E000E100E200E300E400E500E600E700E800E900EA00EB00EC00ED00EE00EF011F00F100F200F300F400F500F600F700F800F900FA00FB00FC0131015F00FF')
    """)

    stopIfSqlNotOK (session,
    """
    INSERT INTO CODEPAGE VALUES('ISO-8859-10', x'0000000100020003000400050006000700080009000A000B000C000D000E000F0010001100120013001400150016001700180019001A001B001C001D001E001F0020002100220023002400250026002700280029002A002B002C002D002E002F0030003100320033003400350036003700380039003A003B003C003D003E003F0040004100420043004400450046004700480049004A004B004C004D004E004F0050005100520053005400550056005700580059005A005B005C005D005E005F0060006100620063006400650066006700680069006A006B006C006D006E006F0070007100720073007400750076007700780079007A007B007C007D007E007F0080008100820083008400850086008700880089008A008B008C008D008E008F0090009100920093009400950096009700980099009A009B009C009D009E009F00A0010401120122012A0128013600A7013B011001600166017D00AD016A014A00B0010501130123012B0129013700B7013C011101610167017E2015016B014B010000C100C200C300C400C500C6012E010C00C9011800CB011600CD00CE00CF00D00145014C00D300D400D500D6016800D8017200DA00DB00DC00DD00DE00DF010100E100E200E300E400E500E6012F010D00E9011900EB011700ED00EE00EF00F00146014D00F300F400F500F6016900F8017300FA00FB00FC00FD00FE0138')
    """)

    stopIfSqlNotOK (session,
    """
    INSERT INTO CODEPAGE VALUES('ISO-8859-11', x'0000000100020003000400050006000700080009000A000B000C000D000E000F0010001100120013001400150016001700180019001A001B001C001D001E001F0020002100220023002400250026002700280029002A002B002C002D002E002F0030003100320033003400350036003700380039003A003B003C003D003E003F0040004100420043004400450046004700480049004A004B004C004D004E004F0050005100520053005400550056005700580059005A005B005C005D005E005F0060006100620063006400650066006700680069006A006B006C006D006E006F0070007100720073007400750076007700780079007A007B007C007D007E007F0080008100820083008400850086008700880089008A008B008C008D008E008F0090009100920093009400950096009700980099009A009B009C009D009E009F00A00E010E020E030E040E050E060E070E080E090E0A0E0B0E0C0E0D0E0E0E0F0E100E110E120E130E140E150E160E170E180E190E1A0E1B0E1C0E1D0E1E0E1F0E200E210E220E230E240E250E260E270E280E290E2A0E2B0E2C0E2D0E2E0E2F0E300E310E320E330E340E350E360E370E380E390E3AFFFFFFFFFFFFFFFF0E3F0E400E410E420E430E440E450E460E470E480E490E4A0E4B0E4C0E4D0E4E0E4F0E500E510E520E530E540E550E560E570E580E590E5A0E5BFFFFFFFFFFFFFFFF')
    """)

    stopIfSqlNotOK (session,
    """
    INSERT INTO CODEPAGE VALUES('ISO-8859-13', x'0000000100020003000400050006000700080009000A000B000C000D000E000F0010001100120013001400150016001700180019001A001B001C001D001E001F0020002100220023002400250026002700280029002A002B002C002D002E002F0030003100320033003400350036003700380039003A003B003C003D003E003F0040004100420043004400450046004700480049004A004B004C004D004E004F0050005100520053005400550056005700580059005A005B005C005D005E005F0060006100620063006400650066006700680069006A006B006C006D006E006F0070007100720073007400750076007700780079007A007B007C007D007E007F0080008100820083008400850086008700880089008A008B008C008D008E008F0090009100920093009400950096009700980099009A009B009C009D009E009F00A0201D00A200A300A4201E00A600A700D800A9015600AB00AC00AD00AE00C600B000B100B200B3201C00B500B600B700F800B9015700BB00BC00BD00BE00E60104012E0100010600C400C501180112010C00C90179011601220136012A013B01600143014500D3014C00D500D600D701720141015A016A00DC017B017D00DF0105012F0101010700E400E501190113010D00E9017A011701230137012B013C01610144014600F3014D00F500F600F701730142015B016B00FC017C017E2019')
    """)

    stopIfSqlNotOK (session,
    """
    INSERT INTO CODEPAGE VALUES('ISO-8859-14', x'0000000100020003000400050006000700080009000A000B000C000D000E000F0010001100120013001400150016001700180019001A001B001C001D001E001F0020002100220023002400250026002700280029002A002B002C002D002E002F0030003100320033003400350036003700380039003A003B003C003D003E003F0040004100420043004400450046004700480049004A004B004C004D004E004F0050005100520053005400550056005700580059005A005B005C005D005E005F0060006100620063006400650066006700680069006A006B006C006D006E006F0070007100720073007400750076007700780079007A007B007C007D007E007F0080008100820083008400850086008700880089008A008B008C008D008E008F0090009100920093009400950096009700980099009A009B009C009D009E009F00A01E021E0300A3010A010B1E0A00A71E8000A91E821E0B1EF200AD00AE01781E1E1E1F012001211E401E4100B61E561E811E571E831E601EF31E841E851E6100C000C100C200C300C400C500C600C700C800C900CA00CB00CC00CD00CE00CF017400D100D200D300D400D500D61E6A00D800D900DA00DB00DC00DD017600DF00E000E100E200E300E400E500E600E700E800E900EA00EB00EC00ED00EE00EF017500F100F200F300F400F500F61E6B00F800F900FA00FB00FC00FD017700FF')
    """)

    stopIfSqlNotOK (session,
    """
    INSERT INTO CODEPAGE VALUES('ISO-8859-15', x'0000000100020003000400050006000700080009000A000B000C000D000E000F0010001100120013001400150016001700180019001A001B001C001D001E001F0020002100220023002400250026002700280029002A002B002C002D002E002F0030003100320033003400350036003700380039003A003B003C003D003E003F0040004100420043004400450046004700480049004A004B004C004D004E004F0050005100520053005400550056005700580059005A005B005C005D005E005F0060006100620063006400650066006700680069006A006B006C006D006E006F0070007100720073007400750076007700780079007A007B007C007D007E007F0080008100820083008400850086008700880089008A008B008C008D008E008F0090009100920093009400950096009700980099009A009B009C009D009E009F00A000A100A200A320AC00A5016000A7016100A900AA00AB00AC00AD00AE00AF00B000B100B200B3017D00B500B600B7017E00B900BA00BB01520153017800BF00C000C100C200C300C400C500C600C700C800C900CA00CB00CC00CD00CE00CF00D000D100D200D300D400D500D600D700D800D900DA00DB00DC00DD00DE00DF00E000E100E200E300E400E500E600E700E800E900EA00EB00EC00ED00EE00EF00F000F100F200F300F400F500F600F700F800F900FA00FB00FC00FD00FE00FF')
    """)

    stopIfSqlNotOK (session,
    """
    INSERT INTO CODEPAGE VALUES('ISO-8859-16', x'0000000100020003000400050006000700080009000A000B000C000D000E000F0010001100120013001400150016001700180019001A001B001C001D001E001F0020002100220023002400250026002700280029002A002B002C002D002E002F0030003100320033003400350036003700380039003A003B003C003D003E003F0040004100420043004400450046004700480049004A004B004C004D004E004F0050005100520053005400550056005700580059005A005B005C005D005E005F0060006100620063006400650066006700680069006A006B006C006D006E006F0070007100720073007400750076007700780079007A007B007C007D007E007F0080008100820083008400850086008700880089008A008B008C008D008E008F0090009100920093009400950096009700980099009A009B009C009D009E009F00A001040105014120AC201E016000A7016100A9021800AB017900AD017A017B00B000B1010C0142017D201D00B600B7017E010D021900BB015201530178017C00C000C100C2010200C4010600C600C700C800C900CA00CB00CC00CD00CE00CF0110014300D200D300D4015000D6015A017000D900DA00DB00DC0118021A00DF00E000E100E2010300E4010700E600E700E800E900EA00EB00EC00ED00EE00EF0111014400F200F300F4015100F6015B017100F900FA00FB00FC0119021B00FF')
    """)

    stopIfSqlNotOK (session,
    """
    INSERT INTO CODEPAGE VALUES('WINDOWS-874', X'0000000100020003000400050006000700080009000A000B000C000D000E000F0010001100120013001400150016001700180019001A001B001C001D001E001F0020002100220023002400250026002700280029002A002B002C002D002E002F0030003100320033003400350036003700380039003A003B003C003D003E003F0040004100420043004400450046004700480049004A004B004C004D004E004F0050005100520053005400550056005700580059005A005B005C005D005E005F0060006100620063006400650066006700680069006A006B006C006D006E006F0070007100720073007400750076007700780079007A007B007C007D007E007F20AC008100820083008420260086008700880089008A008B008C008D008E008F009020182019201C201D20222013201400980099009A009B009C009D009E009F00A00E010E020E030E040E050E060E070E080E090E0A0E0B0E0C0E0D0E0E0E0F0E100E110E120E130E140E150E160E170E180E190E1A0E1B0E1C0E1D0E1E0E1F0E200E210E220E230E240E250E260E270E280E290E2A0E2B0E2C0E2D0E2E0E2F0E300E310E320E330E340E350E360E370E380E390E3AF8C1F8C2F8C3F8C40E3F0E400E410E420E430E440E450E460E470E480E490E4A0E4B0E4C0E4D0E4E0E4F0E500E510E520E530E540E550E560E570E580E590E5A0E5BF8C5F8C6F8C7F8C8')
    """)

    stopIfSqlNotOK (session,
    """
    INSERT INTO CODEPAGE VALUES('WINDOWS-932', X'0000000100020003000400050006000700080009000A000B000C000D000E000F0010001100120013001400150016001700180019001A001B001C001D001E001F0020002100220023002400250026002700280029002A002B002C002D002E002F0030003100320033003400350036003700380039003A003B003C003D003E003F0040004100420043004400450046004700480049004A004B004C004D004E004F0050005100520053005400550056005700580059005A005B005C005D005E005F0060006100620063006400650066006700680069006A006B006C006D006E006F0070007100720073007400750076007700780079007A007B007C007D007E007F0080226030E430FB32A7708E65E7514B7F72846C706F6953522952925C4664BC6CDBFF61FF62FF63FF64FF65FF66FF67FF68FF69FF6AFF6BFF6CFF6DFF6EFF6FFF70FF71FF72FF73FF74FF75FF76FF77FF78FF79FF7AFF7BFF7CFF7DFF7EFF7FFF80FF81FF82FF83FF84FF85FF86FF87FF88FF89FF8AFF8BFF8CFF8DFF8EFF8FFF90FF91FF92FF93FF94FF95FF96FF97FF98FF99FF9AFF9BFF9CFF9DFF9EFF9F73EE7CA4849F8DDA97DC30FB30FB2170E0B0E22AE3A4E51EE6986D8730FBF8F2F8F30000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000')
    """)

    stopIfSqlNotOK (session,
    """
    INSERT INTO CODEPAGE VALUES('WINDOWS-936', X'0000000100020003000400050006000700080009000A000B000C000D000E000F0010001100120013001400150016001700180019001A001B001C001D001E001F0020002100220023002400250026002700280029002A002B002C002D002E002F0030003100320033003400350036003700380039003A003B003C003D003E003F0040004100420043004400450046004700480049004A004B004C004D004E004F0050005100520053005400550056005700580059005A005B005C005D005E005F0060006100620063006400650066006700680069006A006B006C006D006E006F0070007100720073007400750076007700780079007A007B007C007D007E007F20AC4E97510E53975672589B5ABD5D155F4161AD6442667C68D96AC46D146F6A715A3001FFE530A604162506E069E127E1E58F887092520072AF8D2D60A39A8457778C055A9A724C4FA85892988281C095F25CA991C97F6968D54EDD572E848954D95F956C855F5073B76B9B8171770D957380317BDD8C8A9F2CE2EBE3A9E467F8F5000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000')
    """)

    stopIfSqlNotOK (session,
    """
    INSERT INTO CODEPAGE VALUES('WINDOWS-949', X'0000000100020003000400050006000700080009000A000B000C000D000E000F0010001100120013001400150016001700180019001A001B001C001D001E001F0020002100220023002400250026002700280029002A002B002C002D002E002F0030003100320033003400350036003700380039003A003B003C003D003E003F0040004100420043004400450046004700480049004A004B004C004D004E004F0050005100520053005400550056005700580059005A005B005C005D005E005F0060006100620063006400650066006700680069006A006B006C006D006E006F0070007100720073007400750076007700780079007A007B007C007D007E007F0080AC57AE42B00AB1E0B3B7B576B70BB8D3BAA4BC6EBE2DBFD5C19EC36BC506C71D3001FF04217533A400F830AC003F003FAD49B0ABB3C5B807BB54BEE4C2ADC624C88CCCD0D0ECD53DE02976D68AA5570B55AB62075006539863CF767D7E4355C798E15BB881C69810968581BAF9FA7A7D589E5F69514557426C866A3A8A70F8F7000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000')
    """)

    stopIfSqlNotOK (session,
    """
    INSERT INTO CODEPAGE VALUES('WINDOWS-950', X'0000000100020003000400050006000700080009000A000B000C000D000E000F0010001100120013001400150016001700180019001A001B001C001D001E001F0020002100220023002400250026002700280029002A002B002C002D002E002F0030003100320033003400350036003700380039003A003B003C003D003E003F0040004100420043004400450046004700480049004A004B004C004D004E004F0050005100520053005400550056005700580059005A005B005C005D005E005F0060006100620063006400650066006700680069006A006B006C006D006E006F0070007100720073007400750076007700780079007A007B007C007D007E007F0080003F003F003F003F003F003F003F003F003F003F003F003F003F003F003F003FFE5C31135B83593E5E1A578B964B79E3637296777D6E6EA25283905E876887838B1D85E59F6AF77557344F6E8FD373BF65C288726B368DB96B398A5868F0846E647587206A098CE56FCB930E81BC701456A69EC0861C8832256DE137E273F8F8000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000')
    """)

    stopIfSqlNotOK (session,
    """
    INSERT INTO CODEPAGE VALUES('WINDOWS-1250', X'0000000100020003000400050006000700080009000A000B000C000D000E000F0010001100120013001400150016001700180019001A001B001C001D001E001F0020002100220023002400250026002700280029002A002B002C002D002E002F0030003100320033003400350036003700380039003A003B003C003D003E003F0040004100420043004400450046004700480049004A004B004C004D004E004F0050005100520053005400550056005700580059005A005B005C005D005E005F0060006100620063006400650066006700680069006A006B006C006D006E006F0070007100720073007400750076007700780079007A007B007C007D007E007F20AC0081201A0083201E2026202020210088203001602039015A0164017D0179009020182019201C201D202220132014009821220161203A015B0165017E017A00A002C702D8014100A4010400A600A700A800A9015E00AB00AC00AD00AE017B00B000B102DB014200B400B500B600B700B80105015F00BB013D02DD013E017C015400C100C2010200C40139010600C7010C00C9011800CB011A00CD00CE010E01100143014700D300D4015000D600D70158016E00DA017000DC00DD016200DF015500E100E2010300E4013A010700E7010D00E9011900EB011B00ED00EE010F01110144014800F300F4015100F600F70159016F00FA017100FC00FD016302D9')
    """)

    stopIfSqlNotOK (session,
    """
    INSERT INTO CODEPAGE VALUES('WINDOWS-1251', X'0000000100020003000400050006000700080009000A000B000C000D000E000F0010001100120013001400150016001700180019001A001B001C001D001E001F0020002100220023002400250026002700280029002A002B002C002D002E002F0030003100320033003400350036003700380039003A003B003C003D003E003F0040004100420043004400450046004700480049004A004B004C004D004E004F0050005100520053005400550056005700580059005A005B005C005D005E005F0060006100620063006400650066006700680069006A006B006C006D006E006F0070007100720073007400750076007700780079007A007B007C007D007E007F04020403201A0453201E20262020202120AC203004092039040A040C040B040F045220182019201C201D202220132014009821220459203A045A045C045B045F00A0040E045E040800A4049000A600A7040100A9040400AB00AC00AD00AE040700B000B104060456049100B500B600B704512116045400BB04580405045504570410041104120413041404150416041704180419041A041B041C041D041E041F0420042104220423042404250426042704280429042A042B042C042D042E042F0430043104320433043404350436043704380439043A043B043C043D043E043F0440044104420443044404450446044704480449044A044B044C044D044E044F')
    """)

    stopIfSqlNotOK (session,
    """
    INSERT INTO CODEPAGE VALUES('WINDOWS-1252', X'0000000100020003000400050006000700080009000A000B000C000D000E000F0010001100120013001400150016001700180019001A001B001C001D001E001F0020002100220023002400250026002700280029002A002B002C002D002E002F0030003100320033003400350036003700380039003A003B003C003D003E003F0040004100420043004400450046004700480049004A004B004C004D004E004F0050005100520053005400550056005700580059005A005B005C005D005E005F0060006100620063006400650066006700680069006A006B006C006D006E006F0070007100720073007400750076007700780079007A007B007C007D007E007F20AC0081201A0192201E20262020202102C62030016020390152008D017D008F009020182019201C201D20222013201402DC21220161203A0153009D017E017800A000A100A200A300A400A500A600A700A800A900AA00AB00AC00AD00AE00AF00B000B100B200B300B400B500B600B700B800B900BA00BB00BC00BD00BE00BF00C000C100C200C300C400C500C600C700C800C900CA00CB00CC00CD00CE00CF00D000D100D200D300D400D500D600D700D800D900DA00DB00DC00DD00DE00DF00E000E100E200E300E400E500E600E700E800E900EA00EB00EC00ED00EE00EF00F000F100F200F300F400F500F600F700F800F900FA00FB00FC00FD00FE00FF')
    """)

    stopIfSqlNotOK (session,
    """
    INSERT INTO CODEPAGE VALUES('WINDOWS-1253', X'0000000100020003000400050006000700080009000A000B000C000D000E000F0010001100120013001400150016001700180019001A001B001C001D001E001F0020002100220023002400250026002700280029002A002B002C002D002E002F0030003100320033003400350036003700380039003A003B003C003D003E003F0040004100420043004400450046004700480049004A004B004C004D004E004F0050005100520053005400550056005700580059005A005B005C005D005E005F0060006100620063006400650066006700680069006A006B006C006D006E006F0070007100720073007400750076007700780079007A007B007C007D007E007F20AC0081201A0192201E20262020202100882030008A2039008C008D008E008F009020182019201C201D20222013201400982122009A203A009C009D009E009F00A00385038600A300A400A500A600A700A800A9F8F900AB00AC00AD00AE201500B000B100B200B3038400B500B600B703880389038A00BB038C00BD038E038F0390039103920393039403950396039703980399039A039B039C039D039E039F03A003A1F8FA03A303A403A503A603A703A803A903AA03AB03AC03AD03AE03AF03B003B103B203B303B403B503B603B703B803B903BA03BB03BC03BD03BE03BF03C003C103C203C303C403C503C603C703C803C903CA03CB03CC03CD03CEF8FB')
    """)

    stopIfSqlNotOK (session,
    """
    INSERT INTO CODEPAGE VALUES('WINDOWS-1254', X'0000000100020003000400050006000700080009000A000B000C000D000E000F0010001100120013001400150016001700180019001A001B001C001D001E001F0020002100220023002400250026002700280029002A002B002C002D002E002F0030003100320033003400350036003700380039003A003B003C003D003E003F0040004100420043004400450046004700480049004A004B004C004D004E004F0050005100520053005400550056005700580059005A005B005C005D005E005F0060006100620063006400650066006700680069006A006B006C006D006E006F0070007100720073007400750076007700780079007A007B007C007D007E007F20AC0081201A0192201E20262020202102C62030016020390152008D008E008F009020182019201C201D20222013201402DC21220161203A0153009D009E017800A000A100A200A300A400A500A600A700A800A900AA00AB00AC00AD00AE00AF00B000B100B200B300B400B500B600B700B800B900BA00BB00BC00BD00BE00BF00C000C100C200C300C400C500C600C700C800C900CA00CB00CC00CD00CE00CF011E00D100D200D300D400D500D600D700D800D900DA00DB00DC0130015E00DF00E000E100E200E300E400E500E600E700E800E900EA00EB00EC00ED00EE00EF011F00F100F200F300F400F500F600F700F800F900FA00FB00FC0131015F00FF')
    """)

    stopIfSqlNotOK (session,
    """
    INSERT INTO CODEPAGE VALUES('WINDOWS-1255', X'0000000100020003000400050006000700080009000A000B000C000D000E000F0010001100120013001400150016001700180019001A001B001C001D001E001F0020002100220023002400250026002700280029002A002B002C002D002E002F0030003100320033003400350036003700380039003A003B003C003D003E003F0040004100420043004400450046004700480049004A004B004C004D004E004F0050005100520053005400550056005700580059005A005B005C005D005E005F0060006100620063006400650066006700680069006A006B006C006D006E006F0070007100720073007400750076007700780079007A007B007C007D007E007F20AC0081201A0192201E20262020202102C62030008A2039008C008D008E008F009020182019201C201D20222013201402DC2122009A203A009C009D009E009F00A000A100A200A320AA00A500A600A700A800A900D700AB00AC00AD00AE00AF00B000B100B200B300B400B500B600B700B800B900F700BB00BC00BD00BE00BF05B005B105B205B305B405B505B605B705B805B905BA05BB05BC05BD05BE05BF05C005C105C205C305F005F105F205F305F4F88DF88EF88FF890F891F892F89305D005D105D205D305D405D505D605D705D805D905DA05DB05DC05DD05DE05DF05E005E105E205E305E405E505E605E705E805E905EAF894F895200E200FF896')
    """)

    stopIfSqlNotOK (session,
    """
    INSERT INTO CODEPAGE VALUES('WINDOWS-1256', X'0000000100020003000400050006000700080009000A000B000C000D000E000F0010001100120013001400150016001700180019001A001B001C001D001E001F0020002100220023002400250026002700280029002A002B002C002D002E002F0030003100320033003400350036003700380039003A003B003C003D003E003F0040004100420043004400450046004700480049004A004B004C004D004E004F0050005100520053005400550056005700580059005A005B005C005D005E005F0060006100620063006400650066006700680069006A006B006C006D006E006F0070007100720073007400750076007700780079007A007B007C007D007E007F20AC067E201A0192201E20262020202102C6203006792039015206860698068806AF20182019201C201D20222013201406A921220691203A0153200C200D06BA00A0060C00A200A300A400A500A600A700A800A906BE00AB00AC00AD00AE00AF00B000B100B200B300B400B500B600B700B800B9061B00BB00BC00BD00BE061F06C1062106220623062406250626062706280629062A062B062C062D062E062F063006310632063306340635063600D7063706380639063A064006410642064300E0064400E2064506460647064800E700E800E900EA00EB0649064A00EE00EF064B064C064D064E00F4064F065000F7065100F9065200FB00FC200E200F06D2')
    """)

    stopIfSqlNotOK (session,
    """
    INSERT INTO CODEPAGE VALUES('WINDOWS-1257', X'0000000100020003000400050006000700080009000A000B000C000D000E000F0010001100120013001400150016001700180019001A001B001C001D001E001F0020002100220023002400250026002700280029002A002B002C002D002E002F0030003100320033003400350036003700380039003A003B003C003D003E003F0040004100420043004400450046004700480049004A004B004C004D004E004F0050005100520053005400550056005700580059005A005B005C005D005E005F0060006100620063006400650066006700680069006A006B006C006D006E006F0070007100720073007400750076007700780079007A007B007C007D007E007F20AC0081201A0083201E20262020202100882030008A2039008C00A802C700B8009020182019201C201D20222013201400982122009A203A009C00AF02DB009F00A0F8FC00A200A300A4F8FD00A600A700D800A9015600AB00AC00AD00AE00C600B000B100B200B300B400B500B600B700F800B9015700BB00BC00BD00BE00E60104012E0100010600C400C501180112010C00C90179011601220136012A013B01600143014500D3014C00D500D600D701720141015A016A00DC017B017D00DF0105012F0101010700E400E501190113010D00E9017A011701230137012B013C01610144014600F3014D00F500F600F701730142015B016B00FC017C017E02D9')
    """)



    # ********************************
    #  DBPROC TRANSFORMATIONPACKAGE
    # ********************************
    #dropDBProc (session, "TRANSFORMATIONPACKAGE")

    rc = sqlRC (session, """SELECT DBPROCEDURE FROM SYSDD.DBPROCEDURES WHERE DBPROCEDURE = 'TRANSFORMATIONPACKAGE'""")
    if rc == 0:
        stopIfSqlNotOK(session, """DROP DBPROC \"TRANSFORMATIONPACKAGE\"""")

    stopIfSqlNotOK (session,"""
    CREATE DBPROC SYSDBA.TRANSFORMATIONPACKAGE ( IN packageguid CHAR(24) BYTE )
    AS
    VAR  rc INTEGER; errmsg CHAR(80);
         task_id  FIXED(6,0);step_id  FIXED(6,0); temp_step_id FIXED(6,0); seq_no FIXED(6,0); owner CHAR(32); tablename CHAR(32);
         step_id_ FIXED(6,0);
    TRY
    SET    rc = 0;
    SET    task_id = 0; SET  step_id_ = 0; SET  temp_step_id = 0;

    SELECT MAX(TASKID)+1,STEPID, SEQ_NO, OWNER, TABLENAME
           FROM SYSDBA.TRANSFORMATIONMODEL
    WHERE  PACKAGEGUID = :packageguid
           GROUP BY STEPID, SEQ_NO, OWNER, TABLENAME
           ORDER BY STEPID, SEQ_NO  ASC;
    WHILE $rc = 0 DO
              BEGIN
             FETCH INTO :task_id, :step_id, :seq_no, :owner, :tablename;
                      IF step_id = temp_step_id  THEN
                         SET step_id_ = step_id_
                      ELSE
                         SET step_id_ = step_id_+1;
              UPDATE SYSDBA.TRANSFORMATIONMODEL
                      SET    TASKID = :task_id ,
                             STEPID = :step_id_,
                             SEQ_NO = :seq_no
                      WHERE  PACKAGEGUID = :packageguid AND
                             OWNER       = :owner       AND TABLENAME   = :tablename AND
                             STEPID      = :step_id     AND SEQ_NO      = :seq_no    AND
                             TASKID      = 0 ;
                SET temp_step_id = step_id;
            END;
    CATCH
       IF $rc <> 100 THEN
          STOP ($rc, 'Unexpected error');
    """)

    #comments on SP_TRANSFORMATIONMODEL
    stopIfSqlNotOK (session, flatString ("""COMMENT ON DBPROC SYSDBA.TRANSFORMATIONPACKAGE IS
    'Initializes the TransformationPackage of the TRANSFORMATIONMODEL ' """))

    #grant DBPROC TRANSFORMATIONPACKAGE to PUBLIC
    stopIfSqlNotOK (session, 'GRANT EXECUTE ON SYSDBA.TRANSFORMATIONPACKAGE TO PUBLIC')

    # ********************************
    #  View TRANSFORMATIONPACKAGES
    # ********************************
    createReplaceView (session, 'TRANSFORMATIONPACKAGES ',
                              """AS SELECT PACKAGEGUID,TASKID,STEPID,OWNER,TABLENAME,EXCLUDE,RESTART
                                 FROM TRANSFORMATIONMODEL
                                 WHERE TABLETYPE = 'TABLE' AND CMD NOT LIKE 'GRANT %%' OR CMD IS NULL
                                 INTERNAL
                              """)

    # grant on TRANSFORMATIONPACKAGES
    stopIfSqlNotOK (session, 'GRANT SELECT ON TRANSFORMATIONPACKAGES TO PUBLIC')

    #comments on TRANSFORMATIONPACKAGES columns
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONPACKAGES.PACKAGEGUID IS
    'Unique Identifier of the TransformationPackage ' """))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONPACKAGES.TASKID IS
    'TransformationTask Identifier '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONPACKAGES.STEPID IS
    'TransformationStep Identifier'"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONPACKAGES.OWNER IS
    'Name of Schema that owns TableTypes '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONPACKAGES.TABLENAME IS
    'Name of TableType to transform'"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONPACKAGES.EXCLUDE IS
    'TransformationStep excluded '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONPACKAGES.RESTART IS
    'TransformationStep succeeded '"""))

    # ********************************
    #  View TRANSFORMATIONSTEPS
    # ********************************

    createReplaceView (session, 'TRANSFORMATIONSTEPS',
                              """AS SELECT PACKAGEGUID,TRANSFORMATION,OWNER,TABLENAME,
                                 CATALOGSTREAMNAME,CATALOGSTREAMFORMAT,DATASTREAMNAME,DATASTREAMFORMAT,DATASTREAMHEADERBLOCK,DATASTREAMHEADERPOS,DATASTREAMDATABLOCK,DATASTREAMDATAPOS,DATASTREAMTRAILERBLOCK,DATASTREAMTRAILERPOS,
                                 RESTART,ROWCOUNT AS START
                                 FROM TRANSFORMATIONMODEL
                                 WHERE EXCLUDE = FALSE AND TABLETYPE = 'TABLE' AND ( CMD NOT LIKE 'GRANT %%' OR CMD IS NULL )
                                 INTERNAL
                              """)

    # grant on TRANSFORMATIONSTEPS
    stopIfSqlNotOK (session, 'GRANT SELECT ON TRANSFORMATIONSTEPS TO PUBLIC')

    #comments on TRANSFORMATIONSTEPS columns
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONSTEPS.PACKAGEGUID IS
    'Unique Identifier of the TransformationPackage ' """))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONSTEPS.TRANSFORMATION IS
    'TransformationType '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONSTEPS.OWNER IS
    'Name of Schema that owns TableTypes '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONSTEPS.TABLENAME IS
    'Name of TableType to transform'"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONSTEPS.CATALOGSTREAMNAME IS
    'Identifier of CatalogStream associated to Loader Command '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONSTEPS.CATALOGSTREAMFORMAT IS
    'Format of CatalogStream associated to Loader Command '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONSTEPS.DATASTREAMNAME IS
    'Identifier of DataStream associated to Loader Command '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONSTEPS.DATASTREAMFORMAT IS
    'Format of DataStream associated to Loader Command '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONSTEPS.DATASTREAMHEADERBLOCK IS
    'StartPosition of DataStreamHeader counted in 2 GB Blocks '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONSTEPS.DATASTREAMHEADERPOS IS
    'StartPosition of DataStreamHeader counted in Bytes less than 2 GB '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONSTEPS.DATASTREAMDATABLOCK IS
    'StartPosition of DataStreamData counted in 2 GB Blocks  '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONSTEPS.DATASTREAMDATAPOS IS
    'StartPosition of DataStreamData counted in Bytes less than 2 GB  '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONSTEPS.DATASTREAMTRAILERBLOCK IS
    'StartPosition of DataStreamTrailer counted in 2 GB Blocks '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONSTEPS.DATASTREAMTRAILERPOS IS
    'StartPosition of DataStreamTrailer counted in Bytes less than 2 GB '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONSTEPS.RESTART IS
    'TransformationStep succeeded '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONSTEPS.START IS
    'Number of transformed Rows'"""))


    # ********************************
    #  View TRANSFORMATIONRESOURCES
    # ********************************

    createReplaceView (session, 'TRANSFORMATIONRESOURCES',
                              """AS SELECT DISTINCT PACKAGEGUID, SERVERNODE, SERVERDB, USERNAME, CODEPAGEID, STORAGEDEVICE,
                                 CATALOGSTREAMNAME,CATALOGSTREAMTYPE,CATALOGSTREAMEBID, DATASTREAMNAME,DATASTREAMTYPE, DATASTREAMEBID
                                 FROM TRANSFORMATIONMODEL
                                 WHERE EXCLUDE = FALSE
                                 INTERNAL
                              """)

    # grant on TRANSFORMATIONRESOURCES
    stopIfSqlNotOK (session, 'GRANT SELECT ON TRANSFORMATIONRESOURCES TO PUBLIC')

    #comments on TRANSFORMATIONRESOURCES columns
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONRESOURCES.PACKAGEGUID IS
    'Unique Identifier of the TransformationPackage ' """))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONRESOURCES.SERVERNODE IS
    'Node of the Database to transform '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONRESOURCES.SERVERDB IS
    'Name of the Database to transform '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONRESOURCES.CODEPAGEID IS
    'Identifier of a ASCII Codepage associated to Loader Command '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONRESOURCES.USERNAME IS
    'Schema of the Database to transform'"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONRESOURCES.STORAGEDEVICE IS
    'External BACKUPTOOL associated to Loader Session '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONRESOURCES.CATALOGSTREAMNAME IS
    'Identifier of CatalogStream associated to Loader Command '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONRESOURCES.CATALOGSTREAMTYPE IS
    'Type of CatalogStream associated to Loader Command '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONRESOURCES.CATALOGSTREAMEBID IS
    'External Backup Identifier of CatalogStream associated to Loader Command '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONRESOURCES.DATASTREAMNAME IS
    'Identifier of DataStream associated to Loader Command '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONRESOURCES.DATASTREAMTYPE IS
    'Type of DataStream associated to Loader Command  '"""))
    stopIfSqlNotOK (session, flatString ("""COMMENT ON COLUMN TRANSFORMATIONRESOURCES.DATASTREAMEBID IS
    'External Backup Identifier of DataStream associated to Loader Command '"""))


    # ********************************
    #  View TRANSFORMATIONSTATISTIC
    # ********************************

    createReplaceView (session, 'SYSDBA.TRANSFORMATIONSTATISTIC',
                              """AS SELECT PACKAGEGUID, STEPID, OWNER, TABLENAME,
                                 DATASTREAMTRAILERPOS-DATASTREAMHEADERPOS AS BYTECOUNT, ROWCOUNT, TRANSACTIONSIZE,
                                (HOUR         (ENDTIME) - HOUR        (STARTTIME))  *3600000 +
                                (MINUTE       (ENDTIME) - MINUTE      (STARTTIME))    *60000 +
                                (SECOND       (ENDTIME) - SECOND      (STARTTIME))     *1000 +
                               ((MICROSECOND  (ENDTIME) - MICROSECOND (STARTTIME))    /1000)  AS SYSTEMTIME,
                                (REQUESTTIME+RECEIVETIME) *1000 AS KERNELTIME,
                                (HOUR         (ENDTIME) - HOUR        (STARTTIME))  *3600000 +
                                (MINUTE       (ENDTIME) - MINUTE      (STARTTIME))    *60000 +
                                (SECOND       (ENDTIME) - SECOND      (STARTTIME))     *1000 +
                               ((MICROSECOND  (ENDTIME) - MICROSECOND (STARTTIME))     /1000) -
                                (REQUESTTIME+RECEIVETIME)*1000 AS LOADERTIME,
                                (HOUR         (ENDTIME) - HOUR        (STARTTIME))  *3600000 +
                                (MINUTE       (ENDTIME) - MINUTE      (STARTTIME))    *60000 +
                                (SECOND       (ENDTIME) - SECOND      (STARTTIME))     *1000 +
                               ((MICROSECOND  (ENDTIME) - MICROSECOND (STARTTIME))     /1000) -
                                (REQUESTTIME+RECEIVETIME)*1000 - (IOTIME) *1000 - (LOGTIME) *1000 AS DATATIME,
                                (LOGTIME)*1000 AS LOGTIME,
                                (IOTIME) *1000 AS IOTIME
                                FROM TRANSFORMATIONMODEL
                                WHERE EXCLUDE = FALSE AND RESTART = FALSE AND TABLETYPE = 'TABLE' AND ( CMD NOT LIKE 'GRANT %%' OR CMD IS NULL )
                                INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON TRANSFORMATIONSTATISTIC TO PUBLIC')

    # ********************************
    #  View TRANSFORMATIONMONITOR
    # ********************************

    createReplaceView (session, 'TRANSFORMATIONMONITOR',
                              """AS SELECT PACKAGEGUID,
                                 COUNT(*)          AS TABLECOUNT,
                                 SUM  (ROWCOUNT)   AS ROWCOUNT, TRANSACTIONSIZE,
                                 SUM  (SYSTEMTIME) AS SYSTEMDURATION,
                                 SUM  (KERNELTIME) AS KERNELDURATION,
                                 SUM  (LOADERTIME) AS LOADERDURATION,
                                 SUM  (DATATIME)   AS DATADURATION,
                                 SUM  (LOGTIME)    AS LOGDURATION,
                                 SUM  (IOTIME)     AS IODURATION
                                 FROM TRANSFORMATIONSTATISTIC
                                 GROUP BY PACKAGEGUID, TRANSACTIONSIZE
                                 INTERNAL
                              """)

    stopIfSqlNotOK (session, 'GRANT SELECT ON TRANSFORMATIONMONITOR TO PUBLIC')

    loaderCmd (session, 'COMMIT')

    loaderCmd (session, 'INSTALLATION OFF')


if __name__ == '__main__':
    connectAndInstall (install, install.__doc__)

