#!/usr/bin/perl
#
# $Header: //sapdb/V75/c_00/develop/sys/src/install/perl/SAPDB/Install/Instance/Check/Instances.pm#3 $
# $DateTime: 2003/12/11 13:40:27 $
# $Change: 59245 $
#
#    ========== licence begin  GPL
#    Copyright (c) 2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end


package SAPDB::Install::Instance::Check::Instances;

sub BEGIN {
	@ISA = ('SAPDB::Install::Exporter');
	@EXPORT = ();
	my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages = (
		'Instance::Base',
		'Instance::Check::Conditions'
	);

	foreach my $package (@neededPackages) {
	  	unless (defined $repo->Eval 
		("SAPDB::Install::$package", 1.01)) {
                	print join ("\n", $repo->GetErr)."\n";
                	die;
        	}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package");
	  } 
}

push @ISA, 
	'SAPDB::Install::Instance::Base',
	'SAPDB::Install::Instance::Check::Conditions';

sub instances {
	my ($self) = @_;
	my $dbm = $self->{dbm};

	#
	# find out instance type if not already known
	#
	unless (defined $self->{'instancetype'}) {
		my $rc = $self->conditions ();
		return undef unless (defined $rc && $rc == 0);
	}

	$self->set_errorstate ('ERROR');
	$self->msgbegin ("looking for running instances");	
	$self->msg0 ("looking for running instances...\n");
	$self->{'running_instances'} = undef;

	my $enum = $dbm->db_enum ();
	unless (defined $enum) {
		$self->msg1 ("error during db_enum\n");
		$self->msg1 ("\n");
		$self->msg1 ($dbm->lastdialog ());
		return undef;
	}

	my $lines = $#{$enum->{'DBNAME'}} + 1;
	if ($lines <= 0) {
		$self->msg1 ("no instances found\n");
		$self->msg1 ("\n");
		$self->msg1 ($dbm->lastdialog ());
		return undef;
	}

	my @running_instances = ();
	for (my $i = 0; $i < $lines; $i++) {
		next unless ($enum->{'STATE'}->[$i] eq 'running');
		next if ($enum->{'DBNAME'}->[$i] eq $self->{'dbname'});
		
		push @running_instances, $enum->{'DBNAME'}->[$i];
	}

	if (($#running_instances + 1) != 0) {
		$self->{running_instances} = \@running_instances;

		$self->msg1 ("found running instances\n");
		foreach (@{$self->{running_instances}}) {
			$self->msg1 ("  ".$_."\n");
		}
	}

	$self->set_errorstate ('OK');
	$self->msgend ();
	return 0;
} 

1;

