#!/usr/bin/perl
#
# $Header: //sapdb/V74/develop/sys/src/install/perl/SAPDB/Install/Instance/Check/Finalize/Generic.pm#2 $
# $DateTime: 2002/01/21 13:49:16 $
# $Change: 14297 $
#
#    ========== licence begin  GPL
#    Copyright (c) 2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end


package SAPDB::Install::Instance::Check::Finalize::ConData;

sub BEGIN {
	@ISA = ('SAPDB::Install::Exporter');
	@EXPORT = ();
	my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages = (
		'Instance::Base',
		'Instance::Check::Common',
		'Instance::Check::DomainUser'
	);

	foreach my $package (@neededPackages) {
	  	unless (defined $repo->Eval 
		("SAPDB::Install::$package", 1.01)) {
                	print join ("\n", $repo->GetErr)."\n";
                	die;
        	}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package");
	  } 
}

push @ISA, 
	'SAPDB::Install::Instance::Base',
	'SAPDB::Install::Instance::Check::Common',
	'SAPDB::Install::Instance::Check::DomainUser';

#
# finalize check for migration strategy CONSISTENT_DATA
#
sub finalizecheck {
	my ($self) = @_; 

	$self->set_errorstate ('ERROR');
	$self->msgbegin
	("running finalize check for CONSISTENT_DATA");
	$self->msg1
	("running finalize check for CONSISTENT_DATA...\n");

	my $rc = $self->domainuser ();
	unless (defined $rc && $rc == 0) {
		$self->set_errorstate ('ERROR');
		$self->msgend ();
		return undef;
	}

	$self->set_errorstate ('EXEC_MIGRATE_DATABASE_REQUIRED');
	$self->msgend ();
	return 0;
}

1;

