#!/usr/bin/perl
#
# $Header: //sapdb/V75/c_00/develop/sys/src/install/perl/SAPDB/Install/Instance/Check.pm#3 $
# $DateTime: 2003/12/11 13:40:27 $
# $Change: 59245 $
#
#    ========== licence begin  GPL
#    Copyright (c) 2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end


package SAPDB::Install::Instance::Check;

sub BEGIN {
	@ISA = ('SAPDB::Install::Exporter');
	@EXPORT = ();
	my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages = (
		'Instance::Base',
		'Instance::Check::Conditions',
		'Instance::Check::DataCons',
		'Instance::Check::DomainUser',
		'Instance::Check::Instances',
		'Instance::Check::Finalize',
		'Instance::Check::Params',
		'Instance::Check::Volumes'
	);

	foreach my $package (@neededPackages) {
	  	unless (defined $repo->Eval 
		("SAPDB::Install::$package", 1.01)) {
                	print join ("\n", $repo->GetErr)."\n";
                	die;
		}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package");
	}
}

push @ISA,
	'SAPDB::Install::Instance::Base', 
	'SAPDB::Install::Instance::Check::Conditions',
	'SAPDB::Install::Instance::Check::DataCons',
	'SAPDB::Install::Instance::Check::DomainUser',
	'SAPDB::Install::Instance::Check::Instances',
	'SAPDB::Install::Instance::Check::Finalize',
	'SAPDB::Install::Instance::Check::Params',
	'SAPDB::Install::Instance::Check::Volumes';

#
# do_anycheck ()
# do any possible check method
#
sub do_anycheck {
	my ($self) = @_; 
	my $rc;

	$rc = $self->conditions ();
	return (-1) unless (defined $rc && $rc == 0);

	$rc = $self->instances ();
	return (-1) unless (defined $rc && $rc == 0);

	$rc = $self->params ();
	return (-1) unless (defined $rc && $rc == 0);

	$rc = $self->volumes ();
	return (-1) unless (defined $rc && $rc == 0);

	$rc = $self->domainuser ();
	return (-1) unless (defined $rc && $rc == 0);

	$rc = $self->datacons ();
	return (-1) unless (defined $rc && $rc == 0);

	return 0;
}

#
# sub do_finalizecheck ()
# check for recovered instance when using
# migration strategy 'EXTERNAL_CONSISTENT_BACKUP'
#
sub do_finalizecheck {
	my ($self) = @_;

	return ($self->finalizecheck ());
}

#
# main
#
sub main {
	return (SAPDB::Install::Instance::Check::Test::main (@_));
}

package SAPDB::Install::Instance::Check::Test;

$DEBUG = 0;

sub BEGIN {
	@ISA = ('SAPDB::Install::Exporter');
	@EXPORT = ();
	my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages = (
		'Getopt::Long'
	);

	foreach my $package (@neededPackages) {
	  	unless (defined $repo->Eval 
		("SAPDB::Install::$package", 1.01)) {
                	print join ("\n", $repo->GetErr)."\n";
                	die;
        	}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package");
	  } 
}

sub main {
	local @ARGV = @_;

	my $dbname, $userpwd, $target, $verbose, $help, $finalize, $apotarget;

	# allow interpretation of '-v' as '--verbose'
	SAPDB::Install::Getopt::Long::Configure ('auto_abbrev');
	GetOptions (
		'dbname=s', \$dbname, 
		'user=s', \$userpwd,
		'target:s', \$target,
		'apotarget:s', \$apotarget,
		'help', \$help,
		'finalize', \$finalize,
		'verbose', \$verbose);

	if (defined $help) {
		print "SAPDB::Install::Instance::Check::main\n";
		print "check, if instance will be ready\n";
		print "for software upgrade or patch installation\n";
		print "usage:\n";
		print "  -d (--dbname) <dbname>\n";
		print "  -u (--user)   <dbmusr,dbmpasswd>\n";
		print "  -t (--target) <buildstring>\n";
		print "  -a (--apotarget) <buildstr>\n";
		print "  -f (--finalize)\n";
		print "  -v (--verbose)\n";
		print "\n";
		return 0;
	}

	$DEBUG = 1 if ($verbose);

	my $ic = SAPDB::Install::Instance::Check->new ();

	$ic->{msg0} = \&msg0;
	$ic->{msg1} = \&msg1 if ($DEBUG);

	unless (defined $dbname) {
		printmsg ("missing instance name\n");		
		return 0;
	}

	unless (defined $userpwd) {
		printmsg ("missing user,password of dbm user\n");
		return 0;
	}

	my $rc;
	if (defined $finalize) {
		$rc = $ic->session ('dbname' => $dbname,
		      'userpwd' => $userpwd, 'target_release' => $target,
		      'apo_target_release' => $apotarget);
	} else {
		$rc = $ic->session ('dbname' => $dbname,
		      'apo_target_release' => $apotarget, 
		      'userpwd' => $userpwd, 'target_release' => $target);	
	}

	unless (defined $rc)  {
		printmsg ($ic->{msgtxt});
		return 0;
	}

	if (defined $finalize) {
		$rc = $ic->do_finalizecheck ();
		printmsg ("\n");
		unless (defined $rc) {
			printmsg ("finalize check failed during:\n");
		} elsif ($rc == 0) {
			printmsg ("finalization allowed\n");
		} else {
			printmsg ("finalization not allowed\n");
		}
	} else {
		$rc = $ic->do_anycheck ();
		printmsg ("\n");
		if ($rc == 0) {
			printmsg ("instance check ok\n");
		} else {
			printmsg ("instance check failed during:\n");
		}
	}

	unless ($ic->get_errorstate () eq 'OK') {
		printmsg ("\n");
		printmsg ($ic->{msgtxt});
	}
	printmsg ("errorstate = ".$ic->get_errorstate ()."\n");
}

sub msg1 {
	print "INFO>>> ";
	print @_;
}

sub msg0 {
	print "MSG >>> ";
	print @_;
}

sub printmsg {
	my $txt = shift;

	msg0 ($txt) if ($txt) eq "\n";

	foreach (split '\n', $txt) {
		msg0 ($_."\n");
	}
}

1;
