#
# =====================================================
# @(#) AS                        7.2        1999-07-29
# =====================================================
# Changes in  7.2:
#
#
#    ========== licence begin  GPL
#    Copyright (c) 2000-2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end

from installib import *

def install (session,options):
    """Installing suppose list
    """

    loaderCmd (session, 'INSTALLATION ON')

    loaderCmd (session, 'AUTOCOMMIT OFF')

    #ADIS #1001953/1002033
    requireSysdba (session)

    if existsTable (session, "SYS_AUTOSUPPOSE"):
        if (options.migrate):
            stopIfSqlNotOK  (session, 'ALTER TABLE SYS_AUTOSUPPOSE MODIFY (OWNER SYSID)')
        stopIfSqlNotErr (session, 100, "DELETE SYS_AUTOSUPPOSE WHERE TYPE <> 3")
    else:
        stopIfSqlNotOK (session, """
            CREATE TABLE SYS_AUTOSUPPOSE (OWNER   SYSID,
                                          TYPE    FIXED(2),
                                          SUPPOSE CHAR(128),
                                          CONSTRAINT SYS_AUTOSUPPOSES_PK PRIMARY KEY(OWNER,SUPPOSE)) INTERNAL""")

        stopIfSqlNotOK (session, "CREATE INDEX OWNER_INDEX ON SYS_AUTOSUPPOSE (OWNER)")


    dropView (session, "SYS_MYAUTOSUPPOSE")

    stopIfSqlNotOK (session, """
        CREATE VIEW SYS_MYAUTOSUPPOSE AS
        SELECT * FROM SYS_AUTOSUPPOSE WHERE OWNER = USERGROUP OR OWNER = 'PUBLIC'
        WITH CHECK OPTION
        INTERNAL""")

    stopIfSqlNotOK (session, "GRANT ALL ON SYS_MYAUTOSUPPOSE TO PUBLIC")

    # SQL Suppose List

    dataLoad (session, """
DATALOAD TABLE SYS_AUTOSUPPOSE
"OWNER" 1 CHAR
"TYPE" 2 CHAR
"SUPPOSE" 3 CHAR
INFILE *""",
""""PUBLIC","0","ABS"
"PUBLIC","0","ACCOUNTING"
"PUBLIC","0","ACOS"
"PUBLIC","0","ACTION"
"PUBLIC","0","ACTIVATE"
"PUBLIC","0","ADD"
"PUBLIC","0","ADD_MONTHS"
"PUBLIC","0","ADDDATE"
"PUBLIC","0","ADDTIME"
"PUBLIC","0","AFTER"
"PUBLIC","0","ALL"
"PUBLIC","0","ALPHA"
"PUBLIC","0","ALTER"
"PUBLIC","0","ANALYZE"
"PUBLIC","0","AND"
"PUBLIC","0","ANSI"
"PUBLIC","0","ANY"
"PUBLIC","0","AS"
"PUBLIC","0","ASC"
"PUBLIC","0","ASCII"
"PUBLIC","0","ASIN"
"PUBLIC","0","AT"
"PUBLIC","0","ATAN"
"PUBLIC","0","ATAN2"
"PUBLIC","0","AUDIT"
"PUBLIC","0","AUTOSAVE"
"PUBLIC","0","AVG"
"PUBLIC","0","BAD"
"PUBLIC","0","BEFORE"
"PUBLIC","0","BEGIN"
"PUBLIC","0","BEGINLOAD"
"PUBLIC","0","BETWEEN"
"PUBLIC","0","BINARY"
"PUBLIC","0","BIT"
"PUBLIC","0","BLOCKSIZE"
"PUBLIC","0","BOOLEAN"
"PUBLIC","0","BOTH"
"PUBLIC","0","BUFFER"
"PUBLIC","0","BUFFERPOOL"
"PUBLIC","0","BY"
"PUBLIC","0","BYTE"
"PUBLIC","0","CACHE"
"PUBLIC","0","CACHES"
"PUBLIC","0","CACHELIMIT"
"PUBLIC","0","CANCEL"
"PUBLIC","0","CASCADE"
"PUBLIC","0","CAST"
"PUBLIC","0","CATALOG"
"PUBLIC","0","CEIL"
"PUBLIC","0","CEILING"
"PUBLIC","0","CHAR"
"PUBLIC","0","CHARACTER"
"PUBLIC","0","CHECK"
"PUBLIC","0","CHECKPOINT"
"PUBLIC","0","CHR"
"PUBLIC","0","CLEAR"
"PUBLIC","0","CLOSE"
"PUBLIC","0","CLUSTER"
"PUBLIC","0","COLD"
"PUBLIC","0","COLUMN"
"PUBLIC","0","COLUMNNAME"
"PUBLIC","0","COLUMNS"
"PUBLIC","0","COMMENT"
"PUBLIC","0","COMMIT"
"PUBLIC","0","COMPLETE"
"PUBLIC","0","COMPUTE"
"PUBLIC","0","CONCAT"
"PUBLIC","0","CONFIG"
"PUBLIC","0","CONNECT"
"PUBLIC","0","CONNECTED"
"PUBLIC","0","CONSOLE"
"PUBLIC","0","CONSTRAINT"
"PUBLIC","0","CONSTRAINTS"
"PUBLIC","0","COPY"
"PUBLIC","0","COS"
"PUBLIC","0","COSH"
"PUBLIC","0","COSTLIMIT"
"PUBLIC","0","COSTWARNING"
"PUBLIC","0","COT"
"PUBLIC","0","COUNT"
"PUBLIC","0","CREATE"
"PUBLIC","0","CURDATE"
"PUBLIC","0","CURRENT"
"PUBLIC","0","CURRENT_DATE"
"PUBLIC","0","CURRENT_TIME"
"PUBLIC","0","CURRENT_TIMESTAMP"
"PUBLIC","0","CURSOR"
"PUBLIC","0","CURTIME"
"PUBLIC","0","CURRVAL"
"PUBLIC","0","CYCLE"
"PUBLIC","0","DATA"
"PUBLIC","0","DATABASE"
"PUBLIC","0","DATE"
"PUBLIC","0","DATEDIFF"
"PUBLIC","0","DAY"
"PUBLIC","0","DAYS"
"PUBLIC","0","DAYNAME"
"PUBLIC","0","DAYOFMONTH"
"PUBLIC","0","DAYOFWEEK"
"PUBLIC","0","DAYOFYEAR"
"PUBLIC","0","DB2"
"PUBLIC","0","DBA"
"PUBLIC","0","DBFUNCTION"
"PUBLIC","0","DBPROC"
"PUBLIC","0","DBPROCEDURE"
"PUBLIC","0","DBYTE"
"PUBLIC","0","DEC"
"PUBLIC","0","DECIMAL"
"PUBLIC","0","DECLARE"
"PUBLIC","0","DECODE"
"PUBLIC","0","DEFAULT"
"PUBLIC","0","DEGREE"
"PUBLIC","0","DEGREES"
"PUBLIC","0","DELETE"
"PUBLIC","0","DESC"
"PUBLIC","0","DESCRIBE"
"PUBLIC","0","DESTPOS"
"PUBLIC","0","DEVICE"
"PUBLIC","0","DEVSPACE"
"PUBLIC","0","DIAGNOSE"
"PUBLIC","0","DIGITS"
"PUBLIC","0","DIRECT"
"PUBLIC","0","DISABLE"
"PUBLIC","0","DISCONNECT"
"PUBLIC","0","DISTINCT"
"PUBLIC","0","DIV"
"PUBLIC","0","DOMAIN"
"PUBLIC","0","DOMAINDEF"
"PUBLIC","0","DOUBLE"
"PUBLIC","0","DROP"
"PUBLIC","0","DSETPASS"
"PUBLIC","0","DUPLICATES"
"PUBLIC","0","DYNAMIC"
"PUBLIC","0","EBCDIC"
"PUBLIC","0","EDITPROC"
"PUBLIC","0","ENABLE"
"PUBLIC","0","END"
"PUBLIC","0","ENDLOAD"
"PUBLIC","0","ENDPOS"
"PUBLIC","0","ENTRY"
"PUBLIC","0","ENTRYDEF"
"PUBLIC","0","ESCAPE"
"PUBLIC","0","ESTIMATE"
"PUBLIC","0","EUR"
"PUBLIC","0","EXCEPT"
"PUBLIC","0","EXCLUSIVE"
"PUBLIC","0","EXECUTE"
"PUBLIC","0","EXISTS"
"PUBLIC","0","EXP"
"PUBLIC","0","EXPAND"
"PUBLIC","0","EXPLAIN"
"PUBLIC","0","EXPLICIT"
"PUBLIC","0","EXTRACT"
"PUBLIC","0","FALSE"
"PUBLIC","0","FETCH"
"PUBLIC","0","FILE"
"PUBLIC","0","FIRST"
"PUBLIC","0","FIRSTPOS"
"PUBLIC","0","FIXED"
"PUBLIC","0","FLOAT"
"PUBLIC","0","FLOOR"
"PUBLIC","0","FNULL"
"PUBLIC","0","FOR"
"PUBLIC","0","FORCE"
"PUBLIC","0","FOREIGN"
"PUBLIC","0","FORMAT"
"PUBLIC","0","FREAD"
"PUBLIC","0","FREEPAGE"
"PUBLIC","0","FROM"
"PUBLIC","0","FULL"
"PUBLIC","0","FVERSION"
"PUBLIC","0","FWRITE"
"PUBLIC","0","GATEWAY"
"PUBLIC","0","GET"
"PUBLIC","0","GRAPHIC"
"PUBLIC","0","GRANT"
"PUBLIC","0","GRANTED"
"PUBLIC","0","GREATEST"
"PUBLIC","0","GROUP"
"PUBLIC","0","HAVING"
"PUBLIC","0","HEX"
"PUBLIC","0","HOUR"
"PUBLIC","0","IDENTIFIED"
"PUBLIC","0","IFNULL"
"PUBLIC","0","IGNORE"
"PUBLIC","0","IN"
"PUBLIC","0","INCREMENT"
"PUBLIC","0","INDEX"
"PUBLIC","0","INDEXNAME"
"PUBLIC","0","INITCAP"
"PUBLIC","0","INSERT"
"PUBLIC","0","INT"
"PUBLIC","0","INTEGER"
"PUBLIC","0","INTERNAL"
"PUBLIC","0","INTERSECT"
"PUBLIC","0","INTO"
"PUBLIC","0","IS"
"PUBLIC","0","ISO"
"PUBLIC","0","ISOLATION"
"PUBLIC","0","JIS"
"PUBLIC","0","KEEP"
"PUBLIC","0","KEY"
"PUBLIC","0","LAST"
"PUBLIC","0","LCASE"
"PUBLIC","0","LEAST"
"PUBLIC","0","LEFT"
"PUBLIC","0","LENGTH"
"PUBLIC","0","LEVEL"
"PUBLIC","0","LFILL"
"PUBLIC","0","LIKE"
"PUBLIC","0","LINK"
"PUBLIC","0","LIST"
"PUBLIC","0","LN"
"PUBLIC","0","LOCATE"
"PUBLIC","0","LOCK"
"PUBLIC","0","LOG"
"PUBLIC","0","LOG10"
"PUBLIC","0","LONG"
"PUBLIC","0","LOWER"
"PUBLIC","0","LPAD"
"PUBLIC","0","LTRIM"
"PUBLIC","0","MAKEDATE"
"PUBLIC","0","MAKETIME"
"PUBLIC","0","MAPCHAR"
"PUBLIC","0","MAX"
"PUBLIC","0","MAXVALUE"
"PUBLIC","0","MBCS"
"PUBLIC","0","MICROSECOND"
"PUBLIC","0","MIN"
"PUBLIC","0","MINUTE"
"PUBLIC","0","MINVALUE"
"PUBLIC","0","MOD"
"PUBLIC","0","MODE"
"PUBLIC","0","MONITOR"
"PUBLIC","0","MONTH"
"PUBLIC","0","MONTHNAME"
"PUBLIC","0","NCHAR"
"PUBLIC","0","NEXT"
"PUBLIC","0","NEXTVAL"
"PUBLIC","0","NOCACHE"
"PUBLIC","0","NOCYCLE"
"PUBLIC","0","NOMAXVALUE"
"PUBLIC","0","NOMINVALUE"
"PUBLIC","0","NOORDER"
"PUBLIC","0","NOROUND"
"PUBLIC","0","NOT"
"PUBLIC","0","NOW"
"PUBLIC","0","NOWAIT"
"PUBLIC","0","NULL"
"PUBLIC","0","NUM"
"PUBLIC","0","NUMERIC"
"PUBLIC","0","OBJECT"
"PUBLIC","0","OF"
"PUBLIC","0","OFF"
"PUBLIC","0","ON"
"PUBLIC","0","OPEN"
"PUBLIC","0","OPTIMISTIC"
"PUBLIC","0","OPTION"
"PUBLIC","0","OR"
"PUBLIC","0","ORACLE"
"PUBLIC","0","ORDER"
"PUBLIC","0","PACKED"
"PUBLIC","0","PASSWORD"
"PUBLIC","0","PERCENT"
"PUBLIC","0","PI"
"PUBLIC","0","POS"
"PUBLIC","0","POWER"
"PUBLIC","0","PREV"
"PUBLIC","0","PRIMARY"
"PUBLIC","0","PRIV"
"PUBLIC","0","PRIVILEGES"
"PUBLIC","0","PUBLIC"
"PUBLIC","0","RADIANS"
"PUBLIC","0","REAL"
"PUBLIC","0","REFERENCED"
"PUBLIC","0","REFERENCES"
"PUBLIC","0","REJECT"
"PUBLIC","0","RELEASE"
"PUBLIC","0","RENAME"
"PUBLIC","0","REPLACE"
"PUBLIC","0","REPLICATION"
"PUBLIC","0","RESOURCE"
"PUBLIC","0","RESTRICT"
"PUBLIC","0","REUSE"
"PUBLIC","0","REVOKE"
"PUBLIC","0","RFILL"
"PUBLIC","0","RIGHT"
"PUBLIC","0","ROLLBACK"
"PUBLIC","0","ROUND"
"PUBLIC","0","ROW"
"PUBLIC","0","ROWID"
"PUBLIC","0","ROWNO"
"PUBLIC","0","RPAD"
"PUBLIC","0","RTRIM"
"PUBLIC","0","SAME"
"PUBLIC","0","SAMPLE"
"PUBLIC","0","SECOND"
"PUBLIC","0","SELECT"
"PUBLIC","0","SELUPD"
"PUBLIC","0","SEQUENCE"
"PUBLIC","0","SET"
"PUBLIC","0","SHARE"
"PUBLIC","0","SHOW"
"PUBLIC","0","SIGN"
"PUBLIC","0","SIN"
"PUBLIC","0","SINH"
"PUBLIC","0","SMALLINT"
"PUBLIC","0","SNAPSHOT"
"PUBLIC","0","SOME"
"PUBLIC","0","SOUNDEX"
"PUBLIC","0","SOUNDS"
"PUBLIC","0","SPACE"
"PUBLIC","0","SQLMODE"
"PUBLIC","0","SQRT"
"PUBLIC","0","STAMP"
"PUBLIC","0","STANDARD"
"PUBLIC","0","START"
"PUBLIC","0","STATISTICS"
"PUBLIC","0","STDDEV"
"PUBLIC","0","SUBDATE"
"PUBLIC","0","SUBSTR"
"PUBLIC","0","SUBSTRING"
"PUBLIC","0","SUBTIME"
"PUBLIC","0","SUBTRANS"
"PUBLIC","0","SUM"
"PUBLIC","0","SYNONYM"
"PUBLIC","0","SYSDBA"
"PUBLIC","0","TABLE"
"PUBLIC","0","TABLENAME"
"PUBLIC","0","TAN"
"PUBLIC","0","TANH"
"PUBLIC","0","TEMP"
"PUBLIC","0","TIME"
"PUBLIC","0","TIMEDIFF"
"PUBLIC","0","TIMEOUT"
"PUBLIC","0","TIMESTAMP"
"PUBLIC","0","TIMEZONE"
"PUBLIC","0","TO"
"PUBLIC","0","TOIDENTIFIER"
"PUBLIC","0","TRANSLATE"
"PUBLIC","0","TRIGGER"
"PUBLIC","0","TRIM"
"PUBLIC","0","TRUE"
"PUBLIC","0","TRUNC"
"PUBLIC","0","TRUNCATE"
"PUBLIC","0","UCASE"
"PUBLIC","0","UNICODE"
"PUBLIC","0","UNION"
"PUBLIC","0","UNIQUE"
"PUBLIC","0","UNLOCK"
"PUBLIC","0","UPDATE"
"PUBLIC","0","UPPER"
"PUBLIC","0","USA"
"PUBLIC","0","USER"
"PUBLIC","0","USERNAME"
"PUBLIC","0","USERGROUP"
"PUBLIC","0","VALUE"
"PUBLIC","0","VALUES"
"PUBLIC","0","VARCHAR"
"PUBLIC","0","VARGRAPHIC"
"PUBLIC","0","VARIANCE"
"PUBLIC","0","VIEW"
"PUBLIC","0","WEEK"
"PUBLIC","0","WEEKOFYEAR"
"PUBLIC","0","WHERE"
"PUBLIC","0","WAIT"
"PUBLIC","0","WITH"
"PUBLIC","0","WORK"
"PUBLIC","0","YEAR"
"PUBLIC","0","ZONED"
"PUBLIC","1","CREATE Table"
"PUBLIC","1","CREATE User"
"PUBLIC","1","Delete Table"
"PUBLIC","1","Delete TABLE Where"
"PUBLIC","1","Drop Table"
"PUBLIC","1","Drop User"
"PUBLIC","1","Insert Into"
"PUBLIC","1","Insert Into Set"
"PUBLIC","1","Select * From"
"PUBLIC","1","Select * From Where"
"PUBLIC","1","Select * From Domain.Columns"
"PUBLIC","1","Select * From Domain.ConnectedUsers"
"PUBLIC","1","Select * From Domain.ConnectParameters"
"PUBLIC","1","Select * From Domain.DBFunctions"
"PUBLIC","1","Select * From Domain.DBProcedures"
"PUBLIC","1","Select * From Domain.Domains"
"PUBLIC","1","Select * From Domain.Indexes"
"PUBLIC","1","Select * From Domain.Tables"
"PUBLIC","1","Select * From Domain.Triggers"
"PUBLIC","1","Select * From Domain.Users"
"PUBLIC","1","Select * From Domain.Views"
""")

    loaderCmd (session, 'COMMIT')

    loaderCmd (session, 'INSTALLATION OFF')

    # End of Install


if __name__ == '__main__':
    connectAndInstall (install, install.__doc__)


