/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.packettest.core;

import com.sap.dbtech.util.StructuredBytes;
import com.sap.sapdb.packettest.core.PacketTestException;

public class PacketAnalyzer {
    public static int[] getPositionsOfSegments(StructuredBytes packet) throws PacketTestException {
        int numberOfSegments = packet.getInt2(46);
        if (numberOfSegments < 0) {
            throw new PacketTestException("Negative number of segments", -2);
        }
        int[] segmentsPos = new int[numberOfSegments];
        int offset = 56;
        int i = 0;
        while (i < numberOfSegments) {
            segmentsPos[i] = offset;
            offset += packet.getInt4(offset);
            ++i;
        }
        return segmentsPos;
    }

    public static int[] getParts(StructuredBytes packet, int indexOfSegment) throws PacketTestException {
        int[] segmentsPos = PacketAnalyzer.getPositionsOfSegments(packet);
        int numberOfParts = packet.getInt2(segmentsPos[indexOfSegment] + 8);
        if (numberOfParts < 0) {
            throw new PacketTestException("Negative number of parts", -2);
        }
        int[] partsPos = new int[numberOfParts];
        int offset = segmentsPos[indexOfSegment] + 40;
        int i = 0;
        while (i < numberOfParts) {
            partsPos[i] = offset;
            int partlen = 16 + packet.getInt4(offset + 8);
            if (partlen % 8 != 0) {
                partlen += 8 - partlen % 8;
            }
            offset += partlen;
            ++i;
        }
        return partsPos;
    }

    public static int[] getParts(StructuredBytes packet) throws PacketTestException {
        int[] segmentsPos = PacketAnalyzer.getPositionsOfSegments(packet);
        int numberOfParts = 0;
        int i = 0;
        while (i < segmentsPos.length) {
            int n = packet.getInt2(segmentsPos[i] + 8);
            if (n < 0) {
                throw new PacketTestException("Negative number of parts", -2);
            }
            numberOfParts += n;
            ++i;
        }
        int[] parts = new int[numberOfParts];
        int i2 = 0;
        while (i2 < segmentsPos.length) {
            int offset = segmentsPos[i2] + 40;
            int n = packet.getInt2(segmentsPos[i2] + 8);
            if (n < 0) {
                throw new PacketTestException("Negative number of parts", -2);
            }
            int j = 0;
            while (j < n) {
                parts[i2 + j] = offset;
                int partlen = 16 + packet.getInt4(offset + 8);
                if (partlen % 8 != 0) {
                    partlen += 8 - partlen % 8;
                }
                offset += partlen;
                ++j;
            }
            ++i2;
        }
        return parts;
    }
}

